# ~/.tk/jlaunchpadrc.tcl - menu definitions for jlaunchpad

wm geometry . +0+0
wm overrideredirect . 1

global env
catch {set env(WWW_HOME) [glob ~/web/js.html]}
catch {set env(MOSAIC_DOCUMENTS_MENU_SPECFILE) [glob ~/.mosaic-documents]}
catch {set env(WINTERM) xterm}		;# for SGI's winterm script
catch {set env(XAPPLRESDIR) [glob ~/lib/X11/app-defaults]}

hostmenu Local {
  localhost
  127.0.0.1
}

cmdmenu Apps {
  ical -iconic
  exmh -iconic
  jbrowser
  jedit
  jedit -mode richtext
  jpeople
  cdplayer
  Mosaic 
  showcase
  xcalc
  xterm
}

hostmenu Machines {
  host1 (Widgets department)
  host2 (Wedges department)
  piglet (Woozles department)
}

hostmenu {More Machines} {
  world.std.com (Boston)
  shore.shore.net (Boston)
  launchpad.unc.edu (Chapel Hill)
}



if {$orientation != "vertical"} {
  update idletasks
  set fillwidth [expr {[winfo screenwidth .] - [winfo reqwidth .]}]
  frame .menu.fill -width $fillwidth
  pack .menu.fill -in .menu -side left
}

# bind . <Visibility> {
#   if {"%s" != "VisibilityUnobscured"} {
#     raise %W
#   }
# }
