#!/usr/local/bin/tclsh8.0
# tstCliRealNoSSL.tcl - same as tstCliReal.tcl but withot using ssl.
# for testing the socket command in SSLtcl without ssl.
# (c) Peter Antman, 1998
#
# Part of this code is taken from Hopes webapage "Example Code - Socket server and
# client" at sco.

# load SSLtcl. You have to specifie the path to the module
load ../SSLtcl.so SSLtcl

#  I'm repeating this a few times to check for 
#  problems that may accumulate like file descriptor not being
#  closed.
proc read_sock {sock} {
  set l [gets $sock]
	if {[eof $sock]} {
		close $sock
		set eventLoop "done"
	}
  puts stdout "ServerReply:$l"
}

# Read a line of text from stdin and send it to the echoserver socket,
# on eof stdin closedown the echoserver client socket connection
# this implements sending a message to the Server.
proc read_stdin {wsock} {
  	global  eventLoop
  	set l [gets stdin]
	puts "l: $l"
  	if {[eof stdin]} {
    		close $wsock             ;# close the socket client connection
    		set eventLoop "done"     ;# terminate the vwait (eventloop)
	} elseif {$l == "Q"} {
		puts $wsock $l
		close $wsock
		exit
	} elseif {$l == "q"} {
		puts $wsock $l
		close $wsock
		exit
	} else {
    		puts $wsock $l           ;# send the data to the server
  }
}

# Create the socket without ssl
set s [socket localhost 443]

puts $s
fileevent $s readable [list read_sock $s]
fconfigure $s -buffering line
fileevent stdin readable [list read_stdin $s]
vwait eventLoop
puts "Finished"

