#!/usr/local/bin/tclsh8.0
# tstSrvRealNoSSL.tcl - same as tstSrvReal.tcl but without ssl.
# for testing the socket command in SSLtcl without ssl.
# (c) Peter Antman, 1998
#
# Part of this code is taken from Hopes webapage "Example Code - Socket server and
# client" at sco.

# server writing back to client
proc getit_fork {s l} {
	puts $s $l
	flush $s
}

# the callback from filevent
proc getit_hand {s} {
	puts filevent
	  set l [gets $s]    ;# get the client packet
	puts "got $l"
  	if {[eof $s]} {    ;# client gone or finished
     		close $s        ;# release the servers client channel
  	} elseif {$l == "Q"} {
		close $s
		exit
	} elseif {$l == "q"} {
		close $s
		return
	} else {
    		getit_fork $s $l
  	}
}

# The connection callback, called from ssl
proc getit { s ip port args } {
	puts "in getit"
	fileevent $s readable [list getit_hand $s]
	

	fconfigure $s -buffering line -blocking 0
	return
	
}

# load the module
load ../SSLtcl.so SSLtcl

# create socket, without ssl
set s [socket -server getit 443]
puts "Server waiting connection on $s"

# Go into the eventloop
vwait events
