#!/usr/local/bin/tclsh8.0
# tstCli.tcl - a simple client using ssl
# connects, sends a message, gets it back and exits
#
# (c) Peter Antman, 1998
#
# The script is originaly based on Tony Bringardners tstCli.tcl in tclSSL

set shouldbe [exec cat tstCli.tcl]
load ../SSLtcl.so SSLtcl

#  I'm repeating this a few times to check for 
#  problems that may accumulate like file descriptor not being
#  closed.

set s [socket -ssl -verify 1 -ciphers RC4-MD5 -cert demoCA/newcert.pem -key \
demoCA/newkey.pem -CAfile demoCA/cacert.pem localhost 443]

puts $s "GET /"
puts "Req complete"
flush $s
set got ""
while { [gets $s l ] >= 0 } {
	if { $got == "" } {
		set got $l
	} else {
		set got "$got\n$l"
	}
	# puts "RECV($l)"
}
close $s
puts "Client done"
if { $got == $shouldbe } {
	puts "Client successful!!!"
} else {
	puts "Bummer!!!  Client did not rec what it should have!"
	exit -1;
}

