#!/usr/local/bin/tclsh8.0
# tstSrv.tcl - a simple server using ssl.
# It can only serv one client at a time.
#
# (c) Peter Antman, 1998
#
# The script is originaly based on Tony Bringardners tstCli.tcl in tclSSL

set data [exec cat tstCli.tcl]

# This is the callback procedure that has to be part of the socket call
proc getit { s ip port args } {
	global data
	puts $args
	puts "Server socket ($s $ip $port)"
	set req [gets $s];
	puts "RECV($req)"
	if { $req == "GET /" } {
		puts $s $data
	} else {
		puts "UNKNOWN request"
		puts $s "UNKNOWN request"
	}
	close $s
}

# load the module, with full path to it
load ../SSLtcl.so SSLtcl
set s [socket -server getit -ssl -Verify 1 -cert \
demoCA/newcert.pem -key demoCA/newkey.pem \
-CAfile demoCA/cacert.pem 443]
puts $s
fconfigure $s -blocking 0
set tst 0
puts "Server waiting connection on $s"

# Go into the eventloop
vwait tst
