.if n .ds Q \&"
.if t .ds Q ``
.if n .ds U \&"
.if t .ds U ''
.TH "SSLtcl" 1 
.tr \&
.nr bi 0
.nr ll 0
.nr el 0
.de DS
..
.de DE
..
.de Pp
.ie \\n(ll>0 \{\
.ie \\n(bi=1 \{\
.nr bi 0
.if \\n(t\\n(ll=0 \{.IP \\(bu\}
.if \\n(t\\n(ll=1 \{.IP \\n+(e\\n(el.\}
.\}
.el .sp 
.\}
.el \{\
.ie \\nh=1 \{\
.LP
.nr h 0
.\}
.el .PP 
.\}
..
.SH NAME

.Pp
SSLtcl - a loadable module that extends the tcl socket command with
SSL 
.Pp
.Pp
.Pp
.SH SYNOPSIS

.Pp
load SSLtcl.so SSLtcl
.Pp
\fIsocket\fP [-myaddr addr] [-myport myport] [-async] [-ssl [-verify NUM] 
[-cert Certificate] [-key privateKey] [-CAfile CAfile] [-CAdir CAdir] ] 
\fIhost\fP \fIport\fP
.Pp
.Pp
.Pp
\fIsocket\fP  -server command [-ssl -cert Certificate [-key privateKey] 
[-verify NUM] [-Verify NUM] [-CAfile CAfile] [-CAdir CAdir] [-myaddr addr]  
\fIport\fP
.Pp
.Pp
.Pp
.SH DESCRIPTION

.Pp
.Pp
.Pp
\fISSLtcl \fPcreates a new tcl socket command with SSL capabilities. Se 
\fIsocket(n)\fP for a description of the tcl socket command. Used with -ssl
option it creates a SSL based connection. If \fI-ssl\fP is left out it
function as the normal \fIsocket\fP command and only options described in 
\fIsocket(n)\fP is available. SSLtcls socket creates either a server SSL
socket or a client SSL socket, exactly as the normal socket command.
.Pp
.Pp
.Pp
.SH CLIENT SOCKET

.Pp
If the -se\fIrver\fP option is not specified,  then  the  client side  of 
a connection is opened and the command returns a channel identifier that can
be used for both  reading  and writing.   \fIPort\fP  and  \fIhost\fP 
specify  a port to connect to;  there must be a server accepting connections
on this port. Port  is  an  integer  port  number  and  host is either a
domain-style name such as www.sunlabs.com or  a  numerical IP  address  such
as 127.0.0.1.  Use localhost to refer to the host on which the command is
invoked. The following options may also be present before  host  to specify
additional information about the connection:
.Pp
.Pp
.Pp
.nr ll +1
.nr t\n(ll 2
.if \n(ll>1 .RS
.IP "\fB-myaddr\fP \fIaddr\fP"
.nr bi 1
.Pp
Addr  gives  the  domain-style name or numerical IPaddress of the
client-side network interface to use for  the  connection.  This option may be
useful if  the client machine has multiple network interfaces. If  the  option
is  omitted  then  the client-side interface will be chosen by the system software.
.IP " -myport \fIport\fP"
.nr bi 1
.Pp
Port specifies an integer port number  to  use  for the  client's  side 
of  the  connection.   If this option is omitted, the client's port number
will bechosen at random by the system software.
.if \n(ll>1 .RE
.nr ll -1
.Pp
.Pp
.nr ll +1
.nr t\n(ll 2
.if \n(ll>1 .RS
.IP "\fB  -async\fP "
.nr bi 1
.Pp
The  -async  option will cause the client socket to be connected
asynchronously. This  means  that  the socket  will be created immediately but
may not yet be connected to the server, when the call to socket  returns. When
a gets or flush is done on the socket  before the connection attempt succeeds
or fails, if  the  socket is in blocking mode, the operation will  wait until
the connection is completed or fails. If  the  socket  is  in  nonblocking
mode and a gets or flush is done on the socket before  the  connection attempt
succeeds  or  fails, the operation returns  immediately and fblocked on the
socket returns 1.
.IP "\fB-ssl\fP"
.nr bi 1
.Pp
The -ssl option turns SSL on an makes the following options available.
.IP "\fB-verify\fP \fInum\fP"
.nr bi 1
.Pp
Turns verification of server on. num is an integer that specifies how deep
in the certificate chain verification is required to succeed.
.IP "\fB-key\fP \fIprivateKey\fP"
.nr bi 1
.Pp
Specifies the private key that accompanies the own certificate. A
certificate is only required for the client if it is going to be verified by
the server. If left out will be set to the same value as given for -cert.
.IP "\fB-cert\fP \fICertificate\fP"
.nr bi 1
.Pp
The client certificate, pem encoded, that it will send to the server if required.
.IP "\fB-CAfile\fP \fICAfile\fP"
.nr bi 1
.Pp
A file containing certificates from Certificate Authorities that the
client wants to trust. To verify a server a CAfile, or a CAdir, is required.
.IP "\fB-CAdir\fP \fICAdir\fP"
.nr bi 1
.Pp
A hashed directory that contains certificates from Certificate Authorities
that the client wants to trust. To verify a server a CAdir, or a CAfile, is required.
.IP "\fB-ciphers\fP \fIcipherlist\fP"
.nr bi 1
.Pp
\fIcipherlist\fP is a colon separated list of ciphers that the clients
wants to support. The first one will be tried first, and so on. See Supported
ciphers below.
.if \n(ll>1 .RE
.nr ll -1
.Pp
.Pp
.Pp
.Pp
.SH SERVER SOCKET

.Pp
If the \fI-server\fP option is specified  then  the  new  socket will  be
a  server  for the port given by port.  Tcl will automatically accept
connections to the given  port.   For each  connection Tcl will create a new
channel that may be used to communicate with the  client.   Tcl  then  invokes 
\fIcommand\fP  with  three additional arguments: the name of the new channel,
the address, in network address notation,  of  the client's host, and the
client's port number. The  following  additional  option  may  also be
specified before host:
.Pp
.nr ll +1
.nr t\n(ll 2
.if \n(ll>1 .RS
.IP "\fB-myaddr\fP \fIaddr\fP"
.nr bi 1
.Pp
Addr gives the domain-style name  or  numerical  IP address of the
server-side network interface to use for the connection.  This option may be 
useful  if  the server machine has multiple network interfaces.  If the option
is omitted then the server socket  is bound  to the special address INADDR_ANY
so that it can accept connections from any interface.
.IP "\fB-ssl\fP"
.nr bi 1
.Pp
The -ssl option turns SSL on an makes the following options available.
.IP "\fB-verify\fP \fInum\fP"
.nr bi 1
.Pp
Turns verification of client on. num is an integer that specifies how deep
in the certificate chain verification is required to succeed. Will only report
verification result, not stop the connection
.IP "\fB-Verify\fP \fInum\fP"
.nr bi 1
.Pp
Same as -verify, but will stop the connection if verify fails.
.IP "\fB-key\fP \fIprivateKey\fP"
.nr bi 1
.Pp
Specifies the private key that accompanies the server certificate.  If
left out will be set to the same value as given for -cert.
.IP "\fB-cert\fP \fICertificate\fP"
.nr bi 1
.Pp
The server certificate, pem encoded; it is required.
.IP "\fB-CAfile\fP \fICAfile\fP"
.nr bi 1
.Pp
A file contaning certificates from Certificate Authorities that the server
wants to trust. To verify a client a CAfile, or a CAdir, is required.
.IP "\fB-CAdir\fP \fICAdir\fP"
.nr bi 1
.Pp
A hashed directory that contains certificates from Certificate Authorities
that the server wants to trust. To verify a client a CAdir, or a CAfile, is required.
.IP "\fB-ciphers\fP \fIcipherlist\fP"
.nr bi 1
.Pp
\fIcipherlist\fP is a colon separated list of ciphers that the server
wants to support. The first one will be tried first, and so on. See Supported
ciphers below.
.IP "\fB-maxacloops\fP \fInum\fP"
.nr bi 1
.Pp
Specififies the numer of times the server should try to accept a
connection. \fInum\fP is an integer. The defaultvalue is 100000. The option
exist because of a problem with non SSL aware clients and server socket in non
-blocking mode. Without a timeout the server will block for ever. I will try
to find a better solution in the furure. If releveant connections keeps
returning with bgerror try to increase this value.
.if \n(ll>1 .RE
.nr ll -1
.Pp
.Pp
Server channels cannot be used for input or output;  their sole use is to
accept new client connections. The channels created for each incoming client
connection are opened for input  and  output.  Closing the server channel
shuts down  the server so that no new connections  will  be  accepted;
however, existing connections will be unaffected. Server  sockets  depend on
the Tcl event mechanism to find out when new connections are opened.  If  the 
application doesn't  enter the event loop, for example by invoking the vwait
command or calling the C  procedure  Tcl_DoOneEvent,  then no connections will
be accepted.
.Pp
.Pp
.Pp
.SH SUPPORTED CIPHERS

.Pp
The cipeherslist is specified as a colon separated list of ciphers. The
following cipherabrewations, and  is supported:
.Pp
.DS
.sp 
.ft CR
.nf
RC4-MD5
EXP-RC4-MD5
IDEA-CBC-MD5
RC2-CBC-MD5
EXP-RC2-CBC-MD5
DES-CBC-MD5
DES-CBC-SHA
DES-CBC3-MD5
DES-CBC3-SHA 
DES-CFB-M1
NULL-MD5
.DE
.fi 
.ec
.ft P
.sp

If You link SSLtcl against SSLeay-0.8.1 have a look in ssl.h for aditional ciphers.
.Pp
.Pp
.Pp
.SH TIPS

.Pp
In the SSLtcl distribution there are several scripts that can be used to
understand how sockets and sockets with ssl could be used. \fItstSrc.tcl\fP and \fItstCli.tcl\fP is two small scripts with blocking IO using SSL
that used connects and drop the connection. \fItstSrvReal.tcl \fPand\fI tstCliReal.tcl\fP uses fileevent and nonblocking with SSL. This means You can establish
several simultaneous connection with the server and send messages from the
clients to the server. \fItstSrvRealNoSSL.tcl\fP and \fItstCliRealNoSSL.tcl\fP are the same as the previous scripts, except that SSL is left out.
.Pp
.Pp
.Pp
You may have to change the path to \fItclsh8.0 \fPand to\fI SSLtcl.so\fP to get it to work. To generate own certificates to work with, see the
SSLtcl documentation.
.Pp
.Pp
.Pp
.SH BUGS AND FEATURES

.Pp
SSLtcl is still under development and may contain bug or badly implemented
solutions. Contact the author if something strange happens.
.Pp
.Pp
.Pp
.SH AUTHOR

.Pp
Peter Antman (peter.antman@abc.se)
.Pp
.Pp
.Pp
SSLtcl is based on tclSSL, an earlier work by Tony Bringardner. SSLtcl is
heavily updated compared to tclSSL but owes its basic structure and ideas to tclSSL.
.Pp
.Pp
.Pp
SSLtcl is also based on the work by Eric Young, specially s_server and
s_client, and Ben Lauries SSL patch to apache.
.Pp
.Pp
.Pp
Thank You all.
.Pp
.Pp
.Pp
.SH SEE ALSO

.Pp
socket(n), and the SSLeay documentation.