source "[info library]/init.tcl"

source "$tk_library/tk.tcl"

if {$tk_version < 4.0} {
    puts "\nnn-tk requires at least tk4.0\n"
    exit
}

if {$nn_x_dir == "."} {
    set nn_x_dir [pwd]
}

lappend auto_path "$nn_x_dir/tcl"
lappend auto_path "$nn_x_dir/tcl/exmh"

set config_windows {.display .prompt .user .groups .folders .post\
	.pref .pref0 .pref1 .pref2 .pref3 .variables .seditpref .compose  .nntpm .nn\
        .vars_misc .vars_group .vars_cascade .modify .color}


set monochrome 0
if {[winfo screendepth .] == 1} {
    set monochrome 1
}

if {$monochrome == 1} {
    option add *selectForeground white 99
    option add *selectBackground black 99
    option add *activeForeground white 99
    option add *activeBackground black 99
}

# nn-tk options
#
set vars_misc {menu_min menu_max horizontal_scrollbars default_article_lines mono_font\
		   middle_button_pos mime_handling nntp_progress nntp_progress_a\
		   cprompt_delay compressed_prompt separate_prompt xterm_path}

set vars_group {thread_height single_main group_list_read group_list_unsub group_list_all\
		   group_menu_max group_list_page group_list_width }

set vars_cascade {mk_group_menu group_menu_read group_menu_unsub}

set config_var "$vars_misc $vars_group $vars_cascade"

#Note menu_max must be after menu_min

set options_type(menu_max) panel
set options_header(menu_max) "."

set options_type(horizontal_scrollbars) int
set options_header(horizontal_scrollbars) "Horizontal scrollbars on panels"
set butt(horizontal_scrollbars) {"Never" "When needed" "Always"}

set options_type(default_article_lines) int
set options_header(default_article_lines) "Article lines displayed"

set options_type(mono_font) bool
set options_header(mono_font) "Mono space font for articles"

set options_type(middle_button_pos) int
set options_header(middle_button_pos) "Position of middle button row"
set butt(middle_button_pos) {"betweem menu panel and article panel" "above menu panel" \
         "below article panel"}

set options_type(mime_handling) int
set options_header(mime_handling) "Decoding MIME"
set butt(mime_handling) {"No MIME handling" \
	 "Don't handle text/plain as MIME" "Handle all MIME articles"}

set options_type(cprompt_delay) int
set options_header(cprompt_delay) "Delay displaying Cancel NNTP button"

set options_type(compressed_prompt) int
set options_header(compressed_prompt) "Prompt on mode line or popup"
set butt(compressed_prompt) {"Never" \
		 "As well as normal prompts" "Instead of normal prompts"}

set options_type(separate_prompt) bool
set options_header(separate_prompt) "Prompt lines in separate window"

set options_type(nntp_progress) int
set options_header(nntp_progress) "NNTP group progress every N lines"

set options_type(nntp_progress_a) int
set options_header(nntp_progress_a) "NNTP article progress every N lines"

#

set options_type(single_main) bool
set options_header(single_main) "No separate groups window"

set options_type(thread_height) slider
set options_header(thread_height) "Height of thread panel"
set options_other(thread_height) "0 660"

set options_type(group_list_read) bool
set options_header(group_list_read) "Include groups with no unread"

set options_type(group_list_unsub) bool
set options_header(group_list_unsub) "Include unsubscribed groups"

set options_type(group_list_all) bool
set options_header(group_list_all) "Show number of all articles"

set options_type(group_menu_max) int
set options_header(group_menu_max) "Maximum length of group menu"

set options_type(group_list_width) slider
set options_header(group_list_width) "Width of list"
set options_other(group_list_width) "10 60"

set options_type(group_list_page) int
set options_header(group_list_page) "Scroll when this near end"

set options_type(mk_group_menu) bool
set options_header(mk_group_menu) "Make menus at startup"

set options_type(group_menu_read) bool
set options_header(group_menu_read)  "Include groups with no unread"

set options_type(group_menu_unsub) bool
set options_header(group_menu_unsub) "Include unsubscribed groups"

config_read
set group_menu_length $Config(group_menu_max)

#  fix color on main window frame
set color_bl [option get . background Background]
. configure -background $color_bl

# highlight surrounds of article menu
set color_bd [option get . bold {} ]
option add *menu-g*Background  $color_bd
option add *menu-pr*Background  $color_bd

# color for select
set color_bs [option get . select {} ]
#
# nn variables stuff 
#
set butt(auto-select-closed) {"select first" "select unread" "select all"}
set butt(enter-last-read-mode) {"ignore" "enter if unread(confirm)" \
	"enter next unread(conf)" "enter if unread(no conf)" \
	"enter next unread(no conf)"}
set butt(from-line-parsing) {"always" "at least 8 fields" "valid date & time"}
set butt(layout) {"name, subject, lines" "name, lines, subject" \
	"lines, subject" "subject" "usually n, l, s but s only if too long"}
set butt(marked-by-next-group) {"none" "current article" "current page" \
	"previous pages" "previous & current" "all"}
set butt(marked-by-read-return) {"none" "current article" "current page" \
	"previous pages" "previous & current" "all"}
set butt(marked-by-read-skip) {"none" "current article" "current page" \
	"previous pages" "previous & current" "all"}
set butt(print-header-type) {"No header" "Short header" "Full header"}
set butt(newsrc-sequence) {"init only" "update .newsrc sequence" \
    "use .newsrc sequence only"}
set butt(menu-spacing) {"no blank line" "between different subjects" \
	"between all aricles"}
set butt(new-group-action) {"ignore not it .newsrc" \
	"add not in .newsrc to start" "add not in .newsrc to end" \
	"add new to .newsrc" "add new to .newsrc(confirm)" \
	"add new to .newsrc( rn format)"}
set butt(re-layout) {"one > per reference(a)" "single > if Re:(b)"\
	"number references N>" "single Re:" "if references (a) else (b)"}
set butt(show-purpose-mode) {"never" "new groups" "all groups"}
set butt(sort-mode) {"arrival" "subject age" "lexical" "age" "sender" "thread lexical" "thread date"}
#
# from keymap.c

set token(K_REDRAW)			2 
set token(K_CONTINUE)			3 
set token(K_LAST_MESSAGE)		4 

set token(K_QUIT)			9 

set token(K_NEXT_PAGE)			36
set token(K_PREV_PAGE)			39 
#
set token(K_PREVIOUS)			49
#
set token(K_NEXT_ARTICLE)		52
set token(K_NEXT_SUBJECT)		53
set token(K_BACK_TO_MENU)		57
set token(K_BACK_ARTICLE)		58
set token(K_FORW_ARTICLE)		59
#
set token(K_SEL_GROUP)			71
set token(K_NEXT_GROUP_NO_UPDATE)	74
set token(K_READ_GROUP_UPDATE)		75
set token(K_S_EXTENDED_CMD)		102
#

set EV_CHAR	   1
set EV_FUNCT	   2
set EV_SELECT	   3
set EV_SELECT_C    4
set EV_RETURN	   5
set EV_INT	   6
set EV_SELECT_E    7
set EV_SELECT_C_E  8

proc set_option_values {} {
    global Config
    option_values  $Config(mk_group_menu) \
	$Config(default_article_lines) $Config(mime_handling) \
	$Config(xterm_path) $Config(group_list_read)  $Config(group_list_unsub)\
	$Config(group_list_all) $Config(group_list_width) $Config(group_menu_read) \
	$Config(group_menu_unsub) $Config(nntp_progress) $Config(nntp_progress_a) \
	$Config(group_menu_max)
}

#              execute nn function
proc put_funct {ch {type .}} {
    global ev_input ev_type EV_FUNCT

    if {$type == "m"} {
	ev_type_menu
    } 

    rec_c $EV_FUNCT $ch
#	puts stderr "<$ch>"
}

#              execute extended function
proc put_extended {cmd {type .}} {
	global token ev_param
	set ev_param $cmd
	 put_funct $token(K_S_EXTENDED_CMD) $type
}

#              put text in group info line
proc menug_put {} {
	global text_ent_t g_pt

	.menu-g delete 1.0 "1.0 lineend"
	.menu-g insert 1.0 $text_ent_t
        set g_pt 0
}

#              add string to text
proc text_add {scr} {
    global text_ent_t

    $scr insert end $text_ent_t
    if {$scr != ".menu-pr"} {
	pprompt_msg $text_ent_t
    }
}

#              delete character from end of text
proc text_delc {scr} {
    $scr delete "end -2 chars"
    if {$scr != ".menu-pr"} {
	pprompt_delc
    }
}

#              if not in group menu return to it
proc ev_type_menu {} {
	global menu_mode read_mode token EV_INT EV_FUNCT
	if {$read_mode != "c"} {
		rec_c $EV_INT 0
	}
	if {$menu_mode != "m"} {
		rec_c $EV_FUNCT $token(K_BACK_TO_MENU)
	}
}

#		handle key input	
proc put_key {k} {
    global ev_input ev_type EV_CHAR
	if {"$k" != ""} {
    		rec_c $EV_CHAR $k
	}
}

proc put_del {} {
    global EV_CHAR
    rec_c $EV_CHAR "\x8f"
}

proc put_bs {} {
    global EV_CHAR
    rec_c $EV_CHAR "\b"
}

proc put_ret {} {
    global EV_CHAR
    rec_c $EV_CHAR "\r"
}

proc button_mode {butt val} {
    $butt configure -state $val
}

proc top_y {w y} {
    set top [winfo toplevel $w]
    while {[string compare $w $top] != 0} {
	incr y [winfo y $w]
	set w [winfo parent $w]
    }
    return $y
}

proc top_x {w x} {
    set top [winfo toplevel $w]
    while {[string compare $w $top] != 0} {
	incr x [winfo x $w]
	set w [winfo parent $w]
    }
    return $x
}

proc menu_update {} {
    global token 

    put_funct $token(K_READ_GROUP_UPDATE) m
}

# Handle destroy
#
proc exit_nn {w} {
    if {$w == "."} {
	application_destroyed
    }
}

proc text_bindings {txt} {
    global has_exmh sedit

    bind $txt <Enter> "focus %W"
    bind $txt <Any-KeyPress> "put_key %A; break"
    bind $txt <Key-Delete>  "put_key %A; break"
    bind $txt <Key-BackSpace>  "put_key %A; break"
    bind $txt <Key-Return>  "put_key %A; break"
    bindtags $txt "$txt Text . all"
}

proc setup_bindings {} {
    global has_exmh sedit

    catch {
	tkEntryBind Enter
	tkTextBind Enter
	tkListboxBind Enter
    }

    bind Entry <Enter> "focus %W"
}

proc fetch_nn_variables {} {
    global print

    set print(cmd) "cat \$file | [nn_get_var printer]"
}

proc icon_scan {} {
    global nn_x_dir
    wm iconbitmap . @$nn_x_dir/tcl/tools.icon
}
proc icon_normal {} {
    global nn_x_dir
    wm iconbitmap . @$nn_x_dir/tcl/tool.icon
}

proc icon_busy {} {
    global nn_x_dir
    wm iconbitmap . @$nn_x_dir/tcl/toolb.icon
}

#
#	Main routine
#

set chp 0
set s_last 0
set list_cnt 0
set pr_pt 0
set g_pt 0
set tcl_interactive 1
set cur_menu_pos 0
set grp_x 300
set grp_y 300

set read_mode " "
set menu_mode "m"

if [file exists $nn_x_dir/tcl/exmh] {
    set has_exmh 1
} else {
    set has_exmh 0
}

set_option_values

if {$has_exmh} {
    source "$nn_x_dir/tcl/exmh/main.tcl"
    source "$nn_x_dir/tcl/exmh/exwin.tcl"
    source "$nn_x_dir/tcl/exmh/preferences.tcl"
    source "$nn_x_dir/tcl/exmh/seditBind.tcl"
    catch {
	source "$nn_x_dir/tcl/exmh/pgpMisc.tcl"
    }

    catch {
	source "$nn_x_dir/tcl/exmh/msgShow.tcl"
    }

    exmh_init
} 

prompt_Make

main_Make

list_mk .groups
thread_Make
thread_handle_Make .groups.t

group_handle_Make .menu

set split_group [option get . split_group {}]
regsub -all , $split_group ., split_group
regsub "_." $split_group "_" split_group
set split_group "$split_group.,"

setup_bindings
bind . <Destroy> "exit_nn %W"

icon_normal


if {[info exists Config(.nn)]} {
    wm geometry . $Config(.nn)
}
wm maxsize . 2400 2400
menu_resize $Config(menu_max)

list_tabs .groups.list








