/**************************** NN CONFIGURATION ***************************
 *
 *	Configuration file for nn.
 *
 *	You must edit this file to reflect your local configuration
 *	and environment.
 *
 *	Before editing this file, read the licence terms in the README
 *	file and the installation guidelines in the INSTALLATION file.
 *
 *	(c) Copyright 1990, Kim F. Storm.  All rights reserved.
 */

#define	RELEASE 	"6.5"

#include "nnconfig.h"

#include <stdio.h>
#include <ctype.h>

/************************* USER INTERFACE *********************************
 *
 *	TK
 *	Compile to use X windows interface using the TK toolkit
 *	Requires tcl and tk be installed
 *
*/
#define TK

/*      TCL and TK include files (overide configure) */
/* #define TKINCLUDE -I/usr/local/include/tcl */

/*      TCL and TK libraries (overide configure) */
/* #define TKLIB -I/usr/local/lib -ltk4.0 -ltcl7.4 -lX11 -lm */

/********************************** NNTP *********************************
 *
 * 	Define NNTP to enable nntp support.  If you are not using NNTP,
 *	just leave the following NNTP_* definitions as they are - they
 *	will be ignored anyway.
 *
 *	Consult the file NNTP for further information on the use of NNTP.
 */

#define NNTP

/*********************************** INEWS *********************************
 *  Define your local domain name.  You *must* define something if
 *  the domain name is not included in the hostname.
 *
 *  You are not strictly *required* to have a domain name; nonetheless
 *  it's a good idea.  If you are on the Internet or otherwise have a
 *  valid domain name, use it (except see HIDDENNET below).  If you're
 *  a uucp-only site, use ".uucp" for now and go get a real name.
 *
 *  Note that if you imbed your domain name in the hostname and you don't
 *  use HIDDENNET, you may get a period on the end of your fully qualified
 *  domian name (FQDN) in postings.  In that case, use HIDDENNET and
 *  define DOMAIN to be your FQDN.
 */

#define	DOMAIN	"un.configured.domain"

/*
 *  If you define this, the hostname will not appear in the posting
 *  data except on the path.  Items will be from user@DOMAIN (with
 *  DOMAIN as defined above).  If you don't want this, comment it out.
 */

/*#define	HIDDENNET*/

/*********************************** NNTP *********************************
 *	Define NNTP_SERVER to the name of a file containing the name of the
 *	nntp server.
 *
 *	It is vital that both the nnmaster and all nn users on a machine
 *	uses the same nntp server, because the nn database is synchronized
 *	with a specific news active file.
 *
 *	If the file name does not start with a slash, it is relative to
 *	LIB_DIRECTORY defined below.
 *	NOTE: If you plan to use the included inews, it MUST be a full pathname
 */

#define NNTP_SERVER	"/usr/lib/nntp_server"

/*
 *
 *      Defining NO_NNTP_SERVER_READ causes NNTP to ignore the NNTP_SERVER
 *      file for reading news but still allows the -R command to specify
 *      an NNTP sever. The purpose of this is to allow for occasional
 *      reading of news via NNTP in stiuations where news reading is 
 *      usually done from local files but posting is via NNTP.
 */

/* #define NO_NNTP_SERVER_READ */

/*
 *	Define NNTP_POST if you want nn to reject attempts to post via
 *	NNTP to a server, that disallows postings.
 *
 *	You should define this, if you use the NNTP based mini-inews for
 *	postings from NNTP clients.  If you use another mechanism, that
 *	does not involve NNTP, you should leave it undefined.
 */

#define NNTP_POST

/*
 *	NNTP's mini-inews seems to require that messages contain a complete
 *	header with Message-ID, Path, and Date fields which the normal inews
 *	generates itself.  If your mini-inews requires these headers to
 *	be present, define NNTP_MINI_INEWS_HEADER below.
 *
 *      NOTE: this is unlikely to be required.
 */

#undef NNTP_MINI_INEWS_HEADER	/* uses "broken" mini-inews */

/*
 *	Define NNTP_PATH_HOSTNAME to force a specific hostname into the
 *	Path: header generated when NNTP_MINI_INEWS_HEADER is defined.
 *	This is useful for multi-machine sites with one mail/news gateway.
 *
 *	If the string starts with a '/' it is taken as the name of a file
 *	from which the outgoing hostname should be read (at runtime).
 */

/* #define NNTP_PATH_HOSTNAME	"puthostnamehere"	*/
#define NNTP_PATH_HOSTNAME	"/usr/lib/news/nntp_path"


/*********************************** DIGEST *********************************
*
*    DO_NOV_DIGEST allows auto-splitting of digests
*/
#define DO_NOV_DIGEST

/***************** OPERATING SYSTEM DEPENDENT DEFINITIONS *******************
/*
 *	Define DEFAULT_PAGER as the initial value of the 'pager' variable.
 *	nnadmin pipes shell command output though this command.
 */

/* #define DEFAULT_PAGER	"pg -n -s" */		/* system V */
#define DEFAULT_PAGER		"less"			/* bsd */

/*
 *	DEFAULT_PRINTER is the initial value of the 'printer' variable.
 *	nn's :print command pipes text into this command.
 */

#define DEFAULT_PRINTER		"lp -s"			/* System V */
/* #define DEFAULT_PRINTER	"lpr"	*/ 	/* bsd */


/**************************** LOCALIZATION ****************************
 *
 *	Specify where programs and files are installed.
 *
 *	BIN_DIRECTORY    - the location of the user programs (mandatory)
 *
 *	LIB_DIRECTORY	 - the location of auxiliary programs and files.
 *			   (mandatory UNLESS ALL of the following are defined).
 *
 *	MASTER_DIRECTORY - the location of the master program (on server)
 *			   (= LIB_DIRECTORY if undefined)
 *
 *	CLIENT_DIRECTORY - the location of auxiliary programs (on clients)
 *			   (= LIB_DIRECTORY if undefined)
 *
 *	HELP_DIRECTORY   - the location of help files, online manual, etc.
 *			   (= CLIENT_DIRECTORY/help if undefined)
 *
 *	CACHE_DIRECTORY	 - if NNTP is used, nn uses this central directory
 *			   to store working copies of articles on the local
 *			   system.  If not defined, it stores the articles
 *			   in each user's ~/.nn directory.
 *
 *	TMP_DIRECTORY    - temporary file storage.  Overriden by $TMPDIR.
 *			   (= /usr/tmp if undefined).
 *
 *	LOG_FILE         - the location of nn's log file.
 *			   (= LIB_DIRECTORY/Log if undefined).
 */

#define BIN_DIRECTORY	"/usr/local/bin"
#define LIB_DIRECTORY	"/usr/local/lib/nn"

/*************************** NEWS TRANSPORT **************************
 *
 *	Specify the location of your news programs and files
 *	You only need to specify these if you are not
 *	satisfied with the default settings.
 *
 *	NEWS_DIRECTORY	 	- The news spool directory.
 *				  Default: /usr/spool/news
 *
 *	NEWS_LIB_DIRECTORY	- The news lib directory.
 *				  Default: /usr/lib/news
 *
 *	NOV_DIRECTORY		- The .overview directory.
 *				  Default: /usr/spool/news
 *
 *	INEWS_PATH		- The location of the inews program.
 *				  Default: NEWS_LIB_DIR/inews
 *
 *	RMGROUP_PATH		- The location of the rmgroup program.
 *				  Default: NEWS_LIB_DIR/{rm,del}group
 */

#define NEWS_DIRECTORY		"/usr/spool/news"
#define NEWS_LIB_DIRECTORY	"/usr/lib/news"
#define NOV_DIRECTORY		"/usr/spool/news"

/* path to inews (overide configure) */
/* #define INEWS_PATH		"/usr/lib/news/inews"	*/


/*
 *	If no "Lines:" header field is present, NN can be made to
 *	count them itself.
 */

/* #define DONT_COUNT_LINES	1 */

/*************************** MAIL INTERFACE *************************
 *
 *	Specify a mailer that accepts a letter WITH a header IN THE TEXT.
 *
 * 	A program named 'recmail' program is normally delivered with
 *	the Bnews system, or you can use sendmail -t if you have it.
 *
 *	The contrib/ directory contains two programs which you might
 *	be able to use with a little tweaking.
 */

/* #define REC_MAIL	"/usr/lib/news/recmail"	*/	/* non-sendmail */
#define REC_MAIL	"/usr/lib/sendmail -t"		/* sendmail */


/*
 *	Define HAVE_ROUTING if your mailer understands domain based
 *	adresses (...@...) and performs the necessary rerouting (e.g.
 *	Sendmail or Smail).
 *
 *	Otherwise, nn will provide a simple routing facility using
 *      routing information specified in the file LIB_DIRECTORY/routes.
 */

#define HAVE_ROUTING			/* */

/*
 *	If HAVE_ROUTING is NOT defined, nn needs to know the name of
 * 	your host.  To obtain the host name it will use either of the
 *	'uname' or 'gethostname' system calls as specified in the s-
 *	file included above.
 *
 *	If neither 'uname' nor 'gethostname' is available, you must
 *	define HOSTNAME to be the name of your host.  Otherwise, leave
 *	it undefined (it will not be used anyway).
 */

/* #define HOSTNAME	"myhost" */	/* Not used if HAVE_ROUTING */

/*
 *	Define APPEND_SIGNATURE if you want nn to ask users to append
 *	~/.signature to mail messages (reply/forward/mail).
 *
 *	If the mailer defined in REC_MAIL automatically includes .signature
 *	you should not define this (it will fool people to include it twice).
 *
 *	I think 'recmail' includes .signature, but 'sendmail -t' doesn't.
 */

#define APPEND_SIGNATURE		/* */

/*
 *	BUG_REPORT_ADDRESS is the initial value of the bug-report-address
 *	variable which is used by the :bug command to report bugs in
 *	the nn software.  
 *	This address is currently set up as a mailing list, and it is
 *	intended that it will point to the current maintainer.
 */

#define BUG_REPORT_ADDRESS	"bugs@nn.org"


/*************************** DOCUMENTATION ***************************
 *
 * 	Specify directories for the user and system manuals
 *
 * 	Adapt this to your local standards; the manuals will be named
 * 		$(MAN_DIR)/program.$(MAN_SECTION)
 *
 *	USER_MAN	- nn, nntidy, nngrep, etc.
 *	SYS_MAN		- nnadmin
 *	DAEMON_MAN	- nnmaster
 */

#define USER_MAN_DIR 	"/usr/local/man/man1"
#define USER_MAN_SECTION 	"1"

#define SYS_MAN_DIR 	"/usr/local/man/man1"
#define SYS_MAN_SECTION 	"1m"

#define DAEMON_MAN_DIR 	"/usr/local/man/man8"
#define DAEMON_MAN_SECTION 	"8"


/************************** LOCAL POLICY *****************************
 *
 *	Define STATISTICS if you want to keep a record of how much
 *	time the users spend on news reading.
 *
 *	Sessions shorter than the specified number of minutes are not
 *	recorded (don't clutter up the log file).
 *
 *	Usage statistics is entered into the $LOG_FILE with code U
 */

/* #define STATISTICS	5 */ 		/* minutes */

/*
 *	Define ACCOUNTING if you want to keep accumulated accounting
 *	based on the statistics in a separate 'acct' file.  In this
 *	case, the accounting figures will be secret, and not be
 *	written to the Log file.  And the users will not be able to
 *	"decrease" their own account.
 *
 *	See account.c for optional cost calculation parameters.
 */

/* #define ACCOUNTING */

/*
 *	Define AUTHORIZE if you want to restrict the use of nn to
 *	certain users or certain periods of the day.  Define both
 *	this and ACCOUNTING if you want to impose a usage quota
 *
 *	See account.c for implementing various access policies.
 */

/* #define AUTHORIZE */

/*
 *	Default folder directory
 */

#define FOLDER_DIRECTORY	"~/News"

/*
 *	Max length of authors name (in "edited" format).
 *	Also size of "Name" field on the article menus.
 *	You may want to increase this if your terminals are wider than
 *	80 columns.
 */

#ifdef TK
#define NAME_LENGTH 		24
#else
#define NAME_LENGTH 		16
#endif

/*
 *	Does your 'inews' program run immediately, or does it defer?
 *	If you have C-News, it can take minutes to find out if a post
 *	was accepted, whereas with INN, it only takes seconds.
 */

#define INEWS_IS_FAST		/* comment out for C-News */

/*
 *	Synchronous posting: If set this will cause NN to wait until a
 *	post or mail is *actually* finished.  If you want to NN's
 *	"Article posted" message to be *accurate*, then define this. 
 *	Warning: Do NOT define this if you are using C-News, or you will
 *	have to wait 60 seconds or more to find out if the post has been
 *	accepted.  You probably want this if you are using INN or posting
 *	via some sort of NNTP.
 */

#define SYNCHRONOUS_POSTING	/* comment out for C-News */

/*
 *	PUT_TIMESTAMP_IN_SCRIPTS
 *	Defining this causes the "inst" script to add identifying information
 *	to the beginning of the shell scripts.
 */
#define PUT_TIMESTAMP_IN_SCRIPTS

/*
 *	CONFIG_NUM_IN_VERSION
 *	Defining this will make NN announce itself including the build number
 *	like "NN version 6.5.xx #12", rather than "NN version 6.5.xx".
 */
#define CONFIG_NUM_IN_VERSION

/*
 *	NO_X_NEWSREADER
 *	Define this to disable the "X-Newsreader: " header in posts and mail
 *	Son-of-RFC1036 is rumoured to discourage this.
 */
/* #define NO_X_NEWSREADER */

/*
 *	ART_GREP
 *	Define this if you want to enable the "experimental" subject
 *	body search code.  On the "G" menu, there will be two extra
 *	choices: "b" body search unread, and "B" body search all.
 *	Choose your pattern, and you will be presented with a merged group
 *	containing the articles you chose.  There may still be bugs!
 *	WARNING:
 *	THIS WOULD BE *BAD* FOR NNTP SITES!  You don't want all your
 * 	users downloading the entire news database...
 */

#define ART_GREP

/*
 *	CACHE_PURPOSE
 *	Defining this makes NN cache the newsgroup/purpose list, sorted
 *	in memory and use binary search to locate a group's purpose.
 *	This can be a winner on systems with *everything* in their
 *	newsgroups list.
 */

#define	CACHE_PURPOSE


/************************ CONFIGURATION COMPLETED ************************/

#include "global.h"
