
# (Large) prefix inserted above by Make

PATH="$PATH:/etc:/usr/sbin"

case "$1" in
mkdir)
	if [ -n "$2" -a ! -d "$2"/. ]
	then
		mkdir $2
		if [ ! -d "$2" ] ; then
			echo "Cannot create directory $2"
			exit 1
		fi
		chmod $3 $2
		echo Created directory $2
	fi
	exit 0
	;;
copy)
	cp $4 $3
	chmod $2 $3/$4
	echo "$4 -> $3/$4"
	exit 0
	;;
chmod)
	chmod $2 $3
	exit 0
	;;

inews)
	if [ ! -f ./usercheck ] ; then
		ln ./usercheck usercheck
	fi
	if [ ! -d "${INEWS_DIR}"/. ]
	then
		./inst mkdir ${INEWS_DIR} 755 || exit 1
	fi
	echo Installing $2 in $INEWS
	cp $2 $INEWS && ./inst chmod 755 $INEWS
	exit 0
	;;
esac

set -u

(
if $NNTP
then
	:
else
	if [ ! -d "$SPOOL"/. ]
	then
		echo Error: News spool directory $SPOOL not found.
	fi

	if [ ! -d "$NLIB"/. ]
	then
		echo Error: News lib directory $NLIB not found.
	fi
fi

set $INEWS
if [ ! -f "$1" ]
then
	echo Note: Inews program $INEWS not installed yet
fi

set $RECMAIL
if [ ! -f "$1" ]
then
	echo ERROR: Mailer program $RECMAIL not found.
fi
) > ErrorCheck

if [ -s ErrorCheck ]
then
	cat ErrorCheck
	echo "Hit return to continue"
	read X
fi
rm -f ErrorCheck

LOOP=true
while $LOOP
do

if [ $# -ge 1 ]
then
	OPT="$1"
	shift
	if [ $# -eq 0 ]
	then
		LOOP=false
	fi
	PAUSE=false
else
	PAUSE=true

cat <<'EOF'


INSTALLATION

1) User programs (machince dependent, shareable)
2) auxiliary programs (configuration dependent, shareable)
3) Documentation (shareable)
4) Help files (shareable)
5) Online manual (shareable with 5)
6) nn-tk program
7) inews

n) nn installation:      1 + 2 + 3 + 4 + 5 
t) nn-tk installation:   1 + 2 + 3 + 4 + 5 + 6
h) Shared installation:  1 + 2
c) Client installation:      2
u) Update after patch
q) Quit

EOF
if ./usercheck 0 ; then
	:
else
  echo "Warning: not running as super user"
  echo ""
fi
${AWK} 'BEGIN{printf "Select option: "}' < /dev/null
read OPT
echo

fi

case $OPT in

s*|a*)
	OPT="master bin aux help online man"
	;;
u*)
	OPT=""
	if [ -f "$BIN/nn" ]
	then
		OPT="$OPT bin"
	fi
	if [ -f "$LIB/aux" ]
	then
		OPT="$OPT aux"
	fi
	if [ -d "$HELP" ]
	then
		OPT="$OPT help"
	fi
	if [ -f "$DMAN_DIR/nnmaster.$DMAN_SECT" ]
	then
		OPT="$OPT man"
	fi
	if [ -f "$HELP/Manual" ]
	then
		OPT="$OPT online"
	fi
	;;
n)
	OPT="bin aux help online man"
	;;
t)
        OPT="nn-tk aux help online man"
        ;;
1|c)
	OPT=bin
	;;
h)
	OPT="bin aux"
	;;
2)
	OPT="aux"
	;;
3)
	OPT="man"
	;;
4)
	OPT="help"
	;;
5)
	OPT="online"
	;;
6)
	OPT="nn-tk"
        ;;
7)
	OPT="inews"
        ;;
q*|"")
	exit 0
	;;
*)
	echo "Unrecognized option: $OPT"
	exit 1
	;;
esac

for OP in $OPT
do
case "$OP" in

inews)
	./inst inews inews/inews
	;;

nn-tk)
       echo Installing nn-tk programs in $BIN
       for prog in nn-tk
       do
               ./inst copy 755 $BIN $prog
       done
       ;;
bin)
	echo
	if [ ! -d "$BIN"/. ]
	then
		echo Directory $BIN does not found!
		exit 1
	fi

	echo Installing user programs in $BIN

	if [ -f $BIN/nn ]
	then
	     (
		cd $BIN
		mv nn nn.old
		rm -f $BIN_PROG $BIN_LINK
	     )
	fi

	for prog in $BIN_PROG
	do
		./inst copy 755 $BIN $prog
	done

	for link in $BIN_LINK
	do
		ln $BIN/nn $BIN/$link
		echo $link linked to nn
	done

	if [ -f $BIN/nnacct ] ; then
		chmod 4755 $BIN/nnacct
		echo nnacct is setuid ${OWNER}.
	fi
	;;

aux)
	echo
	./inst mkdir $LIB 755 || exit 1

	echo Installing auxiliary programs in $LIB

	for prog in $LIB_PROG
	do
		./inst copy 755 $LIB $prog
	done

       ./inst mkdir $LIB/tcl 755 || exit 1

       for prog in tcl/*
       do
	  if test -f $prog
	  then
               cp $prog $LIB/tcl
               ./inst chmod 755 $prog
	  fi
       done
       if test -d "$EXMH_DIR"
       then
	  rm $LIB/tcl/exmh
	  ln -s $EXMH_DIR $LIB/tcl/exmh
       fi

	./mkprefix conf > ${LIB}/conf
	grep "^#" config.h |
	sed -e '/_MAN_/d' -e 's/[ 	]*\/\*.*$//' >> ${LIB}/conf
	./inst chmod 644 ${LIB}/conf
	;;

help)
	./inst mkdir $HELP 755 || exit 1

	echo
	echo Installing help files in $HELP


        for h in `cd help; echo *`
	do
		./cvt-help < help/$h > $HELP/$h
		./inst chmod 644 $HELP/$h
		echo $h
	done
	;;

man)
	echo
	echo Installing manuals

	PL="`echo $VERSION | sed -e 's/ .*$//'`"
	{
		echo $UMAN_DIR $UMAN_SECT .1
		echo $SMAN_DIR $SMAN_SECT .1m
		echo $DMAN_DIR $DMAN_SECT .8
	} |
	while read DIR SECT SRC
	do
		if [ -d "$DIR"/. ]
		then
			for i in man/*$SRC
			do
				MAN=`basename ${i} $SRC`
				NEW=$DIR/${MAN}.$SECT
				sed -e '/^\.TH /s/6.5/'${PL}'/' $i > $NEW
				./inst chmod 644 $NEW
				echo $MAN in $NEW
			done
		else
			echo $DIR not found or not writeable
		fi
	done
	;;

online)
	./inst mkdir $HELP 755 || exit 1

	MAN=$HELP/Manual

	echo
	echo "Formatting online manual $MAN"
	echo ".... (continues in background) ...."

	rm -f $MAN

	(
	sed 	-e 's/\\f[BPI]//g' \
		-e 's/\\-/-/g' -e 's/\\&//g' -e 's/\\e/\\/g' \
		-e '/^\.\\"ta/p' -e '/^\.\\"/d' \
		-e '/^\.nf/d' -e '/^\.fi/d' \
		-e '/^\.if/d' -e '/^\.ta/d' -e '/^\.nr/d' \
		-e '/^\.in/d' -e 's/^\.[BI] //' \
		`grep '^man/' MANIFEST | ${AWK} '{print $1}'` |
	${AWK} -f format.awk - > $MAN

	./inst chmod 644 $MAN
	) &
	;;

esac

done

if [ -f $LOG ]
then
	chmod 666 $LOG
fi

if $PAUSE
then
${AWK} 'BEGIN{printf("\nHit return to continue....")}' < /dev/null
read X
fi
done
