#
#  Popup showing nntp transfer  progress
#
proc nntp_lmsg {cnt aflg} {
    global Config

    if {$Config(compressed_prompt) != 0} {
	mprompt_msg $cnt
    }

    if {$Config(compressed_prompt) != 2} {
	if {[wm state .] != "iconic"} {
	    if {![winfo exists .nntpm]} {
		toplevel .nntpm
		wm transient .nntpm .
		label .nntpm.l -text  $cnt
		pack .nntpm.l -padx 20 -pady 7 -expand yes
		if {$aflg == 1} {
		    frame .nntpm.f -relief ridge -borderwidth 2
		    button .nntpm.f.a -text "Cancel" -command "nntp_abort"
		    pack .nntpm.f.a 
		    pack .nntpm.f -expand yes -fill x
		}
		wm minsize .nntpm 0 0
		if {[info exists Config(.nntpm)]} {
		    wm geometry  .nntpm $Config(.nntpm)
		}
	    } else {
		.nntpm.l configure -text $cnt
	    }
	}
    }
    update
}

proc nntp_kmsg {} {
    global Config

    if {$Config(compressed_prompt) != 0} {
	mprompt_clear
    }
    if {$Config(compressed_prompt) != 2} {
	catch {destroy .nntpm}
    }
}
    
#
#  Posting PoPup
#
# Pass values in global variables because they may have arbitrary
# characters in them
#
proc post_Make {already increment imessage args} {
    global Config has_exmh
    toplevel .post
    frame .post.s
    pack .post.s

    set n 0
    foreach x $args {
	global post_$x
	frame .post.s.f$n
	label .post.s.f$n.l -text $x
	pack .post.s.f$n.l -side left -expand yes -fill x
	entry .post.s.f$n.e  -width 60
	.post.s.f$n.e delete 0 999
	.post.s.f$n.e insert 0 [set post_$x]
	pack   .post.s.f$n.e -side right
	pack .post.s.f$n -fill x
	incr n
    }

    if {$increment == "1"} {
	frame .post.i -borderwidth 2  -relief ridge
	checkbutton .post.i.b -variable post_include -text $imessage -relief flat
	global post_include
	set post_include 1
	pack .post.i.b
	pack .post.i -expand yes -fill x
    }

    frame .post.x -relief sunken -borderwidth 2
    if {$already != -1} {
	if {$already == 1} {
	    set xedit x
	} else {
	    set xedit s
	}
	button .post.x.go -text "  Do  " -command "post_do $xedit $n"
	button .post.x.exit  -text "Cancel" -command "post_exit"
	pack .post.x.go  .post.x.exit -side left -padx 25m -pady 5m
    } else {
	if {$has_exmh} {
	    button .post.x.edit -text "internal editor" -command "post_do  s $n"
	} else {
	    button .post.x.edit -text "internal editor" -command "post_do  s $n" -state disabled
	}
	button .post.x.xt -text "external editor" -command "post_do x $n" 
	button .post.x.exit  -text "Cancel" -command "post_exit"

	pack .post.x.edit .post.x.xt .post.x.exit -side left -padx 12m -pady 5m
    }
    pack .post.x -side top -fill both -expand yes

    if {[info exists Config(.post)]} {
	wm geometry  .post $Config(.post)
    }
    wm minsize .post 0 0
}

proc post_do {c n} {

    if {$n > 0} {
	for {set i 0} {$i < $n} {incr i} {
	    set var [lindex [.post.s.f$i.l configure -text] 4]
	    global post_$var
	    set post_$var  [.post.s.f$i.e get]
	}
    }

    if {![info exists post_Subject] || $post_Subject != ""} {
	put_key $c
	destroy .post
    } else {
	msg_tmp "You must enter a subject"
    }
}

proc post_exit {} {
    put_key  e
    destroy .post
}

#
# message - popup
#
proc msg_Make {mess warn} {
    global Config

    if {$Config(compressed_prompt) != 0} {
	mprompt_msg $mess
    }

    if {($Config(compressed_prompt) != 2) || $warn} {
	catch {destroy .msg}
	toplevel .msg
	wm transient .msg .
	wm geometry .msg +300+300

	message .msg.m -text $mess -aspect 800

	pack .msg.m -side left -expand yes -fill both
    }    
}

proc msg_destroy {} {
    global Config

    if {$Config(compressed_prompt) != 0} {
	mprompt_clear
    }
    catch {destroy .msg}
}

proc msg_tmp {mess} {
    global Config

    msg_Make $mess 0
    if {$Config(compressed_prompt) != 2} {
	after 5000 {msg_destroy}
    }
}

proc msg_warn {mess} {
    global Config

    msg_Make $mess 1
    if {$Config(compressed_prompt) != 2} {
	after 5000 {msg_destroy}
    }
}

#
#	Group cascading menus
# 
#		pass group selection to nn
proc gg {grp {menu ""}} {
    global grp_x grp_y
    global gm_type ev_param ev_type ev_input 
    global EV_FUNCT token

    if {$menu != ""} {
	update
#	puts [winfo rootx .top.m.menu.$menu]
#	puts [winfo rooty .top.m.menu.$menu]
#	puts [winfo geometry  .top.m.menu.$menu]
	scan  "[winfo geometry  .top.m.menu.$menu]" "%dx%d+%d+%d" sx sy x y
	set ya [.top.m.menu.$menu yposition active]
    } else {
	scan  "[winfo geometry  .top.m.menu]" "%dx%d+%d+%d" sx sy x y
	set ya [.top.m.menu yposition active]
    }

    set grp_x [expr $sx/2+$x]
    set grp_y [expr $y+$ya-6]
    set gm_type "m"
    set ev_param $grp
    ev_type_menu
    rec_c $EV_FUNCT $token(K_SEL_GROUP)
}

#		display group jump menu
proc gr_Make {} {
    global grp_x grp_y
    global list_cnt first_menu

    incr list_cnt

    if {[winfo exists .gr-popup]} {
	destroy .gr-popup
    }
    menu .gr-popup
    .gr-popup add command -label "Enter Group"
    .gr-popup add separator
    foreach i {"j)jump" "J)Jump read" "a)all"  "s)subject" "n)name" "e)either" \
		   "u)unread" "@)archive"} {
	set a [string index $i 0]
	set i [string range $i 2 end]
	.gr-popup add command -label $i -accelerator $a -command "gr_select $a"
    }

    if {![info exists grp_x]} {
	if {[info exists .menu]} {
	    set grp_x [winfo rootx .menu]
	    set grp_y [winfo rooty .menu]
	}
    }
    if {[info exists grp_x]} {
	.gr-popup configure -tearoff no
	tk_popup .gr-popup $grp_x [expr $grp_y-35]
	grab release .gr-popup
	if {![info exists first_menu]} {
#	    tkMenuBind .gr-popup Enter
	    set first_menu 1
	}
	
	unset grp_x grp_y
	update
    }
}

#		group jump menu selection
proc gr_select {x} {
    global ev_input  ev_type EV_CHAR 
    global list_cnt      

    rec_c $EV_CHAR $x
    .gr-popup unpost
    destroy .gr-popup
    set list_cnt 0
}

proc gr_del {} {
    global list_cnt      
    #   fudgy variable to make sure window
    #   isn't destroyed if it has to be reposted

    if {$list_cnt <= 1} {
	if {[winfo exists .gr-popup]} {
	    destroy  .gr-popup
	}
    }
    incr list_cnt -1
}

#
#	Group List
#
proc list_group {grp yc} {
    set t [$grp get $yc.0 $yc.9999]
    set l [expr [string first "\t" $t]-1]
    if { $l > 0 } {
	set t [string range $t 0 $l]
    }
    return $t
}

#		pass group list selection to nn
proc list_select {grp y} {
    global gm_type ev_param ev_input ev_type 
    global EV_FUNCT token

    set gm_type 'g'

    list_mark $grp $y

    set t [list_group $grp.list $y]
#       puts stderr "$grp<$y>$t-"
    set ev_param $t
    if {$grp == ".folders"} {
	set ev_param "+$ev_param"
    }
    ev_type_menu
    rec_c $EV_FUNCT $token(K_SEL_GROUP)
}

#		replace a group list entry
proc list_update {ent y} {
#    puts "list_update $ent $y"
    if {$y >= 0} {
	set nm [.groups.list tag names $y.0]
	.groups.list delete $y.0 $y.9999
	.groups.list insert $y.0 $ent $nm
    }
}

proc list_add {ent y} {
#     puts "list_add $ent $y"
    .groups.list insert end "$ent\n"
}

proc list_flag {type rc {y 0} } {
#    puts "list_flag $type $rc $y"

    if {$y >=  0} {
	if {$y == 0} {
	    scan [.groups.list index end] %d.%d y x
	    set y [expr $y-2]
	}

	if {$type == "n"} {
	    .groups.list insert $y.9999 "\t "
	    .groups.list insert $y.9999 N lred
	} elseif {$type == "u"} {
	    .groups.list insert $y.9999 "\t "
	    .groups.list insert $y.9999 U lblue
	} elseif {$rc > 0  }  {
	    .groups.list insert $y.9999 "\t "
	}	
	if {$rc > 0  }  {
	    .groups.list insert $y.9999 "\|" lgreen
	}
    }
}

proc list_flag_raise {} {
    .groups.list tag raise lred
    .groups.list tag raise lblue
    .groups.list tag raise lgreen
}

proc group_save {n} {
    global gpos_save
    set gpos_save $n
}

proc group_ret {t} {
    global gpos_save
    if {$t == "r"} {
	list_mark .groups $gpos_save
    }
}

proc list_pos_save {} {
    global list_pos_s
    catch {
	set n [.groups.list get sely.first sely.last]
	scan $n "%s" list_pos_s
    }
}

proc list_pos_ret {} {
    global list_pos_s
    catch {list_mark .groups [lookup_group_pos $list_pos_s]}
}

proc list_cl {} {
    global Config

    .groups.list configure -width $Config(group_list_width)
    list_tabs .groups.list
}

proc list_clear {} {
    if {[winfo exists .groups] != 0} {
	list_pos_save
	.groups.list delete 0.0 end
	list_tabs .groups.list
	grp_list
	list_pos_ret
    }
}

proc list_reset {} {
    if {[winfo exists .groups] != 0} {
	list_pos_save
	destroy .groups
	list_Make .groups grp_list
	thread_Make
	list_pos_ret
    }
}

#		mark current group 
proc list_mark {w y} {
    global Config

    if {[winfo exists $w] != 0} {
	if {$y > 0} {
	    $w.list tag remove sely 0.0 end
	    $w.list tag add sely $y.0 [expr $y+1].0
	    $w.list tag raise sely

	    set t [$w.scroll get]
	    scan $t "%f %f" first last
	    set lines [$w.list index end]
	    set yl [expr $lines*$last]
	    set yf [expr $lines*$first]
#	    puts "lines=$lines first=$first last=$last yl=$yl yf=$yf y=$y"
	    if {($y > [expr $yl-$Config(group_list_page)]) || \
		    ($y < [expr $yf+$Config(group_list_page)])} {
		$w.list yview [expr $y-4]
	    }
	}
    }
}

# 		create group list
proc list_Make {grp flist} {
    if {[winfo exists $grp] == 0} {
	list_mk $grp
	$flist
    }
}

proc group_handle_Make {w} {
    global color_bd

    frame $w-handle -height 12 -width 12 -relief raised -borderwidth 2 \
	-cursor sb_h_double_arrow -background $color_bd
    place $w-handle -rely 0.05 -x -12 -in $w

    set xsize [lindex [.groups.thr.y configure -width] 4]
    bind $w-handle <Button-1> "group_drag $w 0 $xsize"
    bind $w-handle <B1-Motion> "group_drag $w %x $xsize"
    bind $w-handle <ButtonRelease-1> "group_drag_resize $w %x $xsize"
    frame $w-bar -width 3 -height 1800 -bg red
}

proc group_drag {w x xsize} {
    place $w-bar -y [top_y  $w 0] -x [expr [top_x  $w $x] - $xsize] -anchor n
}
    
proc group_drag_resize {w x xsize} {

    if {$x < 0} {
	set xsize [expr $xsize*2]
    }
    set curr [expr [top_x  $w $x] - $xsize]

    group_drag_resize_do $w $curr

    set nycurr [winfo height .groups.t]
    pack propagate .groups.t 0
    .groups.t configure -width $curr -height $nycurr

    list_tabs .groups.list
    place  forget $w-bar
}

proc group_drag_resize_do {w curr} {
    global Config

    pack propagate .groups.t false
    pack propagate .groups.t true
    set menu_top [top_x .groups.list 0]
    set menu_height [winfo width .groups.list]
    set menu_chars [lindex [.groups.list configure -width] 4]
    set new_size [expr (($curr-$menu_top)*$menu_chars)/$menu_height]
    .groups.list configure -width $new_size
    set Config(group_list_width) $new_size
}

proc group_color {pat col} {
    global color_list

    set start 0.0
    .groups.list  tag configure b$col -background  $col -foreground black
    lappend color_list b$col
    while {[set fnd [.groups.list search $pat $start end]]  != "" } {
	scan $fnd %d yc
	.groups.list tag add b$col $yc.0 [expr $yc+1].0
	set start [expr $yc+1].0
    }
    update
}
    
proc group_color_clear {} {
     global color_list

    foreach c $color_list {
	.groups.list  tag remove $c 0.0 end
    }
}

proc group-search {grp up} {
    global grp_x grp_y

    set srch [$grp.search.txt get]

    if {$up} {
	set start 999999.1
	scan [$grp.list tag ranges sely] "%s" start
	set fnd [$grp.list  search -backwards  $srch $start 0.0]
    } else {
	set start 0.1
	scan [$grp.list tag ranges sely] "%s %s" d start
	set fnd [$grp.list search  $srch $start end]
    } 

    if {$fnd != ""} {
	scan $fnd %d i
	list_select $grp $i
	list_mark $grp $i
	set grp_x [expr [winfo rootx $grp.search.bt]+15]
	set grp_y [winfo rooty $grp.search.bt] 
	return
    }

    msg_tmp "Group no found"
}

proc group-srch {grp} {
    frame $grp.search

    button $grp.search.bt -image down -command "group-search $grp 0" -bd 2 \
	-relief raised
    button  $grp.search.bf -image up  -command "group-search $grp 1"\
	-bd 2 -relief raised
    entry $grp.search.txt -relief sunken 
    pack $grp.search.bt $grp.search.txt $grp.search.bf -side left  -pady 2 

    bind $grp.search.txt <Return> "group-search $grp 0; break"
}


proc list_press {grp window x y} {
    global grp_x grp_y

    scan [$window index @$x,$y] %d.%d yc xc
    set i [$window index @$x,$y]
#puts "x=$x y=$y i=$i xc=$xc yc=$yc"
    list_select $grp $yc
    set x [expr [winfo rootx $window]+$x]
    set y [expr [winfo rooty $window]+$y]
    set grp_x $x
    set grp_y $y 
}

proc list_tabs {w} {
    global  Config

#   need to substantiate the window to get the right size
    update
    set t2 [winfo width $w]

    incr t2 -8
    if {$Config(group_list_all)} {
	set t1 [expr $t2-40]
    } else {
	set t1 [expr $t2-20]
    }
    $w configure -tabs "$t1 right $t2  right [expr $t2+10] right"
}

proc list_mk {grp} {
    global color_w color_bs Config nn_x_dir drag_id

    set drag_id 0
    if {$grp == ".groups"} {
	if {$Config(single_main)} {
	    .top.f.func.w entryconfigure 1 -state disabled
	    frame  $grp -relief ridge -borderwidth 2
	} else {
	    .top.f.func.w entryconfigure 1 -state normal
	    toplevel $grp
	    if {[info exists Config(.groups)]} {
		set geom $Config(.groups)
	    }
	}
    } else {
	toplevel $grp
	if {[info exists Config(.folders)]} {
	    set geom $Config(.folders)
	}
    }

    frame $grp.t
    frame $grp.t.b -borderwidth 2  -relief ridge
    group-srch $grp
    if {$grp ==  ".groups"} {
	checkbutton $grp.mod -text Modify -command {modify_Make} \
	    -relief raised -bd 2 -variable groups_mod
	pack $grp.mod -in $grp.t.b -side left -padx 5
    }
    pack $grp.search -in $grp.t.b
    pack $grp.t -side top -fill both

    if {!$Config(single_main) || $grp !=  ".groups"} {
	button $grp.t.dis  -text "Dismiss" -command "destroy $grp"
	pack  $grp.t.dis -side right 
    }
    button $grp.t.help  -text "Help" -command "put_extended {help nn-tk-groups}"
    pack  $grp.t.help -side right 
    pack $grp.t.b -side left -expand y

    scrollbar $grp.scroll -command "$grp.list yview"
    text $grp.list -yscroll "$grp.scroll set"  -relief raised -borderwidth 0 \
	-cursor left_ptr -wrap none -spacing1 3
    text_bindings $grp.list

    $grp.list  tag configure sely  -background  $color_bs -relief raised -borderwidth 1 
    $grp.list  tag configure lred -foreground  red 
    $grp.list  tag configure lblue -foreground  blue 
    $grp.list  tag configure lgreen -foreground  green

    bind $grp.list <B1-Motion> {break}
    bind $grp.list <Button-1> "list_press $grp %W %x %y"
    bind $grp.list <ButtonRelease-1> {after cancel $drag_id}

    pack $grp.scroll -side right -fill y
    pack $grp.list -side left -expand yes -fill both

    $grp.list configure -width $Config(group_list_width)
    if {!$Config(single_main) || $grp !=  ".groups"} {
	$grp.list configure -exportselection 0 -setgrid 1 
	if {[info exists geom]} {
	    wm geometry $grp $geom
	}
    update
    list_tabs $grp.list
    } else {
	$grp.list configure -exportselection 0 -setgrid 0 
	pack $grp  -fill y -side left -padx 4 -before .top
    }
}

#
#       Yes/No popup
#
proc y_prompt {} {
    global prompt_buf
    toplevel .yp 
    regsub -all "\\1" $prompt_buf "" prompt_buf
    regsub -all \x0d $prompt_buf "" prompt_buf
    regsub -all \x01 $prompt_buf "" prompt_buf
    wm transient .yp .
    wm geometry .yp +300+300
    message .yp.t -text $prompt_buf -aspect 1500
    frame .yp.f -relief sunken -borderwidth 2
    button .yp.f.yes -text "YES" -command "prompt_r y"
    button .yp.f.no -text "NO" -command "prompt_r n"

    pack .yp.f.no -side left -padx 10m -pady 5m 
    pack .yp.f.yes -side right -padx 10m -pady 5m
    pack .yp.t -side top -expand yes -fill x
    pack .yp.f -side top -fill both

    grab set .yp
    focus .yp
    bind .yp y {prompt_r y}
    bind .yp Y {prompt_r y}
    bind .yp n {prompt_r n}
    bind .yp N {prompt_r n}
    bind .yp escape {prompt_r n}
    bind .yp <Key-Return> {prompt_r y}
}

proc y_destroy {} {
    if {[winfo exists .yp]} {
	destroy .yp
    }
}

proc prompt_r {c} {
    destroy .yp
    put_key $c
}

#
#	Prompting popup
#
proc prompt_Make {} {
    global color_w Config

    if {($Config(separate_prompt) == 1) && ($Config(compressed_prompt) != 2)} {
	toplevel .prompt

	wm transient .prompt .
	wm title .prompt "NN Prompt"
    } else {
	frame .prompt
    }
    
    text .prompt.pr1 -relief raised -bd 2 \
	-height 1
    text .prompt.pr2 -relief raised -bd 2 \
	-height 1
    text .prompt.pr3 -relief raised -bd 2 \
	-height 1

    if {($Config(separate_prompt) == 1) && ($Config(compressed_prompt) != 2)} {
	.prompt.pr1 configure -setgrid true
	.prompt.pr2  configure -setgrid true
	.prompt.pr3  configure -setgrid true
    }
    if {$Config(compressed_prompt) != 2} {
	pack .prompt.pr1 .prompt.pr2 .prompt.pr3 -side top \
	    -fill both -expand yes
    }

    bind .prompt.pr1 <ButtonRelease-2> break
    bind .prompt.pr2 <ButtonRelease-2> break
    bind .prompt.pr3 <ButtonRelease-2> break

    bind .prompt <Destroy> prompt_d
    bind .prompt.pr1 <2> prompt_insert
    text_bindings .prompt.pr1
    bind .prompt.pr2 <2> prompt_insert
    text_bindings .prompt.pr2
    bind .prompt.pr3 <2> prompt_insert
    text_bindings .prompt.pr3


    if {($Config(separate_prompt) == 1) && ($Config(compressed_prompt) != 2)} {
	if {[info exists Config(.prompt)]} {
	    wm geometry  .prompt $Config(.prompt)
	}
    } 
}

proc prompt_insert {} {
    catch {set t [selection get]}
    set n [string length $t]
    for {set i 0} {$i < $n} {incr i} {
	put_key [string index $t $i]
    }
}

proc prompt_clear {} {
    global Config

    catch {
	pprompt_clear 
	.prompt.pr1 delete 0.0 end
	.prompt.pr2 delete 0.0 end
	.prompt.pr3 delete 0.0 end
	if {($Config(separate_prompt) == 1) && ($Config(compressed_prompt) != 2)} {
	    wm withdraw .prompt
	    pack forget .prompt
	}
    }
}

proc prompt_clrline {w pos} {

    $w delete $pos end
    if {$w != ".menu-pr"} {
	pprompt_clrline $pos
    }
}

proc prompt_restore {} {
    global Config

    if {($Config(separate_prompt) == 1) && ($Config(compressed_prompt) != 2)} {
	if {[winfo exists .prompt] == 0} {
	    prompt_Make
	} else {
	    if {[winfo toplevel .prompt] == ".prompt"} {
		wm deiconify .prompt
		catch {
		    pack configure .prompt -after .more -side top -fill x
		}
	    }
	}
    }
}

proc prompt_d {} {
    prompt_delete
} 
#
#	display popup
#
proc display_l {} {
    global display_l_t

    if {[winfo exists .display] == 0} {
	display_Make
    }

    set x $display_l_t
    scan [.display.t index end] "%d." l
    incr l -1

    set offset 0

    while {[regexp -indices "\01(\[^\01\]+)\01" $x pos]} {
	scan $pos "%d %d" s f
	set xt [string range $x 0 $f]
	regsub -all \x01 $xt "" xt
	.display.t insert end $xt
	.display.t tag add out $l.[expr $offset+$s] $l.[expr $offset+$f-1]
	set x [string range $x [expr $f+1] 999]
	incr offset [expr $f-1]
    }
    regsub -all \x01 $x "" x

    .display.t insert end $x
}

proc display_Make {} {
    global color_w Config

    if {[winfo exists .display] == 0} {
	toplevel .display

	frame .display.b 
	button .display.b.b  -text "Dismiss" -command "destroy .display"
	pack  .display.b.b -side right 
	pack .display.b -side top -fill x

	text .display.t -relief raised -bd 2 -setgrid true \
	    -height 25 -width 80  -yscrollcommand ".display.s set" \
	    -wrap none
	scrollbar .display.s -command ".display.t yview"
	pack .display.t -side left -expand yes -fill both
	pack .display.s -side left -fill y
        .display.t tag configure out -background black -foreground white
	wm title .display "NN help"
	if {[info exists Config(.display)]} {
	    wm geometry .display $Config(.display)
	}
    } else {
	.display.t delete 0.0 end
    }
}

#
# deal with draging selection
#
proc modify_drag {y } {
    global mod_prev tkPriv drag_id

    set resced 1
    if {$y >= [winfo height .groups.list]} {
	.groups.list yview scroll 2 units
    } elseif {$y < 0} {
	.groups.list yview scroll -2 units
    } else {
	set resced 0
    }

    scan [.groups.list index @0,$y] %d yc
    if {$yc != $mod_prev} {
	if {$yc > $mod_prev} {
	    set n 1
	} else {
	    set n -1
	}
	set ychk [expr $yc+$n]
	for {set i [expr $mod_prev+$n]} {$i != $ychk} {incr i $n} {
	    modify_toggle_select $i
	}
	set mod_prev $yc
    }

    after cancel $drag_id
    if {$resced} {
	set drag_id [after 100 "modify_drag $y"]
    }	
}

proc modify_toggle_select {i} {
    if {[lsearch -exact [.groups.list tag name $i.0] sely] < 0} {
	.groups.list tag add sely $i.0 [expr $i+1].0
    } else {
	.groups.list tag remove sely $i.0 [expr $i+1].0
    }
}

proc modify_clear {} {
    .groups.list tag remove sely 0.0 end
}
		      
proc modify_sel {y} {
    global mod_prev

    scan [.groups.list index @0,$y] %d yc
    modify_toggle_select $yc
    set mod_prev $yc
}

proc modify_choose {cmd} {
    set rg [.groups.list tag ranges sely]
#    puts "=$rg"
    set l [expr [llength $rg]/2]
    for {set i 0} {$i < $l} {incr i} {
	scan [lindex $rg [expr $i*2]] %d st
	scan [lindex $rg [expr ($i*2)+1]] %d fn
#	puts "-$st $fn"
	for {set j $st} {$j < $fn} {incr j} {
	    scan [.groups.list get $j.0 $j.9999] %s grp
	    $cmd $grp
	}
    }
    if {"$cmd" != "modify_sub"} {
	end_subscribe
    }
    list_clear
}

# select items in group list containing a string
proc modify_select {} {
    set srch [.modify.sl.s.e get]
    if {$srch == ""} {
	return
    }
    set start 0.0
    while {[set fnd [.groups.list search $srch $start end]]  != "" } {
	scan $fnd %d yc
	.groups.list tag add sely $yc.0 [expr $yc+1].0
	set start [expr $yc+1].0
    }
}
	
proc modify_sub {g} {
    subscribe $g s
}

proc modify_unsub {g} {
    subscribe $g u
}

proc modify_new {g} {
    subscribe $g o
}

# call C code for cutting part out of newsgroup sequence chain
proc modify_cut {s f} {
    scan $s %d st
    scan $f %d fn
    set snm [list_group .groups.list $st]
    set fnm [list_group .groups.list $fn]
#    puts "modify_cut $snm $fnm"
    group_cut $snm $fnm
}

proc modify_put_first {} {
    modify_move 1
}

proc modify_put_last {} {
    scan [.groups.list index end] %d yc
    modify_move [expr $yc-1]
}
   
proc modify_put_after {} {
    set srch [.modify.p.g.e get]
    if {[set fnd [.groups.list search $srch 0.0 end]]  != ""} {
	scan $fnd %d yc
	modify_move $yc
    } else {
	msg_tmp "Not found"
    }
}
	
proc modify_paste {y} {
    global tkPriv

    if {!$tkPriv(mouseMoved)} {
	scan [.groups.list index @0,$y] %d yc
	modify_move $yc
    }
}

proc modify_fix_sequence {} {
    toplevel .mess
    message .mess.m1 -text "Setting newsrc-sequence." -aspect 800
    message .mess.m2 -text "Should the .newsrc file be used to determine the \
entire newsgroup sequence or just the part matching RC in the init file sequence.\
If you haven't set up a .nn/init file use Newsrc only." \
	-aspect 500
    pack .mess.m1 .mess.m2
    frame .mess.f -relief ridge -borderwidth 2
    button .mess.f.only -text "Newsrc only" -command "modify_fix_done 2"
    button .mess.f.init -text "Init RC" -command "modify_fix_done 1"
    pack .mess.f.only -side left -padx 10 -pady 5
    pack .mess.f.init -side right -padx 10 -pady 5
    pack .mess.f -expand yes -fill both
}

proc modify_fix_done {flag} {
    global variables_m variables_val

    set variables_m(newsrc-sequence) 1
    set variables_val(newsrc-sequence) $flag
    nn_set_var newsrc-sequence $flag

    variables_save
    destroy .mess
}

#
# move groups in group list, at the same time
# rearrange the newsgroup sequence chains in the
# C code
#
proc modify_move {yc} {
    if {[nn_get_var newsrc-sequence] == 0} {
	modify_fix_sequence
    }
    set grp_paste [list_group .groups.list $yc]
    #      test if pasting at end
    if {$grp_paste == ""} {
	set grp_paste [list_group .groups.list [expr $yc-1]]
	set pos a
    } else {
	set pos b
    }

    .groups.list tag delete point
    .groups.list tag add point $yc.0 $yc.9999

    #	puts "$grp_paste $yc"
    set rg [.groups.list tag ranges sely]
    set l [expr ([llength $rg]/2)-1]

    #      check to make sure a range isn't being moved into itself
    for {set i $l} {$i >= 0} {incr i -1} {
	set s [lindex $rg [expr $i*2]] 
	set f [lindex $rg [expr ($i*2)+1]]
	if {($yc >= $s) && ($yc<$f)} {
	    bell
	    return 0
	}
    }

    text .groups.tmp
    #      process backwards so indexs don't change with deletions
    for {set i $l} {$i >= 0} {incr i -1} {
	set s [lindex $rg [expr $i*2]] 
	set f [lindex $rg [expr ($i*2)+1]]

	scan [.groups.list index end] "%d" fin
	if {$fin == $f} {
	    set f [expr $f-1]
	}
	if {$f != $s} {
	    modify_cut $s [expr $f-1]
	    .groups.tmp insert 0.0 [.groups.list get $s $f]
	    .groups.list delete $s $f
	}
    }
    
    group_paste $grp_paste $pos
    #	puts [lookup_group_pos $grp_paste].0
    scan [.groups.list tag  ranges point] %d yc
    .groups.list insert $yc.0 \
	[.groups.tmp get  0.0 "end - 1 chars"]
    destroy .groups.tmp
}

proc modify_Make {} {
    global Config groups_mod groups_pt

    if {$groups_mod} {
	toplevel .modify

	frame .modify.b
#	-borderwidth 2  -relief ridge
	button .modify.b.d -text "Dismiss" -command "modify_destroy"
	button .modify.b.h -text "Help" -command "put_extended {help nn-tk-modify}"
	pack .modify.b.d -side right
	pack .modify.b.h -side right
	pack .modify.b  -fill x
	
	label .modify.t -text "MODIFY GROUP LIST"

	frame .modify.sl -borderwidth 2  -relief ridge
	label .modify.sl.t -text "Manipulate slection"
	frame .modify.sl.s
	button .modify.sl.s.b -text "Select" -command "modify_select"
	entry .modify.sl.s.e
	button .modify.sl.cl -text "Clear Selection" -command "modify_clear"
	pack .modify.sl.s.b .modify.sl.s.e -side left
	pack  .modify.sl.t .modify.sl.s .modify.sl.cl -fill x

	frame .modify.s -borderwidth 2  -relief ridge
	label .modify.s.t -text "Subscription"
	button .modify.s.sub -text "Subscribe" -command "modify_choose modify_sub"
	button .modify.s.unsub -text "unSubscribe" -command "modify_choose modify_unsub"
	button .modify.s.new -text "Clear new" -command "modify_choose modify_new"
	pack .modify.s.t .modify.s.sub .modify.s.unsub .modify.s.new  -fill x

	frame .modify.p -borderwidth 2  -relief ridge
	label .modify.p.t -text "Move Groups"
	button .modify.p.first -text "Put First" -command "modify_put_first"
	button .modify.p.last -text "Put Last" -command "modify_put_last"
	frame .modify.p.g
	button .modify.p.g.b -text "Put Before" -command "modify_put_after"
	entry .modify.p.g.e
	pack .modify.p.g.b .modify.p.g.e -side left -fill x
	pack .modify.p.t .modify.p.first .modify.p.last .modify.p.g -fill x

	pack .modify.t .modify.sl .modify.s .modify.p -fill x 

	bind .groups.list <Button-1> "modify_sel %y; break"
	bind .groups.list <B1-Motion> "modify_drag %y; break"
	bind .groups.list <ButtonRelease-2> "modify_paste %y; break"
	bind .groups.list <B1-Leave> "break"
	bind .groups.list <B1-Enter> "break"
	bind .modify <Destroy> modify_destroy

	list_pos_save
	.groups.list tag remove sely 0.0 end
	if {[info exists Config(.modify)]} {
	    wm geometry  .modify $Config(.modify)
	}
    } else {
	modify_destroy
    }
}

proc modify_destroy {} {
    global groups_mod

    .groups.list tag remove sely 0.0 end
    bind .groups.list <Button-1> "list_press .groups %W %x %y"
    bind .groups.list <B1-Motion> {break}
    catch {destroy .modify}
    list_pos_ret
    set groups_mod 0
}

#
# Thread structure display
#
proc thread_Make {} {
    global Config
    global areaX1 areaY1 areaX2 areaY2

    frame .groups.thr
    scrollbar .groups.thr.x -command ".groups.c xview" -width 7 -orient horiz 
    scrollbar .groups.thr.y -command ".groups.c yview" 
    canvas .groups.c -relief sunken -borderwidth 0 \
	-height $Config(thread_height) \
        -width 0 \
	-scrollregion {0 0 1500 1000} \
	-xscrollcommand ".groups.thr.x set" \
	-yscrollcommand ".groups.thr.y set"

    if {$Config(thread_height) != 0} {
        pack .groups.thr.y -side right -fill y
        pack .groups.thr.x -side bottom -fill x
        pack .groups.c -side top  -fill both -in .groups.thr
        pack .groups.thr -side top  -fill both -before .groups.t
    }

    bind .groups.c <2> ".groups.c scan mark %x %y"
    bind .groups.c <B2-Motion> ".groups.c scan dragto %x %y"
    bind  .groups.c <1> "thread_draw_init %x %y 1"
    bind  .groups.c <B1-Motion> "thread_draw %x %y"
    bind  .groups.c <ButtonRelease-1> "thread_draw_in"
    bind  .groups.c <Button-3> "thread_draw_init %x %y 0"
    bind  .groups.c <B3-Motion> "thread_draw %x %y"
    bind  .groups.c <ButtonRelease-3> "thread_draw_in"

}

proc thread_nmark {x y} {
    global nid bid nprev bprev Config

    if {$Config(thread_height) != 0} {
        # mark current node
        .groups.c itemconfigure $nid($x,$y) -fill white
        .groups.c itemconfigure $bid($x,$y) -fill red -outline red
        .groups.c lower $bid($x,$y)

        # unmark previous node
        if {[info exists nprev]} {
            .groups.c itemconfigure $nprev -fill black
            .groups.c itemconfigure $bprev -fill ""
        }

        # scroll so current node is visible
        scan [.groups.c bbox $nid($x,$y)] "%d %d %d %d" x1 y1 x2 y2
        scan [.groups.c cget -scrollregion] "%d %d %d %d" lx1 ly1 lx2 ly2

        #    puts [.groups.thr.y get]

        set xs [expr $x1*1.0/$lx2]
        set ys [expr $y1*1.0/$ly2]
        set xf [expr $x2*1.0/$lx2]
        set yf [expr $y2*1.0/$ly2]

        scan [.groups.thr.x get] "%f %f" xmin xmax
        scan [.groups.thr.y get] "%f %f" ymin ymax

        if {$xs < $xmin || $xf > $xmax} {
            .groups.c xview moveto [expr $xs-($xf-$xs)*3 ]
        } else {
            .groups.c xview moveto $xmin
        }

        if {$ys < $ymin || $yf > $ymax} {
            .groups.c yview moveto [expr $ys-($yf-$ys)*0.5 ]
        } else {
            .groups.c yview moveto $ymin
        }

# remember last node
        set nprev $nid($x,$y)
        set bprev $bid($x,$y)
    }
}

proc thread_button {box_id} {
    global token th_num
    
    set a_num $th_num($box_id)

    set w  [lindex [.groups.c itemconfigure $box_id -width] 4]
    if {$w == 1} {
	.groups.c itemconfigure $box_id -width 2
    } else {
	.groups.c itemconfigure $box_id -width 1
    }
    toggle_select $a_num
    put_funct $token(K_READ_GROUP_UPDATE) "m"
}

proc thread_set {box_id on} {
    global th_num

    if {[info exists th_num($box_id)]} {
	incr on
	set w  [lindex [.groups.c itemconfigure $box_id -width] 4]
	if {$w != $on} {
	    .groups.c itemconfigure $box_id -width $on
	    toggle_select $th_num($box_id)
	}
    }
}
  
proc thread_node {x y selected a_num} {
    global thread_text nid bid th_num

    set t $thread_text
    set l [llength $t]

    if {$l > 1} {
	set c1 [string range [lindex $t 0] 0 0]
	set c2 " "
	set c2 [string range [lindex $t 1] 0 0]
	set c3 " "
	if {[llength $t] > 2} {
	    set c3 [string range [lindex $t [expr [llength $t]-1]] 0 0]
	}
	set node "$c1$c2$c3"
    } else {
	set node  [string range $t 0 2]
    }
    set n_id [.groups.c create text [expr 33*$x+30] [expr 22*$y+10] \
			-text $node -anchor ne -tags nodes \
			-font [option get .groups.c font {} ]]
    set nid($x,$y) $n_id
    set box [.groups.c bbox $n_id]
    set x1 [expr [lindex $box 0]-2]
    set y1 [expr [lindex $box 1]-2]
    set x2 [lindex $box 2]
    set y2 [lindex $box 3]

    set box_id [.groups.c create rectangle \
		    $x1 $y1 $x2 $y2 -tags nodes ]
    set th_num($box_id) $a_num
    set bid($x,$y) $box_id

#   the width flags if selected or not
    if {$selected == 1} {
	.groups.c itemconfigure $box_id -width 2
    }

    if {$a_num >= 0} {
	.groups.c bind $n_id <Button-1>  "thread_button $box_id"
    }

    set xp [expr $x-1]
    set yp $y
    set ymid [expr ($y2+$y1)/2]
    if {[info exists bid($xp,$yp)]} {
	set pbox [.groups.c bbox $bid($xp,$yp)]
	.groups.c create line $x1  $ymid \
	     [lindex $pbox 2] $ymid \
	    -tags nodes
    } else {
	while {$yp > 0} {
	    incr yp -1
	    if {[info exists bid($xp,$yp)]} {
		set pbox [.groups.c bbox $bid($xp,$yp)]
		set xmid [expr ([lindex $pbox 0]+[lindex $pbox 2])/2]
		.groups.c create line $x1  $ymid \
		    $xmid $ymid $xmid [lindex $pbox 3] \
		    -tags nodes
		break
	    }
	}
    }
}

proc thread_clear {} {
    global nid bid nprev 

    .groups.c  delete nodes
    .groups.c xview moveto 0
    .groups.c yview moveto 0
    catch {
	unset nid
	unset bid
	unset th_num
        unset nprev
        .groups.c delete area
    }
}

proc thread_draw_init {x y on} {
    global areaX1 areaY1  areaX2 areaY2 thread_on
    set thread_on $on
    set areaX1 [.groups.c canvasx $x]
    set areaY1 [.groups.c canvasy $y]
    set areaX2 $areaX1
    set areaY2 $areaY1
    .groups.c delete area
}
    
proc thread_draw {x y} {
    global areaX1 areaY1 areaX2 areaY2 thread_on

    if {$thread_on == 1} {
	set col "green"
    } else {
	set col "red"
    }

    set x [.groups.c canvasx $x]
    set y [.groups.c canvasy $y]
    if {($areaX1 != $x) && ($areaY1 != $y)} {
	.groups.c delete area
	.groups.c addtag area withtag [.groups.c create rect $areaX1 $areaY1 $x $y \
		-outline $col]
	set areaX2 $x
	set areaY2 $y
    }
}

proc thread_draw_in {} {
    global areaX1 areaY1 areaX2 areaY2 thread_on token
    set area [.groups.c find withtag area]

    foreach i [.groups.c find overlapping $areaX1 $areaY1 $areaX2 $areaY2] {
	if {[.groups.c type $i] == "rectangle"} {
	    thread_set $i $thread_on
	}
    }
    .groups.c delete area
    put_funct $token(K_READ_GROUP_UPDATE) "m"
}

proc thread_handle_Make {w} {
    global color_bd

    frame $w-handle -height 12 -width 12 -relief raised -borderwidth 2 \
	-cursor double_arrow -background $color_bd
    place $w-handle -relx 0.85 -y -6 -in $w

    bind $w-handle <Button-1> "thread_drag $w 0"
    bind $w-handle <B1-Motion> "thread_drag $w %y"
    bind $w-handle <ButtonRelease-1> "thread_drag_resize $w %y"
    frame $w-bar -width 800 -height 3 -bg red
}

proc thread_drag {w y} {
    place $w-bar -y [top_y  $w $y] -x [top_x  $w 0] -anchor w
}
    
proc thread_drag_resize {w y} {
    global Config

    set curr [top_y  $w $y]
    set menu_top [top_y .groups.c 0]
    set new_size [expr $curr-$menu_top-[winfo height .groups.thr.x]]
    .groups.c configure -height $new_size
    set Config(thread_height) $new_size
    place  forget $w-bar
}
