/*
 * $Id: creds.c,v 1.2 1997/01/03 22:07:04 kenh Exp $
 *
 * creds - Interface to credential access function for Tcl-Kerberos 5
 */

#ifndef LINT
static char rcsid[]=
	"$Id: creds.c,v 1.2 1997/01/03 22:07:04 kenh Exp $";
#endif

#include <sys/types.h>
#include <unistd.h>
#include <stdlib.h>
#include <krb5.h>
#include <com_err.h>
#include <tcl.h>

#include "tcl-krb5.h"

/*
 * An interface to krb5_get_credentials()
 */

int
Krb5GetCredentialsCmd(ClientData clientData, Tcl_Interp *interp, int argc,
		      char *argv[])
{
	krb5_context context = (krb5_context) clientData;
	krb5_creds creds, *out_creds;
	krb5_error_code code;
	krb5_ccache cc = NULL;
	krb5_flags flags = 0;
	Tcl_DString dstr;
	int i, temp;

	if (argc < 3) {
		Tcl_AppendResult(interp, "wrong # args, should be \"", argv[0],
				 " ccache input_credentials " "?flag ...?\"",
				 (char *) NULL);
		return TCL_ERROR;
	}

	if (GetKrb5Ccache(interp, context, argv[1], &cc, NULL) != TCL_OK) {
		return TCL_ERROR;
	}

	if (StringToCreds(interp, context, argv[2], &creds) != TCL_OK) {
		return TCL_ERROR;
	}

	for (i = 3; i < argc; i++) {
		if (StringToNum(GetCredsTable, argv[i], &temp) != TCL_OK) {
			Tcl_AppendResult(interp, "invalid flag \"", argv[i],
					 "\"", (char *) NULL);
			krb5_free_cred_contents(context, &creds);
			return TCL_ERROR;
		}
		flags |= temp;
	}

	if ((code = krb5_get_credentials(context, flags, cc, &creds,
					 &out_creds))) {
		Tcl_AppendResult(interp, "krb5_get_credentials failed: ",
				 error_message(code), (char *) NULL);
		krb5_free_cred_contents(context, &creds);
		return TCL_ERROR;
	}

	Tcl_DStringInit(&dstr);

	if (CredsToDString(interp, context, out_creds, &dstr) != TCL_OK) {
		Tcl_DStringFree(&dstr);
		krb5_free_cred_contents(context, &creds);
		krb5_free_creds(context, out_creds);
		return TCL_ERROR;
	}

	Tcl_DStringResult(interp, &dstr);

	krb5_free_cred_contents(context, &creds);
	krb5_free_creds(context, out_creds);

	return TCL_OK;
}
