/*
 * $Id: principal.c,v 1.1 1997/01/02 23:01:22 kenh Exp $
 *
 * principal - Glue routines for principal manipulation for Tcl-Kerberos 5
 */

#ifndef LINT
static char rcsid[]=
	"$Id: principal.c,v 1.1 1997/01/02 23:01:22 kenh Exp $";
#endif

#include <sys/types.h>
#include <unistd.h>
#include <stdlib.h>
#include <krb5.h>
#include <com_err.h>
#include <tcl.h>

#include "tcl-krb5.h"

/*
 * Glue routine to krb5_sname_to_principal
 */

int
Krb5SnameToPrincipalCmd(ClientData clientData, Tcl_Interp *interp, int argc,
			char *argv[])
{
	krb5_context context = (krb5_context) clientData;
	krb5_principal princ;
	krb5_error_code code;
	krb5_int32 type;
	char *princ_string;

	if (argc != 4) {
		Tcl_AppendResult(interp, "wrong # args, should be \"", argv[0],
			 	 " hostname service type\"", (char *) NULL);
		return TCL_ERROR;
	}

	if (StringToNum(SnameTypeTable, argv[3], &type) == TCL_ERROR) {
		Tcl_AppendResult(interp, "Invalid principal type: ",
				 argv[3], (char *) NULL);
		return TCL_ERROR;
	}

	if ((code = krb5_sname_to_principal(context, argv[1], argv[2], type,
					    &princ))) {
		Tcl_AppendResult(interp, "krb5_sname_to_principal failed: ",
				 error_message(code), (char *) NULL);
		return TCL_ERROR;
	}

	if ((code = krb5_unparse_name(context, princ, &princ_string))) {
		Tcl_AppendResult(interp, "krb5_unparse_name failed: ",
				error_message(code), (char *) NULL);
		krb5_free_principal(context, princ);
		return TCL_ERROR;
	}

	Tcl_SetResult(interp, princ_string, TCL_VOLATILE);

	free(princ_string);
	krb5_free_principal(context, princ);

	return TCL_OK;
}
