/*
 * $Id: read_msg.c,v 1.3 1997/01/07 18:04:52 kenh Exp $
 *
 * read_msg - Interface to krb5_read_message.
 *
 * This function provides a "compatible" interface to krb5_read_message().
 * Note that is doesn't actually call krb5_read_message(); it just reads
 * information in a krb5_read_message()-compatible format.
 */

#ifndef LINT
static char rcsid[]=
	"$Id: read_msg.c,v 1.3 1997/01/07 18:04:52 kenh Exp $";
#endif

#include <sys/types.h>
#include <unistd.h>
#include <stdlib.h>
#include <netinet/in.h>
#include <krb5.h>
#include <com_err.h>
#include <tcl.h>

#ifdef HAVE_STRING_H
#include <string.h>
#endif

#include "tcl-krb5.h"

/*
 * A "compatible" interface to krb5_read_message()
 */

int
Krb5ReadMessageCmd(ClientData clientData, Tcl_Interp *interp, int argc,
		   char *argv[])
{
	char *message;
	krb5_int32 len;
	Tcl_Channel chan;
	Tcl_DString dstr;
	int dataflag = 0;

	if ((argc < 2 || argc > 3) ||
	    (argc == 3 && strcmp(argv[1], "-data") != 0)) {
		Tcl_AppendResult(interp, "wrong # args, should be \"", argv[0],
				 " ?-data? channelId", (char *) NULL);
		return TCL_ERROR;
	}

	if (argc == 3) {
		dataflag++;
		argv++;
	}

	chan = Tcl_GetChannel(interp, argv[1], NULL);

	if (chan == NULL) {
		return TCL_ERROR;
	}

	/*
	 * Emulate krb5_read_message().  First, read in the length.
	 */

	if (Tcl_Read(chan, (char *) &len, sizeof(krb5_int32)) !=
	    sizeof(krb5_int32)) {
		Tcl_AppendResult(interp, "Could not read message size",
				 (char *) NULL);
		return TCL_ERROR;
	}

	len = ntohl(len);

	if ((message = malloc(len + 1)) == NULL) {
		Tcl_SetErrno(ENOMEM);
		return TCL_ERROR;
	}

	/*
	 * Now, read in the actual data
	 */

	if (Tcl_Read(chan, message, len) != len) {
		Tcl_AppendResult(interp, "Unable to read message data",
				 (char *) NULL);
		krb5_xfree(message);
		return TCL_OK;
	}

	/*
	 * If it was requested, then convert this to a hex data string
	 */

	if (dataflag) {
		Tcl_DStringInit(&dstr);

		if (DataToDString(interp, (krb5_octet *) message, len, &dstr) !=
		    TCL_OK) {
			krb5_xfree(message);
			return TCL_OK;
		}

		krb5_xfree(message);

		Tcl_DStringResult(interp, &dstr);
	} else {

		/*
		 * If the string isn't null-terminated, then add a trailing
		 * NULL (just in case)
		 */

		if (message[len - 1] != '\0') {
			message[len] = '\0';
		}

		Tcl_SetResult(interp, message, TCL_DYNAMIC);
	}

	return TCL_OK;
}
