/*
 * $Id: tcl-krb5.h,v 1.4 1997/01/06 22:46:25 kenh Exp $
 *
 * tcl-krb5.h - Common header file for Tcl-Kerberos 5
 *
 */

/*
 * Internal declarations
 */

typedef struct _StringToNumTable {
	char *name;
	krb5_int32 value;
} StringToNumTable;

/*
 * Prototypes for internal functions.  First, we have the Tcl interfaces
 * to the Kerberos 5 functions.
 */

int Krb5GetDefaultRealmCmd(ClientData, Tcl_Interp *, int, char *[]);
int Krb5SetDefaultRealmCmd(ClientData, Tcl_Interp *, int, char *[]);
int Krb5SnameToPrincipalCmd(ClientData, Tcl_Interp *, int, char *[]);
int Krb5CcDefaultCmd(ClientData, Tcl_Interp *, int, char *[]);
int Krb5CcGetPrincipalCmd(ClientData, Tcl_Interp *, int, char *[]);
int Krb5CcCloseCmd(ClientData, Tcl_Interp *, int, char *[]);
int Krb5CcDestroyCmd(ClientData, Tcl_Interp *, int, char *[]);
int Krb5AuthConInitCmd(ClientData, Tcl_Interp *, int, char *[]);
int Krb5AuthConFreeCmd(ClientData, Tcl_Interp *, int, char *[]);
int Krb5AuthConGetkeyCmd(ClientData, Tcl_Interp *, int, char *[]);
int Krb5AuthConGetlocalsubkeyCmd(ClientData, Tcl_Interp *, int, char *[]);
int Krb5AuthConGetremotesubkeyCmd(ClientData, Tcl_Interp *, int, char *[]);
int Krb5AuthConGetflagsCmd(ClientData, Tcl_Interp *, int, char *[]);
int Krb5AuthConSetflagsCmd(ClientData, Tcl_Interp *, int, char *[]);
int Krb5AuthConGenaddrsCmd(ClientData, Tcl_Interp *, int, char *[]);
int Krb5AuthConSetrcacheCmd(ClientData, Tcl_Interp *, int, char *[]);
int Krb5AuthConSetuseruserkeyCmd(ClientData, Tcl_Interp *, int, char *[]);
int Krb5SendauthCmd(ClientData, Tcl_Interp *, int, char *[]);
int Krb5WriteMkSafeCmd(ClientData, Tcl_Interp *, int, char *[]);
int Krb5ReadRdSafeCmd(ClientData, Tcl_Interp *, int, char *[]);
int Krb5GetServerRcacheCmd(ClientData, Tcl_Interp *, int, char *[]);
int Krb5RcCloseCmd(ClientData, Tcl_Interp *, int, char *[]);
int Krb5RcDestroyCmd(ClientData, Tcl_Interp *, int, char *[]);
int Krb5RecvauthCmd(ClientData, Tcl_Interp *, int, char *[]);
int Krb5WriteMkPrivCmd(ClientData, Tcl_Interp *, int, char *[]);
int Krb5ReadRdPrivCmd(ClientData, Tcl_Interp *, int, char *[]);
int Krb5GetCredentialsCmd(ClientData, Tcl_Interp *, int, char *[]);
int Krb5ReadMessageCmd(ClientData, Tcl_Interp *, int, char *[]);
int Krb5WriteMessageCmd(ClientData, Tcl_Interp *, int, char *[]);

/*
 * Next, we have internal functions for data structure management
 */

int StringToNum(StringToNumTable *, char *, int *);
int NumToString(StringToNumTable *, int, char **);
int GetKrb5Ccache(Tcl_Interp *, krb5_context, char *, krb5_ccache *,
		  Tcl_HashEntry **);
int CreateAuthContext(Tcl_Interp *, krb5_context, krb5_auth_context *, char *);
int GetAuthContext(Tcl_Interp *, krb5_context, char *, krb5_auth_context *,
		   Tcl_HashEntry **);
int CreateReplayCache(krb5_rcache, char *);
int GetReplayCache(Tcl_Interp *, char *, krb5_rcache *, Tcl_HashEntry **);

int CredsToDString(Tcl_Interp *, krb5_context, krb5_creds *, Tcl_DString *);
int KeyblockToDString(Tcl_Interp *, krb5_keyblock *, Tcl_DString *);
int EncTktPartToDString(Tcl_Interp *, krb5_context, krb5_enc_tkt_part *,
			Tcl_DString *);

int AddressToDString(Tcl_Interp *, krb5_address *, Tcl_DString *);
int DataToDString(Tcl_Interp *, krb5_octet *, int, Tcl_DString *);
void FlagToDString(StringToNumTable *, int, Tcl_DString *);

int StringToCreds(Tcl_Interp *, krb5_context, char *, krb5_creds *);
int StringToKeyblock(Tcl_Interp *, char *, krb5_keyblock *);
int StringToData(Tcl_Interp *, char *, krb5_octet **, int *);
int StringToTimes(Tcl_Interp *, char *, krb5_ticket_times *);
int StringToAddress(Tcl_Interp *, char *, krb5_address *);
int StringToFlags(Tcl_Interp *, char *, StringToNumTable *, krb5_flags *);

/*
 * Hash tables and other internal variables used by this extension
 */

extern Tcl_HashTable Ccache_Table;
extern int Ccache_Counter;

extern Tcl_HashTable AuthCon_Table;
extern int AuthCon_Counter;

extern Tcl_HashTable Rcache_Table;
extern int Rcache_Counter;

extern StringToNumTable SnameTypeTable[];
extern StringToNumTable ApOptsTable[];
extern StringToNumTable AuthConFlagTable[];
extern StringToNumTable GenaddrsFlagTable[];
extern StringToNumTable TicketFlagTable[];
extern StringToNumTable AddrtypeTable[];
extern StringToNumTable EnctypeTable[];
extern StringToNumTable GetCredsTable[];
