/*
 * $Id: write_msg.c,v 1.2 1997/01/07 18:04:52 kenh Exp $
 *
 * write_msg - Interface to krb5_write_message.
 *
 * This function provides a "compatible" interface to krb5_wrte_message().
 * Note that is doesn't actually call krb5_write_message(); it just reads
 * information in a krb5_write_message()-compatible format.
 */

#ifndef LINT
static char rcsid[]=
	"$Id: write_msg.c,v 1.2 1997/01/07 18:04:52 kenh Exp $";
#endif

#include <sys/types.h>
#include <unistd.h>
#include <stdlib.h>
#include <netinet/in.h>
#include <krb5.h>
#include <com_err.h>
#include <tcl.h>

#ifdef HAVE_STRING_H
#include <string.h>
#endif

#include "tcl-krb5.h"

/*
 * A "compatible" interface to krb5_write_message()
 */

int
Krb5WriteMessageCmd(ClientData clientData, Tcl_Interp *interp, int argc,
		   char *argv[])
{
	char *data;
	krb5_int32 len, lenout;
	Tcl_Channel chan;
	int dataflag = 0;

	if ((argc < 3 || argc > 4) ||
	    (argc == 4 && strcmp(argv[1], "-data") != 0)) {
		Tcl_AppendResult(interp, "wrong # args, should be \"", argv[0],
				 " ?-data? channelId data", (char *) NULL);
		return TCL_ERROR;
	}

	if (argc == 4) {
		dataflag++;
		argv++;
	}

	chan = Tcl_GetChannel(interp, argv[1], NULL);

	if (chan == NULL) {
		return TCL_ERROR;
	}

	/*
	 * If we were given the "dataflag" argument, then convert that
	 * argument over first.  Otherwise, we're just going to send
	 * a string, so include the trailing NUL
	 */

	if (dataflag) {
		if (StringToData(interp, argv[2], (krb5_octet **) &data,
				 &len) != TCL_OK) {
			return TCL_ERROR;
		}
	} else {
		len = strlen(argv[2]) + 1;
	}

	/*
	 * Emulate krb5_write_message().  First, write the length.
	 */

	lenout = htonl(len);

	if (Tcl_Write(chan, (char *) &lenout, sizeof(krb5_int32)) !=
	    sizeof(krb5_int32)) {
		Tcl_AppendResult(interp, "Could not write message size",
				 (char *) NULL);
		if (dataflag)
			krb5_xfree(data);
		return TCL_ERROR;
	}

	/*
	 * Now, write the actual data
	 */

	if (Tcl_Write(chan, dataflag ? data : argv[2], len) != len) {
		Tcl_AppendResult(interp, "Unable to write message data",
				 (char *) NULL);
		if (dataflag)
			krb5_xfree(data);
		return TCL_OK;
	}

	if (dataflag)
		krb5_xfree(data);

	return TCL_OK;
}
