dnl
dnl $Id: aclocal.m4,v 1.2 1996/12/31 20:03:28 kenh Exp $
dnl
dnl Some local macros that we need for autoconf
dnl
dnl AC_FIND_LIB(LIBRARY, FUNCTION, LIST-OF-DIRECTORIES [, ACTION-IF-FOUND
dnl		[, ACTION-IF-NOT-FOUND [, OTHER-LIBRARIES ]]])
AC_DEFUN(AC_FIND_LIB,
[AC_MSG_CHECKING([directories for -l$1])
dnl
dnl A lot of this is taken from AC_CHECK_LIB.  Note that we always check
dnl the "no directory" case first.
dnl
ac_lib_var=`echo $1['_']$2 | tr './+\055' '__p_'`
ac_save_LIBS="$LIBS"
AC_CACHE_VAL(ac_cv_lib_$ac_lib_var,
[for dir in "" $3
do
	ac_cache_save_LIBS="$LIBS"
	if test "X$dir" = "X"; then
		LIBS="$LIBS -l$1 $6"
	else
		LIBS="$LIBS -L$dir -l$1 $6"
	fi
	AC_TRY_LINK(dnl
ifelse([$2], [main], , dnl Avoid conflicting decl of main.
[/* Override any gcc2 internal prototype to avoid an error.  */
]ifelse(AC_LANG, CPLUSPLUS, [#ifdef __cplusplus
extern "C"
#endif
])dnl
[/* We use char because int might match the return type of a gcc2
    builtin and then its argument prototype would still apply.  */
char $2();
]),
	[$2()],
	if test "X$dir" = "X"; then
		eval "ac_cv_lib_$ac_lib_var=yes"
	else
		eval "ac_cv_lib_$ac_lib_var=$dir"
	fi
	break,
	eval "ac_cv_lib_$ac_lib_var=no")dnl
	LIBS="$ac_cache_save_LIBS"
done
])dnl
LIBS="$ac_save_LIBS"
if eval "test \"`echo '$ac_cv_lib_'$ac_lib_var`\" != no"; then
  eval "dir=\"`echo '$ac_cv_lib_'$ac_lib_var`\""
  if test "$dir" = "yes"; then
	AC_MSG_RESULT([found])
  else
	AC_MSG_RESULT([found in $dir])
  fi
  ifelse([$4], ,
[
  if test "$dir" = "yes"; then
    LIBS="$LIBS -l$1"
  else 
    LIBS="$LIBS -L$dir -l$1"
  fi
], [$4])
else
  AC_MSG_RESULT(not found)
ifelse([$5], , , [$5
])dnl
fi
])
dnl
dnl Check for a tclConfig.sh
dnl
AC_DEFUN(AC_CHECK_TCLCONFIG, [
#
# Look for tclConfig.sh
#
AC_ARG_WITH(tclconfig, [  --with-tclconfig=PATH   directory containing tcl configuration (tclConfig.sh)],
	with_tclconfig=${withval})
AC_MSG_CHECKING([for Tcl configuration])
AC_CACHE_VAL(ac_cv_c_tclconfig,[
# First see if --with-tclconfig was specified
if test x"${with_tclconfig}" != x ; then
  if test -f "${with_tclconfig}/tclConfig.sh" ; then
    ac_cv_c_tclconfig=`(cd ${with_tclconfig}; pwd)`
  else
    AC_MSG_ERROR([${with_tclconfig} directory doesn't contain tclConfig.sh])
  fi
fi

if test x"${ac_cv_c_tclconfig}" = x ; then
  for dir in `ls -d ${prefix}/lib /usr/local/lib 2>/dev/null` ; do
    if test -f "$dir/tclConfig.sh" ; then
      ac_cv_c_tclconfig=`(cd $dir; pwd)`
      break
    fi
  done
fi
])
if test x"${ac_cv_c_tclconfig}" = x ; then
  AC_MSG_ERROR([Cannot find Tcl configuration definitions])
else
  TCLCONFIG=${ac_cv_c_tclconfig}/tclConfig.sh
  AC_MSG_RESULT(found $TCLCONFIG)
fi
])
dnl
dnl Load in our Tcl configuration
dnl
AC_DEFUN(AC_LOAD_TCLCONFIG, [
  . $TCLCONFIG

  CC="$TCL_CC"
  AC_SUBST(TCL_DEFS)
  AC_SUBST(TCL_SHLIB_LD)
  AC_SUBST(TCL_SHLIB_CFLAGS)
  AC_SUBST(TCL_SHLIB_SUFFIX)
])
dnl
dnl A lot of this was taken from AC_CHECK_HEADER
dnl
dnl AC_FIND_HEADER(HEADER-FILE, LIST-OF-DIRECTORIES, [ACTION-IF-FOUND
dnl		   [, ACTION-IF-NOT-FOUND]])
dnl
AC_DEFUN(AC_FIND_HEADER,
[dnl Do the transliteration at runtime so arg 1 can be a shell variable.
ac_safe=`echo "$1" | tr './\055' '___'`
AC_MSG_CHECKING([directories for $1])
ac_cache_save_CPPFLAGS="$CPPFLAGS"
AC_CACHE_VAL(ac_cv_header_$ac_safe,
[for dir in "" $2
do
	ac_cache_save_CPPFLAGS="$CPPFLAGS"
	if test x"${dir}" != x ; then
		CPPFLAGS="-I${dir} ${CPPFLAGS}"
	fi
	AC_TRY_CPP([#include <$1>], [if test x"${dir}" = x; then
	eval "ac_cv_header_$ac_safe=yes"
else
	eval "ac_cv_header_$ac_safe=$dir"
fi
break], eval "ac_cv_header_$ac_safe=no")
done
])dnl
CPPFLAGS="$ac_cache_save_CPPFLAGS"
if eval "test \"`echo '$ac_cv_header_'$ac_safe`\" != no"; then
  eval "dir=\"`echo '$ac_cv_header_'$ac_safe`\""
  if test "$dir" = "yes"; then
	AC_MSG_RESULT([found])
  else
	AC_MSG_RESULT([found in $dir])
  fi
ifelse([$3], ,
[
  if test "$dir" != "yes"; then
     CPPFLAGS="$CPPFLAGS -I$dir"
  fi
], [$3])
else
    AC_MSG_RESULT([not found])
ifelse([$4], , , [$4
])dnl
fi
])
