/*
 * $Id: realm.c,v 1.1 1997/01/02 23:01:22 kenh Exp $
 *
 * realm - Glue to realm access functions for Tcl-Kerberos 5
 *
 */

#ifndef LINT
static char rcsid[]=
	"$Id: realm.c,v 1.1 1997/01/02 23:01:22 kenh Exp $";
#endif

#include <sys/types.h>
#include <unistd.h>
#include <stdlib.h>
#include <krb5.h>
#include <com_err.h>
#include <tcl.h>

#include "tcl-krb5.h"

/*
 * Glue routine to krb5_get_default_realm()
 */

int
Krb5GetDefaultRealmCmd(ClientData clientData, Tcl_Interp *interp, int argc,
		       char *argv[])
{
	krb5_context context = (krb5_context) clientData;
	krb5_error_code code;
	char *realm;

	if (argc != 1) {
		Tcl_AppendResult(interp, "wrong # args, should be \"", argv[0],
				 "\"", (char *) NULL);
		return TCL_ERROR;
	}

	if ((code = krb5_get_default_realm(context, &realm))) {
		Tcl_AppendResult(interp, "krb5_get_default_realm failed: ",
				 error_message(code), (char *) NULL);
		return TCL_ERROR;
	}

	Tcl_SetResult(interp, realm, TCL_VOLATILE);

	krb5_xfree(realm);

	return TCL_OK;
}

/*
 * Glue routine to krb5_set_default_realm
 */

int
Krb5SetDefaultRealmCmd(ClientData clientData, Tcl_Interp *interp, int argc,
		    char *argv[])
{
	krb5_context context = (krb5_context) clientData;
	krb5_error_code code;

	if (argc != 2) {
		Tcl_AppendResult(interp, "wrong #args, should be \"", argv[0],
				 " realm\"", (char *) NULL);
		return TCL_ERROR;
	}

	if ((code = krb5_set_default_realm(context, argv[1]))) {
		Tcl_AppendResult(interp, "krb5_set_default_realm failed: ",
				 error_message(code), (char *) NULL);
		return TCL_ERROR;
	}

	return TCL_OK;
}
