/*
 * $Id: safe.c,v 1.4 1997/01/07 18:04:52 kenh Exp $
 *
 * safe - Interface for sending/receiving KRB_SAFE messages for Tcl-Kerberos 5
 */

#ifndef LINT
static char rcsid[]=
	"$Id: safe.c,v 1.4 1997/01/07 18:04:52 kenh Exp $";
#endif

#include <sys/types.h>
#include <unistd.h>
#include <stdlib.h>
#include <netinet/in.h>
#include <krb5.h>
#include <com_err.h>
#include <tcl.h>

#ifdef HAVE_STRING_H
#include <string.h>
#endif

#include "tcl-krb5.h"

/*
 * An interface to krb5_mk_safe(), but instead write out the data over
 * a channel.
 */

int
Krb5WriteMkSafeCmd(ClientData clientData, Tcl_Interp *interp, int argc,
		   char *argv[])
{
	krb5_context context = (krb5_context) clientData;
	krb5_error_code code;
	krb5_auth_context auth_context;
	krb5_data inbuf, outbuf;
	krb5_int32 len;
	Tcl_Channel channel;

	if (argc != 4) {
		Tcl_AppendResult(interp, "wrong # args, should be \"", argv[0],
				 " auth_context channelId data\"",
				 (char *) NULL);
		return TCL_ERROR;
	}

	if (GetAuthContext(interp, context, argv[1], &auth_context, NULL)
	    != TCL_OK)
		return TCL_ERROR;

	channel = Tcl_GetChannel(interp, argv[2], NULL);

	if (channel == NULL) {
		return TCL_ERROR;
	}

	inbuf.data = argv[3];
	inbuf.length = strlen(argv[3]);

	if ((code = krb5_mk_safe(context, auth_context,
				 (const krb5_data *) &inbuf, &outbuf, NULL))) {
		Tcl_AppendResult(interp, "krb5_mk_safe failed: ",
				 error_message(code), (char *) NULL);
		return TCL_ERROR;
	}

	/*
	 * Emulate krb5_write_message().  Write the length first, then
	 * the data
	 */

	len = htonl(outbuf.length);

	if (Tcl_Write(channel, (char *) &len, sizeof(krb5_int32)) == -1) {
		Tcl_AppendResult(interp, "Tcl_Write failed", (char *) NULL);
		krb5_xfree(outbuf.data);
		return TCL_ERROR;
	}

	if (Tcl_Write(channel, outbuf.data, outbuf.length) == -1) {
		Tcl_AppendResult(interp, "Tcl_Write failed", (char *) NULL);
		krb5_xfree(outbuf.data);
		return TCL_ERROR;
	}

	krb5_xfree(outbuf.data);

	return TCL_OK;
}

/*
 * An interface to krb5_rd_safe(), but instead read in the data over
 * a channel.
 */

int
Krb5ReadRdSafeCmd(ClientData clientData, Tcl_Interp *interp, int argc,
		   char *argv[])
{
	krb5_context context = (krb5_context) clientData;
	krb5_error_code code;
	krb5_auth_context auth_context;
	krb5_data inbuf, outbuf;
	krb5_int32 len;
	Tcl_Channel channel;
	Tcl_DString dstr;

	if (argc != 3) {
		Tcl_AppendResult(interp, "wrong # args, should be \"", argv[0],
				 " auth_context channelId\"",
				 (char *) NULL);
		return TCL_ERROR;
	}

	if (GetAuthContext(interp, context, argv[1], &auth_context, NULL)
	    != TCL_OK)
		return TCL_ERROR;

	channel = Tcl_GetChannel(interp, argv[2], NULL);

	if (channel == NULL) {
		return TCL_ERROR;
	}

	/*
	 * Emulate krb5_read_message().  First, read in the length.
	 */

	if (Tcl_Read(channel, (char *) &len, sizeof(krb5_int32)) !=
	    sizeof(krb5_int32)) {
		Tcl_AppendResult(interp, "Could not read message size",
				 (char *) NULL);
		return TCL_ERROR;
	}

	inbuf.length = ntohl(len);

	if ((inbuf.data = (char *) malloc(inbuf.length)) == NULL) {
		Tcl_SetErrno(ENOMEM);
		return TCL_ERROR;
	}

	if (Tcl_Read(channel, inbuf.data, inbuf.length) != inbuf.length) {
		Tcl_AppendResult(interp, "Could not read message",
				 (char *) NULL);
		krb5_xfree(inbuf.data);
		return TCL_ERROR;
	}

	if ((code = krb5_rd_safe(context, auth_context,
				 (const krb5_data *) &inbuf, &outbuf, NULL))) {
		Tcl_AppendResult(interp, "krb5_rd_safe failed: ",
				 error_message(code), (char *) NULL);
		krb5_xfree(inbuf.data);
		return TCL_ERROR;
	}

	krb5_xfree(inbuf.data);

	Tcl_DStringInit(&dstr);

	Tcl_DStringAppend(&dstr, outbuf.data, outbuf.length);

	krb5_xfree(outbuf.data);

	Tcl_DStringResult(interp, &dstr);

	return TCL_OK;
}
