/*
 * $Id: sendauth.c,v 1.3 1997/01/07 18:04:52 kenh Exp $
 *
 * sendauth - Glue to krb5_sendauth() for Tcl-Kerberos 5
 */

#ifndef LINT
static char rcsid[]=
	"$Id: sendauth.c,v 1.3 1997/01/07 18:04:52 kenh Exp $";
#endif

#include <sys/types.h>
#include <unistd.h>
#include <stdlib.h>
#include <krb5.h>
#include <com_err.h>
#include <tcl.h>

#ifdef HAVE_STRING_H
#include <string.h>
#endif

#include "tcl-krb5.h"

/*
 * This is unfortunately rather more complicated than I would want,
 * but what are ya gonna do?
 *
 */

int
Krb5SendauthCmd(ClientData clientData, Tcl_Interp *interp, int argc,
		char *argv[])
{
	krb5_context context = (krb5_context) clientData;
	krb5_error_code code;
	krb5_auth_context auth_context = NULL;
	krb5_ccache ccache = NULL;
	krb5_principal client = NULL, server = NULL;
	krb5_error *error = NULL;
	krb5_creds *creds = NULL;
	krb5_int32 ap_opts = 0;
	int retcode = TCL_OK;
	Tcl_Channel channel;
	Tcl_File file;
	int fd, mode, authconfree = 1, authconalloc = 0;
	char *authconvar = NULL, *authconname, **argPtr;

	if (argc < 3 || argc > 15)
		goto usage;

	argPtr = argv + 1;
	argc--;

	/*
	 * Parse all of the command-line switches.  I wish there was
	 * a better way to deal with this!
	 */

	while((argc > 0) && (argPtr[0][0] == '-')) {

		/*
		 * Handle the -ccache switch.  Check for a valid credential
		 * cache when we process the argument
		 */

		if (strcmp(argPtr[0], "-ccache") == 0) {
			if (argc < 2) {
				Tcl_AppendResult(interp, "\"-ccache\" must "
						 "be followed by a credential "
						 "cache", (char *) NULL);
				retcode = TCL_ERROR;
				goto exit;
			}

			if (GetKrb5Ccache(interp, context, argPtr[1], &ccache,
					  NULL) != TCL_OK) {
				retcode = TCL_ERROR;
				goto exit;
			}
			argPtr++;
			argc--;
		}

		/*
		 * Handle the -client switch
		 */

		else if (strcmp(argPtr[0], "-client") == 0) {
			if (argc < 2) {
				Tcl_AppendResult(interp, "\"-client\" must "
						 "be followed by a principal",
						 (char *) NULL);
				retcode = TCL_ERROR;
				goto exit;
			}

			if ((code = krb5_parse_name(context, argPtr[1],
						    &client))) {
				Tcl_AppendResult(interp, "krb5_parse_name "
						 "failed for -client: ",
						 error_message(code),
						 (char *) NULL);
				retcode = TCL_ERROR;
				goto exit;
			}
			argPtr++;
			argc--;
		}

		/*
		 * Handle the -server switch
		 */

		else if (strcmp(argPtr[0], "-server") == 0) {
			if (argc < 2) {
				Tcl_AppendResult(interp, "\"-server\" must "
						 "be followed by a principal",
						 (char *) NULL);
				retcode = TCL_ERROR;
				goto exit;
			}

			if ((code = krb5_parse_name(context, argPtr[1],
						    &server))) {
				Tcl_AppendResult(interp, "krb5_parse_name "
						 "failed for -server: ",
						 error_message(code),
						 (char *) NULL);
				retcode = TCL_ERROR;
				goto exit;
			}
			argPtr++;
			argc--;
		}

		/*
		 * Handle the "-authconvar" switch.  This is a little
		 * different -- if the variable doesn't exist, then we
		 * want to _put_ the new auth context in this variable.
		 * Otherwise, use the auth context in this variable.
		 */

		else if (strcmp(argPtr[0], "-authconvar") == 0) {
			if (argc < 2) {
				Tcl_AppendResult(interp, "\"-authconvar\" must "
						 "be followed by a variable "
						 "name", (char *) NULL);
				retcode = TCL_ERROR;
				goto exit;
			}

			authconvar = argPtr[1];
			argPtr++;
			argc--;
			authconfree = 0;

			if ((authconname = Tcl_GetVar(interp, authconvar, 0))) {
				if (GetAuthContext(interp, context,
						   authconname, &auth_context,
						   NULL) != TCL_OK) {
					retcode = TCL_ERROR;
					goto exit;
				}
			} else {
				authconalloc = 1;
			}
		}

		/*
		 * Handle the "-flags" option.  This takes a list of
		 * valid flags
		 */

		else if (strcmp(argPtr[0], "-flags") == 0) {
			int localargc, i, tempflag;
			char **localargv;

			if (argc < 2) {
				Tcl_AppendResult(interp, "\"-flags\" must "
						 "be followed by a list of "
						 "flags", (char *) NULL);
				retcode = TCL_ERROR;
				goto exit;
			}

			if (Tcl_SplitList(interp, argPtr[1], &localargc,
					  &localargv) != TCL_OK) {
				retcode = TCL_ERROR;
				goto exit;
			}

			for (i = 0; i < localargc; i++) {
				if (StringToNum(ApOptsTable, localargv[i],
						&tempflag) != TCL_OK) {
					Tcl_AppendResult(interp, "Invalid "
							 "flag \"",
							 localargv[i], "\"",
							 (char *) NULL);
					Tcl_Free((char *) localargv);
					retcode = TCL_ERROR;
					goto exit;
				}

				ap_opts |= tempflag;
			}

			Tcl_Free((char *) localargv);
			argPtr++;
			argc--;
		}

		/*
		 * Handle the "-creds" flag.  This takes a valid credential
		 * list
		 */

		else if (strcmp(argPtr[0], "-creds") == 0) {
			creds = (krb5_creds *) malloc(sizeof(krb5_creds));

			if (creds == NULL) {
				Tcl_SetErrno(ENOMEM);
				retcode = TCL_ERROR;
				goto exit;
			}

			if (StringToCreds(interp, context, argPtr[1], creds)
			    != TCL_OK) {
				retcode = TCL_ERROR;
				goto exit;
			}

			argPtr++;
			argc--;
		}

		/*
		 * Handle the "bad switch" case
		 */

		else {
			goto usage;
		}
		
		/*
		 * Next switch
		 */
		
		argPtr++; argc--;
	}

	if (argc != 2) {
usage:
		Tcl_AppendResult(interp, "wrong # args or bad options: should "
				 "be \"", argv[0],
				 " ?-authconvar authconvar? "
				 "?-client client_principal? "
				 "?-server server_principal? "
				 "?-ccache ccache? "
				 "?-creds credentials? "
				 "?-flags {flags ?...?}? ",
				 "channelId app-version",
				 (char *) NULL);
		retcode = TCL_ERROR;
		goto exit;
	}

	/*
	 * Get a file descriptor from the channel ID
	 */

	channel = Tcl_GetChannel(interp, argPtr[0], &mode);

	if (channel == NULL) {
		retcode = TCL_ERROR;
		goto exit;
	}

	if (((mode & TCL_WRITABLE) == 0) || ((mode & TCL_READABLE) == 0)) {
		Tcl_AppendResult(interp, "channel \"", argPtr[0], "\" wasn't "
				 "open for both reading and writing",
				 (char *) NULL);
		retcode = TCL_ERROR;
		goto exit;
	}

	file = Tcl_GetChannelFile(channel, TCL_WRITABLE);

	if (file == NULL) {
		Tcl_AppendResult(interp, "cannot get Unix file descriptor "
				 "for channel \"", argPtr[0], "\"",
				 (char *) NULL);
		retcode = TCL_ERROR;
		goto exit;
	}

	fd = (int) Tcl_GetFileInfo(file, NULL);

	if ((code = krb5_sendauth(context, &auth_context, &fd, argPtr[1],
				  client, server, ap_opts, NULL, creds, ccache,
				  &error, NULL, NULL))) {
		Tcl_AppendResult(interp, "krb5_sendauth failed: ",
				 error_message(code), (char *) NULL);
		retcode = TCL_ERROR;
		if (error) {
			Tcl_AppendResult(interp, " (server returned: \"",
					 error->text.data, "\")",
					 (char *) NULL);
			krb5_free_error(context, error);
		}
		if (authconalloc)
			authconfree = 1;
		goto exit;
	}

	if (authconalloc && auth_context) {
		char authcontempname[256];
		Tcl_HashEntry *entry;
		int new;

		sprintf(authcontempname, "authcon%d", AuthCon_Counter++);
		entry = Tcl_CreateHashEntry(&AuthCon_Table, authcontempname,
					    &new);
		Tcl_SetHashValue(entry, (ClientData) auth_context);
		if (Tcl_SetVar(interp, authconvar, authcontempname,
			       TCL_LEAVE_ERR_MSG) == NULL) {
			authconfree = 1;
			Tcl_DeleteHashEntry(entry);
			retcode = TCL_ERROR;
			goto exit;
		}
	}

exit:
	if (client)
		krb5_free_principal(context, client);
	if (server)
		krb5_free_principal(context, server);
	if (auth_context && authconfree == 1)
		krb5_auth_con_free(context, auth_context);
	if (creds)
		krb5_free_creds(context, creds);
	
	return retcode;
}
