/*
 * Program:	Safe File Lock for OSF/1
 *
 * Author:	Mark Crispin
 *		Networks and Distributed Computing
 *		Computing & Communications
 *		University of Washington
 *		Administration Building, AG-44
 *		Seattle, WA  98195
 *		Internet: MRC@CAC.Washington.EDU
 *
 * Date:	10 October 1996
 * Last Edited:	6 November 1996
 *
 * Copyright 1996 by the University of Washington
 *
 *  Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appears in all copies and that both the
 * above copyright notice and this permission notice appear in supporting
 * documentation, and that the name of the University of Washington not be
 * used in advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.  This software is made available
 * "as is", and
 * THE UNIVERSITY OF WASHINGTON DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED,
 * WITH REGARD TO THIS SOFTWARE, INCLUDING WITHOUT LIMITATION ALL IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, AND IN
 * NO EVENT SHALL THE UNIVERSITY OF WASHINGTON BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
 * LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, TORT
 * (INCLUDING NEGLIGENCE) OR STRICT LIABILITY, ARISING OUT OF OR IN CONNECTION
 * WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 */
 
/* Safe BSD flock() call
 * Accepts: file descriptor
 *	    operation bitmask
 * Returns: 0 if successful, -1 if failure under BSD conditions
 */

int safe_flock (int fd,int operation)
{
  int ret;
  char tmp[MAILTMPLEN];
  /* It may be tempting to use a switch() instead of all these comparisons.
   * Don't do it.  Some of these error numbers resolve to the same thing on
   * various operating system variants. */
				/* do the lock */
  while (ret = flock (fd,operation)) if (errno != EINTR) {
    if ((operation & LOCK_NB) &&/* non-blocking lock case? */
	((errno == EWOULDBLOCK) || (errno == EAGAIN) || (errno == EACCES))) {
      errno = EWOULDBLOCK;	/* canonicalize error */
      return -1;		/* OK to fail */
    }
    sprintf (tmp,"Unexpected locking failure %s",strerror (errno));
    mm_log (tmp,WARN);		/* give the user a warning of what happened */
    sleep (5);			/* barf */
    break;
  }
  return ret;
}
