/*
 * rat.h --
 *
 *      Declarations for things used internally by the Ratatosk
 *      procedures but not exported outside the module.
 *
 * TkRat software and its included text is Copyright 1996 by Martin Forssen.
 *
 * The full text of the legal notice is contained in the file called
 * COPYRIGHT, included with this distribution.
 */

#ifndef _RAT_H
#define _RAT_H

#include "../config.h"

#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <errno.h>
#include <stdlib.h>
#include <ctype.h>
#include <mail.h>
#include <rfc822.h>
#include <env.h>
#include <smtp.h>
#include <misc.h>
#include <string.h>
#include <pwd.h>
#include <utime.h>
#ifdef TM_IN_SYS_TIME
# include <sys/time.h>
#else
# include <time.h>
#endif
#ifdef HAVE_UNISTD_H
# include <unistd.h>
#endif
#ifdef HAVE_FCNTL_H
# include <fcntl.h>
#endif

/*
 * dirent definitions
 */
#if HAVE_DIRENT_H
# include <dirent.h>
# define NAMLEN(dirent) strlen((dirent)->d_name)
#else
# define dirent direct
# define NAMLEN(dirent) (dirent)->d_namlen
# if HAVE_SYS_NDIR_H
#  include <sys/ndir.h>
# endif
# if HAVE_SYS_DIR_H
#  include <sys/dir.h>
# endif
# if HAVE_NDIR_H
#  include <ndir.h>
# endif
#endif

/*
 * Wait
 */
#ifdef HAVE_SYS_WAIT_H
  /* ISC doesn't def WNOHANG unless _POSIX_SOURCE is def'ed */
# ifdef WNOHANG_REQUIRES_POSIX_SOURCE
#  define _POSIX_SOURCE
# endif
# include <sys/wait.h>
# ifdef WNOHANG_REQUIRES_POSIX_SOURCE
#  undef _POSIX_SOURCE
# endif
#endif
#ifndef WEXITSTATUS
# define WEXITSTATUS(stat_val) ((unsigned)(stat_val) >> 8)
#endif
#ifndef WIFEXITED
# define WIFEXITED(stat_val) (((stat_val) & 255) == 0)
#endif
/* Last chance guess for WNOHANG */
#ifndef WNOHANG
#define WNOHANG WNOHANG_BACKUP_VALUE
#endif

/*
 * On some systems realloc can handle a NULL block pointer. Unfortunately
 * there are some systems on which this isn't the case. I don't know how
 * to identify those systems so we always define the macro.
 */
#define REALLOC(block,size)	((block)?ckrealloc(block, size):ckalloc(size))

#include <tk.h>

#define FILEMODE 0600		/* The mode of created files */
#define DIRMODE 0700		/* The mode of created directories */

/*
 * The structure returned by RatDbGet which describes an entry in the
 * database.
 */

typedef enum {
    TO, FROM, CC, SUBJECT, DATE, KEYWORDS, RSIZE, STATUS,
    EX_TIME, EX_TYPE, FILENAME, RATDBETYPE_END
} RatDbEType;

typedef struct RatDbEntry {
    char *content[RATDBETYPE_END];
} RatDbEntry;

/*
 * The different classes of log messages
 */
typedef enum {
     RAT_BABBLE, RAT_PARSE, RAT_WARN, RAT_ERROR, RAT_FATAL, RAT_INFO
} RatLogLevel;

/*
 * The different encodings
 */
typedef enum {
    RAT_7BIT, RAT_8BIT, RAT_BINARY, RAT_BASE64, RAT_QP, RAT_UNKOWN
} RatEncoding;

typedef struct RatFolderInfo *RatFolderInfoPtr;

/*
 * A SMTP channel
 */
typedef void *SMTPChannel;

/*
 * A DSN handle
 */
typedef void *DSNhandle;

/*
 * Hexadecimal characters
 */
extern char alphabetHEX[17];

/* ratAppInit.c */
extern char *currentHost;
extern char *currentDomain;
extern char *currentMailboxName;
extern char *currentPersonalName;
extern char *dayName[];
extern char *monthName[];
extern void RatInitCurrent (Tcl_Interp *interp);
extern void RatLog (Tcl_Interp *interp, RatLogLevel level, char *message,
	int keep);
extern int RatMangleNumber (Tcl_Interp *interp, int number);
extern Tcl_CmdProc RatBgExec;
extern Tcl_CmdProc RatGenId;
extern Tcl_CmdProc RatSend;
extern Tcl_CmdProc RatGetEncoding;
extern Tcl_CmdProc RatCleanup;
extern Tcl_CmdProc RatTildeSubst;
extern Tcl_CmdProc RatTime;
extern int RatSearch (char *searchFor, char *searchIn);
extern Tcl_CmdProc RatLock;
extern Tcl_CmdProc RatIsLocked;
extern Tcl_CmdProc RatType;
extern long RatTclPuts (void *stream_x, char *string);
extern long RatStringPuts (void *stream_x, char *string);
extern MESSAGE *RatParseMsg (Tcl_Interp *interp, char *message);
extern Tcl_CmdProc RatDSE;
extern Tcl_CmdProc RatExpire;
extern int RatIsEmpty (char *string);
extern int RatEncodingCompat (Tcl_Interp *interp, char *wanted, char *avail);
extern char* RatLindex (Tcl_Interp *interp, char *list, int index);
extern Tcl_CmdProc RatLL;
extern Tcl_CmdProc RatDbaseCheck;

/* ratHold.c */
extern Tcl_CmdProc RatHold;
extern int RatHoldInsert(Tcl_Interp *interp, char *dir, char *handler,
	char *description);
extern int RatHoldList(Tcl_Interp *interp, char *dir, Tcl_DString *fileListPtr);
extern int RatHoldExtract(Tcl_Interp *interp, char *prefix,
	Tcl_DString *usedVariablesPtr, Tcl_DString *filesPtr);

/* RatSender.c */
extern void RatSender(Tcl_Interp *interp);

/* ratFolder.c */
extern int RatFolderInit (Tcl_Interp *interp);

/* ratStdFolder.c */
extern void AppendToIMAP(Tcl_Interp *interp, char *mailbox, char *user,
			 char *msg, int length);

/* ratCode.c */
extern char *RatDecodeHeader (Tcl_Interp *interp, char *string);
extern char *RatDecodeHeaderFull (Tcl_Interp *interp,char *string);
extern unsigned char *RatDecode (Tcl_Interp *interp, unsigned char *data,
	int inLength, RatEncoding encoding, int *outLength, char *isCharset,
	char *toCharset);
extern unsigned char *RatEncodeHeaderLine (unsigned char *line, char *charset,
	int nameLength, int doAll);
extern unsigned char *RatConvertEncoding (Tcl_Interp *interp,
	char *fromEncoding, char *toEncoding, unsigned char *data);

/* ratAddress.c */
extern Tcl_HashTable aliasTable;
extern Tcl_HashTable userTable;
extern void RatInitAddresses (Tcl_Interp *interp, ADDRESS *addressPtr);
extern int RatAddress (ClientData dummy, Tcl_Interp *interp, int argc,
	char *argv[]);
extern Tcl_CmdDeleteProc RatDeleteAddress;
extern int RatAddressIsMe (Tcl_Interp *interp, ADDRESS *adrPtr, int useUP);
extern int RatAddressCompare (ADDRESS *adr1Ptr, ADDRESS* adr2Ptr);
extern void RatAddressTranslate (Tcl_Interp *interp, ADDRESS *adrPtr);
extern Tcl_CmdProc RatAlias;
extern void RatAddressTranslate (Tcl_Interp *interp, ADDRESS *adrPtr);
extern char *RatAddressMail(ADDRESS *adrPtr);
extern Tcl_CmdProc RatSplitAddresses;

/* ratDbase.c */
extern int RatDbInsert (Tcl_Interp *interp, char *to, char *from,
	char *cc, char *subject, int date, char *flags, char *keywords,
	int exDate, char *exType, char *mail, int length);
extern int RatDbSetStatus (Tcl_Interp *interp, int index, char *status);
extern int RatDbSearch (Tcl_Interp *interp, char *exp, int *numFoundPtr,
	int **foundPtrPtr);
extern RatDbEntry *RatDbGetEntry (int index);
extern MESSAGE *RatDbGetMessage (Tcl_Interp *interp, int index);
extern char *RatDbGetHeaders (Tcl_Interp *interp, int index);
extern char *RatDbGetText (Tcl_Interp *interp, int index);
extern int RatDbDelete (Tcl_Interp *interp, int index);
extern int RatDbExpunge (Tcl_Interp *interp);
extern int RatDbDaysSinceExpire (Tcl_Interp *interp);
extern int RatDbExpire (Tcl_Interp *interp, char *infolder,
	char *backupDirectory);
extern void RatDbClose();
extern int RatDbCheck(Tcl_Interp *interp, int fix);

/* ratFrMessage.c */
extern char *RatFrMessageCreate (Tcl_Interp *interp, char *data, int length);

/* ratSMTP.c */
extern SMTPChannel RatSMTPOpen (Tcl_Interp *interp, char *host, int verbose);
extern void RatSMTPClose (Tcl_Interp *interp, SMTPChannel channel, int verbose);
extern int RatSMTPSend (Tcl_Interp *interp, SMTPChannel channel,
	ENVELOPE *envelopePtr, BODY *bodyPtr, int requestDSN, int verbose);
extern Tcl_CmdProc RatSMTPSupportDSN;
extern long RatTclPutsSMTP (void *stream_x, char *string);

/* ratDSN.c */
extern int RatDSNInit (Tcl_Interp *interp);
extern DSNhandle RatDSNStartMessage (Tcl_Interp *interp, char *id,
	char *subject);
extern void RatDSNAddRecipient (Tcl_Interp *interp, DSNhandle handle,
	char *recipient);
extern void RatDSNAbort (Tcl_Interp *interp, DSNhandle handle);
extern void RatDSNFinish (Tcl_Interp *interp, DSNhandle handle);
extern int RatDSNHandle (Tcl_Interp *interp, char *msg);
extern int RatDSNExtract (Tcl_Interp *interp, char *data, int length);

/* ratMessage.c */
extern int RatMessageGetHeader(Tcl_Interp *interp, char *srcHeader,char *level);

/* ratMailcap.c */
extern Tcl_CmdProc RatMailcapReload;

#endif /* _RAT_H */
