# print.tcl --
#
# Handles printing of a message
#
#
#  TkRat software and its included text is Copyright 1996 by Martin Forssen.
#
#  The full text of the legal notices is contained in the file called
#  COPYRIGHT, included with this distribution.

# Print --
#
# Prints messages.
#
# Arguments:
# handler -	Handler of the corresponding folder command
# which	  -	Which messages that should be printed "group" or "selected"

proc Print {handler which} {
    global option

    foreach msg [GetMsgSet $handler $which] {
	set fileName $option(tmp)/rat.[RatGenId]
	set tmpFH [open $fileName w]
	# headers
	switch $option(print_header) {
	all	{
		foreach h [$msg headers full] {
		    puts $tmpFH "[lindex $h 0]: [lindex $h 1]"
		}
		puts $tmpFH ""
	    }
	selected {
		foreach h [$msg headers full] {
		    set header([string tolower [lindex $h 0]]) [lindex $h 1]
		}
		foreach f $option(show_header_selection) {
		    set n [string tolower $f]
		    if [info exists header($n)] {
			puts $tmpFH "$f: $header($n)"
		    }
		}
		unset header
		puts $tmpFH ""
	    }
	default	{ }
	}
	[$msg body] saveData $tmpFH 0 1
	close $tmpFH
	DoPrint $fileName
    }
}

# DoPrint --
#
# Actually does the printing
#
# Arguments:
# fileName  - The name of the file to print

proc DoPrint {fileName} {
    global option idCnt env

    # Create identifier
    set id print[incr idCnt]
    global $id
    set ${id}(fileName) $fileName

    if { 0 == [regsub "%s" $option(print_command) $fileName cmd]} {
	set cmd "cat $fileName | $option(print_command)"
    }
    regsub {^~/} $cmd $env(HOME)/ cmd
    regsub {[ 	]~/} $cmd " $env(HOME)/" cmd
    RatBgExec ${id}(exitStatus) $cmd
    uplevel #0 "trace variable ${id}(exitStatus) w PrintDone"
}

# PrintDone --
#
# Is called by the trace callback when the print command is done. It is
# meant to do any cleaning up.
#
# Arguments:
# name1, name2 -	Variable specifiers
# op	       -	Operation

proc PrintDone {name1 name2 op} {
    upvar #0 $name1 pr

    exec rm -f $pr(fileName) &
    unset pr
}
