#
wm withdraw .
#
if {![file exists installer] || ![file isdirectory installer]} {
    tk_dialog .err {Zircon Installer} {You must have run the installer\
      with the zircon distribution directory as your current \
      directory!} error 0 Quit
    update
    exit 0
}
#
switch -glob [info tclversion] {
{[123456]\.*} -
{7\.[1234]} {
	tk_dialog .err {Zircon Installer} {You must have tcl7.5 or newer\
          in order to run Zircon} info 0 Quit
	update
	exit 0
    }
7\.5 { 
	tk_dialog .err {Zircon Installer} {I see you are running \
          tcl7.5/tk4.1. Zircon will work perfectly well with this \
	  version, but you really ought to upgrade to the latest \
          release!} info 0 OK
	update
    }
default {}
}
#
set auto_path [linsert $auto_path 0 [file join [pwd] installer]]
#
source [file join installer manifest.tcl]
#
foreach x [array names Manifest] {
    if ![file exists $x] {
	tk_dialog .err {Zircon Installer} "Missing file - $x" error 0 Quit
	update
	exit 0	
    }
}
#
package require $tcl_platform(platform) 1.18
#
install $argv
