#
# $Source: /home/nlfm/Working/Zircon/Released/lib/RCS/confInfo.tcl,v $
# $Date: 1997/06/07 13:14:30 $
# $Revision: 1.18.1.7 $
#
package provide zircon 1.18
#
set zircon(idata1) {
    { {Verbose CTCP} verboseCTCP }
    { {Pop Up Info} popInfo }
    { {Flag Pop Up} noPopup }
    { {No Channel List} noRefresh }
    { {Kill Path} killPath }
}
#
proc confInfo {net} {
    set win .@cfInfo$net
    if [winfo exists $win] { popup $win ; return }
    global zircon
    upvar #0 new$net newd
    toplevel $win -class Zircon
    wm title $win "[$net name] - General Configuration"
    wm protocol $win WM_DELETE_WINDOW "confDismiss $net Info"
    confInit $net Info
    frame $win.misc0 -relief raised
    set i 0
    foreach d $zircon(idata1) {
	checkbutton $win.misc0.$i -text [lindex $d 0] \
	  -variable new${net}([lindex $d 1]) -command "confDirty $net $win"
	grid $win.misc0.$i -row 0 -column $i -sticky ew
	incr i
    }
    frame $win.misc1
#    labelEntry 0 $win.misc1.help {-text {Help Service}} $newd(helpService) \
#      " set new${net}(helpService) \[%W get\] ; confDirty $net $win"
#    grid $win.misc1.help -sticky ew
    labelNumber 0 $win.misc1.ison {-text {ISON interval}} \
      [expr {$newd(notifyInterval) / 1000}] \
      "set new${net}(notifyInterval) \[expr {\[%W get\]*1000}\] ; confDirty $net $win"
    grid $win.misc1.ison
    frame $win.misc2 -relief raised
    global Configure.Net
    label $win.misc2.label -text "Send to Info :"
    grid $win.misc2.label
    set i 0
    foreach ci [lindex [set Configure.Net(toInfo)] 1] {
	set uci [string toupper $ci]
	checkbutton $win.misc2.inf${i} -text $ci \
	  -variable confI($net,$i) -command "doCInfo $net $i $uci"
	global confI
	set confI($net,$i) [expr {[lsearch [$net toInfo] $uci] >= 0}]
	grid $win.misc2.inf${i} -row 0 -column [incr i] -sticky ew
    }
    frame $win.misc3 -relief raised
    label $win.misc3.label -text "No Confirm :"
    grid $win.misc3.label
    set i 0
    foreach ci [lindex [set Configure.Net(noConfirm)] 1] {
	set uci [string toupper $ci]
	checkbutton $win.misc3.inf${i} -text $ci \
	  -variable confNC${i} -command "doCNConf $net $i $uci"
	global confNC${i}
	set confNC${i} [expr {[lsearch [$net noConfirm] $uci] >= 0}]
	grid $win.misc3.inf${i} -row 0 -column [incr i] -sticky ew
    }
    frame $win.filter -relief raised

    checkbutton $win.filter.public -variable new${net}(showPublic) \
      -text "Public" -command "confDirty $net $win"

    checkbutton $win.filter.local -variable new${net}(showLocal) \
      -text "Local" -command "confDirty $net $win"
    checkbutton $win.filter.private -variable new${net}(showPrivate) \
      -text "Private" -command "confDirty $net $win"
    checkbutton $win.filter.topic -variable new${net}(topicOnly) \
      -text "With Topic" -command "confDirty $net $win"

    scale $win.filter.members \
      -from 1 -to 25 -label {Minimum Number of Members} \
      -showvalue 1 -orient horizontal
    $win.filter.members set [$net minMembers]
    $win.filter.members configure \
      -command "$win.filter.members configure \
	-command {confDirty $net $win ; set new${net}(minMembers)} ; set x "
    grid $win.filter.members - - - -sticky ew
    grid $win.filter.public $win.filter.local $win.filter.private \
      $win.filter.topic 

    labelEntry 0 $win.filter2 {-text {Channel Pattern} -width 16} \
      $newd(listPattern) "set new${net}(listPattern) \[%W get\] ; confDirty $net $win"
    labelEntry 0 $win.filter3 {-text {Topic Pattern} -width 16} \
      $newd(topicPattern) "set new${net}(topicPattern) \[%W get\] ; confDirty $net $win"
    grid columnconfigure $win 0 -weight 1
    grid $win.misc0 -sticky ew
    grid $win.misc1 -sticky ew
    grid $win.misc2 -sticky ew
    grid $win.misc3 -sticky ew
    grid $win.filter -sticky ew
    grid $win.filter -sticky ew
    grid $win.filter2 -sticky ew
    grid $win.filter3 -sticky ew
    confMkBtn $net $win Info
    grid $win.btn -sticky ew
}
#
proc doCNConf {net indx val} {
    global confNC$indx
    upvar #0 new$net newd
    if [set confNC$indx] {
	lappend newd(noConfirm) $val
    } {
	listdel newd(noConfirm) [lsearch $newd(noConfirm) $val]
    }
    confDirty $net .@cfInfo$net
}
#
proc doCInfo {net indx val} {
    global confI
    upvar #0 new$net newd
    if $confI($net,$indx) {
	lappend newd(toInfo) $val
    } {
	listdel newd(toInfo) [lsearch $newd(toInfo) $val]
    }
    confDirty $net .@cfInfo$net
}













