#
# $Source: /home/nlfm/Working/Zircon/Released/installer/RCS/support.tcl,v $
# $Date: 1997/01/13 13:06:09 $
# $Revision: 1.18.1.11 $
#
# ----------------------------------------------------------------------
#   AUTHOR:  Lindsay Marshall <lindsay.marshall@newcastle.ac.uk>
# ----------------------------------------------------------------------
# Copyright 1996 The University of Newcastle upon Tyne (see COPYRIGHT)
# ======================================================================
#
package provide support 1.18
#
proc askUser {title msg} {
    return [tk_dialog .ask $title $msg question 1 No Yes]
}
proc fail {msg} {
    tk_dialog .err Error! $msg error 0 OK
}
#
proc zinfo {msg} {
    .inst.info configure -text $msg
    update
}
#
proc Quit {} {
    exit
}
#
proc Go {} {
    .inst configure -cursor {watch red}
    foreach x [winfo children .inst] {
	catch {$x configure -cursor {watch red}}
	catch {$x configure -state disabled}
    }
    .inst.btn.install configure -state disabled
    if {[makeLibrary] && [makeBinary]} {
	zinfo Done!!
	if [catch {open install.in w} fd] {
	} {
	    foreach x {Type Lib Bin CC SCflag SLDflag CFlags Wish TIDir} {
		puts $fd "set $x {[uplevel #0 set $x]}"
	    }
	    close $fd
	}
    }
    foreach x [winfo children .inst] {
	catch {$x configure -state normal}
	catch {$x configure -cursor arrow}
    }
    .inst.btn.install configure -state normal
    .inst configure -cursor arrow
}
#
proc ncopy {file to} {
    if ![file exists [file join $to $file]] { copy $file $to }
}
#
proc gridIt {w name row} {
    grid $w.$name -row $row -column 0 -sticky ew
    grid $w.${name}entry -sticky ew -row $row -column 1
}
#
proc fixPath {dir} {
    switch [file pathtype $dir] absolute {return $dir}
    return [file join [pwd] $dir]
}
#
#
proc copy {from to} {
    zinfo "Copying $from ..."
    set to [dmake [file dirname $from] $to]
    set target [file join $to [file tail $from]]
    copyfile $from $target
}
#
proc dmake {from to} {
    switch . $from {} default {
	foreach x [file split $from] {
	    set to [file join $to $x]
	    filemkdir $to
	}
    }
    return $to
}
