#
proc zircon {} {
#
#	ZIRCON - an X11 interface to the Internet Relay Chat
#
#	Written by Lindsay (Lindsay F. Marshall)
#
#	Copyright (c) 1993, 1994, 1995, 1996
#
#	See the file COPYRIGHT for details
#
set lib [file join $zircon(lib) lib]
set auto_path [linsert $auto_path 0 $lib]
package require -exact interp [info tclversion]
package require $tcl_platform(platform)
package require zircon
package require Debug
#
#
Initialise
InitGlobals
#
# save some space!!! it will reload if necessary.
#
rename Initialise {}
rename InitGlobals {}
#
if {[set l [llength [set nets [Net :: list]]]] == 1} {
    $defaultNet show
    if [$defaultNet nocontrol] {
	wm withdraw .@ctl
	wm withdraw .@inf
    } {
	exposeFrame .@ctl $defaultNet
	exposeFrame .@inf [$defaultNet info]
	hideFrame .@ctl $defaultNet
	hideFrame .@inf [$defaultNet info]
    }
} {
    addToConf $defaultNet
    if {$l == 2} {
	set net [lindex $nets 1]
	if [$net nocontrol] {
	    wm withdraw .@ctl
	    wm withdraw .@inf
	} {
	    exposeFrame .@ctl $net
	    exposeFrame .@inf [$net info]
	}
    }
}
unset l
#
if !$zircon(C) {
    foreach x $znetList {
	switch nil [set hst [$x hostid]] {} default {
	    set s [$x servers]
	    set v [lsearch $s $hst]
	    listdel s $v
	    while {![$x startIRC $hst]} {
		switch {} $s break
		$x configure -hostid [set hst [lindex $s 0]]
		set s [lrange $s 1 end]
		update
	    }
	}
    }
    unset s x v
}
}
