#
# $Source: /home/nlfm/Working/Zircon/Released/lib/RCS/Monitor.tcl,v $
# $Date: 1997/06/09 12:02:56 $
# $Revision: 1.18.1.7 $
#
package provide zircon 1.18
#
proc channelMonitor {net chan} { $net monitor $chan }
#
proc updateMon {net chid names} {
    set w .@mon$chid
    if ![winfo exists $w] {makeMon $net $chid $names ; return}
    set xist {}
    foreach n [winfo children $w.userList] { lappend xist [winfo name $n] }
    foreach n $names {
	switch {} $n continue
	regexp {^([@+]?)(.*)} $n m mrk n
	switch $mrk {
	@ { set mrk operator} 
	+ { set mrk speaker}
	}
	set usr [User :: make $net $n]
	if ![winfo exists [set winu $w.userList.$usr]] {
	    wsortIns nil $w.userList $n $usr
	    $usr ref
	} {
	    if ![normal $winu] {
		$winu configure -state normal
		$usr heal
	    }
	    listkill xist $usr
	}
	markButton $winu $mrk
    }
    foreach n $xist {if [normal $w.userList.$n] {destroy $w.userList.$n ; $n deref}}
}
#
proc makeMon {net chid names} {
    set w .@mon$chid
    toplevel $w -class Zircon
    set chan [$chid name]
    wm title $w "$chan [trans monitor]"
    wm resizable $w 0 1
    wm protocol $w WM_DELETE_WINDOW "deMonitor $net $chid 1"
    grid columnconfigure $w 0 -weight 1
    grid rowconfigure $w 0 -weight 1 
    scrollbar $w.vscroller -command "$w.userList yview" 
    text $w.userList -yscrollcommand "$w.vscroller set" \
      -relief flat -borderwidth 0 -width 14 -height 10
    grid $w.userList $w.vscroller -sticky ns
    grid [frame $w.btns -relief raised] - -sticky ew
    grid columnconfigure $w.btns 0 -weight 1
    grid columnconfigure $w.btns 1 -weight 1
    button $w.btns.cancel -text [trans dismiss] \
      -command "deMonitor $net $chid 1" -width 5
    button $w.btns.join -text [trans join] \
      -command " $chid sendJoin {} " -width 5
    grid $w.btns.cancel $w.btns.join -sticky ew
    foreach n $names {
	regexp {^([@+]?)(.*)} $n m mrk n
	switch $mrk {
	@ { set mrk operator} 
	+ { set mrk speaker}
	}
	set usr [User :: make $net $n]
	set winu $w.$usr
	if ![winfo exists $winu] {
	    wsortIns nil $w.userList $n $usr
	    $usr ref
	    markButton $winu $mrk
	}
    }
}
