#
# $Source: /home/nlfm/Working/Zircon/Released/lib/RCS/misc2.tcl,v $
# $Date: 1997/05/09 10:21:13 $
# $Revision: 1.18.1.17 $
#
#
package provide zircon 1.18
#
proc net_doMisc2 {this chid win} {
    set line [$win get]
    $win delete 0 end
    if [regexp {^(/[a-zA-Z]+)( (.*))?$} $line dummy pr r1 rest] {
	set pr [string toupper $pr]
	switch {} [info procs $pr] {} default {
	    $chid addText @me "!> $line"
	    $chid configure -hpos end
	    $pr $this $chid $rest
	    return
	} 
    }
    $chid send $line
}
#
proc /ABORT {net chid arg} { exit }
#
proc /ADMIN {net chid arg} { $net nsend ADMIN [lindex $arg 0]}
#
proc /ALIAS {net chid arg} { sillyPerson $net }
#
proc /ASSIGN {net chid arg} { sillyPerson $net }
#
proc /AWAY {net chid arg} { $net AWAY $arg }
#
proc /BEEP {args} { bell }
#
proc /BIND {net chid arg} { sillyPerson $net }
#
proc /BYE {net chid arg} { $net doQuit [lindex $arg 0]}
#
proc /CD {net chid arg} {
    if [string match {} $arg] {
	tellInfo {Working Directory} [pwd]
    } {
	cd $arg
    }
}
#
proc /CHANNEL {net chid arg} { channelJoin $net [lindex $arg 0] }
#
proc /CLEAR {net chid arg} { sillyPerson $net }
#
proc /COMMENT {net chid arg} { }
#
proc /CONNECT {net chid arg} {
    $net CONNECT [lindex $arg 0] [lindex $arg 1] [lindex $arg 3]
}
#
proc /CTCP {net chid arg} {
    set nk [lindex $arg 0]
    switch * $nk {set nk [$chid name]}
    switch [set cmd [string toupper [lindex $arg 1]]] {
    PING { $net CTCP PING $nk [ZPING] }
    CLIENTINFO {$net CTCP $CMD $nk [lindex $arg 2]}
    ERRMSG -
    SOUND -
    ACTION -
    ECHO {$net CTCP $cmd $nk $arg }
    default {
	    $net CTCP $cmd $nk {}
	}
    }
}
#
proc /DATE {net chid arg} { $net TIME $arg }
#
proc /DCC {net chid arg} {
    set op [string toupper [lindex $arg 0]]
    switch -- $op {
    SEND {
	   DCCSend [User :: make $net [lindex $arg 1]] [lindex $arg 2]
	}
    CHAT {[User :: make $net [lindex $arg 1]] dcc CHAT}
    GET {
	    global DCCList
	    set gusr [User :: make $net [lindex $arg 1]]
	    set file [lindex $arg 2]
	    set i 0
	    foreach x $DCCList($net) {
		switch [set op [lindex $l 0]] Send continue
		set usr [lindex $l 1]
		set addr [lindex $l 2]
		set port [lindex $l 3]
		set fln [lindex $l 4]
		set leng [lindex $l 5]
		set posn [lindex $l 6]
		switch -- $gusr $usr {
		    switch -- $file $fln {
		        doGetDCC $net $op $usr $addr $port $leng $posn $file
			$usr deref
			listdel DCCList($net) $i
			switch {} $DCCList($net) {destroy .@drq$net}
			return
		    }
		}
		incr i
	    }
	    tellError {} {DCC Get} {No such send outstanding}
	}
    CLOSE -
    LIST {buildDCCList $net}
    close {
	    set typ [lindex $arg 1]
	    set gusr [User :: make $net [lindex $arg 2]]
	    sillyPerson $net
	}
    default { sillyPerson $net }
    }
}
#
proc /DEOP {net chid arg} { $net deIRCOp }
#
proc /DESCRIBE {net chid arg} {
    set chan [lindex $arg 0]
    if {[string compare nil [set ch [Channel :: find $chan $net]]] ||
	[string cpmpare nil [set ch [Message :: find $chan $net]]]} {
	$ch action [lrange $arg 1 end]
    } {
	$net msg $chan "\001ACTION [lrange $arg 1 end]\001"
    }
}
#
proc /DIE {net chid arg} { sillyPerson $net }
#
proc /DIGRAPH {net chid arg} { sillyPerson $net }
#
proc /DMSG {net chid arg} {
    switch nil [set cht [Chat :: find [lindex $arg 0] $net]] {
	tellError $net Error {No such DCC chat  connection}
    } default {$cht send [lrange $arg 1 end]}
}
#
proc /DQUERY {net chid arg} { sillyPerson $net }
#
proc /ECHO {net chid arg} { $net inform $arg }
#
proc /ENCRYPT {net chid arg} {
    set nk [lindex $arg 0]
    if [string match {[#&]} $nk] {
	set chid [Channel :: make $net $nk]
    } {
	set chid [Message :: make $net $nk]
    }
    $chid configure -key [lindex $arg 1]
}
#
proc /EVAL {net chid arg} { sillyPerson $net }
#
proc /EXEC {net chid arg} { runCmd $net $chid $arg }
#
proc /EXIT {net chid arg} { $net doQuit [lindex $arg 0]}
#
proc /FLUSH {net chid arg} { sillyPerson $net }
#
proc /FOREACH {net chid arg} { sillyPerson $net }
#
proc /HELP {net chid arg} { sillyPerson $net }
#
proc /HISTORY {net chid arg} { sillyPerson $net }
#
proc /HOOK {net chid arg} { sillyPerson $net }
#
proc /IF {net chid arg} { sillyPerson $net }
#
proc /IGNORE {net chid arg} { sillyPerson $net }
#
proc /INFO {net chid arg} { $net INFO $arg }
#
proc /INPUT {net chid arg} { sillyPerson $net }
#
proc /INVITE {net chid arg} {
    set nk [lindex $arg 0]
    foreach x [lrange $arg 1 end] { $net INVITE $nk $x }
}

#
proc /JOIN {net chid arg} { channelJoin $net $arg }
#
proc /KICK {net chid arg} {
    set chn [lindex $arg 0]
    switch * $chn {set chn [$chid name]}
    $net KICK $chn [lindex $arg 1] [lrange $arg 2 end]
}
#
proc /KILL {net chid arg} {$net KILL [lindex $arg 0] [lrange $arg 1 end]}
#
proc /LASTLOG {net chid arg} { sillyPerson $net }
#
proc /LEAVE {net chid arg} { /PART $net $chid $arg }
#
proc /LINKS {net chid arg} { $net LINKS [lindex $arg 0] [lindex $arg 1] }
#
proc /LIST {net chid arg} { sillyPerson $net }
#
proc /LOAD {net chid arg} {  sillyPerson $net }
#
proc /LUSERS {net chid arg} {$net send LUSERS [lindex $arg 0] [lindex $arg 1]}
#
proc /ME {net chid arg} { $chid action $arg }
#
proc /MLOAD {net chid arg} { sillyPerson $net }
#
proc /MODE {net chid arg} {
    set chn [lindex [set arg [safeClean $arg]] 0]
    switch * $chn {set chn [$chid name]}
    eval $net send MODE \{$chn\} [lrange $arg 1 end]
}
#
proc /MOTD {net chid arg} { $net send MOTD $arg }
#
proc /MSG {net chid arg} {
    set arg [safeClean $arg]
    $net msg [lindex $arg 0] [lrange $arg 1 end]
}
#
proc /NAMES {net chid arg} { $net NAMES $arg }
#
proc /NICK {net chid arg} { $net NICK $arg }
#
proc /NOTE {net chid arg} { sillyPerson $net }
#
proc /NOTICE {net chid arg} {
    $net NOTICE [lindex $arg 0] [lrange $arg 1 end]
}
#
proc /NOTIFY {net chid arg} { sillyPerson $net }
#
proc /ON {net chid arg} { sillyPerson $net }
#
proc /OPER {net chid arg} {$net OPER [lindex $arg 0] [lindex $arg 1]}
#
proc /PARSEKEY {net chid arg} { sillyPerson $net }
#
proc /PART {net chid arg} {
    if {[string match {} $arg] || ![string compare * $arg]} {
	$chid doLeave {}
    } {
	switch nil [set id [find [lindex $arg 0]]] {} default {
	    $id doLeave [lindex $arg 1]
	}
    }
}
#
proc /PING {net chid arg} { foreach nk $arg { doCtcp $net PING $nk } }
#
proc /QUERY {net chid arg} {
    set usr [User :: make $net $arg]
    set msg [Message :: make $net [$usr name]]
    $msg show
    if ![$msg isJoined $usr] { $msg addUser $usr 0 0 }
}
#
proc /QUIT {net chid arg} { $net doQuit $arg }
#
proc /QUOTE {net chid arg} {  eval $net send [safeClean $arg] }
#
proc /RAW {net chid arg} {  eval $net send [safeClean $arg] }
#
proc /REDIRECT {net chid arg} { sillyPerson $net }
#
proc /REHASH {net chid arg} { $net q1Send REHASH }
#
proc /RESTART {net chid arg} { $net q1Send RESTART }
#
proc /SAVE {net chid arg} { sillyPerson $net }
#
proc /SAY {net chid arg} { $chid send $arg }
#
proc /SEND {net chid arg} { $chid send $arg }
#
proc /SENDLINE {net chid arg} { sillyPerson $net }
#
proc /SERVER {net chid arg} {
    set sv [Server :: make $net [lindex $arg 0]]
    if {[set port [lindex $arg 1]] != {}} { $sv configure -port $port }
    $net changeServer $sv
}
#
proc /SET {net chid arg} { sillyPerson $net }
#
proc /SIGNOFF {net chid arg} { $net doQuit $arg }
#
proc /SLEEP {net chid arg} { sillyPerson $net }
#
proc /SQUIT {net chid arg} { $net send SQUIT $arg }
#
proc /STATS {net chid arg} { $net STATS [lindex $arg 0] [lindex $arg 1] }
#
proc /SUMMON {net chid arg} { $net send SUMMON $arg }
#
proc /TIME {net chid arg} { $net send TIME $arg }
#
proc /TIMER {net chid arg} { sillyPerson $net }
#
proc /TOPIC {net chid arg} { $chid configure -topic [lindex $arg 0] }
#
proc /TRACE {net chid arg} { $net nsend TRACE $arg }
#
proc /TYPE {net chid arg} { sillyPerson $net }
#
proc /USERHOST {net chid arg} {
    foreach x $arg {
	if [string compare -cmd $x] {$net USERHOST $x} {
	    sillyPerson $net
	    break
	}
    }
}
#
proc /USERS {net chid arg} { $net send USERS $arg }
#
proc /VERSION {net chid arg} { $net send VERSION $arg }
#
proc /WAIT {net chid arg} { sillyPerson $net }
#
proc /WALLOPS {net chid arg} { sillyPerson $net }
#
proc /WHICH {net chid arg} { sillyPerson $net }
#
proc /WHILE {net chid arg} { sillyPerson $net }
#
proc /WHO {net chid arg} { eval $net send WHO [safeClean $arg] }
#
proc /WHOIS {net chid arg} { eval $net WHOIS [safeClean $arg] }
#
proc /WHOWAS {net chid arg} { eval $net WHOWAS [safeClean $arg] }
#
proc /WINDOW {net chid arg} { sillyPerson $net}
#
proc /XECHO {net chid arg} { sillyPerson $net}
#
proc /XTYPE {net chid arg} { sillyPerson $net}
#
proc sillyPerson {net} {
    bell
    tellError $net Silly {Don't be silly! This is Zircon!!}
}
