#
# $Source: /home/nlfm/Working/Zircon/Released/lib/RCS/tcl80.tcl,v $
# $Date: 1996/12/20 21:54:10 $
# $Revision: 1.18.1.1 $
#
# ----------------------------------------------------------------------
#   AUTHOR:  Lindsay Marshall <lindsay.marshall@newcastle.ac.uk>
# ----------------------------------------------------------------------
# Copyright 1996 The University of Newcastle upon Tyne (see COPYRIGHT)
# ======================================================================
#
#
package provide interp 8.0
#
proc sconf {sk} {
    global hostIPaddress
    fconfigure $sk -buffering line -translation {auto lf} -blocking 0
    if ![info exists hostIPaddress] {
	if ![catch {fconfigure $sk -sockname} xx] {
	    set hostIPaddress [lindex $xx 0]
	}
    }
}
#
proc filecopy {f1 f2} { file copy -- $f1 $f2 }
#
proc filerename {f1 f2} { file rename -force -- $f1 $f2 }
#
proc filemkdir {f1} { file mkdir $f1 }
#
proc filedelete {f1} { file delete -- $f1 }
#
proc filedirdel {f1} { file delete -force -- $f1 }
#
proc sendSound {net nk} {
    global SoundDir zircon
    if ![info exists SoundDir($net)] {
	if [file exists [file join $zircon(prefdir) sounds]] {
	    set SoundDir($net) $zircon(prefdir)/sounds
	} {
	    set SoundDir($net) [file join $zircon(lib) sounds]
	}
    }
    doSendSound $net $nk [tk_getOpenFile -defaultextension wav \
      -filetypes {{{Wav format sound files} {.\[wW\]\[aA\]\[vV\]}}} \
      -initialdir $SoundDir($net)]
}
