## -*-Tcl-*-
 # ###################################################################
 #  Alphatk - the ultimate editor
 # 
 #  FILE: "alpha_dnd.tcl"
 #                                    created: 01/29/2001 {19:23:38 PM} 
 #                                last update: 11/13/2001 {17:13:48 PM} 
 #  
 # This file (unlike most of the rest of Alphatk core)
 # is distributed under a BSD style license.
 # 
 # ###################################################################
 ##

namespace eval alpha {}

proc alpha::initDnd {} {
    BindTarget .status FILENAME 30 
    BindTarget .status.text FILENAME 30
    BindTarget .status text/uri-list
    BindTarget .status.text text/uri-list
    BindTarget . FILENAME 30
    BindTarget . text/uri-list
}

if {[catch {package require tkdnd}]} {
    echo "Install 'tkdnd' to let Alphatk make use of drag and drop features."
    # declare dummy proc so we don't have to worry later.
    proc dnd {args} {}
}

proc BindDialogItem  {win cmdSet cmdCheck Type {p 50}} {
    foreach type $Type {
	dnd bindtarget $win $type <DragEnter> [list dragfoo DragDialogEnter $cmdCheck %A %a %T %W %X %Y %x %y %D] $p
	dnd bindtarget $win $type <Drag>      [list dragfoo Drag %A %a %T %W %X %Y %x %y] $p
	dnd bindtarget $win $type <DragLeave> [list dragfoo DragLeave %A %a %T %W %X %Y %x %y] $p
	dnd bindtarget $win $type <Drop>      [list dragfoo DropDialogItem $cmdSet %A %a %T %W %X %Y %x %y %D] $p
    }
}

proc DragDialogEnter {cmdCheck action actions type win X Y x y {data {}}} {
    #puts stderr "drag enter '$cmdCheck' $action $type $data"
    set t [winfo toplevel $win]
    #$win configure -bg green
    #update
    switch -glob $type {
	image/* {
	    set msg "Can't accept an image"
	}
	TK_COLOR {
	    set msg "Can't accept a colour"
	}
	FILENAME -
	"text/uri-list" {
	    if {$data == ""} {
		message "Probably ok to drop here"
		return $action
	    }
	    if {$type == "FILENAME"} {
		set data [list $data]
	    }
	    #puts [list DragDialogEnter $cmdCheck $data]
	    set res [eval $cmdCheck $data]
	    #puts $res
	    if {![string length $res]} {
		message "Ok to drop $data here"
		return $action
	    } else {
		message "Can't drop here: $res"
		return "none"
	    }
	}
	default {
	    set msg "Unknown type $type dropped with data $data"
	}
    }
    message "Can't drop here: $msg"
    return "none"
}

proc DropDialogItem {cmd action actions type win X Y x y data} {
    #puts stderr "drop $action $type $cmd $data"
    set t [winfo toplevel $win]
    if {[string match text/* $type]} {
	# These are fine.
    } elseif {$type == "FILENAME"} {
	# This is fine.
    } else {
	set Data "Binary data dropped..."
    }
    #puts "$Data"
    set msg "Unknown error"
    switch -glob $type {
	image/* {
	    set msg "Can't accept an image"
	}
	TK_COLOR {
	    set msg "Can't accept a colour"
	}
	FILENAME -
	"text/uri-list" {
	    if {$type == "FILENAME"} {
		set data [list $data]
	    }
	    #puts [list DropDialogItem $cmd $data]
	    if {![catch {eval $cmd $data} msg]} {
		return
	    }
	}
	default {
	    set msg "Unknown type $type dropped with data $data"
	}
    }
    message "Drop error: $msg"
    #global errorInfo ; puts $errorInfo
    error "Drop error: $msg"
}

# We have the 'dnd' command
proc BindTarget {win Type {p 50}} {
    foreach type $Type {
	dnd bindtarget $win $type <DragEnter> {dragfoo DragEnter %A %a %T %W %X %Y %x %y} $p
	dnd bindtarget $win $type <Drag>      {dragfoo Drag %A %a %T %W %X %Y %x %y} $p
	dnd bindtarget $win $type <DragLeave> {dragfoo DragLeave %A %a %T %W %X %Y %x %y} $p
	dnd bindtarget $win $type <Drop>      {dragfoo Drop %A %a %T %W %X %Y %x %y %D} $p
    }
}
proc Drag {action actions type win X Y x y} {
    set t [winfo toplevel $win]
    #puts stderr "drag $action"
    update
    if {[lsearch -exact $actions ask] != -1} {
	set ret_action ask
    } elseif {[lsearch -exact $actions copy] != -1} {
	set ret_action copy
    } else {
	set ret_action $action
    }
    return $ret_action
}
proc DragEnter {action actions type win X Y x y {data {}}} {
    set t [winfo toplevel $win]
    #puts stderr "drag enter $type $action"
    #$win configure -bg green
    update
    return $action
}
proc DragLeave {action actions type win X Y x y} {
    set t [winfo toplevel $win]
    #puts stderr "drag leave $action"
    #$win configure -bg ""
    update
}
proc Drop {action actions type win X Y x y data} {
    #puts stderr "drop $action"
    set t [winfo toplevel $win]
    if {[string match text/* $type]} {
	set Data $data
    } elseif {$type == "FILENAME"} {
	set Data $data
    } else {
	set Data "Binary data dropped..."
    }
    #puts "$Data"
    switch -glob $type {
	image/* {
	    switch -- [string range $type 6 end] {
		xpm {image create pixmap itk -data $data}
		xbm {image create bitmap itk -data $data}
		default {image create photo itk -data $data}
	    }
	    $win configure -image itk -bg gray
	}
	TK_COLOR {$win configure -bg $data}
	FILENAME -
	"text/uri-list" {
	    if {$type == "FILENAME"} {
		set Data [list $Data]
	    }
	    #puts "got $Data"
	    foreach f $Data {
		if {[info tclversion] < 8.4} {
		    global tcl_platform
		    if {$tcl_platform(platform) == "windows"} {
			set f [file nativename [file attributes -longname $f]]
		    } else {
			set f [file nativename $f]
		    }
		} else {
		    set f [file nativename [file normalize $f]]
		}
		edit $f
	    }
	}
	default {$win configure -text $data -bg gray -image {}}
    }
}
proc dragfoo {args} {
    #puts stderr "dragfoo $args"
    eval $args
}
