## -*-Tcl-*-
 # ###################################################################
 #  Alphatk - the ultimate editor
 # 
 #  FILE: "alpha_startup.tcl"
 #                                    created: 04/08/98 {21:52:56 PM} 
 #                                last update: 12/13/2001 {18:37:48 PM} 
 #  Author: Vince Darley
 #  E-mail: vince.darley@kagi.com
 #    mail: Flat 10, 98 Gloucester Terrace, London W2 6HP
 #     www: http://www.santafe.edu/~vince/Alphatk.html
 #  
 # Copyright (c) 1998-2001  Vince Darley
 # 
 # See the file "license.terms" for information on usage and redistribution
 # of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 # 
 # In particular, while this is 'open source', it is NOT free, and
 # cannot be copied in full or in part except according to the terms
 # of the license agreement.
 # 
 # ###################################################################
 ##

namespace eval alpha {}

set alpha::version "8.1fc1"
# Alphatk 7.x and 8.x prefs are compatible
set alpha::majorUpgradePrefsCompatible 1
set alpha::tclversion ""

# version - Return string of the form "5.31 for ppc, released...".
proc version {args} { 
    global alpha::version
    return "$alpha::version, for Tk, beta-release" 
}

proc alpha::thanks {} {
    set l [list "Pete Keleher" "Jon Guyer" "Johan Linde" \
      "Tom Scavo" "Tom Pollard" "Tom Fetherston" "Mark Nagata" "Juan Falgeras"\
      "Jim Ingham" "Craig Upright"]
    return [lsort -dictionary -index 1 $l]
}

set alpha::colours(alphabackground) #0000ff

proc alpha::_copyrightYear {} {
    set year [clock format [clock seconds] -format %Y]
    if {$year < 2000} {set year 2000}
    return $year
}

proc alpha::makeStartup {{win .startup}} {
    global HOME
    variable colours
    variable version
    variable tclversion
    if {![winfo exists $win]} {
	toplevel $win -background $colours(alphabackground) ; wm overrideredirect $win 1
    } elseif {[winfo toplevel $win] == $win} {
	catch {destroy $win}
	toplevel $win -background $colours(alphabackground) ; wm overrideredirect $win 1
    }
    if {[file exists [file join $HOME AlphaCore Images alphatksplash.gif]]} {
	image create photo splash -file [file join $HOME AlphaCore Images alphatksplash.gif]
    } else {
	image create photo splash -file [file join $HOME AlphaCore Images alphatksplash.ppm]
    }
    canvas $win.f -width [image width splash] -height [image height splash] \
      -highlightthickness 0 -borderwidth 0
    $win.f create image 0 0 -image splash -anchor nw
    pack $win.f -fill both -expand yes
    $win.f create text 690 270 -anchor ne -fill white -justify right \
      -text "Copyright  Vince Darley\n1998-[_copyrightYear]"
    $win.f create text 690 350 -anchor se -text "Alphatk version $version" \
      -fill white -tags alphatk
    $win.f create text 1690 368 -anchor se -text "using Tcl [info patchlevel]" \
      -fill white -tags tcl
    if {[string length $tclversion]} {
	$win.f create text 1690 386 -anchor se \
	  -text "and AlphaTcl $tclversion" -fill white -tags alphatcl
    } else {
	$win.f create text 1690 386 -anchor se \
	  -text "" -fill white -tags alphatcl
    }
    $win.f create text 690 15 -anchor ne -fill white -justify right -tags credits \
      -text ""
    set h [winfo screenheight .]
    set w [winfo screenwidth .]
    set w [winfo toplevel $win]
    wm withdraw $w
    update idletasks
    wm geometry $w +[expr {([winfo screenwidth .]-[winfo reqwidth $w])/2}]+[expr {([winfo screenheight .]-[winfo reqheight $w])/2}]
    update
    wm deiconify $w
    raise $w
    update
    wm geometry $w +[expr {([winfo screenwidth .]-[winfo reqwidth $w])/2}]+[expr {([winfo screenheight .]-[winfo reqheight $w])/2}]
    # This double 'list' is required because the 'after' is eval'ed and
    # then the 'catch' evals again.
    after 1000 "
	catch [list [list $win.f move tcl -1000 0]]
	after 1000 [list catch [list [list $win.f move alphatcl -1000 0]]]
    "
    bind $w <Destroy> {catch {image delete splash}}
}

proc alpha::showStartupVersions {} {
    variable tclversion
    if {[winfo exists .startup.alphatclversion]} {
	.startup.f itemconfigure alphatcl -text "and AlphaTcl $tclversion"
	update idletasks
    }
}
    
default::findDefaults
alpha::makeStartup
# make .status

proc alpha::makeStatus {} {
    global tcl_platform locationOfStatusBar pixelOffsetFromBottomOfWindow
    if {![winfo exists .status]} {
	if {$tcl_platform(platform) == "macintosh"} {
	    toplevel .status ; catch {::tk::unsupported::MacWindowStyle style .status plainDBox}
	    set locationOfStatusBar 0
	} else {
	    if {$locationOfStatusBar} {
		wm geometry . +0+0
		frame .status -width [winfo screenwidth .] -height 20
		pack .status -expand 1 -fill x
		pack propagate .status 0
		update
		wm geometry . +0+0
		update
	    } else {
		toplevel .status ; wm overrideredirect .status 1
	    }
	}
	if {[winfo toplevel .status] == ".status"} {
	    update
	    set h [winfo screenheight .]
	    set w [winfo screenwidth .]
	    wm geometry .status \
	      ${w}x20+0+[expr {$h - 18 - $pixelOffsetFromBottomOfWindow}]
	    update
	}
	label .status.text -text ""
	pack .status.text -side left
	frame .status.w -width 250 -height 20
	label .status.w.position -text "" -width 7 -anchor c
	bind .status.w.position <Button-1> gotoLine
	# mode menu
	global mode
	menubutton .status.w.mode -textvariable mode -direction above \
	  -menu .status.w.mode.menu -relief ridge \
	  -activebackground [color activebackground] \
	  -activeforeground [color activeforeground]
	bindtags .status.w.mode \
	  [concat Modepopup [bindtags .status.w.mode]]
	# encoding menu
	global encoding
	menubutton .status.w.encoding -textvariable encoding -direction above \
	  -menu .status.w.encoding.menu -relief ridge\
	  -activebackground [color activebackground] \
	  -activeforeground [color activeforeground]
	bindtags .status.w.encoding \
	  [concat Encodingpopup [bindtags .status.w.encoding]]

	pack .status.w.position -side right
	pack .status.w.mode -side right
	pack .status.w.encoding -side right

	update
	balloon::help .status "This bar is used for quick interaction\
	  with the user.  To change its location, go to the 'Window'\
	  preferences dialog.  You may also drag files onto it to open them."
    }
}

proc alpha::updateStatusLocation {args} {
    global pixelOffsetFromBottomOfWindow locationOfStatusBar
    if {$locationOfStatusBar ^ !([winfo toplevel .status] == ".status")} {
	set geom [wm geometry .]
	set height [lindex [split $geom "+x"] 1]
	if {[winfo toplevel .status] != ".status"} {
	    wm geometry . [winfo screenwidth .]x[expr {$height - 16}]
	} else {
	    wm geometry . [winfo screenwidth .]x[expr {$height + 16}]
	}
	# Ok, we're changing it on the fly
	destroy .status
	makeStatus
    } else {
	if {!$locationOfStatusBar} {
	    # It's a standalone window
	    set h [winfo screenheight .]
	    set w [winfo screenwidth .]
	    wm geometry .status \
	      ${w}x20+0+[expr {$h - 18 - $pixelOffsetFromBottomOfWindow}]
	    update
	}
    }
    message "Status bar moved"
}

proc alpha::resizeMenuBar {} {
    wm resizable . 1 0
    global tcl_platform alpha::systemMenu
    if {$tcl_platform(platform) != "macintosh"} {
	if {![catch {$alpha::systemMenu index "Resize"}]} {
	    $alpha::systemMenu delete "Resize"
	}
	$alpha::systemMenu add command -label "Fix size" \
	  -command alpha::fixMenuBarSize
	if {($tcl_platform(platform) == "windows") \
	  && ($alpha::systemMenu == ".menubar.system")} {
	    # These two lines are required to work around a windows bug
	    catch {.menubar delete tmp}
	    .menubar add cascade -menu $alpha::systemMenu -label tmp
	}
    }
}

proc alpha::fixMenuBarSize {} {
    wm resizable . 0 0
    # The above line resets Alphatk's icon on Windows!
    if {[llength [info commands alpha::setIcon]]} {alpha::setIcon .}
    global tcl_platform alpha::systemMenu
    if {$tcl_platform(platform) != "macintosh"} {
	if {![catch {$alpha::systemMenu index "Fix size"}]} {
	    $alpha::systemMenu delete "Fix size"
	}
	$alpha::systemMenu add command -label "Resize" \
	  -command alpha::resizeMenuBar
	if {($tcl_platform(platform) == "windows") \
	  && ($alpha::systemMenu == ".menubar.system")} {
	    # These two lines are required to work around a windows bug
	    catch {.menubar delete tmp}
	    .menubar add cascade -menu $alpha::systemMenu -label tmp
	}
	global alpha::menuBarGeometry alpha::earlyPrefs
	lappend alpha::earlyPrefs alpha::menuBarGeometry
	set alpha::menuBarGeometry [wm geometry .]
	prefs::modified alpha::menuBarGeometry
    }
}

proc alpha::positionMenuBar {{startup 0} {andSize 1}} {
    global alpha::menuBarGeometry
    if {[info exists alpha::menuBarGeometry]} {
	set geom $alpha::menuBarGeometry
    } else {
	if {$startup} {
	    # This looks rather confused.  The idea is to generate a long thin
	    # window across the top of the screen, containing the Tk menu
	    # bar.  However some unix systems include the height of the menu
	    # bar in '.', so settings its height to 0 is very bad... we don't
	    # get any menus!  Also we somehow need a bunch of updates etc, so
	    # that this works on different versions of WinTk (there have been
	    # a number of behavioural changes in the wm code of 8.2.x-8.3.x).
	    # 
	    # Anyway, I think it works for all platforms now!
	    wm geometry . +0+0
	    frame .dummy -height 0 -width [winfo screenwidth .]
	    pack .dummy
	    update
	    wm geometry . +0+0
	    update
	    destroy .dummy

	    if {[llength [info commands alpha::setIcon]]} {
		alpha::setIcon .
	    }
	    set geom +0+0
	} else {
	    set geom [wm geometry .]
	}
    }
    wm deiconify .
    if {$andSize} {
	wm geometry . $geom
    } else {
	regexp {\+.*} $geom geom
	wm geometry . $geom
    }
    update
}

proc alpha::makeSystemMenu {} {
    global tcl_platform alpha::systemMenu
    switch -- $tcl_platform(platform) {
	"macintosh" {
	    .menubar add cascade -menu .menubar.apple
	    ::menu .menubar.apple -tearoff 0
	    .menubar.apple add command -label "About Alphatk" \
	      -command "alpha::about"
	}
	"windows" {
	    .menubar.help insert 0 command -label "About Alphatk" \
	      -command "alpha::about"
	    # This update is absolutely required on WinNT at least, or
	    # the .menubar.system menu will not have its contents added
	    # to the system menu.
	    set alpha::systemMenu .menubar.system
	    ::menu $alpha::systemMenu -tearoff 0

	    update idletasks
	    fixMenuBarSize
	}
	"unix" {
	    .menubar.help insert 0 command -label "About Alphatk" \
	      -command "alpha::about"
	    set alpha::systemMenu .menubar.help.system
	    ::menu $alpha::systemMenu -tearoff 0
	    .menubar.help insert 1 cascade -menu $alpha::systemMenu \
	      -label "Adjust"
	    
	    update idletasks
	    fixMenuBarSize
	}
    }
}

proc alpha::about {} {
    if {[winfo exists .about]} {
	catch {destroy .about}
    }
    alpha::makeStartup .startup 
    bind all <ButtonPress> "set alphaAbout(startupdone) 1; set alphaAbout(done) 2"
    grab .startup

    lappend credits \
      "Implemented by Vince Darley" "" "" \
      "inspired by Pete Keleher's" "MacOS editor 'Alpha'" "" "" \
      "Many thanks to" "" 
    eval lappend credits [alpha::thanks]
    lappend credits "" "" \
      "graphic design by" "flip phillips"
    
    after 100 [list alpha::_arrangeScroll .startup.f credits 13 $credits]
    global alphaAbout
    vwait alphaAbout(startupdone)
    bind all <ButtonPress> ""
    foreach a [after info] {
	if {[lindex [after info $a] 0] == "alpha::_arrangeScroll"} {
	    after cancel $a
	}
    }
    destroy .startup
    unset alphaAbout
}

proc alpha::_arrangeScroll {can tag vislines text} {
    global alphaAbout
    for {set i 0} {$i < $vislines} {incr i} {
	lappend show ""
    }
    set height [font metrics [$can itemcget $tag -font] -linespace]
    set delay 30
    eval lappend lines $show $text $show
    for {set i 0} {$i < [llength $lines]} {incr i} {
	$can itemconfigure $tag -text \
	  [join [lrange $lines $i [expr {$i + $vislines -1}]] "\n"]
	for {set j 0} {$j < $height} {incr j} {
	    $can move $tag 0 -1
	    after $delay {set alphaAbout(done) 1}
	    vwait alphaAbout(done)
	    if {$alphaAbout(done) == 2} {return}
	}
	$can move $tag 0 $height
    }
    _showLogo $can
}

proc alpha::_showLogo {can} {
    global tk_library
    image create photo logo -file [file join $tk_library images pwrdLogo150.gif]
    $can create image 690 15 -anchor ne -image logo
}

proc alpha::iconifyAll {w {icon 1}} {
    # Bindings are triggered both for the toplevel and all children
    if {$w != "."} { return }
    foreach w [array names win::tk] {
	set ww $win::tk($w)
	if {[winfo exists $ww]} {
	    set top [winfo toplevel $ww]
	    if {![string length [$top cget -use]]} {
		if {$icon} {
		    wm iconify $top
		} else {
		    wm deiconify $top
		}
	    }
	}
    }
    if {[winfo toplevel .status] == ".status"} {
	if {$icon} {
	    wm withdraw .status
	} else {
	    wm deiconify .status
	}
    }
}

# displayMode <mode> - Up to four characters of the 'mode' string are 
#  displayed in the status line at the bottom of a window.
proc displayMode {m} {
    verifyDisplayStatus
}
# displayEncoding <enc> - The 'enc' string is 
#  displayed in the status line at the bottom of the screen
proc displayEncoding {e} {
    global encoding ; set encoding $e
    verifyDisplayStatus
}

proc verifyDisplayStatus {args} {
    if {[llength [winNames -f]]} {
	if {[catch {pack info .status.w}]} {
	   pack .status.w -side right
       }
    } else {
	.status.w.position configure -text ""
	pack forget .status.w
    }
}

proc alpha::finalStartup {} {
    if {[alpha::isOk]} {return}
    variable registration
    variable userName
    variable timeOfFirstUse
    variable timeOfLastUse
    ensureset userName ""
    ensureset registration ""
    
    prefs::modified alpha::userName alpha::registration
    
    set count 0
    if {![string length $userName]} {
	set firstUse 1
	set timeOfFirstUse [now]
	prefs::modified alpha::timeOfFirstUse
    } else {
	set firstUse 0
    }
    
    ensureset timeOfLastUse [now]
    set daysSinceLastUse [expr {([now] - $timeOfLastUse) / (24*60*60)}]
    
    if {$daysSinceLastUse > 12} {
	alertnote "I notice you haven't used Alphatk recently.\
	  Your trial period will be reset."
	set timeOfFirstUse [now]
	prefs::modified alpha::timeOfFirstUse
    }

    set daysOfUse [expr {([now] - $timeOfFirstUse) / (24*60*60)}]
    set daysLeft [expr {25 - $daysOfUse}]
    if {$daysLeft != 1} {
	append daysLeft " days"
    } else {
	append daysLeft " day"
    }

    set timeOfLastUse [now]
    prefs::modified alpha::timeOfLastUse

    while {1} {
	set resvar ""
	set y 10
	set args ""
	eval lappend args [dialog::image alphatk 10 y]
	incr y 10
	lappend args -T "Welcome to Alphatk"
	eval lappend args [dialog::text "Welcome to Alphatk.\
	  You have a free license to evaluate Alphatk for 25 days, with\
	  no limitations.  If you decide to\
	  continue using Alphatk beyond that time, you must\
	  buy a permanent license.  Once your payment has been received\
	  you will be sent a registration code to allow full, unhampered\
	  access to Alphatk.  You may purchase Alphatk at\
	  <http://order.kagi.com/?1GU> or by pressing the button below." 20 y 65]
	
	if {$firstUse} {
	    eval lappend args [dialog::textedit "User name" $userName 40 y 20 1 100]
	    lappend resvar userName
	} else {
	    eval lappend args [dialog::text "User name: $userName" 40 y]
	}
	incr y 5
	if {$daysOfUse < 26} {
	    if {$firstUse} {
		eval lappend args [dialog::text "If you would like to\
		  evaluate Alphatk for 25 days, please leave the following\
		  field blank." 20 y 65]
	    } else {
		eval lappend args [dialog::text "If you would like to\
		  continue evaluating Alphatk (you have $daysLeft left),\
		  please leave the following\
		  field blank.  If you have paid for and registered Alphatk,\
		  please enter your registration code below." 20 y 65]
	    }
	} else {
	    eval lappend args [dialog::text "You've used Alphatk for\
	      at least $daysOfUse days.  If you use Alphatk beyond this time,\
	      you must pay for it.  If you do not quit now you are breaking\
	      the licence agreement." 20 y 65]
	}
	incr y 5
	eval lappend args [dialog::textedit "Registration code" "" 40 y 20 1 120]
	lappend resvar registration
	incr y 15
	
	set x 20
	eval lappend args [dialog::button "Purchase Online" "" y "Ok" "" y "Quit" "" y "Send Feedback" "" y]
	lappend resvar register ok quit feedback
	foreach var $resvar val [eval dialog -w 480 -h $y $args] {
	    set $var $val
	}
	if {$quit} {
	    after 1 quit
	    return
	}
	if {$register} {
	    catch {url::execute "http://order.kagi.com/?1GU"}
	    continue
	}
	if {$feedback} {
	    catch {url::execute "mailto:vince.darley@kagi.com"}
	    continue
	}
	incr count
	if {[string trim $userName] != ""} {
	    if {[alpha::isOk]} {
		alertnote "Thank you for registering, $userName.  Updated versions\
		  of Alphatk are released at <ftp://ftp.ucsd.edu/pub/alpha/tcl/alphatk/>,\
		  which you may wish to check from time to time.  The author also\
		  appreciates feedback at <vince.darley@kagi.com>"
		break
	    } else {
		if {$registration == ""} {
		    # The user gets 25 days relatively hassle-free,
		    # then after that they have to wait a while for
		    # the dialog to let them continue.
		    if {$daysOfUse < 26} {
			set res [dialog -w 500 -h 173 -b {Go to purchase website} 317 147 480 167 \
			  -b Continue -delay 1000 240 147 305 167 \
			  -t "You have $daysLeft left to\
			  evaluate Alphatk.  I hope you find it useful.\
			  Feel free to send feedback to vince.darley@kagi.com\n\n\
			  During the evaluation period, you will receive occasional\
			  reminders to pay for Alphatk." 5 5 593 79]
			if {[lindex $res 0]} {
			    catch {url::execute "http://order.kagi.com/?1GU"}
			}
			break
		    } else {
			set res [dialog -w 500 -h 73 -b {Go to purchase website} 317 47 480 67 \
			  -b Continue -delay 10000 240 47 305 67 \
			  -t "You have already used Alphatk for $daysOfUse days.\
			  If you want to continue using" 5 5 593 19 \
			  -t {Alphatk, please pay for and register it.  Thank You.} 5 21 425 35]
			if {[lindex $res 0]} {
			    catch {url::execute "http://order.kagi.com/?1GU"}
			}
			after 2000000 alpha::finalStartup
			break
		    }
		} else {
		    alertnote "That code is invalid.  Please enter another."
		    set registration ""
		}
	    }
	} else {
	    alertnote "You must enter your name to use Alphatk (don't worry, Alphatk\
	      never sends any information anywhere)."
	}
    }
}

proc alpha::isOk {} {
    variable registration 
    variable userName
    if {[info exists registration] && [string match "*4*3*2*1*" $registration]} {
	if {[info exists userName]} {
	    foreach w [split $userName " "] {
		if {![string match "*[string toupper [string index $w 0]]*" $registration]} {
		    return 0
		}
	    }
	    return 1
	}
	return 1
    } else {
	return 0
    }
}

bind Modepopup <Button-1> "menu_set_widget modeMenu %W.menu ; modeMenuHook"
bind Encodingpopup <Button-1> "menu_set_widget encodingMenu %W.menu ; encodingMenuHook"
balloon::help Modepopup "Click here to change the mode of the current window"
balloon::help Encodingpopup "Click here to change the encoding of the current window"
