## -*-Tcl-*-
 # ###################################################################
 #  Alphatk - the ultimate editor
 # 
 #  FILE: "alpha_startup.tcl"
 #                                    created: 04/08/98 {21:52:56 PM} 
 #                                last update: 11/22/2001 {14:04:23 PM} 
 #  Author: Vince Darley
 #  E-mail: vince.darley@kagi.com
 #    mail: Flat 10, 98 Gloucester Terrace, London W2 6HP
 #     www: http://www.santafe.edu/~vince/Alphatk.html
 #  
 # Copyright (c) 1998-2001  Vince Darley
 # 
 # See the file "license.terms" for information on usage and redistribution
 # of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 # 
 # In particular, while this is 'open source', it is NOT free, and
 # cannot be copied in full or in part except according to the terms
 # of the license agreement.
 # 
 # ###################################################################
 ##

namespace eval alpha {}

# Choose the location of the status bar here.
newPref earlyvar locationOfStatusBar 1 global alpha::updateStatusLocation \
  [list "Status Bar At Bottom Of Screen" "Status Bar Under Menus"] index
lappend varPrefs(Window) locationOfStatusBar

# If set, use on of Alphatk's windows to dump the stack, otherwise use
# the standard Tcl dialog.
newPref flag stackTraceDumpInWindow 1

switch -- $tcl_platform(platform) {
    "macintosh" {
	set pixelOffsetFromBottomOfWindow 0
    }
    "windows" {
	# The status bar at the bottom of the screen can be placed 
	# according to your preferences for OS-dependent taskbars.
	# If your taskbar automatically hides itself, then there is
	# no need to have any pixel offset.  Otherwise an offset of
	# 18-48 may be useful.  If the status bar is under the menus,
	# this setting is ignored.
	newPref earlyvariable pixelOffsetFromBottomOfWindow 18 global alpha::updateStatusLocation
	lappend varPrefs(Window) pixelOffsetFromBottomOfWindow
    }
    "unix" -
    default {
	# The status bar at the bottom of the screen can be placed 
	# according to your preferences for OS-dependent taskbars.
	# If your taskbar automatically hides itself, then there is
	# no need to have any pixel offset.  Otherwise an offset of
	# 18-48 may be useful.  If the status bar is under the menus,
	# this setting is ignored.
	newPref earlyvariable pixelOffsetFromBottomOfWindow 48 global alpha::updateStatusLocation
	lappend varPrefs(Window) pixelOffsetFromBottomOfWindow
    }
}

# Alpha contains the infrastructure for localisation (i.e. translation)
# of most menu items, dialogs, alerts etc. to any language.  This is 
# accomplished through the use of the 'msgcat' package, part of Tcl 8.1.
# If a .msg file for your language exists, you can select it here.
newPref earlyvar localisation c

msgcat::mclocale $localisation
rename ::msgcat::mcunknown ::msgcat::_mcunknown
proc ::msgcat::mcunknown {locale args} {
    switch -- $locale {
	"en_uk" {
	    regsub -all {ization} $args {isation} args
	    regsub -all {(C|c)olor} $args {\1olour} args
	    return $args
	}
	default {
	    return [uplevel 1 [list ::msgcat::_mcunknown $locale] $args]
	}
    }
}

# Create the popup mode vars
global mode 
# Create the popup encoding vars
global encoding

# Make .status
alpha::makeStatus
alpha::initDnd

message "Starting up"

if {![winfo exists .menubar]} {
    menu .menubar
    wm title . "Alphatk"
    bindtags . [concat Alpha [bindtags .]]
    #bindtags . [concat Alpha AlphaMenu [bindtags .]]
    . configure -menu .menubar
    menu .menubar.help -tearoff 0
    .menubar add cascade -menu .menubar.help -label "Help"
    bind . <<Destroy>> quit
    wm protocol . WM_DELETE_WINDOW {
	if {[tk_messageBox \
	  -icon    question \
	  -type    yesno \
	  -default no \
	  -message "Are you sure you want to quit Alphatk?" \
	  -title  "Quit Application?"] == "yes"} {           
	    quit
	}
    }
    bind . <Unmap> [list alpha::iconifyAll %W]
    bind . <Map> [list alpha::iconifyAll %W 0]
}

namespace eval hook {}

# pre-register this proc to be called after startup
set hook::startupHook(*) [list \
  "destroy .startup"]

set hook::openHook(*) win::openHook
bind all <[lindex $alpha::modifier_keys 0]-Key-period> "abortEm"
set alpha::abort 0

if {$tcl_platform(platform) != "macintosh"} {
    alpha::positionMenuBar 1
}

# Do this after early prefs are in, but before building everything.
alpha::makeSystemMenu

alpha::checkFileExists [file join $HOME Tcl SystemCode AlphaBits.tcl]
source [file join $HOME Tcl SystemCode AlphaBits.tcl]

if {[llength [info commands alpha::setIcon]]} {
    update idletasks
    alpha::setIcon .
}


if {$tcl_platform(platform) != "unix"} {
    menu::insert File items end showTkConsole
    proc showTkConsole {} {
	console show
	console eval {wm title . "Alphatk console"}
	console eval {raise .}
    }
}

if {[catch {menuEnableHook [expr {[win::Current] != ""}]} err]} {
    catch {puts stderr "menuEnableHook error : $err"}
}
unset err

# if we're called up with more arguments, evaluate them.
# Normally they'll be items of the form "edit <file>"
if {$argc>0} {
    foreach str $argv {
	eval $str
    }
}

hook::register diskModifiedHook win::diskModified *
hook::register changeMode removeDisplays ""
hook::register winChangeModeHook ::win::modeHasChanged *
hook::register uninstallHook ::windows::DeleteGroup *

auto_load bgerror
set alpha_error ""
rename bgerror tk_bgerror
proc bgerror {err} {
    global alpha_error
    if {[string length $err]} {
	message -error $err
    } else {
	message -error "Null error occurred"
    }
    set alpha_error $err
}

alpha::finalStartup

if {$tcl_platform(platform) == "windows"} {
    # Since we provide, these, make it easy for the user!
    ensureset catSig [file join $HOME Tools cat.exe]
    ensureset DiffSig [file join $HOME Tools diff.exe]
}
