## -*-Tcl-*-
 # ###################################################################
 #  Alphatk - the ultimate editor
 # 
 #  FILE: "alpha_tk.tcl"
 #                                    created: 04/08/98 {21:52:56 PM} 
 #                                last update: 12/10/2001 {17:33:44 PM} 
 #  Author: Vince Darley
 #  E-mail: vince.darley@kagi.com
 #    mail: Flat 10, 98 Gloucester Terrace, London W2 6HP
 #     www: http://www.santafe.edu/~vince/Alphatk.html
 #  
 # Copyright (c) 1998-2001  Vince Darley
 # 
 # See the file "license.terms" for information on usage and redistribution
 # of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 # 
 # In particular, while this is 'open source', it is NOT free, and
 # cannot be copied in full or in part except according to the terms
 # of the license agreement.
 # 
 # ###################################################################
 ##

alpha::feature Alpha 8.1fc1 {} {
    switch -- $tcl_platform(platform) {
	"macintosh" {
	    set "flagPrefs(Platform Specific)" ""
	    set "varPrefs(Platform Specific)" ""
	    set multiColumnMenusEveryNItems 2000
	    set useGlobalMenuBarOnly 1
	}
	"windows" {
	    lappend "flagPrefs(Platform Specific)" "useGlobalMenuBarOnly"
	    lappend "varPrefs(Platform Specific)" "multiColumnMenusEveryNItems" \
	      "nonInteractiveApps" "showFileInExplorer"
	    # Required for communication with spawned off processes
	    newPref sig catSig ""
	    # If your platform doesn't handle scrolling menus, then your menus need
	    # to be multi-column.  Set this variable to the number of items per column.
	    newPref var multiColumnMenusEveryNItems [expr {($screenHeight - 30)/[default::size menuitemheight]}]
	    # Alpha tries to capture stdout/stderr when it spawns off processes.  For
	    # some processes this isn't really useful, and it's best if Alpha just sets
	    # the thing running and then ignores it.  Set this variable to a list of
	    # those items in the helpers dialog which Alpha should ignore in this way
	    newPref var nonInteractiveApps [list "viewDVI" "viewPS" "viewPDF"]
	    # To remove the menu bar from each separate text window, and use only a
	    # global menu bar, and speed up opening of new windows (Tk is particularly 
	    # slow with respect to 'cloning' menus, which it has to
	    # do if you want a separate menu bar in each editing window), click this box.||
	    # To place a menu bar in each editing window, and probably make the opening of
	    # new windows rather slow, click this box.
	    newPref flag useGlobalMenuBarOnly 1
	    # When Alphatk opens an explorer window for a given file or folder, should
	    # that be a standard 'Folder View' or an 'Explorer Window'.
	    newPref variable showFileInExplorer 0 global "" [list "With Explorer View" "With Folder View"] index
	    menu::insert fileUtils items end associateTypeWithAlpha associateTypeWithEditInAlpha
	}
	"unix" -
	default {
	    lappend "flagPrefs(Platform Specific)" "useGlobalMenuBarOnly"
	    lappend "varPrefs(Platform Specific)" "multiColumnMenusEveryNItems" \
	      "nonInteractiveApps"
	    # Required for communication with spawned off processes
	    newPref sig catSig ""
	    # If your platform doesn't handle scrolling menus, then your menus need
	    # to be multi-column.  Set this variable to the number of items per column.
	    newPref var multiColumnMenusEveryNItems [expr {($screenHeight - 30)/[default::size menuitemheight]}]
	    # Alpha tries to capture stdout/stderr when it spawns off processes.  For
	    # some processes this isn't really useful, and it's best if Alpha just sets
	    # the thing running and then ignores it.  Set this variable to a list of
	    # those items in the helpers dialog which Alpha should ignore in this way
	    newPref var nonInteractiveApps [list "viewDVI" "viewPS" "viewPDF"]
	    # To remove the menu bar from each separate text window, and use only a
	    # global menu bar, and speed up opening of new windows (Tk is particularly 
	    # slow with respect to 'cloning' menus, which it has to
	    # do if you want a separate menu bar in each editing window), click this box.||
	    # To place a menu bar in each editing window, and probably make the opening of
	    # new windows rather slow, click this box.
	    newPref flag useGlobalMenuBarOnly 1
	}
    }
    
    lappend varPrefs(International) "localisation"

    # To use complete path names as the titles of windows, click
    # this box.||To use just the file name for window titles,
    # click this box.
    newPref flag showFullPathsInWindowTitles 0
    lappend flagPrefs(Window) showFullPathsInWindowTitles

    # To use some more complex code to allow internal searches
    # to match text spread across multiple lines, as required
    # by some modes (e.g. HTML) for true Alpha emulation, click
    # this box.||To use simpler and quicker single-line only
    # pattern matching, and hence break some features of some
    # modes, click this box.
    set useMultilineSearchRoutines 1
    # We have now made this permanently active.
    #lappend flagPrefs(Window) useMultilineSearchRoutines
    
} {} 

