# This file (unlike most of the rest of Alphatk core)
# is distributed under a BSD style license.

namespace eval default {
    namespace export color 
    namespace export size
}

proc default::color {which} {
    variable colors
    if {![array exists colors]} {
	findDefaults
    }
    # Return calculated value
    lindex $colors($which) 0
}

proc default::size {what} {
    variable sizes
    if {![array exists sizes]} {
	findDefaults
    }
    # Return calculated value
    set sizes($what)

}

proc default::findDefaults {} {
    variable colors
    variable sizes
    toplevel .default_test ; wm withdraw .default_test
    ::menu .default_test.m ; ::button .default_test.b ; ::scrollbar .default_test.s
    .default_test.m configure -tearoff 0
    .default_test.m add command -label "hello"
    .default_test.m add command -label "hello"
    .default_test.m add command -label "hello"
    .default_test.m add command -label "hello"
    .default_test.m add command -label "hello"
    .default_test.m add command -label "hello"
    .default_test.m add command -label "hello"
    .default_test.m add command -label "hello"
    .default_test.m add command -label "hello"
    .default_test.m add command -label "hello"
    update
    set sizes(menuitemheight) [expr {[winfo reqheight .default_test.m]/10}]
    set colors(activebackground) [.default_test.m cget -activebackground]
    set colors(activeforeground) [.default_test.m cget -activeforeground]
    set colors(background) [.default_test.b cget -background]
    # Convert to RGB.
    foreach color [list activebackground activeforeground background] {
	lappend colors($color) [eval rgbToColor [winfo rgb . $colors($color)]]
    }
    set sizes(scrollbarwidth) [winfo reqwidth .default_test.s]
    destroy .default_test
    set bg [winfo rgb . [lindex $colors(background) 0]]
    set fg [list 65535 65535 65535]
    set types [list "" lightest lighter light]
    for {set i 1} {$i < 4} {incr i} {
	set col {}
	foreach dark_cpt $bg light_cpt $fg {
	    lappend col [expr {($dark_cpt * $i + $light_cpt * (4-$i))/4}]
	}
	set colors([lindex $types $i]background) [list [eval rgbToColor $col]]
    }
    
}

proc default::rgbToColor {r g b} {
    format "#%02x%02x%02x" [expr {$r/256}] [expr {$g/256}] [expr {$b/256}]
}

proc default::showDefaults {} {
    variable colors
    toplevel .colorshow
    set i 0
    foreach name [lsort [array names colors]] {
	set col $colors($name)
	frame .colorshow.square$i -bg $col -width 50 -height 50
	label .colorshow.label$i -text $name
	grid .colorshow.square$i .colorshow.label$i
	incr i
    }
}

proc default::colorSchemeHasChanged {} {
    variable oldcolors
    variable colors
    global HOME
    lappend args \
      [list source [file join $HOME AlphaCore default.tcl]] \
      default::findDefaults \
      [list array get default::colors] 
    array set oldcolors [array get colors]
    array set colors [eval tcltk::launchNewShell $args]
    tcltk::quitRemote 
    default::recurseOverChildren .
}

proc default::reapplyColorScheme {} {
    variable oldcolors
    variable colors
    array set oldcolors [array get colors]
    findDefaults
    recurseOverChildren .
    unset oldcolors
}

proc default::recurseOverChildren {w} {
    variable oldcolors
    variable colors
    foreach col $oldcolors(background) {
	if {[$w cget -background] == $col} {
	    $w configure -background [lindex $colors(background) end]
	}
    }
    foreach subw [winfo children $w] {
	recurseOverChildren $subw
    }
    switch -- [winfo class $w] {
	"Menu" {
	    # loop over menu entries
	}
    }
}

namespace import -force default::color
