##
## This is file `Dialogs-Example.tcl',
## generated with the docstrip utility.
##
## The original source files were:
##
## dialogsNew.dtx  (with options: `examples')
## 
## ===================================================================
## AlphaTcl - generic dialogs examples
## 
## Source file version data:
##                                    created: 12/1/96 {5:36:49 pm}
##                                last update: 2001-11-11 22.17.30
##  Author: Vince Darley
##  E-mail: <vince@santafe.edu>
##    mail: 317 Paseo de Peralta, Santa Fe, NM 87501
##     www: <http://www.santafe.edu/~vince/>
##
##  Author: Lars Hellstr\"om
##  E-mail: <Lars.Hellstrom@math.umu.se>
##
## Copyright (c) 1997-2001  Vince Darley, Lars Hellstr\"om
## Distributed under Tcl style free license.
## ===================================================================
proc test_make {format script} {
   set code [catch $script res]
   new -n "dialog make result" -info [if {$code} then {
        set t "Error: $res"
        global errorInfo
        append t \n "errorInfo:\n" $errorInfo
     } elseif {$format} then {
        set L [list]
        newforeach {page keyvals} $res {
           set t \n
           newforeach {key value} $keyvals {
              append t "  [list $key $value]\n"
           }
           lappend L $page $t
        }
        set L
     } else {
        join $res \n
     }]
}
test_make 0 {
   dialog::make -title "Example dialog 1"\
     [list "TextEdit types"\
       [list var "A 'var'" "Some text"]\
       [list var "A 'var' with a long name" "Again some text"]\
       [list var "A 'var' with a very very very long name" short]\
       [list var2 "A 'var2'" "This piece of editable text is rather long,\
         two lines come in handy."]\
       [list static "A 'static'" "This text cannot be edited."]\
       [list password "A 'password'" Swordfish]\
       [list password "A 'password' with a very long title" Swordfish]\
     ]
}
test_make 1 {
   dialog::make_paged -title "Example dialog 1"\
     [list "TextEdit types"\
       [list a "Some text" b "Again some text" c short\
         d "This piece of editable text is rather long,\
         two lines come in handy." e Swordfish f Swordfish\
         g "This text cannot be edited."]\
       [list\
         [list a var "A 'var'"]\
         [list b var "A 'var' with a long name"]\
         [list c var "A 'var' with a very very very long name"]\
         [list d var2 "A 'var2'"]\
         [list g static "A 'static'"]\
         [list e password "A 'password'"]\
         [list f password "A 'password' with a very long title"]\
       ]\
     ]
}
test_make 0 {
   set page1 [list "Text types"]
   lappend page1 [list var "A 'var'" "Some text"]
   lappend page1 [list var2 "A 'var2'" "This piece of editable text\
     is rather long, two lines come in handy."]
   lappend page1 [list text "This is a 'text' item. It can be used\
     for including a paragraph or two of text inside the dialog."\
     "This value is ignored!"]
   lappend page1 [list password "A 'password'" No]
   lappend page1 [list static "A 'static'" "This is static text"]
   set page2 [list "Files and the like"]
   global HOME
   lappend page2\
     [list file "A 'file'" [file join $HOME Help "Alpha Manual"]]
   lappend page2 [list folder "A 'folder'" $HOME]
   lappend page2\
     [list url "An 'url'" "http://alphatcl.sourceforge.net/"]
   global alpha::platform
   if {${alpha::platform}=="alpha"} then {
      lappend page2 [list appspec "An 'appspec'" 'ALFA']
      set s 'WIsH'
      if {[catch {nameFromAppl $s} t]} then {
         set t $s
      } elseif {[regexp -nocase wish $t]} then {
         set t $s
      } else {
         set t [glob -nocomplain -dir [file dirname $t] *Wish*]
         if {[llength $t]} then {set t [lindex $t 0]} else {set t $s}
      }
      lappend page2 [list appspec "Another 'appspec'" $t]
   } else {
      global texSig
      lappend page2 [list appspec "An 'appspec'" $texSig]
   }
   lappend page2 [list searchpath "A 'searchpath'"\
      [glob -nocomplain -types d -join $HOME {[E-H]*}]]
   set page3 [list "Menus and the like"]
   lappend page3 [list {menu {One two three}} "A 'menu'" two]
   lappend page3\
     [list {menuindex {nul odin dva tri tjetyre pat sjest}}\
       {A 'menuindex'} 2]
   lappend page3 [list colour "A 'colour'" green]
   lappend page3 [list mode "A 'mode'" TeX]
   lappend page3 [list [list subset\
       [list "Charlie Chaplin" Saturn toothbrush {"yeah, yeah"} 19]]\
       {A 'subset'} [list toothbrush 19]]
   lappend page3 [list modeset "A 'modeset'" [list TeX Bib Mf]]
   set page4 [list "Miscellaneous types"]
   lappend page4 [list flag "A 'flag'" 1]
   lappend page4 [list\
       [list multiflag [list AlphaPrefs Developer Examples\
         Help Tcl Tools]]\
     {This is a 'multiflag'} [list 0 1 1 0 1 0]]
   lappend page4 [list binding "A 'binding'" /Q<O]
   lappend page4 [list date "A 'date'" [now]]
   lappend page4 [list thepage "This item is invisible"\
     "This value is ignored"]
   dialog::make $page1 $page2 $page3 $page4
}
test_make 0 {
   set page [list "Login parameters"]
   lappend page [list static "Curent time" [join [mtime [now] long]]]
   lappend page [list var "User name" ""]
   lappend page [list password "Password" ""]
   dialog::make -ok Login\
     -addbuttons [list "Update time"\
       {This button updates the current time shown in the dialog.}\
       {dialog::valSet $dial "Login parameters,Curent time"\
          [join [mtime [now] long]]}]\
     $page
}
test_make 0 {
   set page [list "Email settings"]
   lappend page [list var "Name" "Jane Doe"]
   lappend page [list var "Address" "Jane.Doe@nowhere.edu"]
   lappend page [list var "Organisation" "University of Nowhere"]
   lappend page [list [list hidden var] "POP server" mail.nowhere.edu]
   lappend page [list [list hidden var] "SMTP server" smtp.nowhere.edu]
   dialog::make -addbuttons [list "Full settings"\
     {Toggles between basic and full settings.} {
        if {!$state} then {
           dialog::show_item "Email settings" "POP server"
           dialog::show_item "Email settings" "SMTP server"
           set opts(-addbuttons) [lreplace $opts(-addbuttons) 0 0\
             "Basic settings"]
           set state 1
        } else {
           dialog::hide_item "Email settings" "POP server"
           dialog::hide_item "Email settings" "SMTP server"
           set opts(-addbuttons) [lreplace $opts(-addbuttons) 0 0\
             "Full settings"]
           set state 0
        }
     }]\
     $page
}
test_make 0 {
   set page1 [list "Basic email settings"]
   lappend page1 [list var "Name" "Jane Doe"]
   lappend page1 [list var "Address" "Jane.Doe@nowhere.edu"]
   lappend page1 [list var "Organisation" "University of Nowhere"]
   set page2 [list "Advanced email settings"]
   lappend page2 [list var "POP server" mail.nowhere.edu]
   lappend page2 [list var "SMTP server" smtp.nowhere.edu]
   dialog::make -addbuttons [list "Full settings"\
     {Toggles between basic and full settings.} {
        if {!$state} then {
           set currentpage "Advanced email settings"
           lappend pages $currentpage $pageA($currentpage)
           set opts(-addbuttons) [lreplace $opts(-addbuttons) 0 0\
             "Basic settings"]
           set state 1
        } else {
           set currentpage "Basic email settings"
           set pages [list $currentpage $pageA($currentpage)]
           set opts(-addbuttons) [lreplace $opts(-addbuttons) 0 0\
             "Full settings"]
           set state 0
        }
     }] -hidepages [list "Advanced email settings"]\
     $page1 $page2
}
## 
##
## End of file `Dialogs-Example.tcl'.
