## -*-Tcl-*-
 # ==========================================================================
 #  BibTeX mode - an extension package for Alpha
 # 
 #  FILE: "BibCompletions.tcl"
 #                                    created: 05/10/95 {12:55:13 am} 
 #                                last update: 11/13/2001 {10:09:33 AM}
 #                                
 #  Author: Vince Darley
 #  E-mail: <vince@santafe.edu>
 #    mail: 317 Paseo de Peralta
 #          Santa Fe, NM 87501, USA
 #     www: <http://www.santafe.edu/~vince/>
 #  
 # Currently maintained by Craig Barton Upright.
 #
 #  E-mail: <cupright@princeton.edu>
 #    mail: Princeton University,  Department of Sociology
 #          Princeton, New Jersey  08544
 #     www: <http://www.princeton.edu/~cupright/>
 #  
 # ==========================================================================
 ##

proc BibCompletions.tcl {} {}

namespace eval Bib {}

# Setting the order of precedence for completions.

set completions(Bib) {
    completion::cmd Entry Field LaTeXCommand completion::word Acronyms
}

# Note:  The variable "Bibcmds" is now set in Bib::setBibcmds

#============================================================================
# 
# Bib::Completion::Entry
# 
# If the current text is '@XXX' where 'XXX' is the name of a bib-entry
# type, then insert the correct template for that type.
# 

namespace eval Bib::Completion {}

proc Bib::Completion::Entry {} {

    global Bib::Entries

    set lastWord [completion::lastWord where]
    set lastWord [string trimleft $lastWord @]
    set oneBack [pos::math $where - 1]
    if {([lookAt $where] != "@") && ([lookAt $oneBack] != "@")} {return 0}

    # Make sure that this is a defined entry.
    if {![lcontains Bib::Entries $lastWord]} {return 0}

    deleteText $where [getPos]
    goto $where
    Bib::entriesProc "" $lastWord
    return 1
}

#============================================================================
# 
# Bib::Completion::Field
# 
# Insert a new field within an existing entry.  If the cursor is before a
# current entry (as defined by the variable "indentString"), Bib::makeField
# will insert it on current line.  Otherwise, insert it on the next line.
# 

proc Bib::Completion::Field {} {
    
    global BibmodeVars Bib::Fields
    
    if {!$BibmodeVars(fieldCompletions)} {return 0} 

    set lastword [completion::lastWord where]

    # Make sure that this is a defined entry.
    if {![lcontains Bib::Fields $lastword]} {return 0}

    deleteText $where [getPos]
    Bib::fieldsProc "" $lastword
    return 1
}

#============================================================================
# 
# Bib::Completion::LaTeXCommand
# 
# Insert a LaTeX command with braces and template stops.  If the opening
# backslash is not present, insert that as well.  This will also recognize
# text-command abbreviations, with and without the slash.
# 

proc Bib::Completion::LaTeXCommand {} {
    
    global BibmodeVars Bib::TeXCommandsList Bib::TextAbbrev
    
    if {!$BibmodeVars(latexCompletions)} {return 0} 
    set lastword [string trimleft [completion::lastWord where] "\\"]
    set oneback  [pos::math $where - 1]
    
    # Make sure that this is a defined TeX command.
    if {![lcontains Bib::TeXCommandsList $lastword]} {return 0}

    if {[lsearch -exact [set Bib::TextAbbrev] $lastword] != "-1"} {
        # It's a LaTeX text-command abbreviation.
        if {[lookAt $oneback] != "\\"} {
            # Is there already a slash?  If not, add one.
            deleteText $where [getPos]
            set LaTeXInsertion "\\text$lastword{}"
        } else {
            deleteText $where [getPos]
            set LaTeXInsertion "text$lastword{}"
        }
    } else {
        if {[lookAt $oneback] != "\\"} {
            # Is there already a slash?  If not, add one.
            deleteText $where [getPos]
            set LaTeXInsertion "\\$lastword{}"
        } else {
            set LaTeXInsertion "{}"

        }
    }
    elec::Insertion $LaTeXInsertion
    return 1
}

#============================================================================
# 
# Bib::Completion::BibAcronyms
# 
# For those who prefer completions to @string{...} .  This proc is only
# called if there were no nearby word completions.
# 
# (Technically, these are "expansions" and are included as such below.)
# 

proc Bib::Completion::Acronyms {} {
    
    global Bib::Acronyms 
    
    set lastword [completion::lastWord where]
    
    if {![info exists Bib::Acronyms($lastword)]} {return 0}

    deleteText $where [getPos]
    elec::Insertion [set Bib::Acronyms($lastword)]
    return 1
}

#============================================================================
# 
# Bib::Expansion::Acronyms
# 
# Allowing the expansion key to also complete acronyms.
# 

set expanders(Bib) {Acronyms}

# namespace eval Bib::Expansion {}

# proc Bib::Expansion::ExAcronyms {} {Bib::Completion::Acronyms}

#============================================================================
# 
# .