## -*-Tcl-*-
 # ###################################################################
 #  Vince's Additions - an extension package for Alpha
 # 
 #  FILE: "CCompletions.tcl"
 #                                    created: 31/7/97 {2:46:39 pm} 
 #                                last update: 09/19/2000 {12:20:39 PM} 
 #  Author: Vince Darley
 #  E-mail: <vince@santafe.edu>
 #    mail: 317 Paseo de Peralta
 #          Santa Fe, NM 87501, USA
 #     www: <http://www.santafe.edu/~vince/>
 #  
 # Copyright (c) 1997-2000  Vince Darley, all rights reserved
 # 
 # This file is used for both C and C++
 # 
 # ###################################################################
 ##

set completions(C) {completion::cmd Electric Class completion::word}
set completions(C++) {completion::cmd Electric Class completion::word}

lunion "CTemplates" createNewClass newFunction

#  Completions  #

set Ccmds { #elseif #endif #include class default enum for register return 
struct switch typedef volatile while }

set Celectrics(for) " (init;test;increment)\{\n\tloop body\n\}\n"
set Celectrics(while) " (test)\{\n\tloop body\n\}\n"
set Celectrics(switch) " (value)\{\ncase item:\n\tcase body\ndefault:\n\tdefault body\n\}\n"
set Celectrics(case) " item:\nɥcase body\ncase"
set Celectrics(do) " \{\n\t\n\} while (test);\n"
set Celectrics(if) "(condition)\{\n\tif body\n\} "
set Celectrics(else) " \{\n\telse body\n\} "
set Celectrics(class) " object name : public parent \{\npublic:\n\tobject name(args);\n\t~object name(void);\n\n\};\n"
set Celectrics(struct) " object name \{\n\tobject name(args);\n\t~object name(void);\n\n\};\n"
set Celectrics(enum) " name \{ item, item ... item \};\n"
# For these two to work you must use my '#' modified definitions of 
# wordBreak, wordBreakPreface (defined by Vince's Additions).
set Celectrics(#if) " \n\t\n#endif\n"
set Celectrics(#include) " \"file.h\"\n"
set Celectrics(try) " \{\r\ttry body\r\}\rcatch (...) \{\r\tcatch body\r\}\r"
## 
 # -------------------------------------------------------------------------
 # 
 # "C::Completion::Class" --
 # 
 #  If we've just typed the name of a class, struct or union, we can
 #  automatically fill in all occurrences of that name in the rest of
 #  the class.  (e.g. in constructors, destructors etc.)
 # -------------------------------------------------------------------------
 ##
proc C::Completion::Class { {cmd ""}} {
    set cl [completion::lastTwoWords prev]
    if {[lsearch -exact "class struct union" [string trim $prev]] == -1} {
	return 0
    }
    if {[ring::type]} {ring::replaceStopMatches "object name" $cl}
    return 1
}

proc C::Completion::Electric { {cmd ""} } {
    if {[completion::lastWord] == "case "} { backwardChar }
    return [completion::electric $cmd]
}

