## -*-Tcl-*- (nowrap)
 # ==========================================================================
 #  Statistical Modes - an extension package for Alpha
 # 
 #  FILE: "SCompletions.tcl"
 #                                    created: 05/14/00 {01:48:41 pm} 
 #                                last update: 12/19/00 {09:28:28 pm} 
 #  Description: 
 # 
 #  This file will be sourced automatically, immediately after the _first_
 #  time sMode.tcl is sourced.  This file declare completions items and
 #  procedures for S mode.
 #  
 #  Author: Craig Barton Upright
 #  E-mail: <cupright@princeton.edu>
 #    mail: Princeton University, Department of Sociology
 #          Princeton, New Jersey 08544
 #     www: <http://www.princeton.edu/~cupright>
 #  
 # Copyright (c) 2000  Craig Barton Upright
 # 
 # This program is free software; you can redistribute it and/or modify
 # it under the terms of the GNU General Public License as published by
 # the Free Software Foundation; either version 2 of the License, or
 # (at your option) any later version.
 # 
 # This program is distributed in the hope that it will be useful,
 # but WITHOUT ANY WARRANTY; without even the implied warranty of
 # MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 # GNU General Public License for more details.
 # 
 # You should have received a copy of the GNU General Public License
 # along with this program; if not, write to the Free Software
 # Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 # 
 # ==========================================================================
 ##

proc SCompletions.tcl {} {}

# Setting the order of precedence for completions.

set completions(S) {
    completion::cmd Command completion::electric completion::word
}

#=============================================================================
# 
# S::Completion::Command
# 
# (1)  The lists of commands has already been created.
# (2)  Complete the insertion as defined by the variables 
#      SCommandElectrics($lastword)
# 


proc S::Completion::Command {} {

    global SCommandList SCommandElectrics SSyntaxMessage

    set lastword [completion::lastWord where]
    if {[lsearch -exact $SCommandList $lastword] == -1} {
        return 0
    }
    if {[info exists SCommandElectrics($lastword)]} {
        elec::Insertion $SCommandElectrics($lastword)
    } else {
        elec::Insertion "()"
    } 
    # Putting a message in the status bar with syntax information
    if {[info exists SSyntaxMessage($lastword]} {
        message "$SSyntaxMessage($lastword)"
    } 
    return 1
}


#=============================================================================
# 
#  S Command Electrics   #
# 
# -- further completions beyond the above proc.
# 
# These are distinguished from "Selectrics" because we want them to take
# place after the S::Completions::Command takes place, not before.
# 
# Each completion will already have $lastword, "$lastword"
# 

#    Specific completions  #

array set SCommandElectrics {
    
    if              "() ()"
    for             "( in )\{\r\t\r\}\r"
    glm             "( ~ )\r"
}



#=============================================================================
# 
#    Syntax messages  #
# 
# Make sure that [,],{,},#, and " have preceding backslashes.
# 

# specific messages --

# As of this writing I don't when I'll have time to pursue this project.
# 
# The following examples demonstrate how one could include syntax messages,
# which would appear in the status bar during completions and via
# command-control-double-click.  The syntax can be obtained from the manual 
# pages of S, by entering 
# 
# help (<command>)
# 

array set SSyntaxMessage {
    
    abbreviate  "abbreviate(names, minlength = 4, use.classes = T, dot = F)"
    abline      "abline(a, b)  OR  abline(coef)  OR  abline(reg)  OR  abline(h=, v=)"
}

#=============================================================================
# 
# .
