## -*-Tcl-*- (nowrap)
 # ==========================================================================
 #  Lisp Mode - an extension package for Alpha
 # 
 #  FILE: "ScmCompletions.tcl"
 #                                    created: 05/14/00 {01:48:41 pm} 
 #                                last update: 12/01/00 {01:25:07 pm} 
 #  Description: 
 # 
 #  This file will be sourced automatically, immediately after the _first_
 #  time ScmMode.tcl is sourced.  This file declare completions items and
 #  procedures for Scm mode.
 #  
 #  Author: Craig Barton Upright
 #  E-mail: <cupright@princeton.edu>
 #    mail: Princeton University, Department of Sociology
 #          Princeton, New Jersey 08544
 #     www: <http://www.princeton.edu/~cupright>
 #  
 # Copyright (c) 2000  Craig Barton Upright
 # 
 # This program is free software; you can redistribute it and/or modify
 # it under the terms of the GNU General Public License as published by
 # the Free Software Foundation; either version 2 of the License, or
 # (at your option) any later version.
 # 
 # This program is distributed in the hope that it will be useful,
 # but WITHOUT ANY WARRANTY; without even the implied warranty of
 # MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 # GNU General Public License for more details.
 # 
 # You should have received a copy of the GNU General Public License
 # along with this program; if not, write to the Free Software
 # Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 # 
 # ==========================================================================
 ##

# Setting the order of precedence for completions.

set completions(Scm) {
    completion::cmd Command completion::electric completion::word
}

# ===========================================================================
# 
# Scm::Completion::Command
# 
# (1)  The list of commands has already been created.
# (2)  Check to see if the command is preceded by an opening paranthesis.
# (3)  If not, delete the $lastword, and add the paranthesis.
# (4)  Insert a generic completion.

proc Scm::Completion::Command {} {

    global ScmCommandList ScmCommandElectrics ScmSyntaxMessage

    set lastword [completion::lastWord where]

    if {[lsearch -exact $ScmCommandList $lastword] == -1} {
        return 0
    }
    set oneback [pos::math $where - 1]

    # Do we have a defined completion?
    if {[info exists ScmCommandElectrics($lastword)]} {
        set complete $ScmCommandElectrics($lastword)
    } else {
        set complete ")"
    } 
    # Do we have a message to put in the status bar?
    if {[info exists ScmSyntaxMessage($lastword)]} {
        set sm $ScmSyntaxMessage($lastword)
    } else {
        set sm ""
    } 
    if {[lookAt $oneback] != "("} {
        deleteText $where [getPos]
        set commandInsertion "($lastword $complete"
    } else {
        set commandInsertion " $complete"
    }
    elec::Insertion $commandInsertion
    # Putting a message in the status bar with syntax information
    message "$sm"
    return 1
}    

# ===========================================================================
# 
#  Scm Command Electrics   #
# 
# -- further completions beyond the above proc.
# 
# These are distinguished from "Scmelectrics" because we want them to take
# place after the Scm::Completions::Command takes place, not before.
# 
# Each completion will already have $lastword and a space, "$lastword "
# 

# ===========================================================================
# 
#    Syntax messages  #
# 
# Make sure that [,],{,},#, and " have preceding backslashes.
# 

# specific messages --

# As of this writing I don't intend to pursue this project.
# 
# The following examples demonstrate how one could include syntax messages,
# which would appear in the status bar during completions and via
# command-control-double-click.  The syntax can be obtained from
# 
# <http://www.xanalys.com/software_tools/reference/HyperSpec/Body/>
# 
# Note: These are simply copied from LispCompletions.tcl, and have nothing
# to do with Scheme.
# 

# functions

array set ScmSyntaxMessage {
    abs         "abs number => absolute-value"
    append      "append &rest lists => result"
}

# macros

array set ScmSyntaxMessage {
    and         "and form* => result*"
    assert      "assert test-form \[(place*) \[datum-form argument-form*\]\]"
    defclass    "defclass class-name (\{superclass-name\}*) (\{slot-specifier\}*) \[\[class-option\]\] => new-class"
}

# accessors

set ScmSyntaxMessage(aref) "aref array &rest subscripts => element"

# specials

set ScmSyntaxMessage(setq) "setq \{pair\}* => result"

# ===========================================================================
# 
# .
