## -*-Tcl-*-
 # ###################################################################
 #  Vince's Additions - an extension package for Alpha
 # 
 #  FILE: "TclCompletions.tcl"
 #                                    created: 07/31/1997 {03:01:54 pm} 
 #                                last update: 11/14/2001 {12:23:16 PM} 
 #  Author: Vince Darley
 #  E-mail: <vince@santafe.edu>
 #    mail: 317 Paseo de Peralta
 #          Santa Fe, NM 87501, USA
 #     www: <http://www.santafe.edu/~vince/>
 #  
 # Copyright (c) 1997-2001  Vince Darley, all rights reserved
 # 
 # ###################################################################
 ##

ensureset completions(Tcl) {
    contraction Proc Vvar completion::cmd Ensemble completion::electric Var
}
ensureset completions(Shel) {
    Globalvar Proc completion::cmd Ensemble completion::electric Filename Var
}

lunion TclTemplates "createNewClass"

#  Completions  #

namespace eval Tcl::Completion {}

proc Tcl::Completion::Globalvar {} {
    set lastword [completion::lastWord]
    if {[string length $lastword] < 3} { return 0 }
    if {[string index $lastword 0] != "\$"} { return 0 }
    set lastword [string range $lastword 1 end]
    set matches [lsort [info globals ${lastword}*]]
    return [completion::matchUtil Tcl::Completion::Globalvar $lastword $matches]
}

proc Tcl::Completion::Proc {} {
    set lastword [completion::lastWord p]
    if {[string length $lastword] < 3} {return 0}
    if {[lookAt [pos::math $p - 1]] != "\["} {return 0}
    set matches [lsort [info commands ${lastword}*]]
    return [completion::matchUtil Tcl::Completion::Proc $lastword $matches]
}

## 
 # -------------------------------------------------------------------------
 #   
 #  "Tcl::Completion::Var" --
 #  
 #  A mildly adaptive call of completion::word, in which we realise we
 #  should complete '$abc...'  if we can only see 'abc...'.  The standard
 #  procedure considers '$' to be part of a word so that would otherwise
 #  fail.
 #  
 #  ------------------------------------------------------------------------
 ##

proc Tcl::Completion::Var {} {
    set lastword [completion::lastWord]
    if { [string index $lastword 0] == "\$" } {
	set got [string range $lastword 1 end]
	set looking $got
	return [completion::general -excludeBefore [string length $got] $looking]
    } else {
	return [completion::word]
    }
}

## 
 # -------------------------------------------------------------------------
 # 
 # "Tcl::Completion::Vvar" --
 # 
 # Try to complete a variable, provided it seems to be a variable name.
 # This means it is preceded by '$' or by 'set ' or 'arrayname(',...
 #  
 # This allows us to complete variable names which begin 'str', 'li' etc.
 # preferentially, since they would otherwise be expanded into 'string',
 # 'lindex' etc before they had a chance to be completed as variables.
 #  
 # -------------------------------------------------------------------------
 ##

proc Tcl::Completion::Vvar {} {
    set lastword [completion::lastTwoWords prev]
    if {[string index $lastword 0] == "\$"} {
	set got [string range $lastword 1 end]
	set looking $got
	return [completion::general -excludeBefore [string length $got] $looking]
    } elseif {[regexp "(^(set|global|variable|get)\[ \t\]+\$)|(\\($)" $prev]} {
	return [completion::word]
    } else {
	return 0
    }
}

#  Specific Command Completions  #

set Tclelectrics(append)        " varName value ?value value ...?"
set Tclelectrics(body)          " \{string\} \{\n\tbody\n\}"
set Tclelectrics(break) 	""
set Tclelectrics(case) 		" string ?in? patList body ?patList body ...?"
set Tclelectrics(catch)		" script ?varName?"
set Tclelectrics(cd) 		" ?dirName?"
set Tclelectrics(class)         " name \{\n\tinherit parent\n\}"
set Tclelectrics(close) 	" fileId"
set Tclelectrics(concat)        " ?arg arg ...?"
set Tclelectrics(continue) 	""
set Tclelectrics(else)          " \{\n\telse body\n\} "
set Tclelectrics(elseif)        " \{test\} \{\n\ttrue body\n\} "
set Tclelectrics(eof) 		" fileId"
set Tclelectrics(error) 	" message ?info? ?code?"
set Tclelectrics(eval) 		" arg ?arg ...?"
set Tclelectrics(exec) 		" ?switches? arg ?arg ...?"
set Tclelectrics(exit) 		" ?returnCode?"
set Tclelectrics(expr) 		" arg ?arg arg ...?"
set Tclelectrics(flush) 	" fileId"
set Tclelectrics(for)           " \{start\} \{test\} \{increment\} \{\r\tbody\r\}\r"
set Tclelectrics(format) 	" formatString ?arg arg ...?"
set Tclelectrics(gets) 		" fileId ?varName?"
set Tclelectrics(glob) 		" ?switches? pattern ?pattern ...?"
set Tclelectrics(global) 	" varname ?varname ...?"
set Tclelectrics(if)            " \{test\} \{\r\ttrue body\r\} "
set Tclelectrics(incr) 		" varName ?increment?"
set Tclelectrics(join) 		" list ?joinString?"
set Tclelectrics(lappend)       " varName value ?value value ...?"
set Tclelectrics(lindex)        " list element"
set Tclelectrics(linsert)       " list index element ?element element ...?"
set Tclelectrics(list) 		" ?arg arg ...?"
set Tclelectrics(llength) 	" list"
set Tclelectrics(lrange)        " list first last"
set Tclelectrics(lreplace)      " list first last ?element element ...?"
set Tclelectrics(lsearch)       " ?switches? list pattern"
set Tclelectrics(lsort) 	" ?switches? list"
set Tclelectrics(open) 		" fileName ?access? ?permissions?"
set Tclelectrics(pid) 		" ?fileId?"
set Tclelectrics(proc)          " name \{args\} \{\n\tbody\n\}"
set Tclelectrics(puts) 		" ?-nonewline? fileId string"
set Tclelectrics(pwd) 		""
set Tclelectrics(read) 		" ?-nonewline? fileId"
set Tclelectrics(regexp)        " ?switches? exp string ?matchVars...?"
set Tclelectrics(regsub)        " ?switches? exp string subSpec varName"
set Tclelectrics(rename) 	" oldName newName"
set Tclelectrics(return) 	" ?-code  code? ?-errorinfo  info? ?-errorcode  code? ?string?"
set Tclelectrics(scan)          " string format varName ?varName ...?"
set Tclelectrics(seek) 		" fileId offset ?origin?"
set Tclelectrics(set) 		" varName ?value?"
set Tclelectrics(source) 	" fileName"
set Tclelectrics(split)		" string ?splitChars?"
set Tclelectrics(switch)        " \{string\} \{\n\"pattern\" \{\n\tbody\n\}\n\}\n"
set Tclelectrics(tell) 		" fileId"
set Tclelectrics(time) 		" script ?count?"
set Tclelectrics(time) 		" script ?count?"
set Tclelectrics(unset) 	" name ?name name ...?"
set Tclelectrics(uplevel) 	" ?level? arg ?arg ...?"
set Tclelectrics(upvar)         " ?level? varName localVar"
set Tclelectrics(while)         " \{test\} \{\r\tbody\r\}\r"

if {[info tclversion] < 8.0} {
    set Tclelectrics(foreach)   " varname list \{\r\tbody\r\} "
} else {
    set Tclelectrics(foreach)   " varname list varname list... \{\r\tbody\r\} "
}

#  Commands With Options  #

# Used by Tcl::Completion::PickOption below, and by contractions.

set TclarrayOptions [list \
  anymore donesearch exists get names nextelement set size startsearch unset ]

lappend TclcmdsWithOptions array

set "Tclelectrics(array anymore)" 	" arrayName searchId"
set "Tclelectrics(array donesearch)" 	" arrayName searchId"
set "Tclelectrics(array names)" 	" arrayName" 
set "Tclelectrics(array nextelement)" 	" arrayName searchId" 
set "Tclelectrics(array size)" 		" arrayName" 
set "Tclelectrics(array startsearch)" 	" arrayName"
# Need to add proper options to these:
set "Tclelectrics(array exists)"        " name"
set "Tclelectrics(array get)"           " name"
set "Tclelectrics(array set)"           " name"
set "Tclelectrics(array unset)"         " name"

set Tclfilecmds [list \
  atime copy delete dirname executable exists extension isdirectory \
  isfile join lstat mtime mkdir normalize owned pathtype readable \
  readlink rename \
  root rootname size split stat system tail type writable ]

lappend TclcmdsWithOptions file

set "Tclelectrics(file atime)"          " name"
set "Tclelectrics(file copy)"           " -force? source...source target"
set "Tclelectrics(file delete)"         " name"
set "Tclelectrics(file dirname)"        " name"
set "Tclelectrics(file executable)"     " name"
set "Tclelectrics(file exists)"         " name"
set "Tclelectrics(file extension)"      " name"
set "Tclelectrics(file isdirectory)"    " name"
set "Tclelectrics(file isfile)"         " name"
set "Tclelectrics(file join)"           " name name ... name"
set "Tclelectrics(file lstat)"          " name varName"
set "Tclelectrics(file mkdir)"          " name"
set "Tclelectrics(file mtime)"          " name"
set "Tclelectrics(file normalize)"      " name"
set "Tclelectrics(file owned)"          " name"
set "Tclelectrics(file pathtype)"       " name"
set "Tclelectrics(file readable)"       " name"
set "Tclelectrics(file readlink)"       " name"
set "Tclelectrics(file rename)"         " name name"
set "Tclelectrics(file root)"           " name"
set "Tclelectrics(file rootname)"       " name"
set "Tclelectrics(file size)"           " name"
set "Tclelectrics(file split)"          " name"
set "Tclelectrics(file stat)"           " name varName"
set "Tclelectrics(file system)"         " name"
set "Tclelectrics(file tail)"           " name"
set "Tclelectrics(file type)"           " name"
set "Tclelectrics(file writable)"       " name"

set Tclhistorycmds [list \
  add change event info keep nextid redo substitute words]

lappend TclcmdsWithOptions history

set "Tclelectrics(history add)"         " command ?exec?"
set "Tclelectrics(history change)"      " newValue ?event?"
set "Tclelectrics(history event)"       " ?event?"
set "Tclelectrics(history info)"        " ?count?"
set "Tclelectrics(history keep)"        " count"
set "Tclelectrics(history nextid)"	""
set "Tclelectrics(history redo)"        " ?event?" 
set "Tclelectrics(history substitute)"  " old new ?event?"
set "Tclelectrics(history words)"       " selector ?event?"

set Tclinfocmds [list \
  args body cmdcount commands complete procname exists globals level \
  library library locals patchlevel procs script tclversion vars ]

lappend TclcmdsWithOptions info

set "Tclelectrics(info args)"		" procname"
set "Tclelectrics(info body)"		" procname"
set "Tclelectrics(info cmdcount)"       " "
set "Tclelectrics(info commands)"	" ?pattern?"
set "Tclelectrics(info complete)"	" command"
set "Tclelectrics(info procname)"	" arg varname"
set "Tclelectrics(info exists)"		" varName"
set "Tclelectrics(info globals)"	" ?pattern?"
set "Tclelectrics(info level)"		" ?number?"
set "Tclelectrics(info library}"	""
set "Tclelectrics(info locals)"		" ?pattern?"
set "Tclelectrics(info patchlevel)"	""
set "Tclelectrics(info procs)"		" ?pattern?"
set "Tclelectrics(info script)"		""
set "Tclelectrics(info tclversion)"	""
set "Tclelectrics(info vars)"		" ?pattern?"

set Tclinterpcmds [list \
  alias aliases create delete eval exists expose hidden \
  hide invokehidden issafe marktrusted share slaves target transfer ]

lappend TclcmdsWithOptions interp

# Need to add proper options to these:
set "Tclelectrics(interp alias)"        " name"
set "Tclelectrics(interp aliases)"      " name"
set "Tclelectrics(interp create)"       " name"
set "Tclelectrics(interp delete)"       " name"
set "Tclelectrics(interp eval)"         " name"
set "Tclelectrics(interp exists)"       " name"
set "Tclelectrics(interp expose)"       " name"
set "Tclelectrics(interp hidden)"       " name"
set "Tclelectrics(interp hide)"         " name"
set "Tclelectrics(interp invokehidden)" " name"
set "Tclelectrics(interp issafe)"       " name"
set "Tclelectrics(interp marktrusted)"  " name"
set "Tclelectrics(interp share)"        " name"
set "Tclelectrics(interp slaves)"       " name"
set "Tclelectrics(interp target)"       " name"
set "Tclelectrics(interp transfer)"     " name"

set Tclnamespacecmds [list \
  children code current delete eval exists export forget import inscope \
  origin parent qualifiers tail ]

lappend TclcmdsWithOptions namespace

# Need to add proper options to these:
set "Tclelectrics(namespace children)"  " name"
set "Tclelectrics(namespace code)"      " name"
set "Tclelectrics(namespace current)"   " name"
set "Tclelectrics(namespace delete)"    " name"
set "Tclelectrics(namespace eval)"      " name \{\}"
set "Tclelectrics(namespace exists)"    " name"
set "Tclelectrics(namespace export)"    " name"
set "Tclelectrics(namespace forget)"    " name"
set "Tclelectrics(namespace import)"    " name"
set "Tclelectrics(namespace inscope)"   " name"
set "Tclelectrics(namespace origin)"    " name"
set "Tclelectrics(namespace parent)"    " name"
set "Tclelectrics(namespace qualifiers)" " name"
set "Tclelectrics(namespace tail)"      " name"

set Tclpackagecmds [list \
  forget ifneeded names present provide require unknown vcompare versions \
  vsatisfies ]

lappend TclcmdsWithOptions package

# Need to add proper options to these:
set "Tclelectrics(package forget)"      " name"
set "Tclelectrics(package ifneeded)"    " name"
set "Tclelectrics(package names)"       " name"
set "Tclelectrics(package present)"     " name"
set "Tclelectrics(package provide)"     " name"
set "Tclelectrics(package require)"     " name"
set "Tclelectrics(package unknown)"     " name"
set "Tclelectrics(package vcompare)"    " name"
set "Tclelectrics(package versions)"    " name"
set "Tclelectrics(package vsatisfies)"  " name"

set Tclstringcmds [list \
  bytelength compare equal first index is last length map match range \
  repeat replace tolower totitle toupper trim trimleft trimright wordend \
  wordstart ]

lappend TclcmdsWithOptions string

set "Tclelectrics(string compare)"      " is-bigger compared-with"
set "Tclelectrics(string first)"        " search-for search-in"
set "Tclelectrics(string index)"        " string charIndex"
set "Tclelectrics(string last)"         " search-for search-in"
set "Tclelectrics(string length)"       " string"
set "Tclelectrics(string match)"        " pattern string"
set "Tclelectrics(string range)"        " string first last"
set "Tclelectrics(string tolower)"      " string"
set "Tclelectrics(string toupper)"      " string"
set "Tclelectrics(string trim)"         " string ?chars?"
set "Tclelectrics(string trimleft)"     " string ?chars?"
set "Tclelectrics(string trimright)"    " string ?chars?"
set "Tclelectrics(string wordend)"      " string index"
set "Tclelectrics(string wordstart)"    " string index"
# Need to add proper options to these:
set "Tclelectrics(string bytelength)"   " name"
set "Tclelectrics(string equal)"        " name"
set "Tclelectrics(string is)"           " name"
set "Tclelectrics(string map)"          " name"
set "Tclelectrics(string repeat)"       " name"
set "Tclelectrics(string replace)"      " name"
set "Tclelectrics(string totitle)"      " name"

if {[info tclversion] < 8.4} {
    set "Tclelectrics(trace variable)"  " name ops command"
    set "Tclelectrics(trace vdelete)"   " name ops command"
    set "Tclelectrics(trace vinfo)"     " name"
    set Tcltracecmds {variable vdelete vinfo}
} else {
    set "Tclelectrics(trace add)"       " variable|command ops command"
    set "Tclelectrics(trace remove)"    " variable|command ops command"
    set "Tclelectrics(trace list)"      " variable|command"
    set Tcltracecmds {add remove list}
}

lappend TclcmdsWithOptions trace

#  Contractions  #

# These make use of indirection.

# "array" contractions

set Tclelectrics(a'a) 	        "array anymore"
set Tclelectrics(a'd)          "array donesearch"
set Tclelectrics(a'e)          "array exists"
set Tclelectrics(a'g)          "array get"
set Tclelectrics(a'n) 	        "array names" 
set Tclelectrics(a'ne)         "array nextelement"
set Tclelectrics(a's)          "array set"
set Tclelectrics(a'sz)         "array size"
set Tclelectrics(a'ss)         "array startsearch"
set Tclelectrics(a'u)          "array unset"

# "file" contractions 

set Tclelectrics(f'a)           "file atime"
set Tclelectrics(f'c)           "file copy"
set Tclelectrics(f'dl)          "file delete"
set Tclelectrics(f'd)           "file dirname"
set Tclelectrics(f'exe)         "file executable"
set Tclelectrics(f'exi)         "file exists"
set Tclelectrics(f'ext)         "file extension"
set Tclelectrics(f'id)          "file isdirectory"
set Tclelectrics(f'if)          "file isfile"
set Tclelectrics(f'j)           "file join"
set Tclelectrics(f'l)           "file lstat"
set Tclelectrics(f'md)          "file mkdir"
set Tclelectrics(f'm)           "file mtime"
set Tclelectrics(f'o)           "file owned"
set Tclelectrics(f'p)           "file pathtype"
set Tclelectrics(f'r)           "file readable"
set Tclelectrics(f'rl)          "file readlink"
set Tclelectrics(f'ren)         "file rename"
set Tclelectrics(f'rt)          "file root"
set Tclelectrics(f'rn)          "file rootname"
set Tclelectrics(f'size)        "file size"
set Tclelectrics(f'split)       "file split"
set Tclelectrics(f'stat)        "file stat"
set Tclelectrics(f'tail)        "file tail"
set Tclelectrics(f'type)        "file type"
set Tclelectrics(f'w)           "file writable"

# "info" contractions

set Tclelectrics(i'a)           "info args"
set Tclelectrics(i'b)           "info body"
set Tclelectrics(i'cc)          "info cmdcount"
set Tclelectrics(i'cm)          "info commands"
set Tclelectrics(i'cp)          "info complete"
set Tclelectrics(i'p)           "info procname"
set Tclelectrics(i'e)           "info exists"
set Tclelectrics(i'g)           "info globals"
set Tclelectrics(i'lv)          "info level"
set Tclelectrics(i'lb)          "info library"
set Tclelectrics(i'lc)          "info locals"
set Tclelectrics(i'pl)          "info patchlevel"
set Tclelectrics(i'p)           "info procs"
set Tclelectrics(i's)           "info script"
set Tclelectrics(i't)           "info tclversion"
set Tclelectrics(i'v)           "info vars"

# "string" contractions

set Tclelectrics(s'b)            "string bytelength"
set Tclelectrics(s'c)            "string compare"
set Tclelectrics(s'e)            "string equal"
set Tclelectrics(s'f)            "string first"
set Tclelectrics(s'i)            "string index"
set Tclelectrics(s'i)            "string is"
set Tclelectrics(s'l)            "string last"
set Tclelectrics(s'len)          "string length"
set Tclelectrics(s'map)          "string map"
set Tclelectrics(s'm)            "string match"
set Tclelectrics(s'r)            "string range"
set Tclelectrics(s'rt)           "string repeat"
set Tclelectrics(s'rp)           "string replace"
set Tclelectrics(s't)            "string trim"
set Tclelectrics(s'tl)           "string trimleft"
set Tclelectrics(s'tr)           "string trimright"
set Tclelectrics(s'tol)          "string tolower"
set Tclelectrics(s'tt)           "string totitle"
set Tclelectrics(s'tou)          "string toupper"
set Tclelectrics(s'we)           "string wordend"
set Tclelectrics(s'ws)           "string wordstart"

#  Pick Options  #

# Allowing the user to select required options for some Tcl commands, an
# alternative if you can never remember the abbreviations above.  Any
# "two-word" electric defined above will be included below.
# 
# The option chosen is remembered for the next round.
# 
# Contibuted by Craig Barton Upright.
# 

foreach command $TclcmdsWithOptions {
    set Tclelectrics($command) "\[Tcl::Completion::PickOption $command\]"
}

unset command


proc Tcl::Completion::PickOption {command} {

    global Tcl${command}cmds Tcl::ElectricOptions
    
    if {![info exists Tcl${command}cmds]} {return}

    ensureset Tcl::ElectricOptions($command) ""

    set options [lsort [lunique [set Tcl${command}cmds]]]
    if {[lcontains options [set Tcl::ElectricOptions($command)]]} {
        set L [set Tcl::ElectricOptions($command)]
    } else {
        set L ""
    }
    set title "Choose an option for $command :"
    set Tcl::ElectricOptions($command)  "[listpick -p $title -L $L $options]"
    # This makes use of indirection.
    return "$command [set Tcl::ElectricOptions($command)]"
} 

