# nowrap
#====================
# M2 mode Completions
#====================
#
# Version history
# -----------------------------------
# af    02/Mar/1998   M2 mode V 3.0.5
# af    09/Mar/1998   M2 mode V 3.0.6
# af    30/Mar/1998   M2 mode V 3.1
# af    06/Apr/1998   M2 mode V 3.1.1
# af    15/Apr/1998   M2 mode V 3.1.2
# af    07/May/1998   M2 mode V 3.1.3, adding improvements, 
#                     contributions by Juan Falgueras <juanfc@lcc.uma.es>
# af    12/May/1998   M2 mode V 3.1.4, adding killif and fixl 
# af    27/Aug/1998   M2 mode V 3.1.5, adding killif and fixl 
# af    30/Oct/1998   M2 mode V 3.1.6 
# af    08/Dec/1998   M2 mode V 3.1.7 
# af    01/Mar/1999   M2 mode V 3.2.0 
# af    22/Mar/1999   M2 mode V 3.2.1 
# af    24/Mar/1999   M2 mode V 3.2.2 
# af    08/Apr/1999   M2 mode V 3.2.3 
# af    14/Apr/1999   M2 mode V 3.2.4 
# af    22/Apr/1999   M2 mode V 3.2.5 
# af    22/May/1999   M2 mode V 3.2.6
# af    24/May/1999   M2 mode V 3.3b0
# af    27/May/1999   M2 mode V 3.3b1
# af    29/Jul/1999   M2 mode V 3.3b2
# af    02/Sep/1999   M2 mode V 3.3b3
# af    11/Nov/1999   M2 mode V 3.3b4
# af    25/Sep/2000   M2 mode V 3.5, adding template ife, ifelse for IF THEN ELSE END clause
# af    13/Apr/2001   M2 mode V 3.5.2 adding templates erec, vio
# af    15/Jun/2001   M2 mode V 3.6.0 
# af    23/Sep/2001   M2 mode V 3.7.0 
# af    14/Oct/2001   M2 mode V 3.7.2 for Alpha 7.5b3
# 
# 
# REMARKS
# 
# See "Modula-2 Help" and "Modula-2 Tutorial.M2" for more on the use of 
# templates, expansions, and completions.
# 
# af  14/Feb/98

 
set completions(M2) {completion::electric completion::word}

# For version 3.0 of M2 mode the following completions were added. Some of them were
# taken from Mod2Completions.tcl by Juan Falgueras in order to accomodate some 
# user habits (such as disliking typing in capitals) which might have developed 
# by Mod2 users who are interested in using this mode. 
#  
# Note, however, the completions were not copied as is. I fixed some Modula-2 syntax 
# errors present, slightly streamlined all, and added many new ones.

# The templates will adjust to any reconfiguration done by the user, either via
# "Config > Current Mode > Preferences..." or F12
if {![info exists M2RightShift]} then { set tab "  " } else { set tab "$M2RightShift" }

# Some author specific information to be used in templates during module creation
# Please change this information to your hearts content.  Can of course also be left
# empty entirely.  If you wanna get an idea what they do, just choose the menu command
# 
set M2templateParts(copyright)  "and Swiss Federal Institute of Technology Zurich ETHZ"
# Author's address
set institution                 "Swiss Federal Institute of Technology Zurich ETHZ"
set affiliation                 "Systems Ecology / Institute of Terrestrial Ecology"
set street                      "Grabenstr. 3"
set city                        "Schlieren/Zurich"
set zipCode                     "CH-8952"
set country                     "SWITZERLAND"
if {("$country" == "USA") | ("$country" == "U.S.A.")} then {
	set M2templateParts(address)    "$institution \r$tab$tab$affiliation \r$tab$tab$street \r$tab$tab$city, $zipCode \r$tab$tab$country \r$tab$tab"
} else {
	set M2templateParts(address)    "$institution \r$tab$tab$affiliation \r$tab$tab$street \r$tab$tab$zipCode $city \r$tab$tab$country \r$tab$tab"
}
# Author's URLs
set headerURL                  "URLs:"
set mailtoURL                   "<mailto:RAMSES@ito.umnw.ethz.ch>"
set wwwURL                      "<http://www.ito.umnw.ethz.ch/SysEcol>"
set ftpURL                      "<ftp://ftp.ito.umnw.ethz.ch/pub/mac/RAMSES>"
set M2templateParts(URLs)       "$headerURL \r$tab$tab$tab$mailtoURL \r$tab$tab$tab$wwwURL \r$tab$tab$tab$ftpURL \r$tab$tab"

# Miscellaneous (customize accordint to your specific needs 
set M2electrics(killif)      	"kill0(*. should never occurr, following can be removed from final implementation .*)\rIF cond THEN\r${tab}DoKill(badProgState,GetMsgString, moduleName, procName,\r${tab}'describewhy' );\rEND(*IF*);\r"
set M2electrics(fixl)       	"kill0 (*. needs fixing, only preliminary solution .*)"


# some reserved words, statement clauses and full statements:
# ----------------------------------------------------------

# MODULE structure
set M2electrics(from)      	"kill0FROM moduleName IMPORT object(s);\r"
set M2electrics(const)    	"kill0CONST ;"
set M2electrics(type)      	"kill0TYPE ;"
set M2electrics(var)       	"kill0VAR ;"

# TYPE
set M2electrics(bool)      	"kill0BOOLEAN;"
set M2electrics(tr)      	"kill0TRUE"
set M2electrics(1)      	"kill0TRUE"
set M2electrics(fa)      	"kill0FALSE"
set M2electrics(0)      	"kill0FALSE"
set M2electrics(ch)      	"kill0CHAR;"
set M2electrics(int)      	"kill0INTEGER;"
set M2electrics(lint)      	"kill0LONGINT;"
set M2electrics(real)      	"kill0REAL;"
set M2electrics(lreal)      "kill0LONGREAL;"
set M2electrics(card)      	"kill0CARDINAL;"
set M2electrics(lcard)     	"kill0LONGCARD;"
set M2electrics(arr)      	"kill0ARRAY \[..\] OF "
set M2electrics(str)      	"kill0ARRAY \[0..\] OF CHAR;"
set M2electrics(rec)    	"kill0RECORD\r$tab\rEND(*RECORD*);\r"
set M2electrics(erec)    	"kill0END(*RECORD*);"

# Proc parameter lists
set M2electrics(darr)       "kill0ARRAY OF "
set M2electrics(vdarr)      "kill0VAR : ARRAY OF "
set M2electrics(dstr)      	"kill0ARRAY OF CHAR;"
set M2electrics(vdstr)      "kill0VAR : ARRAY OF CHAR;"
set M2electrics(vsp) 		"kill0VAR(*speed-up*) "
set M2electrics(vio) 		"kill0VAR(*In/Out*) "

# Repetitions
set M2electrics(for)       	"kill0FOR :=  TO  DO\r$tab\rEND(*FOR*);\r"
set M2electrics(forby)      "kill0FOR :=  TO  BY  DO\r$tab\rEND(*FOR*);\r"
set M2electrics(while)     	"kill0WHILE  DO\r$tab\rEND(*WHILE*);\r"
set M2electrics(repeat)    	"kill0REPEAT\r$tab\rUNTIL ;\r"
set M2electrics(loop)    	"kill0LOOP\r$tab\rEND(*LOOP*);\r"
set M2electrics(endwhile) 	"kill0END(*WHILE*);\r"
set M2electrics(endfor) 	"kill0END(*FOR*);\r"

# IF
set M2electrics(if)        	"kill0IF cond THEN\r$tabtrue-clause\rEND(*IF*);\r"
set M2electrics(ife)        "kill0IF cond THEN\r$tabtrue-clause\rELSE\r$tabtrue-clause\rEND(*IF*);\r"
set M2electrics(ifelse)     "kill0IF cond THEN\r$tabtrue-clause\rELSE\r$tabtrue-clause\rEND(*IF*);\r"
set M2electrics(with)      	"kill0WITH  DO\r$tab\rEND(*WITH*);\r"
set M2electrics(elsif)    	"kill0ELSIF  THEN\r$tab"
set M2electrics(else)      	"kill0ELSE\r$tab"
set M2electrics(endif) 		"kill0END(*IF*);\r"
set M2electrics(eif) 		"kill0END(*IF*)"

# CASE
set M2electrics(case)      	"kill0CASE  :  OF\r| :$tab;\r| :$tab;\rELSE\r$tab;\rEND(*CASE*);\r"
set M2electrics(cases)      "kill0CASE  :  OF\r| :\r$tab$tab;\r| :\r$tab$tab;\rELSE\r$tab;\rEND(*CASE*);\r"
set M2electrics(acase)      "kill0| :$tab;"
set M2electrics(acases)     "kill0| :\r$tab$tab;"

# Comments & miscellaneous
set M2electrics(bc) 		"kill0(*\r  \r*)"
set M2electrics(ec) 		"kill0 *)\r"
set M2electrics(cc) 		"kill0(* comment *)"
set M2electrics(end) 		"kill0END; "
set M2electrics(ret)    	"kill0RETURN ;"


# Procedure declarations:
# ----------------------
# simple procedure body without formal parameter list (arguments), without local vars
set procfirstpart      	    "kill0\[set eVar::temp \[getline {procedure name:} {}\];return {}\]PROCEDURE \[set eVar::temp\];\r"
set M2electrics(proc)      	"$procfirstpart\BEGIN \r$tab\rEND \[set eVar::temp\];\r"
# same as proc, but name as comment after BEGIN
set procfirstpart      	    "kill0\[set eVar::temp \[getline {procedure name:} {}\];return {}\]PROCEDURE \[set eVar::temp\];\r"
set M2electrics(procc)      "$procfirstpart\BEGIN (* \[set eVar::temp\] *)\r$tab\rEND \[set eVar::temp\];\r"
# procv is for a procedure without parameter list (arguments), but with local vars and name as comment after BEGIN
set procfirstpart      	    "kill0\[set eVar::temp \[getline {procedure name:} {}\];return {}\]PROCEDURE \[set eVar::temp\];\r"
set M2electrics(procv)      "$procfirstpart$tab\VAR argList: type\rBEGIN(* \[set eVar::temp\] *)\r$tab\rEND \[set eVar::temp\];\r"
# proca is for a procedure with parameter list (arguments), but without local vars, but with name as comment after BEGIN
set procfirstpart      	    "kill0\[set eVar::temp \[getline {procedure name:} {}\];return {}\]PROCEDURE \[set eVar::temp\] (argrumentsAndTypes);\r"
set M2electrics(proca)     	"$procfirstpart\BEGIN (* \[set eVar::temp\] *)\r$tab\rEND \[set eVar::temp\];\r"
# procav is for a procedure with parameter list (arguments) and with local vars and name as comment after BEGIN
set procfirstpart      	    "kill0\[set eVar::temp \[getline {procedure name:} {}\];return {}\]PROCEDURE \[set eVar::temp\] (argrumentsAndTypes);\r"
set M2electrics(procav)     "$procfirstpart$tab\VAR argList: type\rBEGIN (* \[set eVar::temp\] *)\r$tab\rEND \[set eVar::temp\];\r"

# I don't like the following very much and think the templates offered by M2 menu offer much more comfort. E.g. they open also a window, name it correctly etc. etc. 
set M2electrics(def)       	"kill0\[set eVar::temp \[getline {definition name:} {}\];return {}\]DEFINITION MODULE \[set eVar::temp\];\r\r$tab\rEND \[set eVar::temp\].\r"
set M2electrics(imp)       	"kill0\[set eVar::temp \[getline {implementation name:} {}\];return {}\]IMPLEMENTATION MODULE \[set eVar::temp\];\r\rBEGIN\r$tab\rEND \[set eVar::temp\].\r"
set M2electrics(mod)       	"kill0\[set eVar::temp \[getline {module name:} {}\];return {}\]MODULE \[set eVar::temp\];\r\rBEGIN\r$tab\rEND \[set eVar::temp\].\r"

message "M2 Completions loaded"
# alertnote "M2 Completions loaded"