## -*-Tcl-*-
 # ===========================================================================
 #  sh Scripts Mode - an extension package for Alpha
 # 
 #  FILE: "shCompletions.tcl"
 #                                    created: 05/14/2000 {01:48:41 pm} 
 #                                last update: 09/11/2001 {01:32:17 pm} 
 #  Description:
 #  
 #  This file will be sourced automatically, immediately after the _first_
 #  time shScriptsMode.tcl is sourced.  This file declare completions items
 #  and procedures for sh mode.
 #  
 #  Author: Craig Barton Upright
 #  E-mail: <cupright@princeton.edu>
 #    mail: Princeton University,  Department of Sociology
 #          Princeton, New Jersey  08544
 #     www: <http://www.princeton.edu/~cupright>
 #  
 #  Copyright (c) 2000-2001  Craig Barton Upright
 # 
 #  See the "shScriptsMode.tcl" file for license info, credits, etc.
 # ===========================================================================
 ##

# Setting the order of precedence for completions.

set completions(sh) {
    contraction completion::cmd Command completion::electric completion::word
}

#=============================================================================
# 
# sh::Completion::Command
# 
# (1)  The lists of commands has already been created.
# (2)  Complete the insertion as defined by the variables 
#      shcommandElectrics($lastword)
# 

proc sh::Completion::Command {} {

    global shcmds shcommandElectrics shSyntaxMessage

    set lastword [completion::lastWord where]
    if {![lcontains shcmds $lastword]} {return 0}
    set complete $shcommandElectrics($lastword)
    set sm       $shSyntaxMessage($lastword)

    set commandInsertion " $complete"
    
    elec::Insertion $commandInsertion

    # Putting a message in the status bar with syntax information
    status::msg "$sm"
}

#=============================================================================
# 
#  sh Command Electrics   #
# 
# -- further completions beyond the above proc.
# 
# These are distinguished from "shelectrics" because we want them to take
# place after the sh::Completions::Command takes place, not before.
# 
# Each completion will already have $lastword and a space, "$lastword "
# 

#    Generic completions  #

foreach genericCompletion $shcmds {
    set shcommandElectrics($genericCompletion) "\r"
}

#    Specific completions  #

set shcommandElectrics(dbms)      "source  target\r"
set shcommandElectrics(dbmscopy)  "source  target\r"
set shcommandElectrics(echo)      "text\r"
set shcommandElectrics(ln)        "source target\r"
set shcommandElectrics(mkdir)     "dir\r"
set shcommandElectrics(rm)        "source\r"
set shcommandElectrics(sas)       "file\r"
set shcommandElectrics(spss)      "-m  file > file\r"
set shcommandElectrics(stata)     "do  file > file\r"

# Conditionals

set shelectrics(if)      " expr then \r\tcmd\rfi\r"
set shelectrics(ifelse)  "kill0if expr then \r\tcmd\relse\r\tcmd\rfi\r"
set shelectrics(ifelif)  "kill0if expr then \r\tcmd\relif expr \r\tcmd\rfi\r"
set shelectrics(while)   " expr do \r\tcmd\rdone\r"

#=============================================================================
# 
#    Syntax messages  #
# 
# Make sure that [,],{,},#, and " have preceding backslashes.
# 

# generic message -- empty, which will put nothing in status bar

proc sh::setSyntaxMessage {} {
    global shcmds
    foreach genericKeyword $shcmds {set shSyntaxMessage($genericKeyword) ""}
}

# Call this now.
sh::setSyntaxMessage

# specific messages --

# As of this writing I don't intend to pursue this project.
# 
# The following examples demonstrate how one could include syntax messages,
# which would appear in the status bar during completions and via
# command-control-double-click.  The syntax can be obtained from the manual 
# pages of any unix OS, by entering 
# 
# man <command>
# 


set shSyntaxMessage(chdir) "chdir  \[ dir \]"
set shSyntaxMessage(chmod) "chmod  \[ -fR \] <absolute-mode> file ... OR chmod  \[ -fR \] <absolute-mode-list> file ..."
set shSyntaxMessage(rmdir) "/usr/bin/rmdir  \[ -ps \] dirname ..."

#=============================================================================
# 
#  Contractions  #
# 

set shelectrics(s'd)       "kill0stata do  file > file\r"
