## -*-Tcl-*- (install)
 # ###################################################################
 #  Alpha - new Tcl folder configuration
 # 
 #  FILE: "alphaDeveloperMenu.tcl"
 #                                    created: 10/9/97 {11:22:17 am} 
 #                                last update: 12/13/2001 {18:50:33 PM} 
 #  Author: Vince Darley
 #  E-mail: <vince@santafe.edu>
 #    mail: 317 Paseo de Peralta, Santa Fe, NM 87501, USA
 #     www: <http://www.santafe.edu/~vince/>
 #  
 # Copyright (c) 1997-2001  Vince Darley
 # Distributed under a Tcl style license.
 # 
 # Based on original 'developerUtilities.tcl' which is now 
 # obsolete (please delete it!).
 # 
 # ###################################################################
 ##

alpha::menu alphaDeveloperMenu 0.4.1 {global Chng Text Shel Tcl Inst} "1005" {
    lappend tclCmdColourings Tcl::colorAlphaKeywords Tcl::colorObsCommands
    # Colour to use for Alpha's built in commands.
    newPref v alphaColor {black} Tcl {Tcl::updateColors}
    # Turn this item on to colour red all obsolete Alpha procs and obsolete
    # core commands||Turn this item off to disable coloring of obsolete
    # Alpha procs and colour obsolete core commands using the Alpha color
    newPref f recognizeObsoleteProcs 1 Tcl {Tcl::updateColors}
    # Now (re)colorize Tcl mode keywords.
    Tcl::colorizeTcl
    # Build the menu.
    menu::buildProc alphaDeveloperMenu alphadev::buildMenu
    menu::buildSome alphaDeveloperMenu
    # Tom's new procs for Tracing.
    Bind Kpad5 alphadev::backToTclCall Tcl
    Bind Kpad2 alphadev::forwardToTclReturn Tcl
    hook::register openHook alphadev::openHook Tcl
} {
    alphadev::OWH "register"
} {
    alphadev::OWH "deregister"
} uninstall {
    this-file
} help {
    Utilities for developing Tcl code for use with Alpha and Alphatk

    Includes: 

     Tracing functions for debugging errant procedures.  See the help file
      "Bugs and Bug Reporting" for more information.
     Additional support items for Tcl mode, including rebuilding
      Tcl indices and electrics, and electric insertions of menu/binding code
     Help File marking / hyperizing
     www links of interest to Alpha/Alphatk developers
     Comparison of a file with one from distribution
     Stuffing/uploading/updating distributions
     Document template for packages (requires the package: documentProjects)	
} maintainer {
    "Vince Darley" <vince@santafe.edu> <http://www.santafe.edu/~vince/>
}

# Include all defined procedures in electric completions.  Including
# templates will also scan each procedure for required and optional
# arguments -- very useful if the Better Templates package is active but
# also takes more time to complete.  If additional files are sourced and
# new procedures are defined, this list can be rebuilt using the "Rebuild
# Tcl Electrics" menu item.
newPref var allProcCompletions 1 Tcl {alphadev::rebuildTclElectrics} [list \
  "Don't include Defined Procedures" \
  "Include All Defined Procedures"   \
  "Include All Procs with Templates" ] index

# Where does dropStuff put its stuffed items.
newPref var dropStuffFolder "" Inst
# Default internet location to which we upload stuffed, binhexed packages.
newPref var defaultAlphaUploadSite "" Inst "" remote::site array
# Disk location of first separate Alpha distribution (alpha-lite).
newPref folder separateAlpha1DistributionFolder "" Inst
# Disk location of second separate Alpha distribution (full version).
newPref folder separateAlpha2DistributionFolder "" Inst
# Disk location of third separate Alpha distribution (experimental distribution).
newPref folder separateAlpha3DistributionFolder "" Inst
if {[alpha::package exists documentProjects]} {
    llunion elec::DocTemplates 1 \
      { Tcl "Alpha package" Basic t_package * {extension feature mode menu}}
}

ensureset warningForObsoleteProcedures 0

namespace eval alphadev {}

proc alphadev::openHook {name} {
    global alpha::platform
    if {[string first "* Trace" $name] == "0" } {
	# Alphatk seems to have a problem with this.  It churns for
	# 10-20 seconds.
	if {${alpha::platform} == "alpha"} {
	    zoom
	    toggleScrollbar
	}
    }
}

# Register Open Windows Hook.  Placed here so that its easier to modify
# without having to rebuild indices.

proc alphadev::OWH {{which "register"}} {
    set list1 [list changeInstallerIcon compareWithDistribution \
      copyFileToDistribution]

    foreach item $list1 {
	hook::${which} requireOpenWindowsHook [list "distribution" $item] 1
    }
    set list2 [list traceThisProc insertMenuCodes insertBindingCodes \
	surroundWithBullets helpFileMarking]
    foreach item $list2 {
	hook::${which} requireOpenWindowsHook [list "1005" $item] 1
    }
}

#  Alpha Dev Menu, Support  #

proc alphadev::Menu {} {}

# A list of some useful Alpha Developer web sites.

array set alphaDevWebSites {
    alphaDevWiki        {http://alphatcl.sourceforge.net/wikit}
    bugzilla            {http://www.maths.mq.edu.au/~steffen/Alpha/bugzilla/}
    mailingListOptions  {http://sourceforge.net/mail/?group_id=16416}
    preRelease          {ftp://ftp.ucsd.edu/pub/alpha/PreRelease/}
}


proc alphadev::buildMenu {} {

    global alphaDeveloperMenu alpha::platform warningForObsoleteProcedures
    global alphaDevWebSites alphaDevHelpFiles

    if {$warningForObsoleteProcedures} {set mark !} else {set mark ""}
    set ma [list                                                \
      /Z<O<BtraceThisProc /Z<O<UtraceTclProc                   \
      /D<O<UdumpTraces /E<O<UdumpErrorInfo                      \
      ${mark}warningForObsoleteProcs (-)                         \
      insertMenuCodes insertBindingCodes                      \
      /8<I<BsurroundWithBullets (-)                              \
      rebuildTclIndices rebuildTclElectrics rebuildAMenu]
    # Add Help File Marking items.
    set helpList {
	/H<U<BmimicHelpMenu  (-) removeAllColoursAndHypers removeAllMarks (-)
	hyperiseUrls hyperiseEmailAddresses colourHeadingsEtc 
	markAlphaManual markAlphaCommands
    }
    lappend ma [list Menu -n helpFileMarking -p help::MenuProc $helpList]
    # Add help files, www sites.
    set webSites  [lsort [array names alphaDevWebSites]]
    set helpFiles $alphaDevHelpFiles
    lappend ma (-) \
      [list Menu -n alphaDevHelpFiles -p alphadev::helpFiles -m $helpFiles] \
      [list Menu -n alphaDevWwwSites  -p alphadev::MenuProc $webSites]
    # Add Distribution Items.
    set distList {
        changeInstallerIcon (-)  compareWithDistribution
        copyFileToDistribution ensureDistributionIsUpToDate
        stuffPackageForDistribution uploadStuffedPackage updateStuffAndUpload (-)
	rememberDistributionTimeTag makeDistribution makeCompleteDistribution (-)
        ensureAlphaDistn1UpToDate ensureAlphaDistn2UpToDate 
        ensureAlphaDistn3UpToDate
    }
    lappend ma [list Menu -n distribution -p alphadev::MenuProc $distList]
    # Add "Changes" items.
    lappend ma addToChangesFile addToAlphaTclChangesFile
    if {${alpha::platform} != "alpha"} {lappend ma addToAlphatkChangesFile}
    
    return [list build $ma alphadev::MenuProc "" $alphaDeveloperMenu]
}

proc alphadev::helpFiles {menuName itemName} {
    help::openFile $itemName
}

proc alphadev::MenuProc {menu item} {
    if {$item == "warningForObsoleteProcs"} {
	global warningForObsoleteProcedures alphaDeveloperMenu
	set warningForObsoleteProcedures [expr {1 - $warningForObsoleteProcedures}]
	markMenuItem -m $alphaDeveloperMenu "Warning For Obsolete Procs" $warningForObsoleteProcedures
	prefs::modified warningForObsoleteProcedures
    } elseif {$menu == "alphaDevWwwSites"} {
        global alphaDevWebSites 
	url::execute $alphaDevWebSites($item)
    } else {
	menu::generalProc alphadev $item
    }
}

proc alphadev::insertMenuCodes    {} {insertText [prompt::getAKey]}
proc alphadev::insertBindingCodes {} {beep ; keyCode}

# Vince's versions seems to have been left out, so here's mine -trf
# 
# If there is a selection, it get surrounded, if there is no selection,
# but the cursor is touching the end of a word, it gets surrounded. 
# Otherwise, we get a template (could not come up with a "stop beyond")

proc alphadev::surroundWithBullets {} {
    eval select [text::surroundingWord]
    if {[isSelection]} {
	replaceText [getPos] [selEnd] "[getSelect]"
    } else {
	insertText ""
	backwardChar
	elec::Insertion "replace-this"
    }
}

#  Tcl, Inst Mode Support  #

# Create the list of obsolete Alpha commands, used in colorizing and completions.
# 
# Note: 'bind', 'unbind' are not included since Alpha7 can't colorize with
# case sensitivity.  'mkdir' is also not included since that is a valid
# option for 'file mkdir ...'
# 

set alphaObsCommands {
    abbrev currentPosition execAbbrev fileInfo fileMenu fileRemove freeMem
    getPathName icURL insertFile insertPathName largestPrefix substituteVars

    coerce copyFile cp kt moveFile postHigh removeFile replaceAllOld rmdir
    setCompiler winFuncTitle xtclcmd
    endKeyboardMacro
    executeKeyboardMacro
    keyboardMacro
    startKeyboardMacro
}

# Create the list of obsolete Alpha procs, as defined in 'backCompatibility.tcl'.
# 
# Note: 'commentCharacters' is not included since this will affect
# strings such as Tcl::commentCharacters -- as far as I can tell, this
# obs proc is not used anywhere anyway.
# 

set alphaObsProcs {
    realMenuName killWindowStatus chooseWindowStatus sPromptChoices sPrompt
    winComp
    
    file::searchAndHyperise file::multiSearchAndHyperise file::jumpToCode
    file::hyperHelpFileOpen file::hyperOpen file::hyperHelpOpen
    file::hyperExampleOpen
    
    openFolder pushMark popMark pushPosition popPosition absolutePath
    openFileQuietly searchInFile readFile writeFile gotoFileLine buildSubMenu
    listSubfolders getIncludeFiles editIncludeFile tryElseDump
    
    text::genericIndent
    
    revertTheseFiles
    
    file::commentTextBlock
    
    commentLine uncommentLine commentBox uncommentBox commentGetRegion
    commentSameStart commentTextBlock commentGetFillLines commentParagraph
    uncommentParagraph fillParagraph fillOneParagraph paraStart paraFinish
    sentenceParagraph selectParagraph addArrDef removeArrDef addDef removeDef
    readDefs writeDefs addArr removeArr saveModifiedVars
    
    alpha::readUserDefs alpha::readUserPrefs
    
    addUserLine winIsFile
    
    mode::addUserLine
    
    getSavedSettings upBrowse downBrowse gotoMatch stripNameCount car cadr
    caddr cadddr caddddr cdr cddr mapcar map cons
    
    aebuild::result aebuild::objectProperty aebuild::coercion aebuild::list
    aebuild::hexd aebuild::bool aebuild::TEXT aebuild::alis aebuild::fss
    aebuild::name aebuild::filename aebuild::winByName aebuild::winByPos
    aebuild::lineRange aebuild::absPos aebuild::startupDisk aebuild::userName
    
    aeparse::event aeparse::keywordValue
    
    aecoerce::identity aecoerce::hexd:bool aecoerce::hexd:TEXT aecoerce::hexd
    aecoerce::null:TEXT aecoerce::hexd:alis aecoerce::TEXT:alis
    aecoerce::register aecoerce::apply aecoerce::deregister
}
 
proc alphadev::rebuildAMenu {} {
    global menu::build_procs alphadev::lastRebuiltMenus
    
    set title "Choose one or more menus to rebuild :"
    ensureset alphadev::lastRebuiltMenus ""
    set menus [lsort -ignore [array names menu::build_procs]]
    set menus [listpick -p $title -L [set alphadev::lastRebuiltMenus] -l $menus]
    foreach menuName $menus {
	menu::buildSome $menuName
	set alphadev::lastRebuiltMenus $menuName
    }
    message "$menus menu(s) have been rebuilt."
}

proc alphadev::rebuildTclElectrics {{pref ""}} {
    
    global TclmodeVars Tclcmds Tclelectrics
    
    if {$TclmodeVars(allProcCompletions) != 0 || $pref == ""} {
	# Either called when the pref changes, or from the menu.
	set Tclcmds [info commands]
	if {[info tclversion] >= 8.0} {
	    # Create the list of all top level namespaces.
	    regsub -all { ::} " [namespace children ::]" { } allNS
	    # List all of the procs in these namespaces.
	    foreach ns $allNS {
		set procs [uplevel \#0 namespace eval $ns [list info procs]]
		foreach p $procs {lappend Tclcmds ${ns}::${p}} 
	    }
	} 
    } 
    set Tclcmds [lsort $Tclcmds]
    if {$TclmodeVars(allProcCompletions) == 2} {
	message "Building Tcl electric templates "
	foreach p $Tclcmds {
	    if {![info exists Tclelectrics($p)]} {alphadev::procElectrics $p}
	}
    } 
    if {$pref != "0"} {
	message "Defined procedures are now available as Tcl electrics."
    } 
}

proc alphadev::procElectrics {p} {
    
    global Tclelectrics alphaObsProcs alphaObsCommands
    
    if {[info tclversion] >= 8.0} {set P ::${p}} else {set P $p}
    if {[lcontains alphaObsProcs $p]} {
	set electric "\[backwardWordSelect]?\[status::errorMsg \"'$p' is an obsolete proc.  Press F6 for details.\"\]"
    } elseif {[lcontains alphaObsCommands $p]} {
	set electric "\[backwardWordSelect]?\[status::errorMsg \"'$p' is an obsolete command.  Press F6 for details.\"\]"
    } elseif {[info procs $P] == ""} {
	return
    } else {
	set electric " "
	foreach arg [info args $P] {
	    if {[info default $P $arg v]} {
		append electric "$arg \"$v\" "
	    } else {
		append electric "$arg "
	    }
	}
    }
    set Tclelectrics($p) [string trimright $electric]
}

# Call this now.
alphadev::rebuildTclElectrics 0

namespace eval Tcl {}

#===============================================================================
#
# Color Alpha Keywords
#

proc Tcl::colorAlphaKeywords {} {
    global TclmodeVars

    set alphaKeyWords {
	abortEm addAlphaChars addHelpMenu addMenuItem AEBuild alertnote
	alloced alphaCreateTagFile alphaFindTag alphaHelp ascii askyesno
	backColor backSpace backwardChar backwardCharSelect
	backwardDeleteWord backwardWord backwardWordSelect balance
	beginningBufferSelect beginningLineSelect beginningOfBuffer
	beginningOfLine Bind bindingList blink breakIntoLines bringToFront
	buttonAlert capitalizeRegion capitalizeWord centerRedraw clear
	closeAll closeFloat colors colorTriple copy createTagFile createTMark
	cut cvttime decToHex deleteChar deleteMenuItem deleteModeBindings
	deleteSelection deleteWord describeBinding deleteText dialog dirs
	display displayMode dosc downcaseRegion downcaseWord dumpColors
	dumpDebug dumpMacro edit enableMenuItem endBufferSelect
	macro::endRecording endLineSelect endOfBuffer endOfLine
	enterReplaceString enterSearchString enterSelection evaluate
	eventHandler exchangePointAndMark execute macro::execute find
	findAgain findAgainBackward findFile findInNextFile findTag float
	floatShowHide forwardChar forwardCharSelect forwardWord
	forwardWordSelect get_directory getAscii getChar getModifiers
	getColors getfile getFileInfo getGeometry getline getMainDevice
	getMark getNamedMarks getPos getScrap getSelect getText getTMarks
	getWinInfo goto gotoLine gotoMark gotoNamedMark gotoTMark hexToDec
	icon icGetPref icOpen init insertAscii insertColorEscape insertMenu
	insertText insertToTop isearch iterationCount jumpToRegister keyAscii
	keyCode macro::current killLine killWindow launch lineStart linkVar
	listBindings listpick lookAt ls markHilite markMenuItem matchBrace
	matchIt maxPos Menu message minPos mousePos moveInsertionHere moveWin
	mtime nameFromAppl new newPref nextLine nextLineSelect nextLineStart
	nextSentence nextWindow now oneSpace openLine otherPane pageBack
	pageForward pageSetup paste performSearch placeText pointToRegister
	popd posToRowCol pos::compare pos::diff pos::math prefixChar
	previousLine prevLineSelect prevSentence prevWindow print
	printRegistration processes prompt pushd putfile putScrap quit
	rectMarkHilite redo regModeKeywords removeColorEscapes removeMark
	removeNamedMark removeMenu removeTMark replace replaceAll
	replace&FindAgain replaceString replaceText restoreVars revert
	rowColToPos rsearch save saveAll saveAs saveVars scrollDownLine
	scrollLeftCol scrollRightCol scrollUpLine search searchString select
	selEnd sendOpenEvent sendToBack setFileInfo setFontsTabs setMark
	setNamedMark setRGB setWinInfo shell shiftLeftRegion shiftRightRegion
	sizeWin sortMarks spacesToTabs specToPathName splitWindow startEscape
	macro::startRecording status statusPrompt switchTo tab tabsToSpaces
	tclFileCompletion thinkReference ticks toggleScrollbar traceDump
	traceFunc unascii unBind undo unfloat upcaseRegion upcaseWord version
	watchCursor wc winNames wins wrap wrapText yank zapInvisibles zoom
    }

    if {$TclmodeVars(alphaColor) != "none"} {
	regModeKeywords -a -k $TclmodeVars(alphaColor) Tcl $alphaKeyWords
    } else {
	regModeKeywords -a -k {black} Tcl $alphaKeyWords
    }
}

proc Tcl::colorObsCommands {} {
    global TclmodeVars alphaObsCommands alphaObsProcs
    
    if {$TclmodeVars(recognizeObsoleteProcs)} {
	regModeKeywords -a -k {red} Tcl [concat $alphaObsProcs $alphaObsCommands]
    } else {
	regModeKeywords -a -k $TclmodeVars(alphaColor) Tcl $alphaObsCommands
	regModeKeywords -a -k {black}                  Tcl $alphaObsProcs
    }
}

## 
 # -------------------------------------------------------------------------
 # 
 # "Tcl::OptionTitlebar" --
 # 
 #  Add corresponding extension/non-extension files.
 # -------------------------------------------------------------------------
 ##

proc Tcl::OptionTitlebar {} {
    if {[package::active smarterSource]} {
	set n [win::CurrentTail]
	if {[set a [string first + $n]] != -1} {
	    return "[string range $n 0 [expr {$a -1}]][file extension $n]"
	} else {
	    global tclExtensionsFolder
	    pushd $tclExtensionsFolder
	    set f [glob -nocomplain -path "[file root $n]+" "*[file extension $n]"]
	    popd
	    return $f
	}
    } else {
	return ""
    }
}

proc Tcl::searchFunc {dir} {
    if {[Tcl::traceWinActive]} {
	Tcl::traceSearch $dir
    } else {
	::searchFunc $dir
    }
}

proc Tcl::traceSearch {dir} {
    set pos [getPos]
    select $pos $pos
    if {$dir} {
	set searchExpr {(^( *[\w:]+ )\r( *[\w:]+ )OK: )|(^( *[^ ']+ )'.*\r^( *[^ ']+ )OK: )|(^ *[\w:]+ $)|(^ *[^ '\r]+ ')}
	set pos [pos::math $pos + 1]
	set lastStop [maxPos]
    } else {
	if {[regexp {(^.*)OK:} [getSelect] dummy searchExpr]} {
	    set searchExpr "^${searchExpr}"
	} else {
	    set searchExpr {(^ *[\w:]+ $)|(^ *[^ ']+ ')}
	}
	set pos [pos::math $pos - 1]
	set lastStop [minPos]
    }
    
    if {![catch {search -s -f $dir -i 1 -r 1 -- $searchExpr $pos} res]} {
	eval select $res
    } else {
	goto $lastStop
	if {$dir} {
	    message "At bottom, no more calls/returns in this direction"
	} else {
	    message "At top, no more calls in this direction"
	}
    }
}

proc Tcl::traceWinActive {} {regexp "^\\* Trace" [win::CurrentTail]}

namespace eval Inst {}

proc Inst::MarkFile {} {
    if {[file extension [win::Current]] == ".tcl"} {
	return [Tcl::MarkFile]
    }
    removeAllMarks
    help::removeAllColoursAndHypers
    help::colourHeadingsEtc
    help::hyperiseUrls
    help::hyperiseEmailAddresses
}

namespace eval install {}

#  Tracing, ErrorInfo  #

namespace eval alphadev {}

proc alphadev::dumpErrorInfo {} {
    global errorInfo
    new -n {* Error Info *} -m Tcl -info $errorInfo 
    shrinkWindow 1
}

#===============================================================================
# Wonderful procs from Vince Darley (vince@santafe.edu).
#===============================================================================

proc alphadev::traceThisProc {} {
    procs::traceProc [procs::findEnclosingName [getPos]]
}

proc procs::traceProc {func} {uplevel traceTclProc $func}

# We actually have 4 different versions of the traceTclProc/dumpTraces
# pair.  There are versions for:
# 
# Alpha 7.x
# Alpha/Alphatk with a patched core Tcl and the 'Trace' package
# Alphatk with plain Tcl/Tk (no fancy tracing)
# Alpha8.x with the patched TclX 'cmdtrace'.
# 
# Hopefully at some point core Tcl will support some decent
# tracing of procedures/commands (e.g. with the patch used by
# the 'Trace' package), and then the last 3 versions can be merged
# into one...

if {[info tclversion] < 8.0} {
    # These version are for Alpha 7.x
    proc traceTclProc {{func ""}} {
	global alphaDeveloperMenu
	if {[llength [traceFunc status]]>2} {
	    catch {markMenuItem $alphaDeveloperMenu {traceTclProc} off}
	    catch {enableMenuItem $alphaDeveloperMenu dumpTraces off}
	    if {[string length [set data [traceDump]]]} {
		if {[dialog::yesno "Dump traces?"]} {
		    dumpTraces [string trimright [lindex [traceFunc status] 3] {,}] $data
		}
	    }
	    traceFunc off
	    message "Tracing off."
	    return
	}
	if {$func == ""} {
	    set func [procs::pick 1]
	}
	if {![string length $func]} return
	traceFunc on $func ""
	catch {markMenuItem $alphaDeveloperMenu {traceTclProc} on}
	catch {enableMenuItem $alphaDeveloperMenu dumpTraces on}
	message "Tracing '$func'"
    }

    proc dumpTraces {{name ""} {data ""} {action "dump"}} {
	if {![string length $name]} {
	    set name [string trimright [lindex [traceFunc status] 3] {,}]
	}
	if {![string length $data]} {
	    set data [traceDump]
	}
	
	if {![string length $data]} {
	    message "Trace buffer empty"
	    return ""
	} else {
	    switch -- $action {
		"dump" {
		    new -n "* Trace '$name' *" -m Tcl -info $data
		}
		"ask" {
		    if {![dialog::yesno "Dump traces?"]} {return}
		    new -n "* Trace '$name' *" -m Tcl -info $data
		}
		"return" {
		    return $data
		}
	    }
	}
    }

} elseif {[info tclversion] >= 8.4} {
    ensureset alpha::tracingProc ""
    ensureset alpha::tracingData ""
    ensureset alpha::traceStartLevel ""
    # In Tcl 8.4a2 or newer, I hope.
    proc traceTclProc {{func ""}} {
	global alphaDeveloperMenu alpha::tracingProc alpha::traceStartLevel
	if {$alpha::tracingProc != ""} {
	    catch {markMenuItem $alphaDeveloperMenu {traceTclProc} off}
	    catch {enableMenuItem $alphaDeveloperMenu dumpTraces off}
	    dumpTraces $alpha::tracingProc "" ask
	    eval [list trace remove command $alpha::tracingProc] [lindex [trace list command $alpha::tracingProc] 0]
	    message "Tracing off."
	    set alpha::tracingProc ""
	    if {$func == ""} {return}
	}
	if {$func == ""} {
	    set func [procs::pick 1]
	}
	if {![string length $func]} return
	trace add command $func {before after preinside postinside} [list traceCapture $func]
	set alpha::traceStartLevel ""
	set alpha::tracingProc $func
	catch {markMenuItem $alphaDeveloperMenu {traceTclProc} on}
	catch {enableMenuItem $alphaDeveloperMenu dumpTraces on}
	message "Tracing '$func'"
    }
    proc traceCapture {name args} {
	global alpha::traceStartLevel
	if {![string length $alpha::traceStartLevel]} {
	    set alpha::traceStartLevel [info level]
	}
	set level [expr {[info level] - $alpha::traceStartLevel}]
	set cmd [lindex $args 0]
	if {[string first "\n" $cmd] == -1} {
	    set indent [string repeat "    " $level]
	    set cmd "${indent}${cmd}"
	} else {
	    set indent [string repeat "    " $level]
	    #set indent ""
	    regsub -all {^|\n} $cmd "\\0$indent" cmd
	}
	set when [lindex $args end]
	switch -- $when {
	    after -
	    postinside {
		append cmd "\n${indent}"
		set code [lindex $args 1]
		set res [lindex $args 2]
		if {$code == 0} {
		    append cmd "OK"
		} elseif {$code == 1} {
		    append cmd "ERROR"
		} elseif {$code == 2} {
		    append cmd "RETURN"
		} else {
		    append cmd "CODE($code)"
		}
		append cmd ": $res"
	    }
	}
	append cmd "\n"
	if {[lsearch -exact [winNames -f] "* Trace '$name' *"] != -1} {
	    bringToFront "* Trace '$name' *"
	    goto [maxPos]
	    insertText $cmd
	    if {0 && [pos::diff [minPos] [maxPos]] > 200000} {
		global alpha::tracingProc
		eval [list trace remove command $alpha::tracingProc] [lindex [trace list command $alpha::tracingProc] 0]
		puts stderr "too long"
	    }
	    update
	} else {
	    global alpha::tracingData
	    append alpha::tracingData $cmd
	    if {0 && [string length $alpha::tracingData] > 200000} {
		global alpha::tracingProc
		eval [list trace remove command $alpha::tracingProc] [lindex [trace list command $alpha::tracingProc] 0]
		puts stderr "too long"
	    }
	}
    }
    proc dumpTraces {{name ""} {data ""} {action "dump"}} {
	global alpha::tracingProc alpha::tracingData alpha::traceStartLevel
	set alpha::traceStartLevel ""
	if {![string length $name]} {
	    set name $alpha::tracingProc
	}
	if {![string length $data]} {
	    set data $alpha::tracingData
	}
	set alpha::tracingData ""
	if {![string length $data]} {
	    message "Trace buffer empty"
	    return ""
	} else {
	    switch -- $action {
		"dump" {
		    new -n "* Trace '$name' *" -m Tcl -info $data
		}
		"ask" {
		    if {![dialog::yesno "Dump traces?"]} {return}
		    new -n "* Trace '$name' *" -m Tcl -info $data
		}
		"return" {
		    return $data
		}
	    }
	}
    }
} else {
    if {![catch {package require Trace}]} {
	proc traceTclProc {{func ""}} {
	    global alphaDeveloperMenu 
	    set cmd [lindex [tracecommand list] 0]
	    if {$cmd != ""} {
		catch {markMenuItem $alphaDeveloperMenu {traceTclProc} off}
		catch {enableMenuItem $alphaDeveloperMenu dumpTraces off}
		dumpTraces $cmd [tracecommand dump $cmd] ask
		tracecommand off $cmd
		message "Tracing off."
		if {$func == ""} {return}
	    }
	    if {$func == ""} {
		set func [procs::pick 1]
	    }
	    if {![string length $func]} return
	    tracecommand on $func
	    catch {markMenuItem $alphaDeveloperMenu {traceTclProc} on}
	    catch {enableMenuItem $alphaDeveloperMenu dumpTraces on}
	    message "Tracing '$func'"
	}
	proc dumpTraces {{name ""} {data ""} {action "dump"}} {
	    if {![string length $name]} {
		set name [lindex [tracecommand list] 0]
	    }
	    if {![string length $data]} {
		set data [tracecommand dump $name]
	    }
	    
	    if {![string length $data]} {
		message "Trace buffer empty"
		return ""
	    } else {
		switch -- $action {
		    "dump" {
			new -n "* Trace '$name' *" -m Tcl -info $data
		    }
		    "ask" {
			if {![dialog::yesno "Dump traces?"]} {return}
			new -n "* Trace '$name' *" -m Tcl -info $data
		    }
		    "return" {
			return $data
		    }
		}
	    }
	}
    } elseif {$alpha::platform != "alpha"} {
	# We're running Alphatk on a standard Tcl/Tk interpreter.  If that
	# interpreter was compiled with various 'trace' flags set, we can
	# get some detailed information from this...  Otherwise we will get
	# little more than the name of the procedure called, and its 
	# arguments.
	proc traceTclProc {{func ""}} {
	    global alphaDeveloperMenu alpha::tracingProc alpha::tracingChannel PREFS
	    if {[info exists alpha::tracingProc]} {
		catch {markMenuItem $alphaDeveloperMenu {traceTclProc} off}
		catch {enableMenuItem $alphaDeveloperMenu dumpTraces off}
		rename ${alpha::tracingProc} ""
		rename trace_${alpha::tracingProc} ${alpha::tracingProc}
		unset alpha::tracingProc
		message "Tracing off."
		if {$func == ""} {return}
	    }
	    if {$func == ""} {
		set func [procs::pick 1]
	    }
	    if {![string length $func]} return
	    rename $func trace_$func
	    lappend body \
	      {global tcl_traceExec} \
	      {set tcl_traceExec 3} \
	      "puts stdout \"$func \$args\"" \
	      "set code \[catch \{uplevel 1 trace_$func \$args\} res\]" \
	      {set tcl_traceExec 0} \
	      "return -code \$code \$res"
	    ;proc $func args [join $body \n]
	    set alpha::tracingProc $func
	    catch {markMenuItem $alphaDeveloperMenu {traceTclProc} on}
	    catch {enableMenuItem $alphaDeveloperMenu dumpTraces on}
	    message "Tracing '$func'"
	}
	proc dumpTraces {{name ""} {data ""} {what "dump"}} {
	    message "Traces always dumped to stdout"
	    return ""
	}
    } else {
	
	## 
	 # -------------------------------------------------------------------------
	 # 
	 # "traceTclProc" --
	 # 
	 #  Trace and dump still need a little work under Alpha 8.0.  Notice that
	 #  traces are stored in a file, not in memory as in previous versions
	 #  of Alpha.
	 # -------------------------------------------------------------------------
	 ##
	proc traceTclProc {{func ""}} {
	    global tclMenu alpha::tracingProc alpha::tracingChannel PREFS
	    if {[cmdtrace depth] > 0} {
		catch {markMenuItem $tclMenu {traceTclProc} off}
		catch {enableMenuItem $tclMenu dumpTraces off}
		catch {
		    cmdtrace off
		    close $alpha::tracingChannel
		    set alpha::tracingChannel ""
		}
		if {[file exists [file join $PREFS tmp traceDump]]} {
		    dumpTraces "" "" ask
		    file delete [file join $PREFS tmp traceDump]
		}
		message "Tracing off."
		if {$func == ""} {return}
	    }
	    if {$func == ""} {
		set func [procs::pick 1]
	    }
	    if {![string length $func]} return
	    if {![file exists [file join $PREFS tmp]]} {
		file mkdir [file join $PREFS tmp]
	    }
	    set alpha::tracingChannel [alphaOpen [file join $PREFS tmp traceDump] w]
	    cmdtrace on $alpha::tracingChannel inside $func
	    set alpha::tracingProc $func
	    catch {markMenuItem $tclMenu {traceTclProc} on}
	    catch {enableMenuItem $tclMenu dumpTraces on}
	    message "Tracing '$func'"
	}


	proc dumpTraces {{name ""} {data ""} {action "dump"}} {
	    global alpha::tracingProc alpha::tracingChannel PREFS
	    if {![string length $name]} {
		set name $alpha::tracingProc
	    }
	    if {![string length $data]} {
		set data [file::readAll [file join $PREFS tmp traceDump]]
		if {[string length ${alpha::tracingChannel}]} {
		    close $alpha::tracingChannel
		    file delete [file join $PREFS tmp traceDump]
		    set alpha::tracingChannel [alphaOpen [file join $PREFS tmp traceDump] w]
		    cmdtrace configure $alpha::tracingChannel
		}
	    }
	    
	    if {![string length $data]} {
		message "Trace buffer empty"
		return ""
	    } else {
		switch -- $action {
		    "dump" {
			new -n "* Trace '$name' *" -m Tcl -info $data
		    }
		    "ask" {
			if {![dialog::yesno "Dump traces?"]} {return}
			new -n "* Trace '$name' *" -m Tcl -info $data
		    }
		    "return" {
			return $data
		    }
		}
	    }
	}

    }
}

# This is to expand navigation in Trace windows.
# idea is to provide a jump to the return of the selected
# proc/command call (useful when you want to jump over 
# sub step calls).
proc alphadev::forwardToTclReturn {} {
    if {![regexp "^\\* Trace" [win::CurrentTail]]} {return}
    set beg [getPos]
    set call [getSelect]
    set call [string trimright $call "'"]
    if {$call == ""} {return}
    if [regexp -- OK: $call] {
	message "Already at a Return"
	return
    } elseif {[string length [set whe [search -s -n -f 1 -r 1 -i 0 -m 0 "^${call}(OK: |ERROR: )" $beg]]]} {
	eval select $whe
    } 
}

proc alphadev::backToTclCall {} {
    if {![regexp "^\\* Trace" [win::CurrentTail]]} {exchangePointAndMark}
    set beg [pos::math [lineStart [getPos]] - 1]
    set rtn [getSelect]
    if {$rtn == ""} {return}
    if [regexp -- (.*)(OK:|ERROR:) $rtn all rtn] {
	string length [set whe [search -s -n -f 0 -r 1 -i 0 -m 0 "^$rtn'?" $beg]]
	eval select $whe
    } else {
	message "Already at a Call"
	return
    } else {
	exchangePointAndMark
    }
}


#  Distribution Items  #

proc alphadev::changeInstallerIcon {} {
    set f [win::Current]
    setFileInfo $f type InSt
    message "Icon changed."
}

proc alphadev::copyFileToDistribution {} {
    global HOME
    
    set f [win::Current]
    switch -- [file dirname $f] [list \
      $HOME  {
	set toDir "Home"
      } \
      [file join $HOME AlphaCore]  {
	set toDir "AlphaCore"
      } \
      [file join $HOME Help]  {
	set toDir "Help"
      } \
      [file join $HOME QuickStart]  {
	set toDir "QuickStart"
      } \
      [file join $HOME Tests]  {
	set toDir "Tests"
      } \
      [file join $HOME Tools]  {
	set toDir "Tools"
      } \
      [file join $HOME Tcl Completions]  {
	set toDir "Completions"
      } \
      [file join $HOME Tcl Menus]  {
	set toDir "Menus"
      } \
      [file join $HOME Tcl Modes]  {
	set toDir "Modes"
      } \
      [file join $HOME Tcl Packages]  {
	set toDir "Packages"
      } \
      [file join $HOME Tcl SystemCode]  {
	set toDir "SystemCode"
      } \
      [file join $HOME Tcl UserModifications]  {
	set toDir "UserModifications"
      } \
      [file join $HOME Tcl SystemCode CorePackages]  {
	set toDir "CorePackages"
      } \
      default {
	  alertnote "$f does not appear to be part of the current Tcl distribution"
	  return
      } \
    ]

    set distdir [get_directory -p "Select distribution directory"]
    
    set toFile [file join $distdir $toDir [file tail $f]]
    
    if {[file exists $toFile]} {
	file::replaceSecondIfOlder $f $toFile
    } else {
	catch {file mkdir [file join $distdir $toDir]}
	file copy $f $toFile
	message "Added [file tail $f] to $toDir"
    }
}

proc alphadev::compareWithDistribution {} {
    global auto_path
    set w [win::Current]
    if {[string length $w]} {
	set wn [file tail $w]
	foreach dir $auto_path {
	    set f [file join ${dir} ${wn}]
	    if {[file exists $f]} {
		if {$f == $w} { alertnote "It's part of the distribution!" ; return }
		file::openQuietly $f
		compare::windows
		return
	    }
	}
	alertnote "No distribution file with this name was found."
    } else {
	error "No window is open!"
    }
}

## 
 # -------------------------------------------------------------------------
 # 
 # "alphadev::ensureDistributionIsUpToDate" --
 # 
 #  Helpful for package developers.  You can keep your current versions in
 #  the Alpha source tree, but use this procedure periodically to backup
 #  the code, and prepare for distribution.  All files in the distribution
 #  hierarchy (up to one level deep) are replaced if a more recent version
 #  can be found anywhere in the Alpha source tree.  You are told which
 #  were replaced, and which couldn't be found.
 #  
 #  The only exception is that if there is a file whose name matches
 #  *install*.tcl in the top level of your distribution, it is ignored.
 #  It is assumed that such a file contains installation scripts for
 #  your package, and that it will not be installed itself.
 #  
 #  Doesn't cope with recursive directories.
 # -------------------------------------------------------------------------
 ##

proc alphadev::ensureDistributionIsUpToDate {} {
    global HOME 
    set win::Current [win::Current]
    if {[file extension ${win::Current}] == ".tcl"} {
	# single file to install
	set distribfiles [list ${win::Current}]
    } else {
	set currD [file dirname ${win::Current}]
	set distribfiles [glob -types TEXT -nocomplain -dir $currD *]
	set distribfiles [lremove -glob $distribfiles "*\[iI\]nstall*.tcl"]
	set distribfiles [lremove $distribfiles [win::Current]]
	eval lappend distribfiles [glob -nocomplain -join -dir $currD * *]
    }	
    set failed ""
    set replaced ""
    foreach ff $distribfiles {
	if {[file isdirectory $ff]} {
	    lappend failed $ff
	    continue
	}
	set looking 1
	set f [file tail $ff]
	if {[catch {file::standardFind $f} to]} {
	    lappend failed $f
	} else {
	    if {[file::replaceSecondIfOlder $to $ff]} {
		lappend replaced $f
	    }
	}
    }
    if {$failed == ""} {set failed "none"}
    if {$replaced == ""} {set replaced "none"}
    if {[catch {alertnote "Replaced $replaced, failed to find $failed."}]} {
	alertnote "Replaced [llength $replaced], failed to find $failed."
    }
}

proc alphadev::rememberDistributionTimeTag {} {
    cache::create distributionTimeTag
    set alphadev(timetag) [now]
    prefs::modified alphadev(timetag)
}

proc alphadev::getChangesSince {time} {
    global HOME
    set fin [alphaOpen [file join $HOME Help "Changes - AlphaTcl"] r]
    gets $fin ; gets $fin ; gets $fin

    while {![eof $fin]} {
	gets $fin line
	if {[string index $line 0] == "="} {break}
    }

    set changes ""
    
    if {[catch {
	while {![eof $fin]} {
	    gets $fin line
	    if {[string index $line 0] == "="} {
		if {[string index $line 1] == "="} {
		    continue
		}
		if {[regexp {^=.([^ ]*)(.*)last update:(.*)} $line "" v "" line]} {
		    # We have to get rid of the {} before calling clock scan.
		    set line [eval [list concat] [string trim $line]]
		    regsub "(am|pm|AM|PM)" $line "" line
		    set lt [clock scan $line]
		    if {$lt < $time} {
			#puts "$line older than $time"
			break
		    }
		    append changes "\r" $v "\n"
		} else {
		    break
		}
	    } else {
		append changes $line "\n"
	    }
	}
    } err]} {
	alertnote "There was an error while listing changes: $err"
    }

    close $fin
    return $changes
}

ensureset "alphadev(dir)" ""
ensureset "alphadev(requires)" "7.5d21"
ensureset "alphadev(provides)" "7.5d22"
ensureset "alphadev(extraprocs)" ""

# Would be nice to add ability to remove files or directories as well
# (could use a 'search path' dialog item which allows files).
proc alphadev::makeDistribution {} {
    if {![cache::exists distributionTimeTag]} {
	error "You must create a distribution time tag"
    }
    set timetag [cache::name distributionTimeTag]
    set time [file mtime $timetag]

    global alphadev
    set res [dialog::make -ok "Build" -title "Build distribution" \
      -addbuttons [list "Ok" "Remember changes but don't build\
      a distribution" {set retCode 0 ; uplevel 1 {set dontBuild 1}}] \
      [list "Distribution parameters" \
      [list folder "Distribution directory" $alphadev(dir)] \
      [list date "All files newer than" $time] \
      [list var "New procedures in installer" $alphadev(extraprocs)] \
      [list var "Package requirements" $alphadev(requires)] \
      [list var "Version of distribution" $alphadev(provides)]]]

    newforeach {
	alphadev(dir) newtime alphadev(extraprocs) alphadev(requires) 
	alphadev(provides)
    } $res {}
    
    if {$newtime != $time} {
	file mtime $timetag $newtime
	set time $newtime
    }
    
    prefs::modified alphadev

    if {[info exists dontBuild]} { return }
    
    global HOME
    set dir $alphadev(dir)
    
    alpha::registerEncodingFor $dir macRoman

    alphadev::makeRecursiveDistribution $HOME $alphadev(dir) "" $timetag
    set installer [file join $dir "READ.TO.INSTALL"]
    set iout [alphaOpen $installer w]

    alpha::deregisterEncodingFor $dir
    
    puts $iout "# (auto-install-script)(nowrap)"

    foreach pat $alphadev(extraprocs) {
	foreach proc [info procs ::$pat] {
	    puts $iout [procs::generate $proc]
	}
    }
    
    set str {install::packageInstallationDialog "AlphaTcl VVV updater" \
      "This brings AlphaTcl library XXX or newer to version VVV.\
      You cannot and\
      should not install this over any other version of AlphaTcl. \
      This is a 'development' pre-release, it may contain some bugs.\
      Please make sure line-endings undergo cross-platform conversion\
      when Unstuffing.\
      IMPORTANT: Alpha will automatically quit after this installation." \
      -require {AlphaTcl XXX} -provide {AlphaTcl VVV} -forcequit 2 -changes ZZZ}
  
    regsub -all "XXX" $str $alphadev(requires) str
    regsub -all "VVV" $str $alphadev(provides) str
    regsub "ZZZ" $str [list [quote::Regsub [alphadev::getChangesSince $time]]] str
    puts $iout $str
    close $iout

    # This file will be generated later anyway.
    catch {file delete [file join $dir Help Packages]}
    
    if {![dialog::yesno -y "OK" -n "Test distribution" \
      "Distribution is ready"]} {
	edit $installer
    }
}

ensureset alphatkdev(dir) ""
ensureset alphatkdev(encoding) macRoman
ensureset alphatkdev(ignore) "^(CVS|CVSROOT)\$"

proc alphadev::makeCompleteDistribution {} {
    global alphatkdev
    set res [dialog::make -ok "Build" -title "Build distribution" \
      -addbuttons [list "Ok" "Remember changes but don't build\
      a distribution" {set retCode 0 ; uplevel 1 {set dontBuild 1}}] \
      [list "Distribution parameters" \
      [list folder "Distribution directory" $alphatkdev(dir)]\
      [list [list menu [lsort -ignore [encoding names]]] "Encoding" $alphatkdev(encoding)]\
      [list variable "File tail regexp pattern to ignore" $alphatkdev(ignore)]]]

    newforeach {
	alphatkdev(dir) alphatkdev(encoding) alphatkdev(ignore)
    } $res {}
    
    prefs::modified alphatkdev

    if {[info exists dontBuild]} { return }
    
    global HOME alpha::platform
    set from $HOME
    if {${alpha::platform} != "alpha"} {
	set from [file dirname $from]
    }
    set dir $alphatkdev(dir)
    
    if {$alphatkdev(encoding) != ""} {
	alpha::registerEncodingFor $dir  $alphatkdev(encoding) 
    }
    set gotErr [catch {alphadev::makeRecursiveDistribution $from $dir $alphatkdev(ignore)} err]
    if {$alphatkdev(encoding) != ""} {
	alpha::deregisterEncodingFor $dir
    }
    if {$gotErr} {
	message "Error: $err"
    } else {
	message "Done"
    }
}

proc alphadev::makeRecursiveDistribution {source dest {ignore ""} {timetag ""}} {
    if {![file exists $dest]} {
	file mkdir $dest
    } else {
	if {![file isdirectory $dest]} {
	    return -code error "Destination is a file, not a directory!"
	}
    }
    if {[file::pathStartsWith $dest $source]} {
	return -code error "Can't recursively copy a directory inside itself!"
    }
    message "Making distribution...$source"
    foreach f [glob -nocomplain -dir $source *] {
	set tail [file tail $f]
	set to [file join $dest $tail]
	# ignore certain files or directories.
	if {[string length $ignore]} {
	    if {[regexp -- $ignore $tail]} {continue}
	}
	if {[file isdirectory $f]} {
	    file::ensureDirExists $to
	    alphadev::makeRecursiveDistribution $f $to $ignore $timetag
	} else {
	    if {[string length $timetag]} {
		if {[regexp {tclIndexx?$} $tail]} {
		    continue
		}
		if {[file::compareModifiedDates $f $timetag] != 1} {
		    continue
		}
	    }
	    
	    # The source file is newer than the timetag
	    if {[file isdirectory $to]} {
		file delete -force $to
	    }
	    if {[file exists $to]} {
		switch -- [file::compareModifiedDates $f $to] {
		    0 {
			# file is already in the distribution
			continue
		    }
		    1 {
			# distribution file is older, therefore replace
			file delete $to
		    }
		    -1 -
		    default {
			# distribution file is newer!
			alertnote "The file '$to' in the distibution is newer."
			continue
		    }
		}
		# fall through from '1' case above
	    }
	    # Perform a copy
	    file::coreCopy $f $to
	}
    }
}

proc alphadev::ensureAlphaDistn1UpToDate {} {
    global InstmodeVars 
    alphadev::ensureAlphaDistnUpToDate $InstmodeVars(separateAlpha1DistributionFolder)
}

proc alphadev::ensureAlphaDistn2UpToDate {} {
    global InstmodeVars 
    alphadev::ensureAlphaDistnUpToDate $InstmodeVars(separateAlpha2DistributionFolder)
}

proc alphadev::ensureAlphaDistn3UpToDate {} {
    global InstmodeVars 
    alphadev::ensureAlphaDistnUpToDate $InstmodeVars(separateAlpha3DistributionFolder)
}

proc alphadev::ensureAlphaDistnUpToDate {alpha} {
    global alphadev::log
    set alphadev::log ""
    set d [pwd]
    alphadev::_ensureAlphaDistnUpToDate ${alpha} :
    alphadev::showLog
    alphadev::_recursivelyRebuildIndices ${alpha}:Tcl:
    cd $d
    alertnote "Done"
}

proc alphadev::_recursivelyRebuildIndices {dir} {
    global tcl_platform
    if {[file exists $dir]} {
	set old [pwd]
	cd $dir
	if {![catch {glob *.tcl}]} {
	    if {$tcl_platform(platform) == "macintosh"} {
		catch { auto_mkindex : }
	    } else {
		catch { auto_mkindex . }
	    }
	}
	foreach dir [glob -nocomplain -type d *] {
	    alphadev::_recursivelyRebuildIndices $dir
	}
	cd $old
    }
}

proc alphadev::_ensureAlphaDistnUpToDate {alpha dir} {
    global HOME
    message "Examining $dir"
    cd $alpha$dir
    set dirs ""
    set files ""
    set all [glob -nocomplain *]
    set havedir 0
    foreach a $all {
	if {[file isdirectory $a]} { 
	    lappend dirs $a
	    set havedir 1
	} else {
	    lappend files $a
	}
    }
    if {!$havedir} {
	# bottom level directory.  Check file-count
	set cdist [llength $all]
	set corig [llength [glob -nocomplain -path ${HOME}${dir} *]]
	if {$cdist != $corig} {
	    alphadev::log "WARNING: FILE-COUNT CHANGED IN $dir"
	}
    }
	
    foreach f $files {
	if {[file exists ${HOME}${dir}$f]} {
	    if {![regexp {^tclIndexx?$} $f]} {
		file::replaceSecondIfOlder ${HOME}${dir}$f \
		  $alpha$dir$f
	    }
	} else {
	    alphadev::log "Warning: file $f was not found."
	}
    }
    foreach d $dirs {
	if {[file exists ${HOME}${dir}$d]} {
	    alphadev::_ensureAlphaDistnUpToDate $alpha ${dir}${d}:
	} else {
	    alphadev::log "WARNING: Original directory '$d' doesn't exist"
	}
    }
}

proc alphadev::stuffPackageForDistribution {{fore 0}} {
    set stuff [alphadev::_getStuffedFile [alphadev::_getDistributionBaseName]]
    # Try and remove the old stuffed version
    if {$stuff != ""} {
	catch {file delete $stuff}
    }
    alphadev::_stuffDistribution [alphadev::_getDistributionBase] $fore
}

proc alphadev::_getDistributionBaseName {} {
    return [file tail [alphadev::_getDistributionBase]]
}
proc alphadev::_getDistributionBase {} {
    # Is it a file or directory?
    set f [win::Current]
    if {[file extension $f] != ".tcl"} {
	return [file dirname $f]
    } else {
	return $f
    }
}

proc alphadev::_stuffDistribution {ff {fore 0}} {
    global file::separator
    if {[file isdirectory $ff] && ![regexp -- "${file::separator}\$" $ff]} {
	append ff ${file::separator}
    }
    # Now stuff new distribution
    app::launchBack DStf
    if {$fore} {
	sendOpenEvent reply 'DStf' $ff
    } else {
	sendOpenEvent noReply 'DStf' $ff
    }
	
    sendQuitEvent 'DStf'
}

proc alphadev::_getStuffedFile {pref} {
    global InstmodeVars
    set files [glob -nocomplain -path [file join $InstmodeVars(dropStuffFolder) ${pref}] *.hqx]
    if {[llength $files] == 1} {
	return [lindex $files 0]
    }
    return ""
}

proc alphadev::uploadStuffedPackage {{ask 1}} {
    set stuff [alphadev::_getStuffedFile [alphadev::_getDistributionBaseName]]
    if {$stuff == ""} {
	alertnote "Sorry, I couldn't find the stuffed distribution."
	error ""
    }
    global InstmodeVars remote::site
    if {$ask} {
	set sitename [dialog::optionMenu "Upload to which site?" \
	  [lsort -ignore [array names remote::site]] \
	  $InstmodeVars(defaultAlphaUploadSite)]
    } else {
	set sitename $InstmodeVars(defaultAlphaUploadSite)
    }
    url::store [set remote::site($sitename)] $stuff
}

proc alphadev::updateStuffAndUpload {} {
    alphadev::ensureDistributionIsUpToDate
    alphadev::stuffPackageForDistribution 1
    alphadev::uploadStuffedPackage 0
    alertnote "Distribution upload complete."
}

proc alphadev::addToAlphatkChangesFile {} {
    alphadev::addToChangesFile "Changes - Alphatk"
}
proc alphadev::addToAlphaTclChangesFile {} {
    alphadev::addToChangesFile "Changes - AlphaTcl"
}

proc alphadev::addToChangesFile {{which "Changes - Alpha"}} {
    global HOME
    file::openQuietly [file join ${HOME} Help $which]
    setWinInfo read-only 0
    set p [lindex [search -f 1 -r 1 -n -m 0 -s "^ \[\n\r\]" [minPos]] 0]
    if {![llength $p]} {
	set p [lindex [search -f 1 -r 1 -n -m 0 -s "^ " [minPos]] 0]
	while {1} {
	    set p [nextLineStart $p]
	    if {([lookAt $p] == "=") || ([string trim [getText $p [nextLineStart $p]]] == "")} {
		break
	    }
	}
    }
    goto $p
    insertText " \r"
    backwardChar
}

proc t_package {name parentdoc subtype } {
    # Possible 'subtypes' are: extension mode menu
    
    # remove trailing mode/menu etc if possible
    regsub -nocase -- $subtype $name "" name
    set t "\r\# $subtype declaration\r"
    append t "alpha::$subtype $name version "
    switch -- $subtype {
	"mode" {
	    append t "${name}Dummy \{extensions\} \{mode-menus\} "
	}
	"menu" {
	    append t "global or modes title/icon "
	}
    }
    append t "\{\r\tstartup script\r\}"
    if {$subtype == "feature" || $subtype == "menu"} {
	append t " \{\r\tactivate script\r\}"
	append t " \{\r\tdeactivate script\r\}"
    }
    append t " maintainer \{\r"
    global user
    append t "\t\{$user(author)\} $user(email) $user(www)\r\}"
    append t " help \{\r\tfile 'name' or description\r\}"
    append t " uninstall script\r"
    switch $subtype {
	"mode" {
	    append t "\# to auto-load\r"
	    append t "proc ${name}Dummy {} {}\r\r"
	    append t "\#  mode preferences  #\r"
	    append t "newPref type name default $name proc , options, sub-opts\r"
	    append t "\r\r"
	}
    }
    return $t
}
