#=== nowrap =====================================================================
#
# 			Alpha/CodeWarrior Interaction
#
#================================================================================
# Modified and enhanced by Bernard Desgraupes <berdesg@easynet.fr> in vs. 1.3
# Last modification : 2001-11-03 17:31:40
# See version history, license terms etc. in the "CodeWarrior Menu Help" file
#================================================================================

alpha::menu codewarriorMenu 1.3.3 "C C++ Java Pasc" "268" {
} {codewarriorMenu} {} uninstall {this-file} maintainer {
    "No-one"
} help {file "CodeWarrior Menu Help"} preinit {fileset::registerNewType codewarrior "list"}

alpha::package require searchPaths 1.0
set cwdebugMenu	"274"

hook::register savePostHook cw::modified "Java" "Pasc" "C++" "C"

# --------------------------
# Global prefs
# --------------------------
# # Building options
newPref flag buildBeforeRunning 1 cw cw::setBuildFlags
newPref flag playSoundAfterUpdt&Make 0 cw cw::setBuildFlags
newPref flag useExternalEditor 0 cw cw::setBuildFlags
newPref flag saveOpenFilesBeforeBuild 1 cw cw::setBuildFlags

# # Target-specific prefs
# Compiling options
newPref flag activateBrowser 1 cw
newPref flag activateC++Compiler 0 cw
newPref flag enableC++Exceptions 0 cw
newPref flag enableObjectiveC 0 cw
newPref flag enableRunTimeTypeInfo 0 cw
# Linking options
newPref flag generateLinkMap 0 cw 
newPref flag generateSymFile 1 cw 
# CWmenu-specific prefs
newPref flag invertDebugger 0 cw
newPref flag switchWhenCompiling 1 cw

newPref flag "*SyncFlagsWithProject*" 0 cw cw::flagsFromProject
newPref flag - 0 cw

set cwmodeVars(*SyncFlagsWithProject*) 0
# prefs::modified cwmodeVars(*SyncFlagsWithProject*)

newPref var searchpath "" cw
newPref sig CWCompilerSig CWIE
newPref sig CWDebuggerSig MWDB



namespace eval cw {}

proc codewarriorMenu {} {}


# -----------------------------------------------------------------
# # Initialisations
# -----------------------------------------------------------------
# Global parameters
set cw_params(CWCLASS) MMPR
set cw_params(CDCLASS) MWDB
set cw_params(0) "no"
set cw_params(1) "yes"
set cw_params(CODEWarrior) ""
set cw_params(cwstate) ""
set cw_params(currproject) ""
set cw_params(currtarget) ""
set cw_params(currentclass) ""
set cw_params(errorstitle) "*Compiler Errors*"
set cw_params(pathparm) Path
set cw_params(panels) [list "Access Paths" "Build Extras" "C/C++ Compiler" "Custom Keywords" "File Mappings" \
  "MacOS Merge Panel" "Output Flags" "PPC Disassembler" "PPC Linker" "PPC PEF" "PPC Project" \
  "PPCAsm Panel" "Rez Compiler"  "Runtime Settings" "Target Source Trees" "Target Settings" ]
set cw_params(global) [list "Build Settings" "Debugger Display" "Debugger Global" "Extras" "Font" \
  "Layout Editor" "MetroNub Panel" "Plugin Settings" "Shielded Folders" "Syntax Coloring" \
  "Global Source Trees" "VCS Setup" ]


# Load the info arrays
catch {uplevel #0 {source [file join $HOME Tcl Completions codeWarriorCompletions.tcl]}}


# -----------------------------------------------------------------
# Building the CodeWarrior menu
# -----------------------------------------------------------------

Menu -n "$codewarriorMenu" -p cw::menuProc {
	"/-<UswitchToIde"
	"switchToConstructor"
	{Menu -m -n werksFlags {}}
	"(-"
	"selectProject"
	"selectTarget"
	"<E<SaddFile"
	"<S<IremoveFile"
	"(-"
	"/T<Utouch"
	"<E<S/K<Ucompile"
	"<S/K<O<U<IcompileFiles"
	"checkSyntax"
	"preprocess"
	"<E<Sdisassemble"
	"<S<IeditDumpInAlpha"
	"precompileHeader"
	"(-"
	"/U<Uupdate"
	"/M<Umake"
	"/R<Urun"
	"(-"
	"removeObjectCode"
	"resetEntryPaths"
	"exportProject"
	"(-"
	"openResource"
	"openInclude"
	"Header&Source"
	{Menu -m -n headers {}}
	"(-"
	{Menu -m -n debugging -p cw::menuProc {
		"/G<UGo to Debugger"
		"/B<USet Breakpoint"
		"/J<UClear Breakpoint"
		"(-"
		"/N<UNext Error"
		"/P<UPrev Error"
		"/I<UShow in IDE"
		"(-"
		"Edit Link Map"
	}}
	{Menu -m -n inspectors -p cw::menuProc {
		"File Inspector"
		"Target Inspector"
		"Project Inspector"
		"(-"
		"Link Order"
		"(-"
		"Non Simple Classes"
		"Class Info"
		"Class Browser"
	}}
	{Menu -m -n globalPrefs -p cw::globalPrefsProc {
		"Build Settings"
		"Debugger Display"
		"Debugger Global"
		"Extras"
		"Font"
		"Global Source Trees"
		"Layout Editor"
		"MetroNub Panel"
		"Plugin Settings"
		"Shielded Folders"
		"Syntax Coloring"
		"VCS Setup"
		"(-"
		"All Globals"
	}}
	{Menu -m -n targetPrefs -p cw::targetPrefsProc {
		"Access Paths"
		"Build Extras"
		"C-C++ Compiler"
		"Custom Keywords"
		"File Mappings" 
		"MacOS Merge Panel"
		"Output Flags"
		"PPC Disassembler"
		"PPC Linker"
		"PPC PEF"
		"PPC Project"
		"PPCAsm Panel"
		"Rez Compiler" 
		"Runtime Settings"
		"Target Settings"
		"Target Source Trees"
		"(-"
		"All Panels"
	}}
	"(-"
	"createFileset"
	"help"
}

# --------------------------
# Now build the menu
# --------------------------
menu::buildFlagMenu werksFlags array cwmodeVars
mode::rebuildSearchPathMenu 


# -----------------------------------------------------------------
# Menu procs
# -----------------------------------------------------------------

proc cw::menuProc {menu item} {
    regsub -all " +" $item "" item
    cw::$item
}

proc cw::globalPrefsProc {menu item} {
	if {![cw::checkRunning]} {return} 
	set result ""
	if {$item=="C-C++ Compiler"} {
		set item "C/C++ Compiler"
	} 
	switch $item {
		"All Globals" {
			append result [cw::allSettings global]
		}
		default {
			append result "SETTINGS FROM PREFS PANEL '$item'\n"
			append result "[ISOTime::ISODateAndTimeRelaxed]\n\n"
			append result [cw::extractPanelInfo $item]
		}
	}
	new -n "$item settings" -info $result
}

proc cw::targetPrefsProc {menu item} {
	if {![cw::isProjectOpen]} {return} 
	set result ""
	if {$item=="C-C++ Compiler"} {
		set item "C/C++ Compiler"
	} 
	switch $item {
		"All Panels" {
			append result [cw::allSettings panels]
		}
		"All Globals" {
			append result [cw::allSettings global]
		}
		default {
			append result "SETTINGS FROM PREFS PANEL '$item'\nCurrent target : [cw::currentTarget]\n"
			append result "[ISOTime::ISODateAndTimeRelaxed]\n\n"
			append result [cw::extractPanelInfo $item]
		}
	}
	new -n "$item settings" -info $result
}

proc cw::switchToIde {} {
	global cw_params
	cw::check
	switchTo $cw_params(CODEWarrior)
}

proc cw::switchToConstructor {} {app::launchFore MWC2}

proc cw::make {} {
	cw::killErrors
	cw::Do Make
}

proc cw::update {} {
	cw::Do UpdP
}

proc cw::Do {param} {
	global cw_params cwmodeVars ALPHA
	if {![cw::isProjectOpen]} {return 0} 
	cw::setCompileFlags
	if {$cwmodeVars(switchWhenCompiling)} {
		switchTo $cw_params(CODEWarrior)
	}
	if {[string length [set res [AEBuild -r $cw_params(CODEWarrior) $cw_params(CWCLASS) $param \
	  "Errs" "bool(01)"]]]} {
		cw::errors $res
	}
	switchTo $ALPHA
}

proc cw::run {} {
	global cw_params ALPHA cwmodeVars
	if {![cw::isProjectOpen]} {return} 
	cw::killErrors
	set bug $cwmodeVars(invertDebugger)
	switchTo $cw_params(CODEWarrior)
	if {[string length [set res [AEBuild -r $cw_params(CODEWarrior) $cw_params(CWCLASS) RunP \
	  "Errs" "bool(01)" DeBg $bug]]]} {
		cw::errors $res
	}
}

proc cw::removeObjectCode {} {
	global cw_params
	if {![cw::isProjectOpen]} {return} 
	AEBuild -r $cw_params(CODEWarrior) $cw_params(CWCLASS) RemB
}

proc cw::resetEntryPaths {} {
	global cw_params
	if {![cw::isProjectOpen]} {return} 
	AEBuild -r $cw_params(CODEWarrior) $cw_params(CWCLASS) ReFP
}

proc cw::exportProject {} {
	global cw_params 
	if {[expr $cw_params(version) < 4]} {
		alertnote "This version of CodeWarrior is too old. No export feature."
		return
	}
	if {![cw::isProjectOpen]} {return} 	
	set expfile "[cw::currentProject].xml"
	catch {AEBuild -r $cw_params(CODEWarrior) CWIE EXPT ---- \
	  [tclAE::build::indexObject PRJD 1] kfil [tclAE::build::TEXT $expfile]} res
	if {$res=="aevt\\ansr\{\}"} {
		edit $expfile
	} else {
		alertnote "Error: $res"
	}
}

proc cw::precompileHeader {} {
	global cw_params 
	if {![cw::isProjectOpen]} {return} 
	cw::setCompileFlags
	set fname [win::Current]
	set targ [putfile "Precompile target:"]
	switchTo $cw_params(CODEWarrior)
	if {[string length [set res [AEBuild $cw_params(CODEWarrior) $cw_params(CWCLASS) PreC \
	  ---- [makeAlis [win::StripCount $fname]] "Errs" "bool(01)" Targ [makeAlis $targ]]]] > 40} {
		cw::errors $res
	} else {
		if {[regexp {errn:([-0-9]+)} $res dummy errno]}  {
			message "Error number: $errno"
		}
	}
}

proc cw::preprocess {} {
	global cw_params 
	if {![cw::isProjectOpen]} {return} 
	set fname [win::Current]
	switchTo $cw_params(CODEWarrior)
	if {[string length [set res [AEBuild $cw_params(CODEWarrior) $cw_params(CWCLASS) PreP \
	  ---- [makeAlis [win::StripCount $fname]] "Errs" "bool(01)"]]] > 40} {
		cw::errors $res
	} else {
		if {[regexp {errn:([-0-9]+)} $res dummy errno]}  {
			message "Error number: $errno"
		}
	}
}

# The CWIE/DASM event expects a target file designated by index, not by name.
proc cw::disassemble {} {
	global cw_params
	set fname [win::Current]
	if {![cw::isInProject $fname]} {return} 
	set trgtindx [cw::findTargetIndex]
	set fileidx [cw::findFileIndex $fname]
	if {$fileidx} {
		switchTo $cw_params(CODEWarrior)
		AEBuild $cw_params(CODEWarrior) CWIE DASM ---- [tclAE::build::indexObject SRCF $fileidx \
		  [tclAE::build::indexObject TRGT $trgtindx [tclAE::build::indexObject PRJD 1]]]
	} else {
		message "Couldn't find file index"
	}
}

# The disassemble feature opens a window in CW but does not create a file on disk, so we create
# the file, then send a close and save event to CW's output window and finally open the file in Alpha.
# You access this proc by holding the option key down when opening CodeWarrior menu in Alpha.
# Process("CodeWarrior IDE 4.1").SendAE "core,clos,'----':obj {want:type(docu), from:'null'(), form:indx, seld:1}, savo:no  "
proc cw::editDumpInAlpha {} {
	global cw_params
	if {[expr $cw_params(version) < 4]} {
		alertnote "Item not available. This version of CodeWarrior is too old."
		return
	}
	set fname [win::Current]
	if {![cw::isInProject $fname]} {return} 
	set fid [open "$fname.dump" w+]
	close $fid
	catch {AEBuild -r $cw_params(CODEWarrior) core close ---- \
	  [tclAE::build::winByName [file tail "$fname.dump"]] \
	  savo "yes " kfil [tclAE::build::alis "$fname.dump"]} res
	if {$res=="aevt\\ansr\{\}"} {
		edit "$fname.dump"
	} else {
		alertnote "No [file tail "$fname.dump"] window in CodeWarrior"
	}
}

proc cw::touch {} {
    global cw_params
    set fname [win::Current]
	if {![cw::isInProject $fname]} {return} 
    switchTo $cw_params(CODEWarrior)
    set res [AEBuild -t 500000 $cw_params(CODEWarrior) $cw_params(CWCLASS) "Toch" \
	  ---- [makeAlis [win::StripCount $fname]]]
}

proc cw::modified {fname} { 
	global cw_params
	if {![cw::checkRunning 0]} {return} 
	AEBuild -t 500000 $cw_params(CODEWarrior) $cw_params(CWCLASS) "Toch" \
	  ---- [makeAlis [win::StripCount $fname]]
}

proc cw::addFile {} {
	global cw_params
	set fname [win::Current]
	if {[cw::isInProject $fname]} {
		alertnote "File already in project"
		return
	} 
	switchTo $cw_params(CODEWarrior)
	set res [AEBuild -t 500000 -q $cw_params(CODEWarrior) $cw_params(CWCLASS) AddF \
	  ---- [makeAlis [win::StripCount $fname]]]
}

proc cw::removeFile {} {
	global cw_params
	set fname [win::Current]
	if {![cw::isInProject $fname]} {return} 
	switchTo $cw_params(CODEWarrior)
	set res [AEBuild -t 500000 -q $cw_params(CODEWarrior) $cw_params(CWCLASS) RemF \
	  ---- [makeAlis [win::StripCount $fname]]]
}

proc cw::checkSyntax {} {
	global cw_params 
	if {![cw::isProjectOpen]} {return} 
	switchTo $cw_params(CODEWarrior)
	set fname [win::Current]
	if {[string length [set res [AEBuild -t 500000 -r $cw_params(CODEWarrior) $cw_params(CWCLASS) Chek \
	  ---- [concat {[alis(} [coerce TEXT $fname -x alis] {)]}] "Errs" "bool(01)"]]] > 40} {
		cw::errors $res
	}
}

proc cw::compile {} {
	global cw_params ALPHA cwmodeVars
	if {$cwmodeVars(saveOpenFilesBeforeBuild)} {save} 
	if {![cw::isProjectOpen]} {return} 
	cw::setCompileFlags
	set fname [win::Current]
	cw::killErrors
	if {$cwmodeVars(switchWhenCompiling)} {
		switchTo $cw_params(CODEWarrior)
	}
	if {[string length [set res [AEBuild -t 500000 -r $cw_params(CODEWarrior) $cw_params(CWCLASS) Comp \
	  ---- [makeAlis [win::StripCount $fname]] "Errs" "bool(01)"]]] > 40} {
		cw::errors $res
	}
	switchTo $ALPHA
}

proc cw::compileFiles {} {
	global cw_params ALPHA win::Modes cwmodeVars
	if {$cwmodeVars(saveOpenFilesBeforeBuild)} {saveAll} 
	if {![cw::isProjectOpen]} {return} 
	cw::setCompileFlags
	set files {}
	set wins [winNames -f]
	set md [set win::Modes([lindex $wins 0])]
	foreach w $wins {
		if {$md == [set win::Modes($w)]} {
			lappend files $w
		}
	}
	cw::killErrors
	if {$cwmodeVars(switchWhenCompiling)} {
		switchTo $cw_params(CODEWarrior)
	}
	if {[string length [set res [AEBuild -t 500000 -r $cw_params(CODEWarrior) $cw_params(CWCLASS) Comp \
	  ---- [makeAlises $files] "Errs" "bool(01)"]]] > 40} {
		cw::errors $res
	}
	switchTo $ALPHA
}

proc cw::GetFiles {} {
	global cw_params
	if {![cw::isProjectOpen]} {return} 
	set res [AEBuild -t 500000 -r $cw_params(CODEWarrior) $cw_params(CWCLASS) GSeg]
	regexp {\[(.*)\]} $res dummy segs
	regsub -all {, Seg} $segs {} segs
	set ind 1
	foreach seg [split $segs {}] {
		regexp {NumF:([0-9]+)} $seg dummy num
		
		while {$num > 0} {
			set res [AEBuild -t 500000 -r $cw_params(CODEWarrior) $cw_params(CWCLASS) GFil \
			  ---- "long($num)" Segm "long($ind)"]
			if {[regexp {FTxt} $res]} {
				regexp {(.*)} $res dummy spec
				set f [specToPathName $spec]
				message $f
				lappend files $f
			}
			incr num -1
		}
		incr ind
	}
	return $files
}

proc cw::createFileset {} {
    fileset::codewarrior::create
    rebuildAllFilesets
}


# -----------------------------------------------------------------
# Fileset procs
# -----------------------------------------------------------------

namespace eval fileset::codewarrior {}

proc fileset::codewarrior::createTagFile {} { return [alphaCreateTagFile] }

proc fileset::codewarrior::selected {fset menu item} {
    if {$fset != ""} {set m $fset} else { set m $menu}
    filesetBasicOpen $m $item
}

proc fileset::codewarrior::create {} {
    global gfileSets gfileSetsType
    set name [prompt "Fileset name? " "CodeWarrior"]
    set gfileSets($name) [lsort -command sortByTail [cw::GetFiles]]
    set gfileSetsType($name) codewarrior
    return $name
}

proc fileset::codewarrior::updateContents {args} {
    eval [list fileset::fromDirectory::updateContents] $args
}


# -----------------------------------------------------------------
# Error handling
# -----------------------------------------------------------------
# the error reply from CodeWarrior looks like this
# [ErrM{ErrT:ErCW, ErrS:function declaration hides inherited virtual function, file:fss (FFFB000014371443536D617274537464506F7075704D656E752E6800000000000000000000000000000000000000000000000000000000000000000000000000000000000000), ErrL:64}, ...]
#
#   ErrT is the error type parameter (enum : ErCE ErCW ErDf ErFn ErGn ErIn ErLE ErLW)
# 	Eg	ErCW indicates a warning
# 		ErCE indicates a compile error
# Improvements by jdunning@cs.Princeton.EDU (John Dunning)
proc cw::errors {res} {	
	global win::Modes tileLeft tileTop tileWidth errorHeight
	
	if {[regexp {\[.*\]} $res res]} {
		# trim off the outside brackets
		set res [string trim $res {[]}]
		
		# replace all the returns in the error list with spaces.  this is 
		# necessary because CW 7.0 can return multi-line error messages,
		# which aren't processed correctly by this function.
		regsub -all "\r" $res " " res
		
		# delete the first ErrM, and replace the remaining ones (and the preceeding commas)
		# with returns
		regsub {ErrM} $res "" res
		regsub -all {, ErrM} $res "\r" res
		
		set text ""
		set errors 0
		set warnings 0
		set messages 0
		set link 0
		
		# split the string into separate lines, one error per line.  only process
		# process the first 101 errors
		foreach err [lrange [split $res "\r"] 0 100] {
			# the last two letters in ErrT:Er.. signal whether it's a compile (C) or link (L)
			# error and whether it's an error (E) or a warning (W).  stick the rest of
			# the error message back into err.
			if {[regexp {ErrT:Er(.)(.),[ \t]*(.*)} $err unused compileOrLink errorOrWarning err]} {
				if {$errorOrWarning == "E"} {
					# mark actual errors with a bullet
					append text "  "
					incr errors
				} else {
					# mark warnings with a delta
					append text "  "
					incr warnings
				}
				
				if {$compileOrLink == "C"} {
					# we have a compile error, so strip out the error message, the filespec
					# and the line number
					if {[regexp {ErrS:(.*).*(.*).*ErrL:([0-9]+)} $err unused errorString fileSpec lineNumber]} {
						# conver the filespec that was returned in the apple event into a pathname
						# so we can display it
						set pathName [specToPathName $fileSpec]
						
						# append the file name (the tail of the pathname), the line number,
						# the error string, lots of tabs, and then the full pathname
						append text "\"[file tail $pathName]\"\t; Line $lineNumber: $errorString\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t$pathName\r"
					}
				} else {
					# we got a link error
					set link 1
					
					# just strip out the error message.  the file the error occurs in doesn't 
					# seem to get included in the event
					if {[regexp {ErrS:(.*)} $err unused errorString]} {
						# append the error message
						append text "$errorString\r"
					}
				}
			} elseif {[regexp {([^:]*): (.*)} $err unused fileName message]} {
				# we got some sort of message, so strip out the associated file name and 
				# the message. I'm not sure if CodeWarrior still returns anything of this form.
				append text "\"$fileName\" ; $message\r"
				incr messages
			}
		}
		
		set wins [winNames]
		if {$errors == 0 && $warnings == 0 && $messages == 0} {
			hook::register resumeHook cw::killCompilerErrors
			return
		}
		
		new -n {* Compiler Errors *} -g $tileLeft $tileTop $tileWidth $errorHeight -m Brws
		if {$link} {
			insertText "(Link: $errors errors, $warnings warnings, $messages messages)\r-----\r$text"
		} else {
			insertText "($errors errors, $warnings warnings, $messages messages: <cr> to go to line)\r-----\r$text"
		}
		
		display [minPos]
		winReadOnly
		browse::Down
		gotoMatch
	}
}

proc cw::killErrors {} {
	global cw_params
	set wins [winNames]
	if {[set res [lsearch $wins $cw_params(errorstitle)]] >= 0} {
		set name [lindex $wins $res]
		bringToFront $name
		killWindow
	}
}

proc cw::killCompilerErrors {args} {
	global cw_params
	set wins [winNames -f]
	if {[set res [lsearch $wins $cw_params(errorstitle)]] >= 0} {
		bringToFront [lindex $wins $res]
		killWindow
	}
	# This is a one-off hook; we remove it immediately.
	hook::deregister resumeHook cw::killCompilerErrors
}


# -----------------------------------------------------------------
# Debugging procs
# -----------------------------------------------------------------
proc cw::GotoDebugger {} {
    global cw_params
    cw::checkDebug
    switchTo $cw_params(CODEDEBUGGER)
}

proc cw::SetBreakpoint {} {
    global cw_params 
    cw::checkDebug
    set fname [win::Current]
    set ln [lindex [posToRowCol [getPos]] 0]
    set res [AEBuild -t 500000 -r $cw_params(CODEDEBUGGER) $cw_params(CDCLASS) "Sbrk" \
      ---- [makeAlis $fname] "Line" "long($ln)"]
}

proc cw::ClearBreakpoint {} {
    global cw_params 
    cw::checkDebug
    set fname [win::Current]
    set ln [lindex [posToRowCol [getPos]] 0]
    set res [AEBuild -t 500000 -r $cw_params(CODEDEBUGGER) $cw_params(CDCLASS) "Cbrk" \
      ---- [makeAlis [win::StripCount $fname]] "Line" "long($ln)"]
}

proc cw::ShowinIDE {} {
    global cw_params 
    cw::GotoDebugger
    set fname [win::Current]
    set ln [lindex [posToRowCol [getPos]] 0]
    set res [AEBuild -t 500000 -r $cw_params(CODEDEBUGGER) $cw_params(CDCLASS) "Show" \
      ---- [makeAlis [win::StripCount $fname]] "Line" "long($ln)"]
}

proc cw::Help {} {
	help::openFile "CodeWarrior Menu Help"
}

proc cw::NextError {} {
	global cw_params
	nextMatch $cw_params(errorstitle)
}

proc cw::PrevError {} {
	global cw_params
	prevMatch $cw_params(errorstitle)
}


# -----------------------------------------------------------------
# Process
# -----------------------------------------------------------------
proc cw::check {} {
    global cw_params CWCompilerSig 
    app::launchElseTryThese {CWIE MMCC MPCC} CWCompilerSig
    set cw_params(CODEWarrior) [file tail [app::launchBack $CWCompilerSig]]
}

proc cw::checkRunning {{msg 1}} {
	global cw_params CWCompilerSig
	if {![app::isRunning $CWCompilerSig cw_params(CODEWarrior)]} {
		if {![app::isRunning {CWIE MMCC MPCC} cw_params(CODEWarrior) CWCompilerSig]} {
			set cw_params(cwstate) "(CodeWarrior is not running."
			if {$msg} {alertnote $cw_params(cwstate)} 
			return 0
		}
	}
	return 1
}

proc cw::checkDebug {} {
    global cw_params CWDebuggerSig
    app::launchElseTryThese {CWIE MPDB MWDB} CWDebuggerSig
    set cw_params(CODEDEBUGGER) [file tail [app::launchBack $CWDebuggerSig]]
}


# -----------------------------------------------------------------
# Includes
# -----------------------------------------------------------------

## 
 # from old "codeWarriorMenu+.tcl"                                       
 #                                                                       
 # July 15, 1996       Jonathan E. Guyer   <mailto:j-guyer@nwu.edu>  
 #                                                                   
 # These routines implement an includes list for CodeWarrior when you 
 # option-click in the title bar.  It requires CodeWarrior IDE 1.6 or 
 # greater (earlier versions didn't return file dependencies with
 # MMPRGFil events.
 #                                                                            
 # As discussed within the code, it's not the                                 
 # most efficient thing in the world, due to the IDE's                        
 # dain-bramaged object model. I hope to improve this in the future.
 # 
 # Modified : 2001-10-05 Bernard Desgraupes <berdesg@easynet.fr>       
 ##
proc cw::findFileInSegment {name} {
	global cw_params  
	# Get list of Segments
	set blah [AEBuild -r $cw_params(CODEWarrior) $cw_params(CWCLASS) GSeg]
	# aevt\ansr{'----':[Seg	{...}, Seg {...}, ...]}
	if {![regexp {aevt\\ansr\{'----':\[.+\]\}} $blah]} {return [list 0 "" "" {(Empty project}]}
	# Strip out everything down to a list of file counts		
	set fileCountList ""
	# ... Seg {... NumF:??,	...}, ...
	while {[regexp -indices	{NumF:([0-9]*),?} $blah	dummy mtchRange]} {
		set fileCountList [concat $fileCountList " " [string range $blah [lindex $mtchRange 0] [lindex $mtchRange 1]]]
		set blah [string range $blah [expr [lindex $mtchRange 1] + 1] [string length $blah]]
	}
	# Then iterate through each file in each segment until we find what we're looking for :
	set segmentNumber 0
	set foundFile 0
	set SrcfInfo ""
	foreach	fileCount $fileCountList {
		incr segmentNumber
		for {set fileNumber 1} {$fileNumber <= $fileCount} {incr fileNumber} {
			set SrcfInfo [AEBuild -r $cw_params(CODEWarrior) $cw_params(CWCLASS) GFil ---- $fileNumber "Segm" $segmentNumber]
			# aevt\ansr{'----':SrcF{... pnam:????? ...}}
			regexp {pnam:([^]*)}	$SrcfInfo dummy fileName
			if {$fileName == $name}	{
				set foundFile 1
				break
			}
		}
	}
	return [list $foundFile $segmentNumber $fileNumber $SrcfInfo]
}

proc cw::include {name theReply} {
	global cw_params cwpaths 
	set cw_params(cwstate) ""
	# Make sure the file is in the current project before we start iterating 
	# through all its files. Set 0 to disable alertnotes.
	cw::isInProject $name 0
	set cwreply [list $cw_params(cwstate)]
	if {$cwreply=="{}"} {
		set fileinfo [cw::findFileInSegment $name]
		if {[info exists cwpaths]} {unset cwpaths}
		# Break down the list of included files, 
		if {[lindex $fileinfo 0]} {
			# aevt\ansr{'----':SrcF{... IncF:[fss (...), ... ] ...}}
			regexp {IncF:\[([^]]*)\]} [lindex $fileinfo 3]	dummy raw
			if {$raw == ""}	{return	{{(No includes}}}
			regsub -all {[^]*} $raw { } raw
			regsub {[^]*}	$raw {}	raw
			regsub {.*} $raw {} raw
			foreach	f $raw {
				set path [specToPathName $f]
				set tl [file tail $path]
				set cwpaths($tl) $path
				lappend	names $tl
			}
			set cwreply [lsort -ignore $names]
		} else {
			# should never get here
			set cwreply {{(Not in current CW project}}
		}
	}
	return $cwreply
}

proc cw::checkErrorInReply {blah theReply} {
	global cw_params cw_error
	upvar $theReply cwreply
	# aevt\ansr{'----':[?]}
	if {![regexp {'----':\[([^]]*)\]} $blah dummy errCode]} {
		# aevt\ansr{errn:????}
		regexp {errn:([-0-9]*)}	$blah dummy errCode
	}
	if {$errCode} {
		if {[info exists cw_error($errCode)]} {
			lappend cwreply "(CW Error: $cw_error($errCode)"
		} else {
			lappend cwreply "(CW AppleEvent Error: $errCode"
		}
		error $cwreply
		return 0
	}
	return 1
}

proc cw::isInProject {name {msg 1}} {
	global cw_params 
	if {![cw::isProjectOpen $msg]} {return 0} 
	set blah [AEBuild -r $cw_params(CODEWarrior) $cw_params(CWCLASS) FInP ---- "TEXT([file tail $name])"]
	if {![regexp {'----':\[0\]} $blah dummy]} {
		set cw_params(cwstate) "(File not in project [file tail [cw::currentProject]]"
		if $msg {alertnote $cw_params(cwstate)} 
		return 0
	}
	return 1
}

# Called by Alpha to get list of include files for popup (in C/C++ modes).
proc cw::getIncludeFiles {} {
	if {[catch {cw::include [win::CurrentTail] reply} ret]} {
		error $reply
	}
	return $ret
}

proc cw::editIncludeFile {fname} {
	global cwpaths
	if {[info exists cwpaths($fname)]} {
		file::openQuietly $cwpaths($fname)
	} else {
		error "Not found!"
	}
}

proc cw::openInclude {} {
	if {[regexp {#include.*("|<)(.*)("|>)} [getText [lineStart [getPos]] [nextLineStart [getPos]]] d1 d1 inc]} {
		return [editIncludeFile $inc]
	}
	message "No include file found on this line!"
	beep
}

# This proc attempts to edit the header file corresponding to a particular
# source file and vice-versa. It relies on the file::sourceHeaderToggle proc 
# from modeSearchpath.tcl to take advantage of the user defined headers folders.
proc cw::header&Source {} {
	file::sourceHeaderToggle
}

proc cw::correspFile {name extlist} {
	set basename [file root $name]
	foreach ext $extlist {
		if {[file exist "$basename.$ext"]} {
			return "$basename.$ext"
		}
	} 
	error "No file"
}

proc cw::EditLinkMap {} {
	global cw_params
	if {![cw::isProjectOpen]} {return} 
	# Find the output folder set in the "Target Settings" panel
	set outputFold [cw::getOutputFolder]
	if {$outputFold!=""} {
		set filelist [glob -nocomplain -dir $outputFold *.xMAP]
		set debuglist ""
		foreach f $filelist {
			lappend debuglist [file tail $f]
		} 
		if {![llength $debuglist]} {
			alertnote "Weird. No '.xMAP' file in output folder \"$outputFold\".\rDid you set the\
			  'Generate Link Map' flag on?"
			return
		} 
		if {![catch {set outputName [listpick -p "File to open:" $debuglist]}]} {
			edit "[file join $outputFold $outputName]"
		} 
	}
}

# This proc finds the expanded output folder for the current target. The Apple Event
# can return various kinds of path :
# 	'Abso': An absolute path name, including volume name.
# 	'PRel': A path relative to the current projects folder.
# 	'SRel': A path relative to the CodeWarrior folder.
# 	'YRel': A path relative to the system folder
# 	'RRel'': A path root relative
proc cw::getOutputFolder {} {
	global cw_params
	set outputFold ""
	set res [AEBuild -r 'CWIE' MMPR Gref PNam [tclAE::build::TEXT "Target Settings"]]
	if {[regexp {'TA16':\{pnam:([^]+)} $res dum outputFold] \
	  || [regexp {'TA11':([^]+)} $res dum outputFold]} {
		if {[regexp "Orig:(\[^,\}\]+)" $res dum kind] \
		  || [regexp {'TA12':([a-zA-Z]+)} $res dum kind]} {
			switch $kind {
				"Abso" {
					# Nothing
				}
				"PRel" {
					if {[cw::currentProject]==""} {break} 
					set outputFold "[file dirname $cw_params(currproject)]$outputFold"
				}
				"SRel" {}
				"YRel" {}
			}
		} 
	} else {
		alertnote "Couldn't find output folder."
	}
	return $outputFold
}

# -----------------------------------------------------------------
# Preference procs
# -----------------------------------------------------------------
#  Settings from panel 'PPC Global Optimizer'

proc cw::extractPanelInfo {panel} {
	global cw_info
	set result ""
	if {![catch {AEBuild -r 'CWIE' MMPR Gref PNam [tclAE::build::TEXT $panel]} res]} {
		switch $panel {
			"Access Paths" {
				append result [cw::extractSettings bool [list PA02 PA04] $res]
			}
			"Build Extras" - "Debugger Global" {
				append result [cw::extractSettings bool [list EX09 EX04 EX30 EX31] $res]
			}
			"C/C++ Compiler" {
				append result [cw::extractSettings text FE08 $res]
				append result [cw::extractSettings enum [list FE18 FE20] $res]
				append result [cw::extractSettings bool [list FE01 FE02 FE03 FE04 FE05 FE06 FE07 FE09 FE11 \
				  FE12 FE13 FE14 FE15 FE16 FE17 FE24 FE25 FE26 FE23 FE19 FE10] $res]
			}
			"Custom Keywords" {
				append result [cw::extractSettings color [list GH05 GH06 GH07 GH08] $res]		
			}
			"File Mappings" {
				append result "\n\t$cw_info(TA02)\t$cw_info(TA03)\t$cw_info(TA05)\t$cw_info(TA04)\t$cw_info(TA06)\t$cw_info(TA07)\n"
				while {[regexp "\{'PR04':\[^\}\]+\}" $res line]} {
					append result "[cw::extractSettings map [list TA03 TA05 TA04 TA06] $line]\n"
					regsub "\{'PR04':\[^\}\]+\}" $res "" res
				}
			}
			"Layout Editor" {
				append result [cw::extractSettings bool [list LEco LEoi] $res]
				append result [cw::extractSettings default [list LEgx LEgy] $res]
			}
			"MacOS Merge Panel" {
				# append result [cw::extractSettings enum PR01 $res]
				append result [cw::extractSettings text [list PR02 PR03 PR04 MG03] $res]
				append result [cw::extractSettings bool [list L601 MG01 MG02] $res]
			}
			"MetroNub Panel" {
				append result [cw::extractSettings bool [list DB01 DB12 DB03 DB04 DB05 DB10 DB11] $res]
			}
			"Output Flags" {
				append result [cw::extractSettings bool [list OLok RLok PDmf FFiv FFhb FFnl \
				  FFsy FFci FFsh FFin ] $res]
				append result [cw::extractSettings text Comt $res]
				append result [cw::extractSettings enum FFlb $res]
			}
			"PPC Disassembler" {
				append result [cw::extractSettings bool [list DS02 DS23 DS21 DS22 DS03 DS31 DS04 DS05] $res]
			}
			"PPC Global Optimizer" {
				# aevt\ansr{'----':{'GO01':'null'(), 'GO02':'null'()}}
			}
			"PPC Linker" {
				append result [cw::extractSettings text [list L602 L603  L604] $res]
				append result [cw::extractSettings bool [list LN02 LN03 LN04 L601 LN10 LN11] $res]
				append result [cw::extractSettings enum L605 $res]
			}
			"PPC PEF" {
				append result [cw::extractSettings bool [list PE06 PE07 PE10] $res]
				append result [cw::extractSettings text PE08 $res]
				append result [cw::extractSettings enum [list PE01 PE05] $res]
				append result [cw::extractSettings default [list PE02 PE03 PE04 PE09] $res]
			}
			"PPC Project" {
				# A bug in CW (?) : this event always returns a series of null's.
				# aevt\ansr{'----':{'PR01':'null'(), 'PR02':'null'(), 'PR03':'null'(), 'PR04':'null'(), 'PR05':'null'(),
				# 'PR06':'null'(), 'PR07':'null'(), 'PR08':'null'(), 'PR09':'null'(), 'PR11':'null'(), 'PR12':'null'(), 
				# 'PR13':'null'(), 'PR14':'null'(), 'PR15':'null'(), 'P601':'null'(), 'PR16':'null'()}}
				append result [cw::extractSettings default [list PR01 PR02 PR03 PR04 PR05 PR06 PR07 PR08 \
				  PR09 PR11 PR12 PR13 PR14 PR15 P601 PR16] $res]
			}
			"PPCAsm Panel" {
				append result [cw::extractSettings bool [list PPC3 PPC4 PPC5] $res]
				append result [cw::extractSettings enum [list PPC1 PPC2] $res]
				append result [cw::extractSettings text PPC6 $res]
			}
			"Rez Compiler" {
				append result [cw::extractSettings bool [list CR01 CR03] $res]
				append result [cw::extractSettings enum [list CR08 CR05] $res]
				append result [cw::extractSettings text [list CR02 CR06] $res]
				append result [cw::extractSettings default [list CR04 CR07] $res]
			}
			"Runtime Settings" {
				# aevt\ansr{'----':{'RS01':{pnam:'TEXT'(), Frmt:PFMc, Orig:Abso}, 'RS02':'TEXT'(), 'RS03':'TEXT'(), 'RS04':[]}}
				append result [cw::extractSettings text [list RS02 RS03] $res]
			}
			"Source Trees" - "Target Source Trees" - "Global Source Trees" {
				append result [cw::extractSettings tree {} $res]
			}
			"Target Settings" {
				append result [cw::extractSettings text [list TA01 TA13 TA09 TA10 TA11] $res]
				append result [cw::extractSettings enum TA12 $res]
			}
			"Build Settings" {
				append result [cw::extractSettings text [list BX02 BX03] $res]
				append result [cw::extractSettings bool [list BX01 BX07] $res]
				append result [cw::extractSettings default [list BX04 BX05 BX06] $res]
			}
			"Debugger Display" {
				append result [cw::extractSettings bool [list Db01 Db09 Db02 Db03 Db04 Db05 Db10] $res]
				append result [cw::extractSettings color [list Db06 Db07] $res]		
				append result [cw::extractSettings default Db08 $res]
			}
			"Extras" {
				append result [cw::extractSettings bool [list EX19 EX07 EX10 EX11 EX12 EX18] $res]
				append result [cw::extractSettings default [list EX08 EX16 EX17] $res]
			}
			"Font" {
				append result [cw::extractSettings text ptxf $res]
				append result [cw::extractSettings bool FN01 $res]
				append result [cw::extractSettings default [list FN02 FN03 FN04 ptps] $res]
			}
			"Plugin Settings" {
				append result [cw::extractSettings enum PX01 $res]
				append result [cw::extractSettings bool PX02 $res]		
			}
			"Shielded Folders" {
				append result [cw::extractSettings bool [list SF02 SF03] $res]
			}
			"Syntax Coloring" {
				append result [cw::extractSettings bool GH01 $res]
				append result [cw::extractSettings color [list GH02 GH03 GH04 GH05 GH06 GH07 GH08] $res]		
			}
			"VCS Setup" {
				append result [cw::extractSettings text [list VC02 VC03 VC04] $res]
				append result [cw::extractSettings bool [list VC01 VC11 VC05 VC06 VC07 VC08] $res]
			}
		}
	} 
	return $result
}

proc cw::extractSettings {kind codelist settings} {
	global cw_info cw_enum cw_params
	set result ""
	switch $kind {
		"bool" {
			foreach key $codelist {
				if {[regexp "'?$key'?:bool\\(0(\\\d)\\)" $settings dum value]} {
					append result "$cw_info($key) : $cw_params($value)\n"
				} 
			} 
		}
		"text" {
			foreach key $codelist {
				append result "$cw_info($key) : [cw::extractText $key $settings]\n"
			} 
		}
		"color" {
			foreach key $codelist {
				if {[regexp "'?$key'?:cRGB\\((\[a-zA-Z0-9\]+)\\)" $settings dum value]} {
					append result "$cw_info($key) : $value\n"
				} 
			} 
		}
		"enum" {
			foreach key $codelist {
				if {[regexp "'?$key'?:(\[a-zA-Z0-9 '\]+)" $settings dum value]} {
					set value [string trim $value]
					append result "$cw_info($key) : $cw_enum($value)\n"
				} 
			} 
		}
		"map" {
			foreach key [list PR04 TA02] {
				append result "[cw::extractText $key $settings]\t"
			} 
			foreach key $codelist {
				if {[regexp "'$key':bool\\(0(\\\d)\\)" $settings dum value]} {
					append result "$cw_params($value)\t"
				} 
			} 
			append result "[cw::extractText TA07 $settings]"
		}
		"tree" {
			while {[regexp {pnam:([^]+)[^]+Path:([^]+)} $settings dum name path]} {
				append result "Name: $name\tPath: $path\n"
				regsub "pnam:" $settings "" settings
			}
		}
		default {
			foreach key $codelist {
				if {[regexp "'?$key'?:(\[^,\}\]+)" $settings dum value]} {
					append result "$cw_info($key) : $value\n"
				} 
			} 
		}
	}
	return $result
}

# A non-empty string is enclosed in curly quotes. An empty string is 'TEXT'().
proc cw::extractText {key line} {
	set result ""
	if {[regexp "'?$key'?:'TEXT'\\(\\)" $line dum]} {
		set result ""
	} elseif {[regexp "'?$key'?:(\[^\]+)" $line dum value]} {
		set result "$value"
	} 
	return $result
}

proc cw::allSettings {what} {
	global cw_params
	set result "[string toupper $what] SETTINGS\n"
	append result "[ISOTime::ISODateAndTimeRelaxed]\n\n"
	foreach panel $cw_params($what) {
		append result "\n Settings from panel '$panel'\n"
		append result [cw::extractPanelInfo $panel]
	} 
	return $result
}

proc cw::selectTarget {} {
	if {![cw::projectToFront]} {return} 
	cw::getTargetsList
	cw::displayDialog target
}

proc cw::selectProject {} {
	if {![cw::isProjectOpen]} {return} 
	cw::getProjectsList
	cw::displayDialog project
}

proc cw::getProjectsList {} {
	global cw_params
	set cw_params(projectlist) ""
	if {[catch {AEBuild -r 'CWIE' core getd ---- [tclAE::build::propertyObject DKND \
	  [tclAE::build::indexObject docu "abso('all ')"]]} res]} {
		cw::errors $res
		return 
	}
	set namelist [AEBuild -r 'CWIE' core getd ---- [tclAE::build::propertyObject pnam \
	  [tclAE::build::indexObject docu "abso('all ')"]]]
	set res [cw::tclList $res]
	set namelist [cw::tclList $namelist]
	set result ""
	while {[set idx [lsearch $res PRJD]]!="-1"} {
		lappend result [lindex $namelist $idx]
		set res [lreplace $res $idx $idx " "]
	}
	set cw_params(projectlist) $result
}

proc cw::getTargetsList {} {
	global cw_params
	set cw_params(targetlist) ""
	if {[catch {AEBuild -r 'CWIE' core getd ---- [tclAE::build::propertyObject pnam \
	  [tclAE::build::indexObject TRGT "abso('all ')" [tclAE::build::indexObject PRJD 1]]]} res]} {
		cw::errors $res
		return 
	}
	set cw_params(targetlist) [cw::tclList $res]
}

proc cw::displayDialog {what} {
	global cw_params
	set dialogy 10
	set dialogargs ""
	if {$what=="target"} {
		append dialogargs "-t [list "Project '[file tail $cw_params(currproject)]'"] 10 $dialogy 280 [expr $dialogy + 20] "
		set dialogy [expr $dialogy + 20]    
	} 
	append dialogargs "-t [list "Select a $what"] 20 $dialogy 280 [expr $dialogy + 20] "
	set dialogy [expr $dialogy + 65]    
	append dialogargs "-b OK 245 $dialogy 305 [expr $dialogy + 20] "
	append dialogargs "-b Cancel 160 $dialogy 220 [expr $dialogy + 20] "
	set dialogy [expr $dialogy - 40]    
	set y $dialogy
	append dialogargs [dialog::menu 80 y $cw_params(${what}list) [cw::currentTarget]]
	set dialogy [expr $dialogy + 70]    
	set values [eval dialog -w 320 -h $dialogy $dialogargs]
	if {[lindex $values 1]} {return} ; # user cancelled
	set cw_params(curr$what) [lindex $values 2]
	if {$cw_params(curr$what) == ""} {return}
	eval cw::set$what [list $cw_params(curr$what)]
}


# -----------------------------------------------------------------
# Inspectors
# -----------------------------------------------------------------
# errAEEventNotHandled        = -1708
# errAENoSuchObject           = -1728
# If reply is aevt\ansr{errn:...}, probably means that the current
# target has not been built yet.
proc cw::NonSimpleClasses {} {
	set res [AEBuild -r 'CWIE' MMPR NsCl]
	if {[regexp {aevt\\ansr\{'----':\[\]\}} $res] || [regexp {aevt\\ansr\{errn:} $res]} {
		alertnote "Info not available. Rebuild the target then try again."
		return
	} 
	regsub -all {[^]+} $res " " res
	regsub {^[^]+} $res "" res
	regsub {.*$} $res "" res
	set res [split $res]
	new -n "Non Simple Classes" -info [join $res "\n"]
} 

proc cw::ClassInfo {} {
	global cw_params
	if {[cw::classDialog]} {
		cw::classInspector $cw_params(currentclass)
	} 
}

proc cw::ClassBrowser {} {
	global cw_params
	if {[cw::classDialog]} {
		cw::checkRunning
		catch {AEBuild -r $cw_params(CODEWarrior) $cw_params(CWCLASS) Brow \
		  ---- [tclAE::build::nameObject Clas [tclAE::build::TEXT $cw_params(currentclass)]]} res
		if {[regexp {aevt\\ansr\{errn:} $res]} {
			alertnote $res
		} else {
			switchTo $cw_params(CODEWarrior)
		}
	} 
}

proc cw::classDialog {} {
	global cw_params
	set args ""
	lappend args [list -t "Enter a class name :" 5 5 190 25 \
	  -e $cw_params(currentclass) 10 30 270 50 \
	  -b "Get Info" 185 70 270 90 \
	  -b Cancel 90 70 170 90 ]
	set values [eval dialog -w 280 -h 100 [join $args]]
	if {[lindex $values 2]} {return 0}
	set cw_params(currentclass) [lindex $values 0]
	if {$cw_params(currentclass) == ""} {return 0}
	return 1
}

proc cw::classInspector {classname} {
	set title "Class '$classname'"
	set bsresult [cw::baseClasses $classname]
	if {[llength $bsresult]} {
		append title "\n\n[llength $bsresult] base classes :\n[join [lsort -decreasing $bsresult] "\n"]"
	} 
	set dtresult [cw::dataMembers $classname]
	if {[llength $dtresult]} {
		append title "\n\n[llength $dtresult] data members :\n[join [lsort -decreasing $dtresult] "\n"]"
	} 
	set fnresult [cw::memberFunctions $classname]
	if {[llength $fnresult]} {
		append title "\n\n[llength $fnresult] member functions :\n[join [lsort -decreasing $fnresult] "\n"]"
	} 
	new -n "classinfo $classname" -info $title
}

# If one of the lists below is empty, the reply is aevt\ansr{}.
proc cw::baseClasses {name} {
	set result ""
	set bsclnobj [tclAE::build::indexObject BsCl "abso('all ')" \
	  [tclAE::build::nameObject Clas [tclAE::build::TEXT $name] \
	  [tclAE::build::indexObject Cata 1 ]]]
	# List of all base classes
	set bsclList [AEBuild -r  'CWIE' core getd ---- [tclAE::build::propertyObject Clas $bsclnobj]]
	if {![string match {aevt\\ansr\{\}} $bsclList]} {
		# List of all base classes access property
		set acceList [AEBuild -r  'CWIE' core getd ---- [tclAE::build::propertyObject Acce $bsclnobj]]
		# List of all base classes virtual property
		set virtList [AEBuild -r  'CWIE' core getd ---- [tclAE::build::propertyObject Virt $bsclnobj]]
		# Make valid Tcl lists
		set acceList [cw::tclList $acceList]
		set virtList [cw::tclList $virtList]
		regsub {[^]+} $bsclList "" bsclList
		regsub {[^]+$} $bsclList "" bsclList
		regsub -all {[^]+} $bsclList " " bsclList
		# Clean up the bool's
		regsub -all {bool\(00\)} $virtList "  " virtList
		regsub -all {bool\(01\)} $virtList virtual virtList
		# Merge the lists
		set len [llength $bsclList]
		for {set i 0} {$i<$len} {incr i} {
			lappend result "[lindex $acceList $i]\t[lindex $virtList $i]\t[lindex $bsclList $i]"
		}
	} 
	return $result
}

proc cw::dataMembers {name} {
	set result ""
	set dtmbnobj [tclAE::build::indexObject DtMb "abso('all ')" \
	  [tclAE::build::nameObject Clas [tclAE::build::TEXT $name] \
	  [tclAE::build::indexObject Cata 1 ]]]
	# List of all data members
	set dtmbList [AEBuild -r  'CWIE' core getd ---- [tclAE::build::propertyObject pnam $dtmbnobj]]
	if {![string match {aevt\\ansr\{\}} $dtmbList]} {
		# List of all data members access property
		set acceList [AEBuild -r  'CWIE' core getd ---- [tclAE::build::propertyObject Acce $dtmbnobj]]
		# List of all data members static property
		set statList [AEBuild -r  'CWIE' core getd ---- [tclAE::build::propertyObject Stat $dtmbnobj]]
		# Make valid Tcl lists
		set dtmbList [cw::tclList $dtmbList]
		set acceList [cw::tclList $acceList]
		set statList [cw::tclList $statList]
		# Clean up the bool's
		regsub -all {bool\(00\)} $statList "  " statList
		regsub -all {bool\(01\)} $statList static statList
		# Merge the lists
		set len [llength $dtmbList]
		set dttitle "\n\n$len data members :\n"
		for {set i 0} {$i<$len} {incr i} {
			lappend result "[lindex $acceList $i]\t[lindex $statList $i]\t[lindex $dtmbList $i]"
		}
	}
	return $result
}

proc cw::memberFunctions {name} {
	set result ""
	set mbfnobj [tclAE::build::indexObject MbFn "abso('all ')" \
	  [tclAE::build::nameObject Clas [tclAE::build::TEXT $name] \
	  [tclAE::build::indexObject Cata 1 ]]]
	# List of all member functions
	set mbfnList [AEBuild -r  'CWIE' core getd ---- [tclAE::build::propertyObject pnam $mbfnobj]]
	if {![string match {aevt\\ansr\{\}} $mbfnList]} {
		# List of all member functions access property
		set acceList [AEBuild -r  'CWIE' core getd ---- [tclAE::build::propertyObject Acce $mbfnobj]]
		# List of all member functions virtual property
		set virtList [AEBuild -r  'CWIE' core getd ---- [tclAE::build::propertyObject Virt $mbfnobj]]
		# List of all member functions static property
		set statList [AEBuild -r  'CWIE' core getd ---- [tclAE::build::propertyObject Stat $mbfnobj]]
		# Make valid Tcl lists
		set mbfnList [cw::tclList $mbfnList]
		set acceList [cw::tclList $acceList]
		set virtList [cw::tclList $virtList]
		set statList [cw::tclList $statList]
		# Clean up the bool's
		regsub -all {bool\(00\)} $virtList "  " virtList
		regsub -all {bool\(01\)} $virtList virtual virtList
		regsub -all {bool\(00\)} $statList "  " statList
		regsub -all {bool\(01\)} $statList static statList
		# Merge the lists
		set len [llength $mbfnList]
		set fntitle "\n\n$len member functions :\n"
		for {set i 0} {$i<$len} {incr i} {
			lappend result "[lindex $acceList $i]\t[lindex $statList $i]\t[lindex $virtList $i]\t[lindex $mbfnList $i]"
		}
	}
	return $result
}

proc cw::FileInspector {} {
	global cw_params cw_info
	set fname [win::Current]
	if {[info exists cwreply]} {unset cwreply}
	if {[catch {cw::checkRunning} res]} {
		alertnote $res
		return
	} 
	if {![cw::isInProject $fname]} {return} 
	set result "Current target : [cw::currentTarget]\n"
	append result "[ISOTime::ISODateAndTimeRelaxed]\n\n"
	append result "Name : [file tail $fname]\n"
	append result "Access : [file dirname $fname]:\n"
	# Find the file's position in the segment
	set fileInfo [cw::findFileInSegment [file tail $fname]]
	if {[lindex $fileInfo 0]} {
		set segmNum [lindex $fileInfo 1]
		set fileNum [lindex $fileInfo 2]
		set SrcfInfo [lindex $fileInfo 3]
		set proplist [list SrcT UpTD CSiz DSiz SymG Bfor Weak IncF]
		foreach prop $proplist {
			switch $prop {
				SrcT - CSiz - DSiz {
					regexp "$prop:(\[^,\]+)" $SrcfInfo dum res
				}
				UpTD - SymG - Bfor - Weak {
					regexp "$prop:bool\\(0(\\\d)\\)" $SrcfInfo dum value
					set res $cw_params($value)
				}
				IncF {
					regexp {IncF:\[([^]]*)\]} $SrcfInfo	dummy raw
					if {$raw != ""}	{
						regsub -all {[^]*} $raw { } raw
						regsub {[^]*}	$raw {}	raw
						regsub {.*} $raw {} raw
						foreach	f $raw {
							set path [specToPathName $f]
							set tl [file tail $path]
							lappend	names $tl
						}
						set res "\n\t[join $names "\n\t"]"
					}
				}
			}
			append result "$cw_info($prop) : $res\n"
		} 
	} else {
		append result "File not found."
	}
	new -n "[file tail $fname] Inspector" -info $result
} 

proc cw::TargetInspector {} {
	set result "Current target : [cw::currentTarget]\n"
	append result "[ISOTime::ISODateAndTimeRelaxed]\n\n"
	append result "LIBF: Library file\n"
	append result "RESF: Resource file\n"
	append result "TXTF: Text file\n"
	append result "UNKN: Unknown\n"
	append result "Lidx: Linking order (-1 means not in link order)\n"
	append result "\nType\tLidx\tName\n\n"
	append result [join [lsort [cw::FileTypesList]] "\n"]
	new -n "Target Inspector" -info "$result"
}

proc cw::ProjectInspector {} {
	global cw_params
	if {![cw::projectToFront]} {return} 
	set result ""
	append result "Current Project : [tclAE::build::resultData 'CWIE' core getd \
	  ---- [tclAE::build::propertyObject pnam [tclAE::build::indexObject PRJD 1]]]\n"
	if {[string length [set path [cw::currentProject]]]} {
		append result "Access : [file dirname $path]:\n"
	} 
	set nbTrgt [tclAE::build::resultData 'CWIE' core cnte \
	  ---- [tclAE::build::indexObject PRJD 1] kocl type(TRGT)]
	append result "Contains $nbTrgt targets.\n\n"
	# Loop through all targets
	for {set j 1} {$j<=$nbTrgt} {incr j} {
		append result "\t Target : [tclAE::build::resultData 'CWIE' core getd \
		  ---- [tclAE::build::propertyObject pnam \
		  [tclAE::build::indexObject TRGT $j \
		  [tclAE::build::indexObject PRJD 1]]]]\n"
		set nbSubtrgt [tclAE::build::resultData 'CWIE' core cnte \
		  ---- [tclAE::build::indexObject PRJD 1] kocl type(SBTG)]
		if {$nbSubtrgt} {
			append result "\t$nbSubtrgt subtargets.\n"
		} 
		set srcfNum [tclAE::build::resultData 'CWIE' core cnte \
		  ---- [tclAE::build::indexObject TRGT $j \
		  [tclAE::build::indexObject PRJD 1]] kocl type(SRCF)]
		append result "\t\t$srcfNum source files.\n"
		set ftypList [AEBuild -r  'CWIE' core getd ---- [tclAE::build::propertyObject FTYP \
		  [tclAE::build::indexObject SRCF "abso('all ')" \
		  [tclAE::build::indexObject TRGT $j \
		  [tclAE::build::indexObject PRJD 1]]]]]
		set libNum [regsub -all LIBF $ftypList "" ftypList]
		set resNum [regsub -all RESF $ftypList "" ftypList]
		set txtNum [regsub -all TXTF $ftypList "" ftypList]
		set unkNum [regsub -all UNKN $ftypList "" ftypList]
		append result "\n\t\t$libNum library files"
		append result "\n\t\t$resNum resource files"
		append result "\n\t\t$txtNum text files"
		if {$unkNum} {
			append result "\n\t\t$unkNum unknown files"
		} 
		append result "\n\n"
	}		
	new -n "Projects Inspector" -info $result
}

proc cw::LinkOrder {} {
	global cw_params
	set trgtindx [cw::findTargetIndex]
	set targetobj [tclAE::build::indexObject TRGT $trgtindx \
	  [tclAE::build::indexObject PRJD 1]]
	# Name of the current target
	set title "Target : [tclAE::build::resultData 'CWIE' core getd \
	  ---- [tclAE::build::propertyObject pnam $targetobj]]\n"
	# Number of source files
	set nbSrcf [tclAE::build::resultData 'CWIE' core cnte ---- $targetobj kocl type(SRCF)]
	# List of all source files
	cw::checkVersion
	set scrfList [AEBuild -r  'CWIE' core getd ---- [tclAE::build::propertyObject $cw_params(pathparm) \
	  [tclAE::build::indexObject SRCF "abso('all ')" $targetobj]]]
	# List of all link indices
	set lidxList [AEBuild -r  'CWIE' core getd ---- [tclAE::build::propertyObject LIDX \
	  [tclAE::build::indexObject SRCF "abso('all ')" $targetobj]]]
	# Make valid Tcl lists
	set scrfList [cw::tclList $scrfList]
	set lidxList [cw::tclList $lidxList]
	# Merge the two lists. Format the index to sort correctly later. 
	for {set i 0} {$i<$nbSrcf} {incr i} {
		if {[lindex $lidxList $i]!="-1"} {
			set num [format %0[string length $nbSrcf]i [expr [lindex $lidxList $i] + 1]]
			lappend result "$num\t[file tail [lindex $scrfList $i]]"
		} 
	}
	new -n "Link Order" -info "$title\n[join [lsort $result] "\n"]"
}

proc cw::FileTypesList {} {
	global cw_params
	set trgtindx [cw::findTargetIndex]
	set targetobj [tclAE::build::indexObject TRGT $trgtindx \
	  [tclAE::build::indexObject PRJD 1]]
	# Name of the current target
	set title "Target : [tclAE::build::resultData 'CWIE' core getd \
	  ---- [tclAE::build::propertyObject pnam $targetobj]]\n"
	# Number of source files
	set nbSrcf [tclAE::build::resultData 'CWIE' core cnte ---- $targetobj kocl type(SRCF)]
	# List of all source files
	cw::checkVersion
	set scrfList [AEBuild -r  'CWIE' core getd ---- [tclAE::build::propertyObject $cw_params(pathparm) \
	  [tclAE::build::indexObject SRCF "abso('all ')" $targetobj]]]
	# List of all file types
	set ftypList [AEBuild -r  'CWIE' core getd ---- [tclAE::build::propertyObject FTYP \
	  [tclAE::build::indexObject SRCF "abso('all ')" $targetobj]]]
	# List of all linking indices
	set lidxList [AEBuild -r  'CWIE' core getd ---- [tclAE::build::propertyObject LIDX \
	  [tclAE::build::indexObject SRCF "abso('all ')" $targetobj]]]
	# Make valid Tcl lists
	set scrfList [cw::tclList $scrfList]
	set ftypList [cw::tclList $ftypList]
	set lidxList [cw::tclList $lidxList]
	# Merge the three lists
	for {set i 0} {$i<$nbSrcf} {incr i} {
		lappend result "[lindex $ftypList $i]\t[lindex $lidxList $i]\t[file tail [lindex $scrfList $i]]"
	}
	return $result
}

proc cw::ResFilesList {} {
	global cw_params
	set trgtindx [cw::findTargetIndex]
	set targetobj [tclAE::build::indexObject TRGT $trgtindx \
	  [tclAE::build::indexObject PRJD 1]]
	set result ""
	# List of all source files
	cw::checkVersion
	set scrfList [AEBuild -r  'CWIE' core getd ---- [tclAE::build::propertyObject $cw_params(pathparm) \
	  [tclAE::build::indexObject SRCF "abso('all ')" $targetobj]]]
	# List of all file types
	set ftypList [AEBuild -r  'CWIE' core getd ---- [tclAE::build::propertyObject FTYP \
	  [tclAE::build::indexObject SRCF "abso('all ')" $targetobj]]]
	# Make valid Tcl lists
	set scrfList [cw::tclList $scrfList]
	set ftypList [cw::tclList $ftypList]
	# Look for resource files (type RESF)
	while {[set idx [lsearch $ftypList RESF]]!=-1} {
		lappend result [lindex $scrfList $idx]
		regsub RESF $ftypList "x" ftypList
	}
	return $result
}


# -----------------------------------------------------------------
# Utility procs
# -----------------------------------------------------------------
proc cw::isProjectOpen {{msg 1}} {
	global cw_params
	if {![cw::checkRunning $msg]} {return 0} 
	if {![set res [tclAE::build::resultData 'CWIE' core cnte ---- 'null'() kocl type(PRJD)]] } {
		set cw_params(cwstate) "(No open project"
		if {$msg} {alertnote $cw_params(cwstate)} 
		return 0
	} 
	return $res
}

proc cw::openResource {} {
	set resList [cw::ResFilesList]
	switch [llength $resList]  {
		0 {
			alertnote "No resource file found in the current target."
			return
		}
		1 {
			set resName [lindex $resList 0]
		}
		default {
			set shortlist ""
			foreach resf $resList {
				lappend shortlist [file tail $resf]
			}  
			if {[catch {set shortName [listpick -p "Resource file to open:" $shortlist]}]} {
				return
			} 
			set resName [lindex $resList [lsearch $shortlist $shortName]]
		}
	}
	sendOpenEvent noReply 'MACS' $resName
}

# Returns the full path of the current project
proc cw::currentProject {} {
	global cw_params
	set cw_params(currproject) ""
	set res [AEBuild -r 'CWIE' MMPR GetP]
	if {![regexp {aevt\\ansr\{errn:\}} $res]} {
		regexp {fss \(([^]+)\)} $res dummy fsp
		set cw_params(currproject) [specToPathName $fsp]
	} else {
		alertnote "Couldn't get location of current project"
		}
	return $cw_params(currproject)
}

# Brings the current project window to the front in CW (without switching to CW).
proc cw::projectToFront {} {
	if {![cw::isProjectOpen]} {return 0} 
	set prjname [file tail [cw::currentProject]]
	AEBuild 'CWIE' misc slct ---- [tclAE::build::winByName $prjname]
	return 1
}

proc cw::currentTarget {} {
	global cw_params
	if {![cw::projectToFront]} {return} 
	set cw_params(currtarget) ""
	if {![catch {AEBuild -r 'CWIE' core getd ---- [tclAE::build::propertyObject CURT \
	  [tclAE::build::indexObject PRJD 1]]} res]} {
		if {[regexp {([^]+)} $res dum curr]} {
			set cw_params(currtarget) $curr
		} 
	}
	return $cw_params(currtarget)
}

proc cw::settarget {trgt} {
	global cw_params
	if {[catch {AEBuild -r $cw_params(CODEWarrior) $cw_params(CWCLASS) STrg ---- [tclAE::build::TEXT $trgt]} res]} {
		cw::errors $res
		return 
	} else {
		message "Current target set to '$trgt'"
	}
}

proc cw::setproject {proj} {
	AEBuild 'CWIE' misc slct ---- [tclAE::build::winByName $proj]
	message "Current project set to '$proj'"
}

proc cw::findFileIndex {name} {
	global cw_params
	set trgtindx [cw::findTargetIndex]
	set targetobj [tclAE::build::indexObject TRGT $trgtindx \
	  [tclAE::build::indexObject PRJD 1]]
	# List of all source file paths
	cw::checkVersion
	set scrfList [AEBuild -r  'CWIE' core getd ---- [tclAE::build::propertyObject $cw_params(pathparm) \
	  [tclAE::build::indexObject SRCF "abso('all ')" $targetobj]]]
	# Make valid Tcl list
	set scrfList [cw::tclList $scrfList]
	set fileidx [lsearch $scrfList $name]
	return [expr $fileidx + 1]
}

proc cw::findTargetIndex {} {
	global cw_params
	if {![cw::projectToFront]} {return} 
	set res [AEBuild -r 'CWIE' core getd ---- [tclAE::build::propertyObject pnam \
	  [tclAE::build::indexObject TRGT "abso('all ')" \
	  [tclAE::build::indexObject PRJD 1]]]]
	return [expr [lsearch [cw::tclList $res] [cw::currentTarget]] + 1]
}

proc cw::tclList {res} {
	if {$res=="aevt\\ansr\{\}"} {return ""} 
	regsub {aevt\\ansr\{'----':\[?} $res "" res
	regsub {\]?\}} $res "" res
	regsub -all , $res "" res
	regsub -all {[]} $res "\"" res 
	return $res
}

# Possible values for the "buildBeforeRunning" flag are : 
# 'BXb1' (always), 'BXb2' (ask) ou 'BXb3' (never).
proc cw::setBuildFlags {{name ""}} {
	global cw_params cwmodeVars
	if {$cwmodeVars(*SyncFlagsWithProject*)} {return} 
	if {![cw::checkRunning]} {return 0} 
	if {$cwmodeVars(buildBeforeRunning)} {
		set bbr "'BXb1'"
	} else {
		set bbr "'BXb3'"
	}
	catch {
		if {[expr $cw_params(version) >= 4]} {
			AEBuild -r $cw_params(CODEWarrior) $cw_params(CWCLASS) Pref PNam [tclAE::build::TEXT "Build Settings"] \
			  PRec "{'BX07':bool(0$cwmodeVars(saveOpenFilesBeforeBuild))}"
		}
		AEBuild -r $cw_params(CODEWarrior) $cw_params(CWCLASS) Pref PNam [tclAE::build::TEXT "Build Settings"] \
		  PRec "{'BX01':bool(0$cwmodeVars(playSoundAfterUpdt&Make)),'BX04':$bbr}"
		AEBuild -r $cw_params(CODEWarrior) $cw_params(CWCLASS) Pref PNam [tclAE::build::TEXT "Extras"] \
		  PRec "{'EX11':bool(0$cwmodeVars(useExternalEditor))}"
	}
	return 1
}

proc cw::setCompileFlags {} {
	global cw_params cwmodeVars
	if {$cwmodeVars(*SyncFlagsWithProject*)} {return} 
	catch {
		AEBuild -r $cw_params(CODEWarrior) $cw_params(CWCLASS) Pref PNam [tclAE::build::TEXT "PPC Linker"] \
		  PRec "{'LN02':bool(0$cwmodeVars(generateSymFile)),'LN04':bool(0$cwmodeVars(generateLinkMap))}"
		AEBuild $cw_params(CODEWarrior) $cw_params(CWCLASS) Pref PNam [tclAE::build::TEXT "Build Extras"] \
		  PRec "{'EX09':bool(0$cwmodeVars(activateBrowser))}"
		AEBuild $cw_params(CODEWarrior) $cw_params(CWCLASS) Pref PNam [tclAE::build::TEXT "C/C++ Compiler"] \
		  PRec "{'FE01':bool(0$cwmodeVars(activateC++Compiler)),'FE26':bool(0$cwmodeVars(enableObjectiveC)),\
		  'FE09':bool(0$cwmodeVars(enableC++Exceptions)),'FE15':bool(0$cwmodeVars(enableRunTimeTypeInfo))}"
	}
	return 1
}

proc cw::flagsFromProject {{name ""}} {
	global cwmodeVars
	if {!$cwmodeVars(*SyncFlagsWithProject*)} {return} 
	if {![cw::isProjectOpen]} {
		menu::flagProc werksFlags "*SyncFlagsWithProject*"
		return
	} 	
	array set panelandkey {
		useExternalEditor {"Extras" "'EX11'"}
		generateSymFile {"PPC Linker" "'LN02'"}
		generateLinkMap {"PPC Linker" "'LN04'"}
		activateBrowser {"Build Extras" "'EX09'"}
		enableObjectiveC {"C/C++ Compiler" "'FE26'"}
		activateC++Compiler {"C/C++ Compiler" "'FE01'"}
		enableC++Exceptions {"C/C++ Compiler" "'FE09'"}
		enableRunTimeTypeInfo {"C/C++ Compiler" "'FE15'"}
		playSoundAfterUpdt&Make {"Build Settings" "'BX01'"}
		buildBeforeRunning {"Build Settings" "'BX04'"}
		saveOpenFilesBeforeBuild {"Build Settings" "'BX07'"}
	}
	foreach flag [array names panelandkey] {
		set key [lindex $panelandkey($flag) 1]
		catch { AEBuild -r 'CWIE' MMPR Gref PNam [tclAE::build::TEXT [lindex $panelandkey($flag) 0]] \
		  PRec [tclAE::build::propertyObject $key]} res	
		if {[regexp "$key:bool\\(0(\\\d)\\)" $res dum value]} {
			set cwmodeVars($flag) $value
			markMenuItem werksFlags $flag $value
			prefs::modified cwmodeVars($flag)
		}
	} 
}

proc cw::checkVersion {} {
	global cw_params
	if {![info exists cw_params(version)]} {cw::versionNumber} 
	# The following is due to a change of syntax in CW's Apple Events 
	# since version 4. The old PATH parameter has been renamed to Path.
	if {[expr $cw_params(version) < 4]} {
		set cw_params(pathparm) PATH
	}
}

proc cw::versionNumber {} {
	global cw_params
	set cw_params(version) ""
	cw::check
	# Find the version string of the appli
	set cw_params(version) [tclAE::build::resultData 'MACS' core getd ---- \
	  [tclAE::build::propertyObject vers "obj {want:type(appf), seld:CWIE, form:fcrt, from:'null'()}"]]
	regexp {v([0-9.]+)} $cw_params(version) & cw_params(version)
	# Make it a decimal number for numerical comparisons (version 3.1.2 will become 3.1)
	regexp {\d+(\.\d+)?} $cw_params(version) cw_params(version)
	return $cw_params(version)
}

