#=== nowrap =====================================================================
#
# 			CodeWarrior Interaction
#
# Metrowerks currently has an incomplete appleevent interface. 
# Apple events can be used to direct CodeWarrior to compile
# or add individual files, make the project, etc. However, 
# there is currently no provision to report specific errors
# back to the controller.
#
#================================================================================

alpha::menu codewarriorMenu2 2.0.1 "C C++ Java Pasc" "268" {
    newPref flag debugger 0 cw
    newPref flag switchWhenCompiling 1 cw
    newPref var SearchPath "" cw

    newPref sig CWCompilerSig CWIE
    newPref sig CWDebuggerSig MWDB
    
    newPref color winkyColor red cw

    newPref var successSound "" cw cw::sound [concat None (-) [beep -list]] item
    newPref var failureSound "" cw cw::sound [concat None (-) [beep -list]] item
    
    menu::buildProc codewarriorMenu2 cw::buildMenu
    menu::buildProc werksFlags {
	menu::buildFlagMenu werksFlags array cwmodeVars
    }
    menu::buildProc successSound {
	menu::buildFlagMenu successSound list successSound cwmodeVars
    }
    menu::buildProc failureSound {
	menu::buildFlagMenu failureSound list failureSound cwmodeVars
    }
    mode::rebuildSearchPathMenu 
    
    menu::buildSome codewarriorMenu2

    alpha::package require searchPaths 1.0
    set cwdebugMenu	"274"

    hook::register savePostHook cw::modified "Java" "Pasc" "C++" "C"
} {codewarriorMenu2} {
} uninstall {
    this-file
} maintainer {
    "Jon Guyer" <jguyer@his.com> <http://www.his.com/jguyer/>
} help {
    file "CodeWarrior"
} requirements {
    if {[info tclversion] < 8.0} {
	error "codewarrior menu 2 requires Tcl 8"
    }
} preinit {
    fileset::registerNewType codewarrior "list"
}


namespace eval cw {}

proc codewarriorMenu2 {} {}

proc cw::buildMenu {} {
    global codewarriorMenu2

    set ma {
	"help"
	"/-<UswitchToIde"
	{Menu -m -n werksFlags {}}
	"createFileset"
	{Menu -m -n headers {}}
	"(-)"
	"addFile"
	"/K<Ucompile"
	"compileFiles"
	"checkSyntax"
	"precompile"
	"(-)"
	"openHeader"
	"(-)"
	"/U<Uupdate"
	"/M<Umake"
	"(-)"
	"/D<UgotoDebugger"
	"/B<UsetBreakpoint"
	"clearBreakpoint"
	"/J<UshowSource"
	"(-)"
	"/N<UnextError"
	"/P<UprevError"
	"/R<Urun"
	"(-)"
	"preferences"
	{Menu -m -n successSound {}}
	{Menu -m -n failureSound {}}
    }

    return [list build $ma cw::menuProc \
      [list werksFlags headers successSound failureSound] $codewarriorMenu2]
}


proc cw::help {} {
    help::openFile CodeWarrior
}

proc cw::sound {var} {
    global cwmodeVars
    if {[set cwmodeVars($var)] != "None"} {
        beep [set cwmodeVars($var)]
    } 
}


set CWCLASS		MMPR
set CDCLASS		MWDB

proc cw::nextError {} {
    nextMatch "* Compiler Errors *"
}

proc cw::prevError {} {
    prevMatch "* Compiler Errors *"
}

proc cw::menuProc {menu item} {
    cw::$item
}

proc cw::preferences {} {
    dialog::pkg_options cw
}

proc cw::switchToIde {} {
    global CODEWarrior
    cw::check
    switchTo $CODEWarrior
}

proc cw::make {} {
    global mode
    
    cw::killErrors
    
    if {[info exists ${mode}modeVars(makeProc)]} {
        eval [set ${mode}modeVars(makeProc)]
    } else {
	cw::Do Make
    }
}

proc cw::update {} {
    cw::Do UpdP
}

proc cw::Do {param} {
    global CODEWarrior CWCLASS ALPHA
    cw::check
    switchTo $CODEWarrior
    tclAE::send -Q cw::errors $CODEWarrior $CWCLASS $param \
      Errs [tclAE::build::bool 1]
}

proc cw::_run {} {
    global CODEWarrior CWCLASS cwmodeVars
    
    switchTo $CODEWarrior
    tclAE::send -Q cw::errors $CODEWarrior $CWCLASS RunP \
      Errs [tclAE::build::bool 1] \
      DeBg $cwmodeVars(debugger)
}

proc cw::run {} {
    global mode
    
    cw::check
    cw::killErrors

    if {[info exists ${mode}modeVars(makeProc)]} {
        eval [set ${mode}modeVars(makeProc)]
    } else {
	cw::_run
    }
}

proc cw::precompile {} {
    global CODEWarrior CWCLASS
    
    cw::check
    set fname [win::Current]
    set targ [putfile "Precompile target:" "[file rootname [file tail $fname]].mch"]
    switchTo $CODEWarrior
    tclAE::send -Q cw::errors $CODEWarrior $CWCLASS PreC \
      ---- [tclAE::build::alis [win::StripCount $fname]] \
      Errs [tclAE::build::bool 1] \
      Targ [tclAE::build::alis $targ]
}

proc cw::addFile {} {
    global CODEWarrior CWCLASS
    cw::check
    switchTo $CODEWarrior
    tclAE::build::throw -t 500000 $CODEWarrior $CWCLASS AddF \
      ---- [tclAE::build::alis [win::StripCount [win::Current]]]
}

proc cw::checkSyntax {} {
    global CODEWarrior CWCLASS res
    cw::check
    #	switchTo $CODEWarrior
    set fname [win::Current]
    tclAE::send -Q cw::errors $CODEWarrior $CWCLASS Chek \
      ---- [tclAE::build::alis $fname] \
      Errs [tclAE::build::bool 1]
}


proc cw::killErrors {} {
    set wins [winNames]
    if {[set res [lsearch $wins "* Compiler Errors *"]] >= 0} {
	set name [lindex $wins $res]
	bringToFront $name
	killWindow
    }
}	


proc cw::compile {} {
    global CODEWarrior CWCLASS cwmodeVars
    save
    cw::check
    set fname [win::Current]
    cw::killErrors
    if {$cwmodeVars(switchWhenCompiling)} {
	switchTo $CODEWarrior
    }
    tclAE::send -Q cw::errors $CODEWarrior $CWCLASS Comp \
      ---- [tclAE::build::alis [win::StripCount $fname]] \
      Errs [tclAE::build::bool 1]
}


proc cw::compileFiles {} {
    global CODEWarrior CWCLASS win::Modes
    saveAll
    cw::check
    set files {}
    set wins [winNames -f]
    set md [set win::Modes([lindex $wins 0])]
    foreach w $wins {
	if {$md == [set win::Modes($w)]} {
	    lappend files $w
	}
    }
    cw::killErrors
    switchTo $CODEWarrior
    tclAE::send -Q cw::errors $CODEWarrior $CWCLASS Comp \
      ---- [tclAE::build::List [list $fname] -as alis] \
      Errs [tclAE::build::bool 1]
}


proc cw::getFiles {} {
    global CODEWarrior CWCLASS
    cw::check

    set segsDesc [tclAE::build::resultDesc -t 500000 $CODEWarrior $CWCLASS GSeg]
    set segCount [tclAE::countItems $segsDesc]
    
    for {set segNum 0} {$segNum < $segCount} {incr segNum} {
        set segDesc [tclAE::getNthDesc $segsDesc $segNum reco]
	set fileNum [tclAE::getKeyData $segDesc NumF]
	
	while {$fileNum > 0} {
	    set resultDesc [tclAE::send -t 500000 -r $CODEWarrior $CWCLASS GFil \
	      ---- $fileNum \
	      Segm [expr {$segNum + 1}]]
	    
	    set fileDesc [tclAE::getKeyDesc $resultDesc ---- reco]
	    tclAE::disposeDesc $resultDesc
	    
	    if {[tclAE::getKeyData $fileDesc SrcT] == "FTxt"} { 
		set f [tclAE::getKeyData $fileDesc file TEXT]
		message $f
		lappend files $f
	    }
	    incr fileNum -1
	    
	    tclAE::disposeDesc $fileDesc
	}
	tclAE::disposeDesc $segDesc
    }
    
    tclAE::disposeDesc $segsDesc
    return $files
}

proc cw::createFileset {} {
    fileset::codewarrior::create
    rebuildAllFilesets
}


namespace eval fileset::codewarrior {}

proc fileset::codewarrior::createTagFile {} { return [alphaCreateTagFile] }

proc fileset::codewarrior::selected {fset menu item} {
    if {$fset != ""} {set m $fset} else { set m $menu}
    filesetBasicOpen $m $item
}

proc fileset::codewarrior::create {} {
    global gfileSets gfileSetsType
    
    set name [prompt "Fileset name? " "CodeWarrior"]
    set gfileSets($name) [lsort -command sortByTail [cw::getFiles]]
    set gfileSetsType($name) codewarrior
    
    if {[askyesno "Save project fileset?"] == "yes"} {
	prefs::modified gfileSets($name) gfileSetsType($name)
    }
    return $name
}

proc fileset::codewarrior::updateContents {args} {
    eval [list fileset::fromDirectory::updateContents] $args
}


# the error reply from CodeWarrior looks like this
# [ErrM{ErrT:ErCW, ErrS:function declaration hides inherited virtual function, file:fss (FFFB000014371443536D617274537464506F7075704D656E752E6800000000000000000000000000000000000000000000000000000000000000000000000000000000000000), ErrL:64}, ...]
#
# ErrT is the error type parameter
# 	ErCW indicates a warning
# 	ErCE indicates an error
# Improvements by jdunning@cs.Princeton.EDU (John Dunning)
# Completely rewritten to use TclAE by jguyer@his.com (Jon Guyer)
proc cw::errors {theAppleEvent theReplyAE} {
    global ALPHA cwmodeVars
    
    set errorDesc [tclAE::getKeyDesc $theAppleEvent ----]
    
    if {[set errorCount [tclAE::countItems $errorDesc]] > 0} {
	global browse::prefix
	
	switchTo $ALPHA
    
	set text ""
	set errors 0
	set warnings 0
	set messages 0
	set link 0
	
	browse::Start {* Compiler Errors *}
	
	for {set i 0} {$i < $errorCount} {incr i} {
	    set errorMsgDesc [tclAE::getNthDesc $errorDesc $i reco] 
	    set errorType [tclAE::getKeyData $errorMsgDesc ErrT] 
	    switch $errorType {
		"ErCE" -
		"ErLE" {
		    # mark actual errors with a bullet
		    set prefix "  "
		    incr errors
		}
		"ErCW" -
		"ErLW" {
		    # mark warnings with a delta
		    set prefix "  "
		    incr warnings
		}
	    }
	    set errorString [tclAE::getKeyData $errorMsgDesc ErrS]
	    switch $errorType {
		"ErCE" -
		"ErCW" {
		    # we got a compile error
		    set pathName [tclAE::getKeyData $errorMsgDesc file TEXT]
		    set lineNumber [tclAE::getKeyData $errorMsgDesc ErrL]
		    # append the file name (the tail of the pathname), the line number,
		    # the error string, lots of tabs, and then the full pathname
		    browse::Add $pathName $errorString $lineNumber 1 $prefix
		}
		"ErLE" -
		"ErLW" {
		    # we got a link error. the file the error occurs in doesn't 
		    # seem to get included in the event
		    set link 1
		    # append the error message
		    browse::Add "" $errorString "" "" 0 $prefix
		}
	    }
	    tclAE::disposeDesc $errorMsgDesc
	}
	
	if {$errors == 0 && $warnings == 0 && $messages == 0} {
	    hook::register resumeHook cw::killCompilerErrors
	    return
	}
	
	if {$link} {
	    set browse::prefix "(Link:  $errors errors,  $warnings warnings, $messages messages)\r-----"
	} else {
	    set browse::prefix "( $errors errors,  $warnings warnings, $messages messages: <cr> to go to line)\r-----"
	}
	
	browse::createWindow
	
	goto [minPos]
	browse::Down
	browse::Goto
	
       if {$errors != 0} {
	   if {[set cwmodeVars(failureSound)] != "None"} {
	       beep [set cwmodeVars(failureSound)]
	   }
       } else {
	   if {[set cwmodeVars(successSound)] != "None"} {
	       beep [set cwmodeVars(successSound)]
	   }
       }
   } else {
       message "CW: No errors"
       if {[set cwmodeVars(successSound)] != "None"} {
           beep [set cwmodeVars(successSound)]
       } 
   }
   
   tclAE::disposeDesc $errorDesc
}

proc cw::killCompilerErrors {args} {
    set wins [winNames -f]
    if {[set res [lsearch $wins "* Compiler Errors *"]] >= 0} {
	bringToFront [lindex $wins $res]
	killWindow
    }
    # This is a one-off hook; we remove it immediately.
    hook::deregister resumeHook cw::killCompilerErrors
}


proc cw::modified {fname} { 
    global CWCLASS CODEWarrior
    cw::checkRunning
    tclAE::send $CODEWarrior $CWCLASS "Toch" \
      ---- [tclAE::build::alis [win::StripCount $fname]]
}

proc cw::Touch {} {
    global CODEWarrior CWCLASS
    cw::check
    switchTo $CODEWarrior
    set fname [win::Current]
    tclAE::send $CODEWarrior $CWCLASS "Toch" \
      ---- [tclAE::build::alis [win::StripCount $fname]]
}

proc cw::check {} {
    global CODEWarrior modifiedVars CWCompilerSig 
    app::launchElseTryThese {CWIE MMCC MPCC} CWCompilerSig
    set CODEWarrior [file tail [app::launchBack $CWCompilerSig]]
}

proc cw::checkDebug {} {
    global CODEDEBUGGER CWDebuggerSig modifiedVars
    app::launchElseTryThese {MPDB MWDB CWIE} CWDebuggerSig
    set CODEDEBUGGER [file tail [app::launchBack $CWDebuggerSig]]
}

proc cw::gotoDebugger {} {
    global CODEDEBUGGER
    cw::checkDebug
    switchTo $CODEDEBUGGER
}

proc cw::setBreakpoint {} {
    global CODEDEBUGGER CDCLASS
    cw::checkDebug
#     switchTo $CODEDEBUGGER
    set fname [win::Current]
    set ln [lindex [posToRowCol [getPos]] 0]
    tclAE::build::throw $CODEDEBUGGER $CDCLASS "Sbrk" \
      ---- [tclAE::build::alis [win::StripCount $fname]] \
      Line $ln
}

proc cw::clearBreakpoint {} {
    global CODEDEBUGGER CDCLASS
    cw::checkDebug
#     switchTo $CODEDEBUGGER
    set fname [win::Current]
    set ln [lindex [posToRowCol [getPos]] 0]
    tclAE::build::throw $CODEDEBUGGER $CDCLASS "Cbrk" \
      ---- [tclAE::build::alis [win::StripCount $fname]] \
      Line $ln
}


proc cw::showSource {} {
    global CODEDEBUGGER CDCLASS
    cw::checkDebug
    switchTo $CODEDEBUGGER
    set fname [win::Current]
    set ln [lindex [posToRowCol [getPos]] 0]
    tclAE::build::throw $CODEDEBUGGER $CDCLASS "Show" \
      ---- [tclAE::build::alis [win::StripCount $fname]] \
      Line $ln
}
#  "Soff" "long([getPos]" "Eoff" "long([selEnd])"

proc cw::openHeader {} {
    if {[regexp {#include.*("|<)(.*)("|>)} [getText [lineStart [getPos]] [nextLineStart [getPos]]] d1 d1 inc]} {
	return [cw::editIncludeFile $inc]
    }
    message "No include file found on this line!"
    beep
}


## 
 # from old "codeWarriorMenu+.tcl"                                       
 #                                                                       
 # July 15, 1996       Jonathan E. Guyer   <mailto:j-guyer@nwu.edu>  
 #                                                                   
 # These routines implement an includes list for CodeWarrior when you 
 # option-click in the title bar.  It requires CodeWarrior IDE 1.6 or 
 # greater (earlier versions didn't return file dependencies with 
 # MMPRGFil events.
 #                                                                            
 # As discussed within the code, it's not the                                 
 # most efficient thing in the world, due to the IDE's                        
 # dain-bramaged object model. I hope to improve this in the future.          
 ##

proc cw::checkRunning {} {
    global CODEWarrior CWCompilerSig launchIDEifRequired
    if {![app::isRunning $CWCompilerSig CODEWarrior]} {
	if {![app::isRunning {CWIE MMCC MPCC} CODEWarrior CWCompilerSig]} {
	    error "Not running"
	}
    }
}

proc cw::include {name} {
    global CODEWarrior CWCLASS cwpaths 
    
    # This may be more trouble than it's worth:
    # I got tired of "* CodeWarrior Not Running *" messages when it
    # _was_ running (CODEWarrior wasn't defined yet) but this way
    # it'll launch CW on an option-click, whether you want it to or
    # not.
    cw::checkRunning
    
    # Make sure the file is in the current project before we start iterating 
    # through all its files.
    
    # error codes defined in CWAppleEvents.h in CodeWarrior's MacOS Examples
    switch [tclAE::build::resultData $CODEWarrior $CWCLASS FInP \
	  ---- [tclAE::build::TEXT [file tail $name]]] {
	0 {}
        1 {
	    # errShell_ActionFailed
	    return [list "(Action Failed"]
        }
	2 {
	    # errShell_FileNotFound
	    return [list "(Not in current CW project"]
	}
	6 {
	    # errShell_NoOpenProject
	    return [list "(No project open in CW"]
	}
	default {
	    return [list "(CW AppleEvent Error: $errCode"]
	}
    } 
    
    if {[info exists cwpaths]} {unset cwpaths}
    
    # CodeWarrior is a pain in the ass about this and won't just 
    # return the file with a given name so we:
    
    # get list of Segments
    
    set segsDesc [tclAE::build::resultDesc $CODEWarrior $CWCLASS GSeg]
    set segCount [tclAE::countItems $segsDesc]
    
    if {$segCount == 0} {
	# This should never happen
	return {{(Strange. Empty project}}
    } 
    
    for {set segNum 0} {$segNum < $segCount} {incr segNum} {
	set segDesc [tclAE::getNthDesc $segsDesc $segNum reco]
	set fileNum [tclAE::getKeyData $segDesc NumF]
	while {$fileNum > 0} {
	    set resultDesc [tclAE::send -r $CODEWarrior $CWCLASS GFil \
	      ---- $fileNum \
	      Segm [expr {$segNum + 1}]]
	    
	    set fileDesc [tclAE::getKeyDesc $resultDesc ---- reco]
	    tclAE::disposeDesc $resultDesc
	    
	    if {[tclAE::getKeyData $fileDesc pnam] == $name} { 
		set foundFile 1
		break
	    }
	    tclAE::disposeDesc $fileDesc
	    incr fileNum -1
	}
	tclAE::disposeDesc $segDesc
	if {$foundFile} {
	    break
	}
    }
    
    tclAE::disposeDesc $segsDesc

    # and finally break down the list of included files 
    if {$foundFile}	{
	set includesDesc [tclAE::getKeyDesc $fileDesc IncF]
	set includeCount [tclAE::countItems $includesDesc]
	if {$includeCount == 0} {
	    return {{(No CW includes}}
	}
	
	for {set i 0} {$i < $includeCount} {incr i} {
	    set path [tclAE::getNthData $includesDesc $i TEXT]
	    set tail [file tail $path]
	    set cwpaths($tail) $path
	    lappend names $tail
	}
	
	return [lsort -ignore $names]
    } else {
	# should never get here
	return {{(Not in current CW project}}
    }
}

# Called by Alpha to get list of include files for popup.
proc cw::getIncludeFiles {} {
    if {[catch {cw::include [win::CurrentTail]} ret]} {
	error {{(* CodeWarrior not running *}}
    }
    return $ret
}

proc cw::editIncludeFile {fname} {
    global cwpaths
    if {[info exists cwpaths($fname)]} {
	file::openQuietly $cwpaths($fname)
    } else {
	error "Not found!"
    }
}




