# nowrap

alpha::menu internetConfigMenu 0.1.3 global "139" {
} internetConfigMenu {} uninstall this-file help {file "Internet Config"}

proc internetConfigMenu {} {}

Menu -n $internetConfigMenu -p internetProc {
    "Menu -n urls {}"
    "/'<I<OpickUrl"
    (-
    goTo
    help
    (-
    webBrowser
    newsClient
    mailClient
    ftpClient
    gopherClient
    telnetClient
    (-
    finger
    "telnet"
    (-
    resolveUrl
    viewHtmlFile
}


proc internetProc {menu item} {
    if {[catch {switch -- $item {
	pickUrl {catch {icPickUrl}}
	goTo {catch {icOpen}}
	help {catch {help::openFile "Internet Config"}}
	webBrowser {launch -f [icGetPref -t 1 {helperhttp}]}
	mailClient {launch -f [icGetPref -t 1 {helpermailto}]}
	ftpClient {launch -f [icGetPref -t 1 {helperftp}]}
	gopherClient {launch -f [icGetPref -t 1 {helpergopher}]}
	telnetClient {launch -f [icGetPref -t 1 {helpertelnet}]}
	newsClient {launch -f [icGetPref -t 1 {helpernews}]}
	resolveUrl {catch {icURL [getSelect]}}
	viewHtmlFile {catch {htmlSendWindow}}
	telnet {catch telnet}
	finger {catch finger}
    }}]} {
	alertnote "Could not get your [quote::Prettify $item] from Internet Config"
	# Check if IC extension is installed.
	if {![file exists "[tclAE::build::resultData 'MACS' core getd rtyp TEXT ---- "obj {form:prop, want:type(prop), seld:type(extn), from:'null'()}"]Internet Config Extension"]} {
	    alertnote "Despite what Internet Config says, you should reboot after using IC for the first time."
	    icOpen
	}
    }
}


proc icPickUrl {} {
    global savedUrls
    if {![catch {listpick -p "Pick URL:" [lsort [array names savedUrls]]} res]} {
	icURL $savedUrls($res)
    }
}


proc rebuildUrlMenu {} {
    global urlMenu savedUrls
    Menu -m -n urls -p urlProc {
	"Add"
	"View"
	"Remove"
	"(-"
    }
    
    foreach url [lsort -ignore [array names savedUrls]] {
	addMenuItem -m -l "  " urls $url
    }
}

rebuildUrlMenu

# http://www.cs.umd.edu/~keleher/localHome.html
proc urlProc {menu item} {
    global savedUrls
    
    if {$item == "Add"} {
	if {[catch getSelect def]} {set def {}}
	set res [dialog -h 105 -w 370 -b OK 10 80 70 100 -b Cancel 100 80 160 100 -t {Name:} 10 10 60 30 -t {URL:} 10 40 60 60 -e "" 60 10 360 30 -e $def 60 40 360 60 ] 
	if {[lindex $res 0]} {
	    set nm [lindex $res 2]
	    set t [lindex $res 3]
	    if {![string length $t] || ![string length $nm]} {
		beep
		return
	    }
	    set savedUrls($nm) $t
	    prefs::modified savedUrls($nm)
	    rebuildUrlMenu
	}
    } elseif {$item == "Remove"} {
	set r [listpick -p "Remove which URL?" [lsort [array names savedUrls]]]
	unset savedUrls($r)
	prefs::modified savedUrls($r)
	rebuildUrlMenu
    } elseif {$item == "View"} {
	if {[info exists savedUrls]} {
	    set lines {}
	    foreach nm [array names savedUrls] {
		append lines [format "%-20s \"%s\"\r" $nm [set savedUrls($nm)]]
	    }
	    new -n {* Saved URLs *}
	    insertText $lines
	    shrinkWindow
	    setWinInfo dirty 0
	    setWinInfo read-only 1
	}
    } else {
	icURL [set savedUrls($item)]
    }
}

if {![info exists lastFinger]} {set lastFinger ""}
if {![info exists lastTelnet]} {set lastTelnet ""}

proc finger {} {
    global lastFinger
    if {[catch {app::launchBack {'PnLF'}}]} {
	alertnote "You must install Peter Lewis's \"Finger\" program."
	return
    }
    set lastFinger [prompt {Who?} $lastFinger]
    prefs::modified lastFinger
    watchCursor
    set text [AEBuild -r 'PnLF' GURL FURL ---- "$lastFinger"]
    new -n "* $lastFinger *"
    if {[regexp {(.*)} $text dummy text]} {
	insertText $text
	shrinkWindow
	winReadOnly
    }
}

proc telnet {} {
    global lastTelnet telnetSig
    app::launchAnyOfThese [list rlfT NCSA NIFt] telnetSig "Please locate your Telnet application:"
    
    if {[string length $lastTelnet]} {
	set choice [eval prompt {Where?} [lindex $lastTelnet 0] Old $lastTelnet ]
	set lastTelnet [removeDups [concat $choice $lastTelnet]]
    } else {
	set choice [set lastTelnet [prompt {Where?} $lastTelnet]]
    }
    
    prefs::modified lastTelnet
    watchCursor
    AEBuild -r '$telnetSig' GURL GURL ---- "telnet://$choice"
    switchTo '$telnetSig'
}

