## -*-Tcl-*- (install) (nowrap)
## 
 # This file : macMenu.tcl
 # Created : 2001-01-13 17:57:50
 # Last modification : 2001-10-05 12:55:37
 # Author : Bernard Desgraupes
 # e-mail : <berdesg@easynet.fr>
 # Web-page : <http://webperso.easyconnect.fr/berdesg/>
 # Description :
 #                This is a menu for Alpha.  It  allows  you  to  achieve
 #                with maximum flexibility any kind of files manipulation
 #                from within Alpha and to interact with the  MacOS  file
 #                system in a very sophisticated manner.
 # 
 # The macMenu package is split into several  files.  It  will  not  work
 # properly (will not work at all) if any of them is missing. Here  is  a
 # list of the macMenu files :
 #     macMenu.tcl		This file
 #     macMenuDialogs.tcl	Dialog windows procs
 #     macMenuFiles.tcl		Files management procs
 #     macMenuInfo.tcl		Finder items info procs
 #     macMenuUtils.tcl		Various utility procs
 #     macMenuShell.tcl		Mac shell definition procs
 # 
 # Please read the doc in the Mac Menu Help file (it is found in the Help
 # menu once the package is installed) and the MacMenu tutorial  (in  the 
 # Get Info submenu of the Mac Menu).
 # 
 # (c) Copyright : Bernard Desgraupes, 2001
 #         All rights reserved.
 # This software is free software. See licensing terms in the MacMenu Help file.
 # 
 ##

alpha::menu macMenu 1.1.2 global "303" {
    if {$tcl_platform(platform) != "macintosh"} {
	error "The 'Mac Menu' is only useful on MacOS"
    }
    alpha::package require AlphaTcl 7.5d1
    package::addPrefsDialog macMenu
} {macMenu} {} uninstall {this-directory} maintainer {
    "Bernard Desgraupes" <berdesg@easynet.fr> <http://perso.easynet.fr/~berdesg/> 
}  help {file "Mac Menu Help"}


namespace eval mac {}


# # # macMenu preferences # # #
# -----------------------------

# List here the extensions which will have a check box of their own in
# the Predef Exts dialog window. You can also specify
# additional extensions in the "Other Extensions" field of the Predef Exts dialog window.
newPref variable predefExtensions [list tcl html tex sty mf c cp h p j el ps eps gif jpeg] macMenu mac::shadowPrefs
# Specify additional application signatures for the "Creator" popup in 
# the Change Creator dialog window.
newPref variable additionalTypes [list {MSIE - Explorer}] macMenu mac::shadowPrefs
# If this flag is set, you will not be warned when a copy or a move action
# has to overwrite an already existing file.
newPref flag overwriteIfExists {0} macMenu  mac::shadowPrefs
# If this flag is set, the hardware info will be sought at load time to be 
# immediately available on request.
newPref flag buildInfoAtLoad {0} macMenu
# When there are many files to move or copy, there is a risk of memory overflow with Apple Events. 
# So the files are processed by chunks. Choose here the number of files to process at a time.
newPref variable chunksSize {200} macMenu mac::shadowPrefs
# This is the interval between successive  lines  in  the  Info  windows.  It
# happens, depending on the screen size and resolution,  that  these  windows
# are too high and do not fit in the screen. If this is the case, reduce this
# value (not less than 20 otherwise lines will overlap).
newPref variable lineSkip {25} macMenu mac::shadowPrefs


# # # Initialisation of variables # # #
# =====================================
# Predefined extensions
# ---------------------
set predefext $macMenumodeVars(predefExtensions)
set predefext [string trimright $predefext]
foreach e $predefext {
    set ispredef($e) 0
} 

# # # Initialisation of lists # # #
# =================================
# The global lists of selected files
set mac::fileslist {}
set mac::objlist {}
set macchunksize $macMenumodeVars(chunksSize)

# Various lists used in the dialog windows
# ----------------------------------------
set alternlist [list "is not" is]
set compvaluelist [list "lower than" "greater than"]
set compdatelist [list "before" "equals" "after"]
set subfoldslist [list "in Directory" "in Hierarchy" "in all Subfolders"]
set inimaccreatorslist [list { } - {ALFA - Alpha} {MOSS - Netscape} {ttxt - Simple Text}\
  {R*ch - BBEdit} {MPS  - MPW Shell} {CWIE - CodeWarrior} {BlWd - Home Page}] 
set maccreatorslist $inimaccreatorslist
if {$macMenumodeVars(additionalTypes)!=""} {
    foreach type $macMenumodeVars(additionalTypes) {
	lappend maccreatorslist $type
    } 
}
set mactypeslist [list TEXT - APPL INIT TEXT ttro rsrc cdev]
set caselist [list UPPERCASE lowercase "Capitalize Words" "Capitalize first"]
set wherelist [list "at start" "at end"]
set digitlist [list "start at 0" "start at 1"]
set incrlist [list decr incr]
set paddlist [list "no padding" "padd with zeros"]
set untrashlist [list "Last trashed" "All"]
set maceolslist [list mac unix win]
set sortbylist [list " " - "Modification" "Creation" "Size" "Kind" "Labels"]
set sortcodelist [list "" "" asmo ascd ptsz kind labi]

# Various lists used in MacShell
# ------------------------------
set mac::commands [list help files infos empty eject restart shutdown pwd "cd \[<dir|.|..>\]" \
  "mkdir \[<dir>\]" "edit \[<file>\]" ls ld]
set subcmds(files) [list {rename fslinrkdx} {copy fslinto} {move fslinto} {change fslinct} \
  {transtype fslinot} {list fslinb} {duplicate fslin} {trash  fslin} {lock fslin} {unlock fslin} \
  {alias  fslin} {select fsin} {unselect fsin} {unalias  sl} {untrash} ]
set subcmds(infos) [list {file   <path>} {folder <path>} {volume <path>} {appl   <path>} {process <processname>} hardware]
set subcmds(help) [list "" options more bindings tutorial version]
set macshellcmds [list alias appl bindings change copy duplicate edit eject empty file files \
  folder hardware help infos list lock mkdir more move options process rename restart select \
  shutdown transtype trash tutorial unalias unlock unselect untrash version volume ]

# Global arguments to build the dialog windows
set dialogargs ""
set addcondargs ""
# Dialog windows title
set dialogtitle ""
# The y coord in dialog windows
set dialogy 0

# Proc to build the 'help options' cmd in Mac Shell
proc mac::optionsHelp {} {
    global macMenumodeVars
    return [list "-f <expr>\tfiltering regular expr (default '.*')" \
      "-s <folder>\tsource folder (default current folder)" \
      "-l <level>\tnesting level : 0, 1,... or all (default 1)" \
      "-i <flag>\tignore case\? (default 0)" \
      "-n <flag>\tnegate filter\? (default 0)" \
      "-t <folder>\ttarget folder (no default)" \
      "-t <kind>\ttarget eol in transtype (default mac)" \
      "-t <type>\tfile's type (no default)" \
      "-c <type>\tfile's creator (no default)" \
      "-o <flag>\tforce overwrite\? (default $macMenumodeVars(overwriteIfExists), see prefs.)" \
      "-o <kind>\toriginal eol in transtype (default unix)" \
      "-r <expr>\tregsub expr for renaming (default &)" \
      "-k <flag>\tcasing : u, l, w, f (default not set)" \
      "-d <flag>\tnumbering : 0/1 (default 0)" \
      "-b <mcskl>\tsort by (no default)" \
      "-x <m\[.n\]>\ttruncate (default not set)" \
      "-all \t\tall files (equivalent to '-f .*')"
    ]
}


# # # Initialisation of arrays # # #
# ==================================
# Array 'mac_params'
# ------------------
# This array stores all the selecting options
#     Flags
#     -----
set mac_params(add&apply)	0
set mac_params(addconds)	0
set mac_params(addopts)		0
set mac_params(caseopt)		0
set mac_params(casing)		0
set mac_params(creatoridx)	0
set mac_params(criterion)	0
set mac_params(digitopt)	1
set mac_params(currnum)		1
set mac_params(fromshell) 	0
set mac_params(gothdwrinfo)	0
set mac_params(gotsharinfo) 	0
set mac_params(incropt)		1
set mac_params(iscase)		1
set mac_params(isascd)		0
set mac_params(isfcrt)		1
set mac_params(isasmo)		0
set mac_params(issize)		0
set mac_params(isasty)		1
set mac_params(isneg)		0
set mac_params(nest)		1
set mac_params(numbering)	0
set mac_params(overwrite) 	$macMenumodeVars(overwriteIfExists)
set mac_params(paddopt)		1
set mac_params(paddvalue)	2
set mac_params(sameas)		0
set mac_params(isshared)	0
set mac_params(sortbyidx)	0
set mac_params(subfolds)	0
set mac_params(trashnb)		0
set mac_params(truncating)	0
set mac_params(typeidx)		0
set mac_params(untrashopt)	0
set mac_params(whereopt)	1
#     Variables
#     ---------
set mac_params(addedcreator)	""
set mac_params(addedtype)	""
set mac_params(ascd)		""
set mac_params(asmo)		""
set mac_params(asty)		""
set mac_params(casestr)		"-nocase"
set mac_params(fcrt)		""
set mac_params(fromeol) 	"unix"
set mac_params(lasttrashed)	""
set mac_params(oldtitle)	""
set mac_params(otherexts)	""
set mac_params(regex)		".*"
set mac_params(replace)		""
set mac_params(size)		""
set mac_params(srcfold)		$HOME
set mac_params(pwd) 		$mac_params(srcfold)
set mac_params(toeol) 		"mac"
set mac_params(trgtfold)	""
set mac_params(truncexp)	""

set macyesno(0) no
set macyesno(1) yes
set maconoff(0) off
set maconoff(1) on

set oldfileinfo(name) ""
set oldfileinfo(asty) ""
set oldfileinfo(fcrt) ""
set oldfileinfo(aslk) 0
set oldfileinfo(pspd) 0


# Array 'macdescription'
# ----------------------
set mac_description(appt)	"Allocated memory size "
set mac_description(ascd)	"Creation date "
set mac_description(aslk)	"Locked "
set mac_description(asmo)	"Modification date "
set mac_description(asty)	"Type "
set mac_description(bclk)	"Bus clock speed "
set mac_description(capa)	"Capacity "
set mac_description(comt)	"Comment "
set mac_description(cpuf)	"CPU family "
set mac_description(dfsz)	"    Data fork "
set mac_description(fcrt)	"Creator "
set mac_description(file)	"Launched from "
set mac_description(frsp)	"Free bytes "
set mac_description(fshr)	"File sharing "
set mac_description(gppr)	"Group privileges "
set mac_description(gstp)	"Everyone\'s privilege "
set mac_description(hrad)	"Hardware vendor "
set mac_description(hscr)	"Scripting terminology "
set mac_description(iprv)	"Privileges as container "
set mac_description(isab)	"Scriptable "
set mac_description(isej)	"Ejectable "
set mac_description(isrv)	"Local volume "
set mac_description(istd)	"Boot disk "
set mac_description(kind)	"Kind "
set mac_description(lmem)	"Low memory area size "
set mac_description(lram)	"Logical RAM size "
set mac_description(mfre)	"Largest free block "
set mac_description(mprt)	"Minimum memory size "
set mac_description(name)	"Name "
set mac_description(opfw)	"Open Firmware present "
set mac_description(ownr)	"Owner\'s privileges "
set mac_description(path)	"Access path "
set mac_description(pclk)	"Processor clock speed "
set mac_description(pgsz)	"Logical page size "
set mac_description(phys)	"Physical size "
set mac_description(pspd)	"Stationery pad "
set mac_description(ptsz)	"Logical size "
set mac_description(pusd)	"Process partition "
set mac_description(revt)	"Remote events "
set mac_description(rfsz)	"    Resource fork "
set mac_description(rom)	"ROM size "
set mac_description(rram)	"RAM size "
set mac_description(sexp)	"Is share point "
set mac_description(sgrp)	"Group w/ special access "
set mac_description(shar)	"Volume shared "
set mac_description(smou)	"Mounted remotely "
set mac_description(sown)	"Owner "
set mac_description(spro)	"Protected from move "
set mac_description(sprt)	"Suggested memory size "
set mac_description(srad)	"Software vendor "
set mac_description(sysa)	"System architecture "
set mac_description(sysv)	"System version "
set mac_description(uram)	"User RAM size "
set mac_description(ver2)	"Version info "
set mac_description(vers)	"Version "
set mac_description(vm)		"Virtual memory "

proc macMenu {} {}

# # # Menu declarations # # #
# ===========================

menu::buildProc "303" menu::buildmacMenu
menu::buildProc GetInfo menu::buildGetInfo


# # # Building the menu # # #
# ===========================

proc menu::buildmacMenu {} {
    global macMenu 
    set ma ""
    lappend ma "copyFiles"
    lappend ma "moveFiles"
    lappend ma "renameFiles"
    lappend ma "duplicateFiles"
    lappend ma "<E<StrashFiles"
    lappend ma "<S<IuntrashFiles"
    lappend ma "<E<SaliasFiles"
    lappend ma "<S<IremoveAliases"
    lappend ma "<E<SlockFiles"
    lappend ma "<S<IunlockFiles"
    lappend ma "<ElistFiles"
    lappend ma "<E<SselectFiles"
    lappend ma "<S<IunselectFiles"
    lappend ma "transtypeFiles"
    lappend ma "changeType"
    lappend ma "changeCreator"
    lappend ma "(-"
    lappend ma "/Y<O<ImacShell"
    lappend ma "(-"
    lappend ma [list Menu -n GetInfo {}]
    lappend ma "(-"
    lappend ma "emptyTrash"
    lappend ma "showClipboard"
    lappend ma "(-"
    lappend ma "eject"
    lappend ma "restart"
    lappend ma "shutDown"
    
    return [list build $ma mac::MenuProc {GetInfo} $macMenu]
}

proc menu::buildGetInfo {} {
    set ma ""
    lappend ma "file"
    lappend ma "folder"
    lappend ma "volume"
    lappend ma "application"
    lappend ma "process"
    lappend ma "hardware"
    lappend ma "(-"
    lappend ma "macMenuBindings"
    lappend ma "macMenuTutorial"

    return [list build $ma mac::infoMenuProc]
}


# # # Menu items procs # # #
# ==========================

proc mac::MenuProc {menu item} {
    global mac_params
    set item [string trimright $item ""]
    set mac_params(fromshell) 0
    eval mac::$item
}

proc mac::infoMenuProc {menu item} {
    set item [string trimright $item "."]
    eval mac::${item}Info
}


# # # Inserting the menu # # #
# ============================

menu::buildSome "303" 


# # # Key bindings # # #
# ======================
# 'ctrl-z'  'a'	to make <a>liases
# 'ctrl-z'  'b'	to show this <b>indings info window
# 'ctrl-z'  'c'	to <c>opy files
# 'ctrl-z'  'd'	to <d>uplicate files
# 'ctrl-z'  'e'	to <e>mpty the trash
# 'ctrl-z'  'f'	to <f>ree (unlock) locked files
# 'ctrl-z'  'g'	to chan<g>e files creator
# 'ctrl-z'  'h'	to open Mac s<h>ell
# 'ctrl-z'  'j'	to e<j>ect a disk
# 'ctrl-z'  'k'	to loc<k> files
# 'ctrl-z'  'l'	to <l>ist files
# 'ctrl-z'  'm'	to <m>ove files
# 'ctrl-z'  'p'	to show the cli<p>board in the Finder
# 'ctrl-z'  'r'	to <r>emove aliases
# 'ctrl-z'  'r'	to <r>ename files
# 'ctrl-z'  's'	to <s>elect files
# 'ctrl-z'  't'	to send files to the <t>rash
# 'ctrl-z'  'u'	to <u>nselect files
# 'ctrl-z'  'z'	to untrash files (<z> like undo)

Bind 'z' <z> 	prefixChar 

Bind 'a' <Z>	mac::aliasFiles
Bind 'b' <Z>	mac::macMenuBindingsInfo
Bind 'c' <Z>	mac::copyFiles
Bind 'd' <Z>	mac::duplicateFiles
Bind 'e' <Z>	mac::emptyTrash
Bind 'f' <Z>	mac::unlockFiles
Bind 'g' <Z>	mac::changeCreator
Bind 'h' <Z>	mac::macShell
Bind 'j' <Z>	mac::eject
Bind 'k' <Z>	mac::lockFiles
Bind 'l' <Z>	mac::listFiles
Bind 'm' <Z>	mac::moveFiles
Bind 'n' <Z>	mac::renameFiles
Bind 'p' <Z>	mac::showClipboard
Bind 'r' <Z>	mac::removeAliases
Bind 's' <Z>	mac::selectFiles
Bind 't' <Z>	mac::trashFiles
Bind 'u' <Z>	mac::unselectFiles
Bind 'x' <Z>	mac::transtypeFiles
Bind 'y' <Z>	mac::changeType
Bind 'z' <Z>	mac::untrashFiles


# Put this at the end in case it fails.
# Getting hardware info at launch time.
catch {
    if {$macMenumodeVars(buildInfoAtLoad)} {
	mac::getHardwareInfo
	set mac_params(gothdwrinfo) 1
    } 
}

