# File : "macMenuDialogs.tcl"
#                        Created : 2001-01-22 21:35:13
#              Last modification : 2001-09-07 08:54:25
# Author : Bernard Desgraupes
# e-mail : <berdesg@easynet.fr>
# www : <http://perso.easynet.fr/~berdesg/>
# 
# (c) Copyright : Bernard Desgraupes, 2001
#         All rights reserved.
# This software is free software. See licensing terms in the MacMenu Help file.
#
# Description : this file is part of the macMenu package for Alpha.
# It contains procedures to manage the various dialog windows of macMenu.
# 

namespace eval mac {}


# # # Dialog windows # # #
# ========================

proc mac::dialogInit {title} {
    global dialogargs dialogtitle dialogy mac_params
    if {$mac_params(srcfold)==""} {
	set mac_params(srcfold) [file dirname [win::Current]]
    } 
    set dialogtitle $title
    set dialogargs ""
    set dialogy 40    
}

proc mac::selectDialog {title} {
    global dialogargs dialogy slvalues mac_params
    mac::dialogInit $title
    mac::dialogFilterPart
    mac::dialogSourcePart
    mac::dialogButtonPart
    mac::dialogSubFolderPart 2
    set slvalues [eval dialog -w 550 -h $dialogy [join $dialogargs]]
    return [mac::getSelectValues]
}

proc mac::moveDialog {title} {
    global dialogargs dialogy mvvalues mac_params
    mac::dialogInit $title
    mac::dialogFilterPart
    mac::dialogSourcePart
    mac::dialogTargetPart
    mac::dialogButtonPart
    mac::dialogSubFolderPart 3
    set mvvalues [eval dialog -w 550 -h $dialogy [join $dialogargs]]
    return [mac::getMoveValues]    
}

proc mac::renameDialog {title} {
    global dialogargs dialogy rnvalues mac_params
    mac::dialogInit $title
    mac::dialogFilterPart
    mac::dialogReplacePart
    mac::dialogSourcePart
    mac::dialogButtonPart
    mac::dialogSubFolderPart 3
    set rnvalues [eval dialog -w 550 -h $dialogy [join $dialogargs]]
    return [mac::getRenameValues]
}

proc mac::changeCreatorDialog {title} {
    global dialogargs dialogy chvalues pevalues mac_params subfoldslist
    mac::dialogInit $title
    mac::dialogFilterPart creator
    mac::dialogSourcePart
    mac::dialogButtonPart
    mac::dialogSubFolderPart 3
    mac::dialogToCreatorPart
    set chvalues [eval dialog -w 550 -h $dialogy [join $dialogargs]]
    return [mac::getChangeCreatorValues]
}

proc mac::changeTypeDialog {title} {
    global dialogargs dialogy chvalues pevalues mac_params subfoldslist
    mac::dialogInit $title
    mac::dialogFilterPart type
    mac::dialogSourcePart
    mac::dialogButtonPart
    mac::dialogSubFolderPart 3
    mac::dialogToTypePart
    set chvalues [eval dialog -w 550 -h $dialogy [join $dialogargs]]
    return [mac::getChangeTypeValues]
}

proc mac::listDialog {title} {
    global dialogargs dialogy sovalues mac_params
    mac::dialogInit $title
    mac::dialogFilterPart
    mac::dialogSourcePart
    mac::dialogButtonPart
    mac::dialogSubFolderPart 2
    mac::dialogSortingPart
    set sovalues [eval dialog -w 550 -h $dialogy [join $dialogargs]]
    return [mac::getSortingValues]
}

proc mac::transtypeDialog {title} {
    global dialogargs dialogy ttvalues mac_params
    mac::dialogInit $title
    mac::dialogFilterPart
    mac::dialogSourcePart
    mac::dialogButtonPart
    mac::dialogSubFolderPart 3
    mac::dialogTranstypePart
    set ttvalues [eval dialog -w 550 -h $dialogy [join $dialogargs]]
    return [mac::getTranstypeValues]
}

proc mac::predefExtsDialog {title} {
    global dialogargs dialogy pevalues mac_params
    mac::dialogInit $title
    lappend dialogargs [list -t "* Predefined extensions *" 200 5 400 25]        
    mac::dialogPredefExtPart
    mac::dialogButtonPart
    set pevalues [eval dialog -w 550 -h $dialogy [join $dialogargs]]
    return [mac::getPredefValues]    
}

proc mac::addConditionsDialog {} {
    global addcondargs alternlist compvaluelist compdatelist maccreatorslist mactypeslist advalues
    set addcondargs ""
    lappend addcondargs [list -t "* Additional conditions *" 200 8 500 28 \
      -t "yyyy-mm-dd" 390 85 540 105 \
      -t "yyyy-mm-dd" 390 110 540 130 \
      -t "k" 390 135 540 155 \
      -b Apply 450 170 530 190 \
      -b Cancel 350 170 435 190 ]
    mac::dialogLine asty [list "Type "] $alternlist 84 35 5 [concat Examples [lrange $mactypeslist 1 end]]
    mac::dialogLine fcrt [list "Creator "] $alternlist 68 60 5 [concat Examples [lrange $maccreatorslist 1 end]]
    mac::dialogLine asmo [list "Modification date "] $compdatelist 5 85 10
    mac::dialogLine ascd [list "Creation date "] $compdatelist 30 110 10
    mac::dialogLine size [list "Size "] $compvaluelist 88 135 10
    set advalues [eval dialog -w 550 -h 198 [join $addcondargs]]
    return [mac::getAddCondsValues]
}

proc mac::addOptionsDialog {} {
    global addoptargs opvalues mac_params
    global caselist digitlist incrlist paddlist wherelist
    set ycoord 45
    set addoptargs ""
    lappend addoptargs [list -t "* Replacement Options *" 200 10 500 30 \
      -b Apply 450 180 530 200 \
      -b Cancel 350 180 435 200 ]
    set y $ycoord
    eval lappend addoptargs [dialog::checkbox "Casing " $mac_params(casing) 20 y]
    set y $ycoord
    eval lappend addoptargs [list [dialog::menu 100 y $caselist [lindex $caselist $mac_params(caseopt)]]]
    incr ycoord 35
    set y $ycoord
    eval lappend addoptargs [dialog::checkbox "Numbering " $mac_params(numbering) 20 y]
    incr ycoord 25
    set y $ycoord
    eval lappend addoptargs [list [dialog::menu 40 y $wherelist [lindex $wherelist $mac_params(whereopt)] 100]]
    set y $ycoord
    eval lappend addoptargs [list [dialog::menu 155 y $digitlist [lindex $digitlist $mac_params(digitopt)] 125]]
    set y $ycoord
    eval lappend addoptargs [list [dialog::menu 285 y $incrlist [lindex $incrlist $mac_params(incropt)] 100]]
    set y $ycoord
    eval lappend addoptargs [list [dialog::menu 385 y $paddlist [lindex $paddlist $mac_params(paddopt)]]]
    incr ycoord 40
    set y $ycoord
    eval lappend addoptargs [dialog::checkbox "{Truncate to}" $mac_params(truncating) 20 y]
    set y $ycoord
    eval lappend addoptargs [list [dialog::edit "$mac_params(truncexp)" 125 y 4]]    
    set y $ycoord
    eval lappend addoptargs [dialog::text {n\[.m\]} 180 y 30]
    set opvalues [eval dialog -w 550 -h 208 [join $addoptargs]]
    return [mac::getAddOptsValues]
}

proc mac::addCreatorDialog {} {
    global dialogtitle dialogy mac_params acvalues   
    set addcreaargs ""
    lappend addcreaargs [list -t "* Choose a new creator *" 75 10 290 30 \
      -b Apply 230 80 290 100 \
      -b Cancel 10 80 80 100 \
      -b Add&Apply 125 80 210 100 ]
    set dialogy 40    
    lappend addcreaargs [list -t "New creator  " 10 $dialogy 100 [expr $dialogy + 20]\
      -e "$mac_params(addedcreator)" 110 $dialogy 170 [expr $dialogy + 20]\
      -b "Same as..." 210 $dialogy 290 [expr $dialogy + 20]
    ]  
    set dialogy [expr $dialogy + 70]
    set acvalues [eval dialog -w 300 -h $dialogy [join $addcreaargs]]
    return [mac::getAddCreatorValues]    
}

proc mac::addTypeDialog {} {
    global dialogtitle dialogy mac_params acvalues   
    set addtypargs ""
    lappend addtypargs [list -t "* Choose a new type *" 75 10 290 30 \
      -b Apply 230 80 290 100 \
      -b Cancel 10 80 80 100 \
      -b Add&Apply 125 80 210 100 ]
    set dialogy 40    
    lappend addtypargs [list -t "New type  " 30 $dialogy 100 [expr $dialogy + 20]\
      -e "$mac_params(addedtype)" 110 $dialogy 170 [expr $dialogy + 20]\
      -b "Same as..." 210 $dialogy 290 [expr $dialogy + 20]
    ]  
    set dialogy [expr $dialogy + 70]
    set acvalues [eval dialog -w 300 -h $dialogy [join $addtypargs]]
    return [mac::getAddTypeValues]    
}

proc mac::untrashDialog {} {
    global dialogargs dialogy dialogtitle mac_params utvalues
    set dialogargs ""
    set dialogy 30
    set dialogtitle Untrash
    mac::dialogUntrashPart    
    mac::dialogButtonPart
    set utvalues [eval dialog -w 550 -h $dialogy [join $dialogargs]]
    return [mac::getUntrashValues]    
}

proc mac::unaliasDialog {title} {
    global dialogargs dialogy uavalues mac_params
    mac::dialogInit $title
    lappend dialogargs [list -t "* Remove aliases *" 200 5 400 25]
    set dialogy [expr $dialogy + 30]
    mac::dialogSourcePart
    mac::dialogButtonPart
    mac::dialogSubFolderPart 2
    set uavalues [eval dialog -w 550 -h $dialogy [join $dialogargs]]
    return [mac::getUnaliasValues]
}


# Dialog windows elements
# =======================

proc mac::dialogFilterPart {{which ""}} {
    global dialogargs dialogtitle dialogy mac_params
    if {[regexp -nocase Change $dialogtitle]} {
	lappend dialogargs [list -t "* Change files $which *" 200 5 400 25]        
    } else {
	lappend dialogargs [list -t "* $dialogtitle files *" 200 5 400 25]
    }
    set rgx $mac_params(regex)
    set rgx [string trimleft $rgx ^]
    set rgx [string trimright $rgx $]
    if {$rgx==""} {
	set rgx ".*"
    } 
    lappend dialogargs [list -t "Files filter regexp:" 10 $dialogy 140 [expr $dialogy + 20] \
      -e "$rgx" 142 $dialogy 540 [expr $dialogy + 20] \
      -c "case sensitive" $mac_params(iscase) 140 [expr $dialogy + 28] 250 [expr $dialogy + 48] \
      -c "negate filter" $mac_params(isneg) 280 [expr $dialogy + 28] 400 [expr $dialogy + 48] \
      -c "" $mac_params(addconds) 400 [expr $dialogy + 28] 420 [expr $dialogy + 48] \
      -b "Add Conditions" 425 [expr $dialogy + 29] 530 [expr $dialogy + 49]
    ]
    set dialogy [expr $dialogy + 90]
}

proc mac::dialogSubFolderPart {{factor 1}} {
    global dialogargs dialogtitle dialogy subfoldslist mac_params
    set dialogy [expr $dialogy - 60*$factor]
    if {![regexp -nocase (untrash|remove) $dialogtitle]} {
	set y [expr $dialogy - 3]
	eval lappend dialogargs [list  [dialog::button "Predef Exts  " 425 y]]
    }
    set y $dialogy
    eval lappend dialogargs [list [dialog::text "Process " 30 y]]
    set y $dialogy
    eval lappend dialogargs [list [dialog::menu 100 y $subfoldslist \
      [lindex $subfoldslist $mac_params(subfolds)]]]
    set y $dialogy
    eval lappend dialogargs [list [list -n [lindex $subfoldslist 1]]]
    set y $dialogy
    eval lappend dialogargs [list [dialog::text "nesting depth: " 260 y]] \
      [list [list -e "$mac_params(nest)" 363 $dialogy 380 [expr $dialogy + 15]]]
    set dialogy [expr $dialogy + 60*$factor]
}

proc mac::dialogSourcePart {} {
    global dialogargs dialogtitle dialogy mac_params
	mac::dialogFolderPart Source "$mac_params(srcfold)"
}

proc mac::dialogTargetPart {} {
    global dialogargs dialogtitle dialogy mac_params
    mac::dialogFolderPart Target "$mac_params(trgtfold)"
}

proc mac::dialogFolderPart {which fold} {
    global dialogargs dialogtitle dialogy mac_params
    lappend dialogargs [list -t "$which Folder:" 10 $dialogy 160 [expr $dialogy + 15] \
      -e "$fold" 60 [expr $dialogy + 20] 540 [expr $dialogy + 35] \
      -b Set 10 [expr $dialogy + 18] 45 [expr $dialogy + 38]
    ]
    if {$which=="Target" && $dialogtitle!="Alias"} {
    lappend dialogargs [list -c "Force overwrite" $mac_params(overwrite) 60 [expr $dialogy + 45] 200 [expr $dialogy + 60]]
    } 
    set dialogy [expr $dialogy + 60]
}

proc mac::dialogReplacePart {} {
    global dialogargs dialogtitle dialogy mac_params  
    lappend dialogargs [list -t "Replace with :" 10 $dialogy 100 [expr $dialogy + 15] \
      -e "$mac_params(replace)" 110 $dialogy 540 [expr $dialogy + 15]
    ]    
    set dialogy [expr $dialogy + 10]
    lappend dialogargs [list  -c "" $mac_params(addopts) 100 [expr $dialogy + 18] 115 [expr $dialogy + 38] \
      -b "Add Options" 120 [expr $dialogy + 18] 220 [expr $dialogy + 38]
    ]    
    set dialogy [expr $dialogy + 50]
}

proc mac::dialogButtonPart {} {
    global dialogargs dialogtitle dialogy
    if {[regexp -nocase (change|transtype) $dialogtitle]} {
	set dialogy [expr $dialogy + 60]
    } 
    set dialogargs [list "-b $dialogtitle 450 $dialogy 530 [expr $dialogy + 20]" \
      "-b Cancel 360 $dialogy 435 [expr $dialogy + 20]" "[join $dialogargs]"
    ]
    set dialogy [expr $dialogy + 30]
}

proc mac::dialogToCreatorPart {} {
    global mac_params dialogargs dialogtitle dialogy maccreatorslist
    set dialogy [expr $dialogy - 90]
    # This is VERY tricky : the following three widgets have to be inserted in the 'dialogargs' list
    # after the first popup menu (subfolders) but before the -n switch
    set y $dialogy
    set dialogargs [linsert $dialogargs 6 "[dialog::text "Change creator to : " 30 y]"]
    set y $dialogy
    set dialogargs [linsert $dialogargs 7 "[dialog::menu 160 y $maccreatorslist [lindex $maccreatorslist $mac_params(creatoridx)]]"]
    set y $dialogy
    set dialogargs [linsert $dialogargs 8 "[dialog::button Other 465 y]"]
    set dialogy [expr $dialogy + 90]
}

proc mac::dialogToTypePart {} {
    global mac_params dialogargs dialogtitle dialogy mactypeslist
    set dialogy [expr $dialogy - 90]
    set y $dialogy
    set dialogargs [linsert $dialogargs 6 "[dialog::text "Change type to : " 30 y]"]
    set y $dialogy
    set dialogargs [linsert $dialogargs 7 "[dialog::menu 150 y $mactypeslist [lindex $mactypeslist $mac_params(typeidx)]]"]
    set y $dialogy
    set dialogargs [linsert $dialogargs 8 "[dialog::button Other 465 y]"]
    set dialogy [expr $dialogy + 90]
}

proc mac::dialogSortingPart {} {
    global mac_params dialogargs dialogy sortbylist
    set dialogy [expr $dialogy - 30]
    # Same trick as in mac::dialogToCreatorPart : insert the following three widgets 
    # after the subfolders popup menu but before the -n switch
    set y $dialogy
    set dialogargs [linsert $dialogargs 6 "[dialog::text "Sort by  " 10 y]"]
    set y $dialogy
    set dialogargs [linsert $dialogargs 7 "[dialog::menu 70 y $sortbylist [lindex $sortbylist $mac_params(sortbyidx)]]"]
    set y $dialogy
    set dialogargs [linsert $dialogargs 8 "[dialog::checkbox "Incl Crit" $mac_params(criterion) 215 y]"]
    set dialogy [expr $dialogy + 40]
}

proc mac::dialogTranstypePart {} {
    global mac_params dialogargs dialogtitle dialogy maceolslist
    set dialogy [expr $dialogy - 90]
    # Same trick as in mac::dialogToCreatorPart : insert the following three widgets 
    # after the subfolders popup menu but before the -n switch
    set alleolslist [concat $maceolslist "-" all]
    set y $dialogy
    set dialogargs [linsert $dialogargs 6 "[dialog::text "Convert eols from  " 30 y]"]
    set y $dialogy
    set dialogargs [linsert $dialogargs 7 "[dialog::menu 160 y $alleolslist $mac_params(fromeol) 100]"]
    set y $dialogy
    set dialogargs [linsert $dialogargs 8 "[dialog::text "to  " 250 y]"]
    set y $dialogy
    set dialogargs [linsert $dialogargs 9 "[dialog::menu 280 y $maceolslist $mac_params(toeol) 100]"]
    set dialogy [expr $dialogy + 90]
}

proc mac::dialogPredefExtPart {} {
    global dialogargs dialogtitle dialogy mac_params predefext ispredef
    set idx 0
    set nbext [llength $predefext]
    set nbli [expr $nbext/8]
    set rest [expr $nbext % 8]
    set xcoord 30
    lappend dialogargs [list -t "(You can add new checkboxes in the MacMenu prefs)" 30 $dialogy 400 [expr $dialogy + 20]]  
    set dialogy [expr $dialogy + 25]
    for {set j 0} {$j < $nbli} {incr j} {
	set left $xcoord
	foreach e [lrange $predefext $idx [expr $idx + 7]] {
	    eval lappend dialogargs [list -c $e $ispredef($e) $left $dialogy [expr $left + 50] [expr $dialogy + 20]]
	    incr left 60
	}
	set dialogy [expr $dialogy + 30]
	incr idx 8
    }
    if {$rest} {
	set left $xcoord
	foreach e [lrange $predefext $idx [expr $idx + $rest]] {
	    eval lappend dialogargs [list -c $e $ispredef($e) $left $dialogy [expr $left + 50] [expr $dialogy + 20]]
	    incr left 60
	} 
    }
    set dialogy [expr $dialogy + 40]
    	lappend dialogargs [list -t "Other extensions:   " 30 $dialogy 150 [expr $dialogy + 20]\
	  -e "$mac_params(otherexts)" 155 $dialogy 530 [expr $dialogy + 20] ]
    set dialogy [expr $dialogy + 40]
}

proc mac::dialogUntrashPart {} {
    global dialogargs dialogy dialogtitle mac_params utvalues untrashlist
    set y $dialogy
    eval lappend dialogargs [list [dialog::text "Untrash " 160 y]]
    set y $dialogy
    eval lappend dialogargs [list [dialog::menu 220 y $untrashlist [lindex $untrashlist $mac_params(untrashopt) ]]]
    set dialogy [expr $dialogy + 35]
    lappend dialogargs [list -t "Trash contains $mac_params(trashnb) elements" 10 $dialogy 260 [expr $dialogy + 15]]
    set dialogy [expr $dialogy + 18]
    lappend dialogargs [list -t "Recently trashed from macMenu : \
      [llength $mac_params(lasttrashed)] elements" 10 $dialogy 350 [expr $dialogy + 15]]
    set dialogy [expr $dialogy + 28]
}

proc mac::dialogLine {type title altern xcoord ycoord wd {additlist ""}} {
    global addcondargs mac_params
    set y $ycoord
    eval lappend addcondargs [dialog::text $title $xcoord y]
    set y $ycoord
    eval lappend addcondargs [list [dialog::menu 130 y $altern [lindex $altern $mac_params(is$type)]]]
    set y $ycoord
    eval lappend addcondargs [list [dialog::edit "$mac_params($type)" 275 y $wd]]
    if {$additlist!=""} {
	set y $ycoord
	eval lappend addcondargs [list [dialog::menu 370 y $additlist [lindex $additlist 0]]]
    } 
}


# # # Dialog options # # #
# ========================
# Retrieving values from the various dialog windows

proc mac::getSelectValues {} {
    global mac_params dialogtitle slvalues subfoldslist
    if {[lindex $slvalues 1]} {return 0}
    mac::getCommonValues sl
    # In the case of select, there is no subfolders option.
    set mac_params(subfolds) [lsearch -exact $subfoldslist [lindex $slvalues 10]]
    set mac_params(nest) [lindex $slvalues 11]
    if {[lindex $slvalues 6]} {
	set mac_params(addconds) [mac::addConditionsDialog]
	return [mac::selectDialog $dialogtitle]
    } 
    if {[lindex $slvalues 8]} {
	catch {set mac_params(srcfold) [get_directory -p "Select a folder."]}
	return [mac::selectDialog $dialogtitle]
    } else {
	set mac_params(srcfold) [string trimright [lindex $slvalues 7] :]
    }
    if {[lindex $slvalues 9]} {
	set mac_params(oldtitle) $dialogtitle
	if {[mac::predefExtsDialog OK]} {
	    mac::updateFilterExpr
	} 
	return [mac::selectDialog $mac_params(oldtitle)]
    }
    return 1
}

proc mac::getMoveValues {} {
    global mac_params dialogtitle mvvalues subfoldslist
    if {[lindex $mvvalues 1]} {return 0}
    mac::getCommonValues mv
    set diff 0
    if {$dialogtitle!="Alias"} {
	set diff 1
	set mac_params(overwrite) [lindex $mvvalues 11]
    } 
    set mac_params(subfolds) [lsearch -exact $subfoldslist [lindex $mvvalues [expr 12 + $diff]]]
    set mac_params(nest) [lindex $mvvalues [expr 13 + $diff]]
    if {[lindex $mvvalues 6]} {
	set mac_params(addconds) [mac::addConditionsDialog]
	return [mac::moveDialog $dialogtitle]
    } 
    if {[lindex $mvvalues 8]} {
	catch {set mac_params(srcfold) [get_directory -p "Select a folder."]}
	if {[lindex $mvvalues 9]!=""} {
	    set mac_params(trgtfold) [mac::strToPath [lindex $mvvalues 9]]
	} 
	return [mac::moveDialog $dialogtitle]
    } else {
	set mac_params(srcfold) [string trimright [lindex $mvvalues 7] :]
    }
    if {[lindex $mvvalues 10]} {
	catch {set mac_params(trgtfold) [get_directory -p "Select a folder."]}
	return [mac::moveDialog $dialogtitle]
    } else {
	set mac_params(trgtfold) [mac::strToPath [lindex $mvvalues 9]]
    }
    if {[lindex $mvvalues [expr 11 + $diff]]} {
	set mac_params(oldtitle) $dialogtitle
	if {[mac::predefExtsDialog OK]} {
	    mac::updateFilterExpr
	} 
	return [mac::moveDialog $mac_params(oldtitle)]
    }
    return 1
}

proc mac::getRenameValues {} {
    global mac_params dialogtitle rnvalues subfoldslist
    if {[lindex $rnvalues 1]} {return 0}
    mac::getCommonValues rn
    set mac_params(replace) [lindex $rnvalues 7]
    set mac_params(subfolds) [lsearch -exact $subfoldslist [lindex $rnvalues 13]]
    set mac_params(nest) [lindex $rnvalues 14]
    if {[lindex $rnvalues 6]} {
	set mac_params(addconds) [mac::addConditionsDialog]
	return [mac::renameDialog $dialogtitle]
    } 
    if {[lindex $rnvalues 9]} {
	set mac_params(addopts) [mac::addOptionsDialog]
	return [mac::renameDialog $dialogtitle]
    } 
    if {![lindex $rnvalues 8]} {
	set mac_params(casing) 0
	set mac_params(numbering) 0
	set mac_params(truncating) 0
	set mac_params(addopts) 0
    }
    if {[lindex $rnvalues 11]} {
	catch {set mac_params(srcfold) [get_directory -p "Select a folder."]}
	return [mac::renameDialog $dialogtitle]
    } else {
	set mac_params(srcfold) [string trimright [lindex $rnvalues 10]	:]
    }
    if {[lindex $rnvalues 12]} {
	set mac_params(oldtitle) $dialogtitle
	if {[mac::predefExtsDialog OK]} {
	    mac::updateFilterExpr
	} 
	return [mac::renameDialog $mac_params(oldtitle)]
    }
    if {$mac_params(replace)==""} {
	alertnote "Empty replacement string."
	return 0
    }
    return 1
}

proc mac::getCommonValues {prefix} {
    global mac_params ${prefix}values
    set values ${prefix}values
    set rgx [lindex [set $values] 2]
    set rgx [string trimleft $rgx ^]
    set rgx [string trimright $rgx $]
    if {$rgx==""} {
        set rgx ".*"
    } 
    set mac_params(regex) "^$rgx\$"
    set mac_params(iscase) [lindex [set $values] 3]
    set mac_params(casestr) [expr {$mac_params(iscase) ? "":"-nocase"}]
    set mac_params(isneg) [lindex [set $values] 4]
    set mac_params(addconds) [lindex [set $values] 5]
    return 1
}

proc mac::getAddCondsValues {} {
    global mac_params advalues alternlist compdatelist compvaluelist maccreatorslist mactypeslist
    if {[lindex $advalues 1]} {return 0}
    set mac_params(isasty) [lsearch -exact $alternlist [lindex $advalues 2]]
    if {[lindex $advalues 4]!="Examples"} {
        set mac_params(asty) [lindex $advalues 4]
    } else {
	set mac_params(asty) [lindex $advalues 3]
    }
    set mac_params(isfcrt) [lsearch -exact $alternlist [lindex $advalues 5]]
    if {[lindex $advalues 7]!="Examples"} {
        set mac_params(fcrt) [string range [lindex $advalues 7] 0 3]
    } else {
	set mac_params(fcrt) [lindex $advalues 6]
    }
    set mac_params(isasmo) [lsearch -exact $compdatelist [lindex $advalues 8]]
    set mac_params(asmo) [lindex $advalues 9]
    set mac_params(isascd) [lsearch -exact $compdatelist [lindex $advalues 10]]
    set mac_params(ascd) [lindex $advalues 11]
    set mac_params(issize) [lsearch -exact $compvaluelist [lindex $advalues 12]]
    set mac_params(size) [lindex $advalues 13]
    set str [concat $mac_params(asty) $mac_params(fcrt) $mac_params(asmo) $mac_params(ascd) $mac_params(size)]
    return [string length $str]
} 

proc mac::getAddOptsValues {} {
    global opvalues mac_params
    global caselist digitlist incrlist paddlist wherelist
    if {[lindex $opvalues 1]} {return 0}
    set mac_params(casing) [lindex $opvalues 2]
    set mac_params(caseopt) [lsearch -exact $caselist [lindex $opvalues 3]]
    set mac_params(numbering) [lindex $opvalues 4]
    set mac_params(whereopt) [lsearch -exact $wherelist [lindex $opvalues 5]]
    set mac_params(digitopt) [lsearch -exact $digitlist [lindex $opvalues 6]]
    set mac_params(incropt) [lsearch -exact $incrlist [lindex $opvalues 7]]
    set mac_params(paddopt) [lsearch -exact $paddlist [lindex $opvalues 8]]
    set mac_params(truncating) [lindex $opvalues 9]
    set mac_params(truncexp) [lindex $opvalues 10]
    if {![regexp {^\d+(\.\d+)?$} $mac_params(truncexp)] && $mac_params(truncating)} {
	alertnote "Invalid truncate string. Should be:\r    m   or   m.n\rwith m and n integers."
	return 0
    } 
    return [expr $mac_params(casing) + $mac_params(numbering) + $mac_params(truncating)]
}

proc mac::getChangeCreatorValues {} {
    global mac_params dialogtitle chvalues predefext subfoldslist maccreatorslist
    if {[lindex $chvalues 1]} {return 0}
    mac::getCommonValues ch
    set mac_params(subfolds) [lsearch -exact $subfoldslist [lindex $chvalues 10]]
    set mac_params(nest) [lindex $chvalues 13]
    set mac_params(creatoridx) [lsearch -exact $maccreatorslist [lindex $chvalues 11]]
    if {[lindex $chvalues 6]} {
	set mac_params(addconds) [mac::addConditionsDialog]
	return [mac::changeCreatorDialog Change]
    } 
    if {[lindex $chvalues 8]} {
	catch {set mac_params(srcfold) [get_directory -p "Select a folder."]}
	return [mac::changeCreatorDialog $dialogtitle]
    } else {
	set mac_params(srcfold) [string trimright [lindex $chvalues 7] :]	
    }
    if {[lindex $chvalues 9]} {
	set mac_params(oldtitle) $dialogtitle
	if {[mac::predefExtsDialog OK]} {
	    mac::updateFilterExpr
	} 
	return [mac::changeCreatorDialog $mac_params(oldtitle)]
    }
    if {[lindex $chvalues 12]} {
	mac::addCreatorDialog
	return [mac::changeCreatorDialog $dialogtitle]
    }
    return 1
}

proc mac::getChangeTypeValues {} {
    global mac_params dialogtitle chvalues predefext subfoldslist mactypeslist
    if {[lindex $chvalues 1]} {return 0}
    mac::getCommonValues ch
    set mac_params(subfolds) [lsearch -exact $subfoldslist [lindex $chvalues 10]]
    set mac_params(nest) [lindex $chvalues 13]
    set mac_params(typeidx) [lsearch -exact $mactypeslist [lindex $chvalues 11]]
    if {[lindex $chvalues 6]} {
	set mac_params(addconds) [mac::addConditionsDialog]
	return [mac::changeTypeDialog Change]
    } 
    if {[lindex $chvalues 8]} {
	catch {set mac_params(srcfold) [get_directory -p "Select a folder."]}
	return [mac::changeTypeDialog $dialogtitle]
    } else {
	set mac_params(srcfold) [string trimright [lindex $chvalues 7] :]	
    }
    if {[lindex $chvalues 9]} {
	set mac_params(oldtitle) $dialogtitle
	if {[mac::predefExtsDialog OK]} {
	    mac::updateFilterExpr
	} 
	return [mac::changeTypeDialog $mac_params(oldtitle)]
    }
    if {[lindex $chvalues 12]} {
	mac::addTypeDialog
	return [mac::changeTypeDialog $dialogtitle]
    }
    return 1
}

proc mac::getSortingValues {} {
    global mac_params dialogtitle sovalues sortbylist subfoldslist
    if {[lindex $sovalues 1]} {return 0}
    mac::getCommonValues so
    set mac_params(subfolds) [lsearch -exact $subfoldslist [lindex $sovalues 10]]
    set mac_params(sortbyidx) [lsearch -exact $sortbylist [lindex $sovalues 11]]
    set mac_params(criterion) [lindex $sovalues 12]
    set mac_params(nest) [lindex $sovalues 13]
    if {[lindex $sovalues 6]} {
	set mac_params(addconds) [mac::addConditionsDialog]
	return [mac::listDialog $dialogtitle]
    } 
    if {[lindex $sovalues 8]} {
	catch {set mac_params(srcfold) [get_directory -p "Select a folder."]}
	return [mac::listDialog $dialogtitle]
    } else {
	set mac_params(srcfold) [string trimright [lindex $sovalues 7] :]
    }
    if {[lindex $sovalues 9]} {
	set mac_params(oldtitle) $dialogtitle
	if {[mac::predefExtsDialog OK]} {
	    mac::updateFilterExpr
	} 
	return [mac::listDialog $mac_params(oldtitle)]
    }
    return 1
}

proc mac::getTranstypeValues {} {
    global mac_params dialogtitle ttvalues subfoldslist
    if {[lindex $ttvalues 1]} {return 0}
    mac::getCommonValues tt
    set mac_params(fromeol) [lindex $ttvalues 11]
    set mac_params(toeol) [lindex $ttvalues 12]
    set mac_params(subfolds) [lsearch -exact $subfoldslist [lindex $ttvalues 10]]
    set mac_params(nest) [lindex $ttvalues 13]
    if {[lindex $ttvalues 6]} {
	set mac_params(addconds) [mac::addConditionsDialog]
	return [mac::transtypeDialog $dialogtitle]
    } 
    if {[lindex $ttvalues 8]} {
	catch {set mac_params(srcfold) [get_directory -p "Select a folder."]}
	return [mac::transtypeDialog $dialogtitle]
    } else {
	set mac_params(srcfold) [string trimright [lindex $ttvalues 7] :]
    }
    if {[lindex $ttvalues 9]} {
	set mac_params(oldtitle) $dialogtitle
	if {[mac::predefExtsDialog OK]} {
	    mac::updateFilterExpr
	} 
	return [mac::transtypeDialog $mac_params(oldtitle)]
    }
    return 1
}

proc mac::getPredefValues {} {
    global mac_params dialogtitle pevalues predefext ispredef
    if {[lindex $pevalues 1]} {return 0}
    set len [llength $predefext]
    for {set i 0} {$i<$len} {incr i} {
	set ispredef([lindex $predefext $i]) [lindex $pevalues [expr $i+2]]
    }
    set mac_params(otherexts) [lindex $pevalues [expr $len + 2]]
    return 1
}

proc mac::getAddCreatorValues {} {
    global mac_params dialogtitle acvalues maccreatorslist
    if {[lindex $acvalues 1]} {return 0}
    set applname ""
    set mac_params(addedcreator) [lindex $acvalues 3]
    set mac_params(creatoridx) [llength $maccreatorslist]
    if {[lindex $acvalues 4]} {
	set file [getfile " "]
	if {$file!=""} {
	    set mac_params(addedcreator) [tclAE::build::resultData 'MACS' core getd \
	      ---- [tclAE::build::propertyObject fcrt [tclAE::build::filename $file]]]
	} 
	return [mac::addCreatorDialog]
    } 
    if {$mac_params(addedcreator)!=""} {
	# Get the name of the application that created the file.
	catch {tclAE::build::resultData 'MACS' core getd ---- [tclAE::build::propertyObject pnam \
	  "obj {want:type(file), seld:$mac_params(addedcreator), form:fcrt, from:'null'()}"]} res
	if {![regexp {errn:} $res]} {
	    set applname "- $res"
	} 
	if {[lindex $acvalues 2]} {
	    lappend maccreatorslist "$mac_params(addedcreator)$applname" 
	} else {
	    set maccreatorslist [lreplace $maccreatorslist 0 0 "$mac_params(addedcreator)$applname"]
	}
    } 
    return 1
}

proc mac::getAddTypeValues {} {
    global mac_params dialogtitle acvalues mactypeslist
    if {[lindex $acvalues 1]} {return 0}
    set applname ""
    set mac_params(addedtype) [lindex $acvalues 3]
    set mac_params(typeidx) [llength $mactypeslist]
    if {[lindex $acvalues 4]} {
	set file [getfile " "]
	if {$file!=""} {
	    set mac_params(addedtype) [tclAE::build::resultData 'MACS' core getd \
	      ---- [tclAE::build::propertyObject asty [tclAE::build::filename $file]]]
	} 
	return [mac::addTypeDialog]
    } 
    if {$mac_params(addedtype)!=""} {
	if {[lindex $acvalues 2]} {
	    lappend mactypeslist "$mac_params(addedtype)" 
	} else {
	    set mactypeslist [lreplace $mactypeslist 0 0 "$mac_params(addedtype)"]
	}
    } 
    return 1
}

proc mac::getUntrashValues {} {
    global mac_params utvalues untrashlist
    if {[lindex $utvalues 1]} {return 0}
    set mac_params(untrashopt) [lsearch -exact $untrashlist [lindex $utvalues 2]]
    return 1
}

proc mac::getUnaliasValues {} {
    global mac_params dialogtitle uavalues subfoldslist
    if {[lindex $uavalues 1]} {return 0}
    set mac_params(subfolds) [lsearch -exact $subfoldslist [lindex $uavalues 4]]
    set mac_params(nest) [lindex $uavalues 5]
    if {[lindex $uavalues 3]} {
	catch {set mac_params(srcfold) [get_directory -p "Select a folder."]}
	return [mac::unaliasDialog $dialogtitle]
    } else {
	set mac_params(srcfold) [string trimright [lindex $uavalues 2] :]
    }
    return 1
}