# File : "macMenuInfo.tcl"
#                        Created : 2001-01-22 21:35:05
#              Last modification : 2001-08-29 21:51:44
# Author : Bernard Desgraupes
# e-mail : <berdesg@easynet.fr>
# www : <http://perso.easynet.fr/~berdesg/>
# 
# (c) Copyright : Bernard Desgraupes, 2001
#         All rights reserved.
# This software is free software. See licensing terms in the MacMenu Help file.
#
# Description : this file is part of the macMenu package for Alpha.
# It contains procedures related to the management of Finder info
# with macMenu.
# 

namespace eval mac {}


# # # Show info procs # # #
# -------------------------

proc mac::fileInfo {} {
    if {[catch {set f [getfile "Select a file"]}]} {return}
    mac::getFilesInfo $f
    mac::showFilesInfo File
}

proc mac::folderInfo {} {
    if {[catch {set f [get_directory -p "Select a folder"]}]} {return}
    mac::getFolderInfo $f
    mac::showFolderInfo Folder
}

proc mac::volumeInfo {} {
    set vollist [mac::getAllVolsList]
    if {[llength $vollist]==1} {
	set vol [lindex $vollist 0]
    } else {
	set vol [listpick -p "Choose a volume" $vollist]
    }
    if {$vol==""} {return} 
    mac::getVolumeInfo $vol
    mac::showVolumeInfo Disk
}

proc mac::applicationInfo {} {
    if {[catch {set f [getfile "Select an application"]}]} {return}
    if ![mac::getApplInfo $f] return
    mac::showApplInfo Application
}

proc mac::processInfo {} {
    set process [listpick -p "Running processes" [mac::getProcessesList]]
    if {$process==""} {return} 
    mac::getProcessInfo $process
    mac::showProcessInfo Process
}

proc mac::hardwareInfo {} {
    global machardwareinfo
    mac::getHardwareInfo
    mac::showHardwareInfo Hardware
}


# # # Get info procs # # #
# ------------------------
proc mac::getFilesInfo {file} {
    global macfileinfo mac_params
    message "Seeking file info..."
    getFileInfo $file arr
    set mac_params(isshared) 0
    set macfileinfo(name) [file tail $file]
    set macfileinfo(path) [file dirname $file]
    set macfileinfo(dfsz) "$arr(datalen) bytes"
    set macfileinfo(rfsz) "$arr(resourcelen) bytes"
    set macfileinfo(asty) $arr(type)
    set macfileinfo(fcrt) $arr(creator)
    set macfileinfo(phys) [mac::getItemSize phys file $file]
    set macfileinfo(ptsz) [mac::getItemSize ptsz file $file]
    set macfileinfo(ascd) [mac::getItemDate ascd file $file]
    set macfileinfo(asmo) [mac::getItemDate asmo file $file]
    set macfileinfo(kind) [mac::findItemProperty kind file $file]
    set macfileinfo(aslk) [mac::findItemProperty aslk file $file]
    set macfileinfo(pspd) [mac::findItemProperty pspd file $file]
    set macfileinfo(ver2) [mac::findItemProperty ver2 file $file]
    set macfileinfo(vers) [mac::findItemProperty vers file $file]
}

proc mac::getFolderInfo {fold} {
    global macfolderinfo mac_params
    message "Seeking folder info..."
    set fold [string trimright $fold :]
    set mac_params(isshared) 0
    set mac_params(gotsharinfo) 0
    set macfolderinfo(name) [file tail $fold]
    set macfolderinfo(path) [file dirname $fold]
    set macfolderinfo(phys) [mac::getItemSize phys cfol $fold]
    set macfolderinfo(ptsz) [mac::getItemSize ptsz cfol $fold]
    set macfolderinfo(ascd) [mac::getItemDate ascd cfol $fold]
    set macfolderinfo(asmo) [mac::getItemDate asmo cfol $fold]
    set macfolderinfo(kind) [mac::findItemProperty kind cfol $fold]
    set macfolderinfo(asty) [mac::findItemProperty asty cfol $fold]
    set macfolderinfo(fcrt) [mac::findItemProperty fcrt cfol $fold]
    set macfolderinfo(comt) [mac::findItemProperty comt cfol $fold]
    set macfolderinfo(fshr) [tclAE::build::resultData 'MACS' core getd \
      ---- [tclAE::build::propertyObject fshr [tclAE::build::nullObject]]]
    # If file sharing is on :
    if {$macfolderinfo(fshr)} {
	set macfolderinfo(shar) [mac::findItemProperty shar cfol $fold]
	set mac_params(isshared) $macfolderinfo(shar)
    } 
}

proc mac::getFolderSharInfo {fold} {
    global macfolderinfo mac_params
    if {$macfolderinfo(shar) && !$mac_params(gotsharinfo)} {
	set macfolderinfo(sown) [mac::findItemProperty sown cfol $fold]
	set macfolderinfo(sgrp) [mac::findItemProperty sgrp cfol $fold]
	set macfolderinfo(ownr) [mac::findItemProperty ownr cfol $fold]
	set macfolderinfo(gppr) [mac::findItemProperty gppr cfol $fold]
	set macfolderinfo(gstp) [mac::findItemProperty gstp cfol $fold]
	set macfolderinfo(iprv) [mac::findItemProperty iprv cfol $fold]
	set macfolderinfo(smou) [mac::findItemProperty smou cfol $fold]
	set macfolderinfo(sexp) [mac::findItemProperty sexp cfol $fold]
	set macfolderinfo(spro) [mac::findItemProperty spro cfol $fold]        
	set mac_params(gotsharinfo) 1
    } 
}
    
proc mac::getVolumeInfo {vol} {
    global macvolumeinfo mac_params
    message "Seeking disk info..."
    set mac_params(isshared) 0
    set mac_params(gotsharinfo) 0
    set macvolumeinfo(name) [string trimright $vol :]
    set macvolumeinfo(phys) [mac::getItemSize phys cdis $vol]
    set macvolumeinfo(capa) [mac::getItemSize capa cdis $vol]
    set macvolumeinfo(frsp) [mac::getItemSize frsp cdis $vol]
    set macvolumeinfo(ascd) [mac::getItemDate ascd cdis $vol]
    set macvolumeinfo(asmo) [mac::getItemDate asmo cdis $vol]
    set macvolumeinfo(kind) [mac::findItemProperty kind cdis $vol]
    set macvolumeinfo(asty) [mac::findItemProperty asty cdis $vol]
    set macvolumeinfo(fcrt) [mac::findItemProperty fcrt cdis $vol]
    set macvolumeinfo(isej) [mac::findItemProperty isej cdis $vol]
    set macvolumeinfo(isrv) [mac::findItemProperty isrv cdis $vol]
    set macvolumeinfo(istd) [mac::findItemProperty istd cdis $vol]
    set macvolumeinfo(fshr) [tclAE::build::resultData 'MACS' core getd \
      ---- [tclAE::build::propertyObject fshr [tclAE::build::nullObject]]]
    # If file sharing is on :
    if {$macvolumeinfo(fshr)} {
	set macvolumeinfo(shar) [mac::findItemProperty shar cdis $vol]
	set mac_params(isshared) $macvolumeinfo(shar)
    } 
}

proc mac::getVolumeSharInfo {vol} {
    global macvolumeinfo mac_params
    if {$macvolumeinfo(shar) && !$mac_params(gotsharinfo)} {
	set macvolumeinfo(sown) [mac::findItemProperty sown cdis $vol]
	set macvolumeinfo(sgrp) [mac::findItemProperty sgrp cdis $vol]
	set macvolumeinfo(ownr) [mac::findItemProperty ownr cdis $vol]
	set macvolumeinfo(gppr) [mac::findItemProperty gppr cdis $vol]
	set macvolumeinfo(gstp) [mac::findItemProperty gstp cdis $vol]
	set macvolumeinfo(iprv) [mac::findItemProperty iprv cdis $vol]
	set macvolumeinfo(smou) [mac::findItemProperty smou cdis $vol]
	set macvolumeinfo(sexp) [mac::findItemProperty sexp cdis $vol]
	set macvolumeinfo(spro) [mac::findItemProperty spro cdis $vol]        
	set mac_params(gotsharinfo) 1
    } 
}

proc mac::getApplInfo {appli} {
    global macapplinfo mac_params
    if {[mac::findItemProperty asty file $appli]!="APPL"} {
	alertnote "[file tail $appli] doesn't have type APPL."
	return 0
    } 
    message "Seeking application info..."
    set mac_params(isshared) 0
    getFileInfo $appli arr
    set macapplinfo(name) [file tail $appli]
    set macapplinfo(path) [file dirname $appli]
    set macapplinfo(phys) [mac::getItemSize phys appf $appli]
    set macapplinfo(ptsz) [mac::getItemSize ptsz appf $appli]
    set macapplinfo(dfsz) "$arr(datalen) bytes"
    set macapplinfo(rfsz) "$arr(resourcelen) bytes"
    set macapplinfo(asty) $arr(type)
    set macapplinfo(fcrt) $arr(creator)
    set macapplinfo(ascd) [mac::getItemDate ascd appf $appli]
    set macapplinfo(asmo) [mac::getItemDate asmo appf $appli]
    set macapplinfo(kind) [mac::findItemProperty kind appf $appli]
    set macapplinfo(aslk) [mac::findItemProperty aslk appf $appli]
    set macapplinfo(pspd) [mac::findItemProperty pspd appf $appli]
    set macapplinfo(ver2) [mac::findItemProperty ver2 appf $appli]
    set macapplinfo(vers) [mac::findItemProperty vers appf $appli]
    set macapplinfo(comt) [mac::findItemProperty comt appf $appli]
    # Application specific info
    set macapplinfo(sprt) "[mac::findItemProperty sprt appf $appli] bytes"
    set macapplinfo(mprt) "[mac::findItemProperty mprt appf $appli] bytes"
    set macapplinfo(appt) "[mac::findItemProperty appt appf $appli] bytes"
    set macapplinfo(isab) [mac::findItemProperty isab appf $appli]
    set macapplinfo(hscr) [mac::findItemProperty hscr appf $appli]
    return 1
}

proc mac::getProcessInfo {process} {
    global macprocessinfo mac_params
    message "Seeking process info..."
    set mac_params(isshared) 0
    set macprocessinfo(name) $process
    set macprocessinfo(file) [tclAE::build::resultData 'MACS' core getd rtyp TEXT  ---- \
      [tclAE::build::propertyObject file [tclAE::build::nameObject prcs $process]]]
    set macprocessinfo(asty) [mac::findItemProperty asty prcs $process]
    set macprocessinfo(fcrt) [mac::findItemProperty fcrt prcs $process]
    set macprocessinfo(isab) [mac::findItemProperty isab prcs $process]
    set macprocessinfo(revt) [mac::findItemProperty revt prcs $process]
    set macprocessinfo(appt) "[mac::findItemProperty appt prcs $process] bytes"
    set macprocessinfo(pusd) "[mac::findItemProperty pusd prcs $process] bytes"
}

proc mac::getHardwareInfo {} {
    global machardwareinfo mac_params
    set machardwareinfo(fshr) [tclAE::build::resultData 'MACS' core getd \
      ---- [tclAE::build::propertyObject fshr [tclAE::build::nullObject]]]
    set machardwareinfo(vm)   [mac::gestaltRead  vm   bool ]
    set machardwareinfo(mfre) "[tclAE::build::resultData 'MACS' core getd \
      ---- [tclAE::build::propertyObject mfre [tclAE::build::nullObject]]] bytes"
    if $mac_params(gothdwrinfo) return
    message "Seeking hardware info..."
    set mac_params(isshared) 0
    set machardwareinfo(bclk) [mac::gestaltRead  bclk mhz  ]
    set machardwareinfo(rram) [mac::gestaltRead  rram size ]
    set machardwareinfo(uram) [mac::gestaltRead  uram size ]
    set machardwareinfo(cpuf) [mac::gestaltRead  cpuf cpu  ]
    set machardwareinfo(hrad) [mac::gestaltRead  hrad name ]
    set machardwareinfo(lmem) [mac::gestaltRead  lmem size ]
    set machardwareinfo(lram) [mac::gestaltRead  lram size ]
    set machardwareinfo(opfw) [mac::gestaltRead  opfw bool ]
    set machardwareinfo(pclk) [mac::gestaltRead  pclk mhz  ]
    set machardwareinfo(pgsz) [mac::gestaltRead  pgsz size ]
    set machardwareinfo(rom)  [mac::gestaltRead  rom  size ]
    set machardwareinfo(srad) [mac::gestaltRead  srad name ]
    set machardwareinfo(sysa) [mac::gestaltRead  sysa sysa ]
    set machardwareinfo(sysv) [tclAE::build::resultData 'MACS' core getd \
      ---- [tclAE::build::propertyObject ver2 [tclAE::build::nullObject]]]
    set mac_params(gothdwrinfo) 1
}


# # # Building info windows # # #
# -------------------------------
proc mac::showFilesInfo {title} {
    global macfileinfo dialogargs dialogtitle dialogy 
    global infovalues macinfotext mac_description
    mac::initInfoWindow $title
    mac::infoLinePart file name e 30
    mac::infoLinePart file path t
    mac::infoLinePart file kind t
    mac::infoLinePart file phys t
    mac::infoLinePart file ptsz t
    mac::infoLinePart file dfsz t
    mac::infoLinePart file rfsz t
    mac::infoLinePart file ascd t
    mac::infoLinePart file asmo t
    mac::infoLinePart file asty e 6
    mac::infoLinePart file fcrt e 6
    mac::infoLinePart file aslk c
    mac::infoLinePart file pspd c
    mac::infoLinePart file vers t
    mac::infoLinePart file ver2 t
    set dialogy [expr $dialogy + 10]
    mac::infoButtonPart
    set infovalues [eval dialog -w 500 -h $dialogy [join $dialogargs]]
    mac::getFileValues
}

proc mac::showFolderInfo {title} {
    global macfolderinfo dialogargs dialogtitle dialogy 
    global infovalues macinfotext mac_description
    mac::initInfoWindow $title
    mac::infoLinePart folder name e 30
    mac::infoLinePart folder path t
    mac::infoLinePart folder kind t
    mac::infoLinePart folder phys t
    mac::infoLinePart folder ptsz t
    mac::infoLinePart folder ascd e 15
    mac::infoLinePart folder asmo e 15
    mac::infoLinePart folder asty e 6
    mac::infoLinePart folder fcrt e 6
    if {$macfolderinfo(fshr)} {
	mac::infoLinePart folder fshr z
	mac::infoLinePart folder shar y
    } 
    set dialogy [expr $dialogy + 10]
    mac::infoButtonPart
    set infovalues [eval dialog -w 500 -h $dialogy [join $dialogargs]]
    mac::getFolderValues
}

proc mac::showVolumeInfo {title} {
    global macvolumeinfo dialogargs dialogtitle dialogy 
    global infovalues macinfotext mac_description
    mac::initInfoWindow $title
    mac::infoLinePart volume name e 30
    mac::infoLinePart volume kind t
    mac::infoLinePart volume capa t
    mac::infoLinePart volume phys t
    mac::infoLinePart volume frsp t
    mac::infoLinePart volume ascd e 15
    mac::infoLinePart volume asmo e 15
    mac::infoLinePart volume asty e 6
    mac::infoLinePart volume fcrt e 6
    mac::infoLinePart volume isej y
    mac::infoLinePart volume isrv y
    mac::infoLinePart volume istd y
    if {$macvolumeinfo(fshr)} {
	mac::infoLinePart volume fshr z
	mac::infoLinePart volume shar y
    } 
    set dialogy [expr $dialogy + 10]
    mac::infoButtonPart
    set infovalues [eval dialog -w 500 -h $dialogy [join $dialogargs]]
    mac::getVolumeValues
}

proc mac::showApplInfo {title} {
    global macapplinfo dialogargs dialogtitle dialogy 
    global infovalues macinfotext mac_description
    mac::initInfoWindow $title
    mac::infoLinePart appl name e 30
    mac::infoLinePart appl path t
    mac::infoLinePart appl kind t
    mac::infoLinePart appl phys t
    mac::infoLinePart appl ptsz t
    mac::infoLinePart appl dfsz t
    mac::infoLinePart appl rfsz t
    mac::infoLinePart appl ascd e 15
    mac::infoLinePart appl asmo e 15
    mac::infoLinePart appl asty e 6
    mac::infoLinePart appl fcrt e 6
    mac::infoLinePart appl aslk y
    mac::infoLinePart appl pspd y
    mac::infoLinePart appl vers t
    mac::infoLinePart appl ver2 t
    mac::infoLinePart appl sprt t
    mac::infoLinePart appl mprt e
    mac::infoLinePart appl appt e
    mac::infoLinePart appl isab y
    mac::infoLinePart appl hscr y
    set dialogy [expr $dialogy + 10]
    mac::infoButtonPart
    set infovalues [eval dialog -w 500 -h $dialogy [join $dialogargs]]
    mac::getOtherValues
}

proc mac::showProcessInfo {title} {
    global macprocessinfo dialogargs dialogtitle dialogy 
    global infovalues macinfotext mac_description
    mac::initInfoWindow $title
    mac::infoLinePart process name e 30
    mac::infoLinePart process file t
    mac::infoLinePart process asty e 6
    mac::infoLinePart process fcrt e 6
    mac::infoLinePart process isab y
    mac::infoLinePart process revt y
    mac::infoLinePart process appt t
    mac::infoLinePart process pusd t
    set dialogy [expr $dialogy + 10]
    mac::infoButtonPart
    set infovalues [eval dialog -w 500 -h $dialogy [join $dialogargs]]
    mac::getOtherValues
}

proc mac::showHardwareInfo {title} {
    global machardwareinfo dialogargs dialogtitle dialogy 
    global infovalues macinfotext mac_description 
    mac::initInfoWindow $title
    mac::infoLinePart hardware cpuf t
    mac::infoLinePart hardware hrad t
    mac::infoLinePart hardware srad t
    mac::infoLinePart hardware bclk t
    mac::infoLinePart hardware pclk t
    mac::infoLinePart hardware rram t
    mac::infoLinePart hardware uram t
    mac::infoLinePart hardware lram t
    mac::infoLinePart hardware rom  t
    mac::infoLinePart hardware mfre t
    mac::infoLinePart hardware lmem t
    mac::infoLinePart hardware pgsz t
    mac::infoLinePart hardware sysa t
    mac::infoLinePart hardware sysv t
    mac::infoLinePart hardware opfw y
    mac::infoLinePart hardware fshr c
    mac::infoLinePart hardware vm   z
    set dialogy [expr $dialogy + 10]
    mac::infoButtonPart
    set infovalues [eval dialog -w 500 -h $dialogy [join $dialogargs]]
    mac::getHardwareValues
}

proc mac::initInfoWindow {title} {
    global dialogargs dialogtitle dialogy macinfotext
    set macinfotext ""
    set dialogtitle $title
    set dialogargs ""
    set dialogy 40    
    lappend dialogargs [list -t "* $dialogtitle Info *" 180 5 400 25]
}

proc mac::showSharingInfo {type title} {
    global infovalues dialogargs dialogtitle dialogy 
    global macinfotext mac${type}info
    mac::initInfoWindow $title
    append macinfotext "Sharing info about \"[set mac${type}info(name)]\"\n"
    mac::infoLinePart $type sown t
    mac::infoLinePart $type sgrp t
    mac::infoLinePart $type ownr t
    mac::infoLinePart $type gppr t
    mac::infoLinePart $type gstp t
    mac::infoLinePart $type iprv t
    mac::infoLinePart $type smou t
    mac::infoLinePart $type sexp t
    mac::infoLinePart $type spro t
    set dialogargs [list "-b OK 400 $dialogy 480 [expr $dialogy + 20]" \
      "-b \"Get Text\" 10 $dialogy 75 [expr $dialogy + 20]" "[join $dialogargs]"
    ]
    set dialogy [expr $dialogy + 30]
    set infovalues [eval dialog -w 500 -h $dialogy [join $dialogargs]]
    mac::getOtherValues
}


# # # Info building blocks
# ------------------------
proc mac::infoLinePart {device type widget {wd 15}} {
    global mac${device}info dialogargs dialogtitle dialogy macMenumodeVars
    global mac_description macyesno maconoff macinfotext
    set rep [set mac${device}info($type)]
    if {$rep==""} return
    set y $dialogy
    eval lappend dialogargs [list [dialog::text "$mac_description($type)  " 10 y]]
    switch $widget {
	"t" {
	    if {$type=="path" || $type=="file"} {
		mac::pathLine "$rep "
	    } else {
		set y $dialogy
		eval lappend dialogargs [list [dialog::text "$rep  " 190 y ]]
	    }
	}
	"e" {
	    set y $dialogy
	    eval lappend dialogargs [list [dialog::edit "$rep" 190 y $wd]]
	}
	"c" {
	    set y $dialogy
	    eval lappend dialogargs [list [dialog::checkbox "   " "$rep" 190 y]]
	}
	"y" {
	    set y $dialogy
	    eval lappend dialogargs [list [dialog::text "$macyesno($rep) " 190 y ]]
	}
	"z" {
	    set y $dialogy
	    eval lappend dialogargs [list [dialog::text "$maconoff($rep)  " 190 y ]]
	}
    }
    append macinfotext "$mac_description($type): $rep\n"
    set dialogy [expr $dialogy + $macMenumodeVars(lineSkip)]
}

proc mac::infoButtonPart {} {
    global dialogargs dialogtitle dialogy mac_params
    set dialogargs [list "-b Dismiss 400 $dialogy 480 [expr $dialogy + 20]" \
      "-b \"Get Text\" 10 $dialogy 75 [expr $dialogy + 20]" "[join $dialogargs]"
    ]
    if {$dialogtitle=="File" || $dialogtitle=="Hardware"} {
      lappend dialogargs "-b Set 100 $dialogy 175 [expr $dialogy + 20]" 
    } 
    if {$mac_params(isshared)} {
      lappend dialogargs "-b Sharing 190 $dialogy 265 [expr $dialogy + 20]" 
    } 
    set dialogy [expr $dialogy + 30]
}


# # # Info options # # #
# ======================
# Retrieving values from the various info windows

proc mac::getFileValues {} {
    global macfileinfo oldfileinfo infovalues
    if {[lindex $infovalues 0]} {return}
    if {[lindex $infovalues 1]} {
	mac::sendTextInfo
	return
    }
    set oldfileinfo(name) $macfileinfo(name)
    set oldfileinfo(asty) $macfileinfo(asty)
    set oldfileinfo(fcrt) $macfileinfo(fcrt)
    set oldfileinfo(aslk) $macfileinfo(aslk)
    set oldfileinfo(pspd) $macfileinfo(pspd)
    set macfileinfo(name) [lindex $infovalues 2]
    set macfileinfo(asty) [lindex $infovalues 3]
    set macfileinfo(fcrt) [lindex $infovalues 4]
    set macfileinfo(aslk) [lindex $infovalues 5]
    set macfileinfo(pspd) [lindex $infovalues 6]
    if {[lindex $infovalues 7]} {
	mac::setFileValues
	return
    }
}

proc mac::getFolderValues {} {
    global infovalues macfolderinfo dialogtitle mac_params
    if {[lindex $infovalues 0]} {return}
    if {[lindex $infovalues 1]} {
	mac::sendTextInfo
	return
    }
    if {$macfolderinfo(shar) && [lindex $infovalues [expr [llength $infovalues]-1]]} {
	set mac_params(oldtitle) $dialogtitle
	mac::getFolderSharInfo [file join $macfolderinfo(path) $macfolderinfo(name)]
	mac::showSharingInfo folder Sharing
	mac::showFolderInfo $mac_params(oldtitle)
	return
    }
}

proc mac::getVolumeValues {} {
    global infovalues macvolumeinfo dialogtitle mac_params
    if {[lindex $infovalues 0]} {return}
    if {[lindex $infovalues 1]} {
	mac::sendTextInfo
	return
    }
    if {$macvolumeinfo(shar) && [lindex $infovalues [expr [llength $infovalues]-1]]} {
	set mac_params(oldtitle) $dialogtitle
	mac::getVolumeSharInfo $macvolumeinfo(name)
	mac::showSharingInfo volume Sharing
	mac::showVolumeInfo $mac_params(oldtitle)
	return
    }
}

proc mac::getHardwareValues {} {
    global infovalues
    if {[lindex $infovalues 0]} {return}
    if {[lindex $infovalues 1]} {
	mac::sendTextInfo
	return
    }    
    if {[lindex $infovalues 3]} {
	catch {AEBuild -r 'MACS' core setd ---- \
	  [tclAE::build::propertyObject fshr 'null'()] \
	  data [tclAE::build::bool [lindex $infovalues 2]]} res
	if {[mac::testError $res]} return
	
	if {[lindex $infovalues 2]} {
	    message "File sharing activated"
	    
	} else {
	    message "File sharing deactivated"
	}
	return
    }
}

proc mac::getOtherValues {} {
    global infovalues
    if {[lindex $infovalues 0]} {return}
    if {[lindex $infovalues 1]} {
	mac::sendTextInfo
	return
    }
}

proc mac::setFileValues {} {
    global macfileinfo oldfileinfo
    if {$oldfileinfo(name)!=$macfileinfo(name)} {
	catch {AEBuild -r 'MACS' core setd ---- [tclAE::build::propertyObject pnam \
	  [tclAE::build::filename [file join $macfileinfo(path) $oldfileinfo(name)]]] \
	  data "$macfileinfo(name)"} 
    }
    if {$oldfileinfo(asty)!=$macfileinfo(asty)} {
	catch {AEBuild -r 'MACS' core setd ---- [tclAE::build::propertyObject asty \
	  [tclAE::build::filename [file join $macfileinfo(path) $oldfileinfo(name)]]] data 'type'($macfileinfo(asty))} res
    }
    if {$oldfileinfo(fcrt)!=$macfileinfo(fcrt)} {
	catch {AEBuild -r 'MACS' core setd ---- [tclAE::build::propertyObject fcrt \
	  [tclAE::build::filename [file join $macfileinfo(path) $oldfileinfo(name)]]] data 'type'($macfileinfo(fcrt))} res
    }
    if {$oldfileinfo(aslk)!=$macfileinfo(aslk)} {
	catch {AEBuild -r 'MACS' core setd ---- [tclAE::build::propertyObject aslk \
	  [tclAE::build::filename [file join $macfileinfo(path) $oldfileinfo(name)]]] data 'bool'(0$macfileinfo(aslk))} res    
    }
    if {$oldfileinfo(pspd)!=$macfileinfo(pspd)} {
	catch {AEBuild -r 'MACS' core setd ---- [tclAE::build::propertyObject pspd \
	  [tclAE::build::filename [file join $macfileinfo(path) $oldfileinfo(name)]]] data 'bool'(0$macfileinfo(pspd))} res    
    }
}


# # # Bindings Info # # #
# -----------------------
proc mac::macMenuBindingsInfo {} {
    global tileLeft tileTop tileWidth errorHeight
    set mess [mac::bindingsInfoString]
    new -g $tileLeft $tileTop [expr $tileWidth*.5] [expr $errorHeight *2] -n "* MacMenu Bindings *" -info $mess
    set start [minPos]
    while {![catch {search -f 1 -s -r 1 -i 1 {('|<)[a-z= -]+('|>)} $start} res]} {
	text::color [lindex $res 0] [lindex $res 1] 1
	set start [lindex $res 1]
    }
    text::color 0 [nextLineStart 0] 5
    refresh
}

proc mac::bindingsInfoString {} {
    set mess "KEY BINDINGS AVAILABLE FOR THE MAC MENU\n\n"
    append mess "Press 'ctrl-z', release, then hit one of the following letters :\n"
    append mess "  'a'	to make <a>liases\n"
    append mess "  'b'	to show this <b>indings info window\n"
    append mess "  'c'	to <c>opy files\n"
    append mess "  'd'	to <d>uplicate files\n"
    append mess "  'e'	to <e>mpty the trash\n"
    append mess "  'f'	to <f>ree (unlock) locked files\n"
    append mess "  'g'	to chan<g>e files creator\n"
    append mess "  'h'	to open Mac s<h>ell\n"
    append mess "  'j'	to e<j>ect a disk\n"
    append mess "  'k'	to loc<k> files\n"
    append mess "  'l'	to <l>ist files\n"
    append mess "  'm'	to <m>ove files\n"
    append mess "  'n'	to re<n>ame files\n"
    append mess "  'p'	to open the cli<p>board in the Finder\n"
    append mess "  'r'	to <r>emove aliases\n"
    append mess "  's'	to <s>elect files\n"
    append mess "  't'	to send files to the <t>rash\n"
    append mess "  'u'	to <u>nselect files\n"
    append mess "  'x'	to e<x>change end of lines (transtype)\n"
    append mess "  'y'	to change files t<y>pe\n"
    append mess "  'z'	to untrash files (<z> like undo)\n"
    append mess "You can also use :\n"
    append mess "'opt-cmd-y'	to open Mac shell (same as 'ctrl-z h')\n"
    append mess "'TAB' key	to trigger the completion mechanism in Mac shell\n"
    return $mess
}


# # # Tutorial # # #
# ------------------
proc mac::macMenuTutorialInfo {} {
    help::openExample "MacMenu Example" 
}