## -*-Tcl-*-
 # ###################################################################
 #  AlphaTcl - extension to interact with sourceforge
 # 
 #  FILE: "sourceforgeMenu.tcl"
 #                                    created: 09/29/2001 {10:58:06 AM} 
 #                                last update: 10/04/2001 {09:31:11 AM} 
 #  Author: Vince Darley
 #  E-mail: vince@santafe.edu
 #          317 Paseo de Peralta, Santa Fe
 #     www: http://www.santafe.edu/~vince/
 #  
 # ###################################################################
 ##

# menu declaration
alpha::menu sourceforgeMenu 0.2 global SF {
    
} {
    sourceforgeMenu
} {
    
} maintainer {
    {Vince Darley} vince@santafe.edu http://www.santafe.edu/~vince/
} help {
    Provides functionality to aid interactions with the open
    source repository sourceforge.
} uninstall {this-file}

proc sourceforgeMenu {} {}

namespace eval sf {}

proc sf::buildMenu {args} {
    global sourceforgeMenu sfmodeVars sfprojects
    set items [list "goToSourceForge"]
    if {[array size sfprojects] > 0} {
	lappend items \
	  [menu::makeFlagMenu project list project sfmodeVars]
    }
    lappend items "editProjects" "(-)"
    if {[string length $sfmodeVars(project)]} {
	lappend items "$sfmodeVars(project)&"
    }
    lappend items "browseCvs" "viewBugNumber" 
    
    Menu -n $sourceforgeMenu -p sf::MenuProc $items
}

# The current project
newPref var project Tcl sf sf::buildMenu sfprojects array

ensureset sfprojects(Tcl) "sfProjectName tcl sfGroupId 10894"
ensureset sfprojects(AlphaTcl) "sfProjectName alphatcl sfGroupId 16416"

sf::buildMenu

proc sf::MenuProc {menu item} {
    global sfprojects
    if {[info exists sfprojects($item)]} {
	sf::goToProject $item
    } else {
	menu::generalProc sf $item
    }
}

proc sf::editProjects {} {
    global sfprojects sfmodeVars
    set res [dialog::editGroup -array sfprojects -delete ask \
      -new sf::newProjectDetails \
      -title "Edit sourceforge project information" \
      -current $sfmodeVars(project) \
      [list "sfProjectName" variable "Sourceforge project name"\
      "This is the name by which sourceforge refers to the project"] \
      [list "sfGroupId" variable "Sourceforge group id"\
      "This is the number (usually 5 digit) which sourceforge uses\
      to access further information on this project, usually using\
      http lookups with '?group_id=xxxxx'"]]
    # This works whether projects have been modified or deleted.
    foreach proj $res {
	prefs::modified sfprojects($proj)
    }
    if {[llength $res]} {
	# Should now rebuild the menu in case we've added or
	# removed a project.
	sf::buildMenu
    }
}

proc sf::newProjectDetails {} {
    set name [getline "Descriptive name of new project"]
    if {[string length $name]} {
	return [list $name [list sfProjectName "" sfGroupId ""]]
    } else {
	return ""
    }
}

proc sf::goToSourceForge {} {
    url::execute "http://sourceforge.net"
}

proc sf::project {{proj ""}} {
    if {![string length $proj]} { 
	global sfmodeVars
	return $sfmodeVars(project)
    }
    return $proj
}

proc sf::projectInfo {{proj ""}} {
    global sfmodeVars sfprojects
    if {![string length $proj]} { 
	set proj $sfmodeVars(project)
    }
    return $sfprojects($proj)
}

proc sf::goToProject {{proj ""}} {
    set projectInfo [sf::projectInfo $proj]
    url::execute "http://sourceforge.net/projects/[lindex $projectInfo 1]"
}

proc sf::browseCvs {{proj ""}} {
    set projectInfo [sf::projectInfo $proj]
    url::execute "http://cvs.sourceforge.net/cgi-bin/viewcvs.cgi/[lindex $projectInfo 1]/"
}

proc sf::viewBugNumber {{proj ""} {bug ""}} {
    if {$bug == ""} { set bug [getline "View [sf::project $proj] project bug#"] }
    if {$bug == ""} { return }
    set group [lindex [sf::projectInfo $proj] 3]
    set http "http://sourceforge.net/tracker/index.php"
    append http "?func=detail&aid=${bug}&group_id=${group}&atid=1${group}"
    url::execute $http
}
